/****************************************************************************
|                         Digital Audio Processor
|                         =======================
|
| Filename    : lfo.h
|
| Object      : DSPKitLFO
|
| Description : DSPKitLFO
|
| (c) Richard Kent 1996
|
| $Id: lfo.h,v 1.1 2003/09/10 00:06:25 rk Exp $
|
****************************************************************************/

#ifndef _DSPKIT_LFO_H_
#define _DSPKIT_LFO_H_

#include "processo.h"

class DSPKitLFO : public DSPKitProcessor
{
  public:

    int setInput (DSPKitProcessor *ip);
    int setTypeAndFreq (
      int newType,
      double newInputFreq,
      double newOutputFreq, 
      double newDepth, double newPhase);
    int setExponential (double newExpPower);
    int getSample (double &outputSample);
    DSPKitProcessor *getInput () const;
    
  protected:

    double depth;
    double phase;
    double inputFreq;
    double outputFreq;
    int   type;
    int   samplesPerCycle;
    double cyclesPerSample;
    double twoPiCyclesPerSample;
    int   i;
    double expPower;
};

inline int DSPKitLFO::setInput (DSPKitProcessor *ip)
{
  return 1;
}

inline DSPKitProcessor *DSPKitLFO::getInput () const
{
  return 0;
}

inline int DSPKitLFO::setExponential (double newExpPower)
{
  expPower = newExpPower;
  return 1;
}

#endif

/***************************************************************************/
