/****************************************************************************
|                         Digital Audio Processor
|                         =======================
|
| Filename    : feedback.h
|
| Object      : DSPKitFeedback
|
| Description : DSPKitFeedback
|
| (c) Richard Kent 1996
|
| $Id: feedback.h,v 1.1 2003/09/10 00:06:25 rk Exp $
|
****************************************************************************/

#ifndef _DSPKIT_FEEDBACK_H_
#define _DSPKIT_FEEDBACK_H_

#include "processo.h"

class DSPKitFeedback : public DSPKitProcessor
{
  public:

    int setInput (DSPKitProcessor *ip);
    void setFeedbackInput (DSPKitProcessor *fip);
    void setFeedbackTime (double t);
    int getSample (double &outputSample);
    double getFeedbackTime () const;
    DSPKitProcessor *getFeedbackInput ();
    
  protected:

    DSPKitProcessor *feedbackInput;
    double          feedbackTime;
    int            feedbackSampleCount;
    int            feedbackSampleIndex;
    int            haveInput;
    int            haveFeedback;
};

inline DSPKitProcessor *DSPKitFeedback::getFeedbackInput ()
{
  return feedbackInput;
}

inline double DSPKitFeedback::getFeedbackTime () const
{
  return feedbackTime;
}

#endif

/***************************************************************************/
