/****************************************************************************
|                         Digital Audio Processor
|                         =======================
|
| Filename    : feedback.cc
|
| Object      : DSPKitFeedback
|
| Description : DSPKitFeedback
|
| (c) Richard Kent 1996
|
| $Id: feedback.cc,v 1.1 2003/09/10 00:06:25 rk Exp $
|
****************************************************************************/

static char feedback_cc [] = "$Id: feedback.cc,v 1.1 2003/09/10 00:06:25 rk Exp $";

#include "feedback.h"

int DSPKitFeedback::setInput (DSPKitProcessor *ip)
{
  if (DSPKitProcessor::setInput (ip) != 0) return -1;
  feedbackTime        = 0.0;
  feedbackSampleCount = 0;
  feedbackSampleIndex = 0;
  haveInput           = 1;
  feedbackInput       = 0;
  return 0;
}

void DSPKitFeedback::setFeedbackInput (DSPKitProcessor *fip)
{
  feedbackInput = fip;
  feedbackInput->setOutput (this);
  haveFeedback = 1;
}

void DSPKitFeedback::setFeedbackTime (double t)
{
  feedbackTime = t;
  feedbackSampleCount = (int)(feedbackTime * inputSamplingRate);
}

int DSPKitFeedback::getSample (double &outputSample)
{
  double feedbackSample;

  haveInput = input->getSample (outputSample);
  haveFeedback = feedbackInput->getSample (feedbackSample);
  
  if (!haveInput)    outputSample = 0.0;
  if (!haveFeedback) feedbackSample = 0.0;

  if (haveInput || feedbackSampleIndex < feedbackSampleCount)
  {
    outputSample += feedbackSample;
    if (haveFeedback)
    {
      if (!haveInput) feedbackSampleIndex++;
    }
    else
    {
      // Finish as soon as input finishes
      feedbackSampleIndex = feedbackSampleCount;
    }
    return 1;
  }
  else return 0;
}

/***************************************************************************/
