/****************************************************************************
|                         Digital Audio Processor
|                         =======================
|
| Filename    : fbdelay.h
|
| Object      : DSPKitFBDelay
|
| Description : DSPKitFBDelay
|
| (c) Richard Kent 1996
|
| $Id: fbdelay.h,v 1.1 2003/09/10 00:06:25 rk Exp $
|
****************************************************************************/

#ifndef _DSPKIT_FBDELAY_H_
#define _DSPKIT_FBDELAY_H_

#include "processo.h"

class DSPKitFBDelay : public DSPKitProcessor
{
  public:

    DSPKitFBDelay ();
    ~DSPKitFBDelay ();
    int setInputAndDelayTime (DSPKitProcessor *ip,double dt);
    int getSample (double &outputSample);

  protected:

    double delayTime;
    double *buffer;
    int   bufSize;
    int   oldestSampleIndex;
    int   lastSampleIndex;
    int   haveSamples;
    int   endOfInput;
};

#endif

/***************************************************************************/
