/****************************************************************************
|                         Digital Audio Processor
|                         =======================
|
| Filename    : dynamics.h
|
| Object      : DSPKitDynamicsProcessor
|
| Description : DSPKitDynamicsProcessor
|
| (c) Richard Kent 1996
|
| $Id: dynamics.h,v 1.1 2003/09/10 00:06:25 rk Exp $
|
****************************************************************************/

#ifndef _DSPKIT_DYNAMICSPROCESSOR_H_
#define _DSPKIT_DYNAMICSPROCESSOR_H_

#include "processo.h"

class DSPKitDynamicsProcessor : public DSPKitProcessor
{
  public:

    virtual int setInputAndEstimationTime (DSPKitProcessor *ip, double et);
    virtual void setThreshold (double value);
    int getSample (double &outputSample);
    virtual double getThreshold () const;

  protected:

    virtual void scaleBuffer () = 0;
    
    double *sampleBuffer;
    double absMax1;
    double absMax2;
    int   bufSize;
    int   halfInputBufSize;
    int   inputBufSize;
    int   readIndex;
    int   writeIndex;
    int   processIndex;
    double threshold;
    int   endOfInput;
    int   firstTime;
};

inline void DSPKitDynamicsProcessor::setThreshold (double value)
{
  if (value <= 0.0)
    value = 0.00001;

  threshold = value;
}

inline double DSPKitDynamicsProcessor::getThreshold () const
{
  return threshold;
}

#endif

/***************************************************************************/
