/****************************************************************************
|                         Digital Audio Processor
|                         =======================
|
| Filename    : dpwriter.h
|
| Object      : DSPKitDPWriter;
|
| Description : DSPKitDPWriter;
|
| (c) Richard Kent 1996
|
| $Id: dpwriter.h,v 1.1 2003/09/10 00:06:25 rk Exp $
|
****************************************************************************/

class DSPKitDPWriter;

#ifndef _DSPKIT_DPWRITER_H_
#define _DSPKIT_DPWRITER_H_

#include "DPSample.h"
#include "processo.h"

class DSPKitDPWriter : public DSPKitProcessor
{
  public:

    DSPKitDPWriter ();
    void setChannels (
      int newChannel_a,
      int newChannel_b);
    void setChannels (
      int newChannel_a,
      int newChannel_b,
      int newChannel_c,
      int newChannel_d);
    int setInputOutput (
      DSPKitProcessor *ipL,
      DSPKitProcessor *ipR,
      DPSample *newSample);
    int setInputOutput (
      DSPKitProcessor *ipL,
      DSPKitProcessor *ipR,
      DSPKitProcessor *ip3,
      DSPKitProcessor *ip4,
      DPSample *newSample);
    void run ();
    int getSample (double &);
    int getSamplesWritten () const;

  protected:

    int            samplesWritten;
    DSPKitProcessor *inputR;
    DSPKitProcessor *input3;
    DSPKitProcessor *input4;
    DPSample        *sample;
    int            i;
    int            frames;
    int            check;
    int            checkReset;
    int            channel_a;
    int            channel_b;
    int            channel_c;
    int            channel_d;
};

inline int DSPKitDPWriter::getSamplesWritten () const
{
  return samplesWritten;
}

inline int DSPKitDPWriter::getSample (double &)
{
  return 0;
}

#endif

/***************************************************************************/
