/****************************************************************************
|                         Digital Audio Processor
|                         =======================
|
| Filename    : dpreader.h
|
| Object      : DSPKitDPReader;
|
| Description : DSPKitDPReader;
|
| (c) Richard Kent 1996
|
| $Id: dpreader.h,v 1.1 2003/09/10 00:06:25 rk Exp $
|
****************************************************************************/

class DSPKitDPReader;

#ifndef _DSPKIT_DPREADER_H_
#define _DSPKIT_DPREADER_H_

#include "DPSample.h"
#include "processo.h"

class DSPKitDPReader : public DSPKitProcessor
{
  public:

    DSPKitDPReader ();
    int setReaderInput (
      DPSample *newSample,
      int newChannel,
      int newSusLoops,
      int newRelLoops);
    int getSample (double &outputSample);
    DSPKitProcessor *getInput () const;
    int getSampleCount () const;
    int getSamplesLeft () const;
    
  protected:

    int     sampleCount;
    int     samplesLeft;
    DPSample *sample;
    int     channel;
    int     susLoops;
    int     relLoops;
    int     susLoopsTemp;
    int     relLoopsTemp;
    int     i;
    int     frames;
    int     increment;
    int     tempSusLoopMode;
    int     tempRelLoopMode;
    int     susLoopStart;
    int     susLoopEnd;
    int     relLoopStart;
    int     relLoopEnd;
    int     check;
    int     checkReset;
};

inline DSPKitProcessor *DSPKitDPReader::getInput () const
{
  return 0;
}

inline int DSPKitDPReader::getSampleCount () const
{
  return sampleCount;
}

inline int DSPKitDPReader::getSamplesLeft () const
{
  return samplesLeft;
}

#endif

/***************************************************************************/
