/****************************************************************************
|                         Digital Audio Processor
|                         =======================
|
| Filename    : complim.h
|
| Object      : DSPKitCompressorLimiter
|
| Description : DSPKitCompressorLimiter
|
| (c) Richard Kent 1996
|
| $Id: complim.h,v 1.1 2003/09/10 00:06:25 rk Exp $
|
****************************************************************************/

#ifndef _DSPKIT_COMPRESSORLIMITER_H_
#define _DSPKIT_COMPRESSORLIMITER_H_

#include "compress.h"
#include "limiter.h"

class DSPKitCompressorLimiter : public DSPKitProcessor
{
  public:

    int setInputAndEstimationTime
      (DSPKitProcessor *ip,double et);
    int setInputAndEstimationTime
      (DSPKitProcessor *ip,double compet,double limet);
    void setCompressorThreshold (double value);
    void setLimiterThreshold (double value);
    void setCompressionRatio (double value);

  protected:

    DSPKitCompressor compressor;
    DSPKitLimiter    limiter;
};

inline void DSPKitCompressorLimiter::setCompressorThreshold (double value)
{
  compressor.setThreshold (value);
}

inline void DSPKitCompressorLimiter::setLimiterThreshold (double value)
{
  limiter.setThreshold (value);
}

inline void DSPKitCompressorLimiter::setCompressionRatio (double value)
{
  compressor.setRatio (value);
}

#endif

/***************************************************************************/
