/****************************************************************************
|                         Digital Audio Processor
|                         =======================
|
| Filename    : combint.h
|
| Object      : DSPKitCombInt
|
| Description : DSPKitCombInt
|
| (c) Richard Kent 1996
|
| $Id: combint.h,v 1.1 2003/09/10 00:06:25 rk Exp $
|
****************************************************************************/

#ifndef _DSPKIT_COMBINT_H_
#define _DSPKIT_COMBINT_H_

#include "processo.h"
#include "delayint.h"
#include "amp.h"
#include "mux.h"
#include "feedback.h"

class DSPKitCombInt : public DSPKitProcessor
{
  public:

    int setInputAndDelayTime (DSPKitProcessor *ip,double dt);
    int setModInput (DSPKitProcessor *mip);
    void setReverbTime (double rt);
    void setG (double newG);
    double getReverbTime () const;
    double getG () const;

  protected:

    double         reverbTime;
    double         delayTime;
    double         g;
    DSPKitFeedback feedback;
    DSPKitDelayInt fbdelay;
    DSPKitAmp      amp;
    DSPKitMux      mux;
};

inline double DSPKitCombInt::getReverbTime () const
{
  return reverbTime;
}

inline double DSPKitCombInt::getG () const
{
  return g;
}

#endif

/***************************************************************************/
