/****************************************************************************
|                         Digital Audio Processor
|                         =======================
|
| Filename    : comb.h
|
| Object      : DSPKitComb
|
| Description : DSPKitComb
|
| (c) Richard Kent 1996
|
| $Id: comb.h,v 1.1 2003/09/10 00:06:25 rk Exp $
|
****************************************************************************/

#ifndef _DSPKIT_COMB_H_
#define _DSPKIT_COMB_H_

#include "processo.h"
#include "fbdelay.h"
#include "amp.h"
#include "mux.h"
#include "feedback.h"

class DSPKitComb : public DSPKitProcessor
{
  public:

    int setInputAndDelayTime (DSPKitProcessor *ip,double dt);
    void setReverbTime (double rt);
    void setG (double newG);
    double getReverbTime () const;
    double getG () const;

  protected:

    double         reverbTime;
    double         delayTime;
    double         g;
    DSPKitFeedback feedback;
    DSPKitFBDelay  fbdelay;
    DSPKitAmp      amp;
    DSPKitMux      mux;
};

inline double DSPKitComb::getReverbTime () const
{
  return reverbTime;
}

inline double DSPKitComb::getG () const
{
  return g;
}

#endif

/***************************************************************************/
