/****************************************************************************
|                         Digital Audio Processor
|                         =======================
|
| Filename    : bwhighpa.cc
|
| Object      : DSPKitBWHighPassFilter
|
| Description : DSPKitBWHighPassFilter
|
| (c) Richard Kent 1996
|
| $Id: bwhighpa.cc,v 1.1 2003/09/10 00:06:25 rk Exp $
|
****************************************************************************/

static char bwhighpa_cc [] = "$Id: bwhighpa.cc,v 1.1 2003/09/10 00:06:25 rk Exp $";

#include "bwhighpa.h"

void DSPKitBWHighPassFilter::setCutOffFreq (double f)
{
  cutOffFreq = f;
  C = tan (M_PI * cutOffFreq / inputSamplingRate);

  a [0] = 1.0 / (1.0 + sqrt (2.0) * C + C * C);
  a [1] = -2.0 * a [0];
  a [2] = a [0];

  b [0] = 2.0 * (C * C - 1.0) * a [0];
  b [1] = (1.0 - sqrt (2.0) * C + C * C) * a [0];
}

/***************************************************************************/
