/****************************************************************************
|                         Digital Audio Processor
|                         =======================
|
| Filename    : bwbandpa.cc
|
| Object      : DSPKitBWBandPassFilter
|
| Description : DSPKitBWBandPassFilter
|
| (c) Richard Kent 1996
|
| $Id: bwbandpa.cc,v 1.1 2003/09/10 00:06:25 rk Exp $
|
****************************************************************************/

static char bwbandpa_cc [] = "$Id: bwbandpa.cc,v 1.1 2003/09/10 00:06:25 rk Exp $";

#include "bwbandpa.h"

void DSPKitBWBandPassFilter::setCenterFreqAndBW (double f,double bw)
{
  centerFreq = f;
  bandwidth  = bw;

  C = 1.0 / tan (M_PI * bandwidth / inputSamplingRate);
  D = 2 * cos (2 * M_PI * centerFreq / inputSamplingRate);

  a [0] = 1.0 / (1.0 + C);
  a [1] = 0.0;
  a [2] = -a [0];

  b [0] = -C * D * a [0];
  b [1] = (C - 1.0) * a [0];
}

/***************************************************************************/
