/****************************************************************************
|                         Digital Audio Processor
|                         =======================
|
| Filename    : butterwo.h
|
| Object      : DSPKitButterworthFilter
|
| Description : DSPKitButterworthFilter
|
| (c) Richard Kent 1996
|
| $Id: butterwo.h,v 1.1 2003/09/10 00:06:25 rk Exp $
|
****************************************************************************/

#ifndef _DSPKIT_BUTTERWORTH_H_
#define _DSPKIT_BUTTERWORTH_H_

#include "processo.h"

typedef struct BWBuffer
{
  double x [2];
  double y [2];

} BWBuffer;

class DSPKitButterworthFilter : public DSPKitProcessor
{
  public:

    int setInput (DSPKitProcessor *ip);
    int getSample (double &outputSample);

  protected:

    double   cutOffFreq;
    double   C;
    double   D;
    double   a [3];
    double   b [2];
    BWBuffer chBuf;
};

#endif

/***************************************************************************/
