/****************************************************************************
|                         Digital Audio Processor
|                         =======================
|
| Filename    : amp.h
|
| Object      : DSPKitAmp
|
| Description : DSPKitAmp
|
| (c) Richard Kent 1996
|
| $Id: amp.h,v 1.1 2003/09/10 00:06:25 rk Exp $
|
****************************************************************************/

#ifndef _DSPKIT_AMP_H_
#define _DSPKIT_AMP_H_

#include "processo.h"

class DSPKitAmp : public DSPKitProcessor
{
  public:

    DSPKitAmp ();
    void setGain (double g);
    int getSample (double &outputSample);
    double getGain () const;

  protected:

    double gain;
};

inline DSPKitAmp::DSPKitAmp ()
{
  gain = 1.0;
}

inline void DSPKitAmp::setGain (double g)
{
  gain = g;
}

inline double DSPKitAmp::getGain () const
{
  return gain;
}

#endif

/***************************************************************************/
