/****************************************************************************
|                         Digital Audio Processor
|                         =======================
|
| Filename    : allpassn.cc
|
| Object      : DSPKitAllPassNetwork
|
| Description : DSPKitAllPassNetwork
|
| (c) Richard Kent 1996
|
| $Id: allpassn.cc,v 1.1 2003/09/10 00:06:25 rk Exp $
|
****************************************************************************/

static char allpassn_cc [] = "$Id: allpassn.cc,v 1.1 2003/09/10 00:06:25 rk Exp $";

#include "allpassn.h"

DSPKitAllPassNetwork::DSPKitAllPassNetwork ()
{
  reverbTime = 2.0;
  delayTime  = 0.1;
  g = pow (0.001,delayTime / reverbTime);
}

int DSPKitAllPassNetwork::setInputAndDelayTime
  (DSPKitProcessor *ip, double dt)
{
  delayTime  = dt;
  reverbTime = 3.0 * delayTime / log10 (1.0 / g);
  mux1.setInput (ip);
  amp1.setInput (&mux1);
  amp1.setGain (-g);
  sum.setInput (&amp1);
  feedback.setInput (&mux1);
  feedback.setFeedbackTime (reverbTime);
  delay.setInputAndDelayTime (&feedback,delayTime);
  mux2.setInput (&delay);
  amp2.setInput (&mux2);
  amp2.setGain (1.0 - g*g);
  sum.addInput (&amp2);
  amp3.setInput (&mux2);
  amp3.setGain (g);
  feedback.setFeedbackInput (&amp3);
  return DSPKitProcessor::setInput (&sum);
}

void DSPKitAllPassNetwork::setG (double newG)
{
  if (newG <= 0.0)
    g = 0.00001;
  else if (newG >= 1.0)
    g = 0.99999;
  else
    g = newG;

  reverbTime = 3.0 * delayTime / log10 (1.0 / g);
  feedback.setFeedbackTime (reverbTime);
  amp1.setGain (-g);
  amp2.setGain (1.0 - g*g);
  amp3.setGain (g);
}

void DSPKitAllPassNetwork::setReverbTime (double rt)
{
  reverbTime = rt;
  g = pow (0.001, delayTime / reverbTime);
  feedback.setFeedbackTime (reverbTime);
  amp1.setGain (-g);
  amp2.setGain (1.0 - g*g);
  amp3.setGain (g);
}

/***************************************************************************/
