/****************************************************************************
|                         Digital Audio Processor
|                         =======================
|
| Filename    : allpassi.h
|
| Object      : DSPKitAllPassNetworkInt
|
| Description : DSPKitAllPassNetworkInt
|
| (c) Richard Kent 1996
|
| $Id: allpassi.h,v 1.1 2003/09/10 00:06:25 rk Exp $
|
****************************************************************************/

#ifndef _DSPKIT_ALLPASSNETWORKINT_H_
#define _DSPKIT_ALLPASSNETWORKINT_H_

#include "processo.h"
#include "feedback.h"
#include "mux.h"
#include "sum.h"
#include "amp.h"
#include "delayint.h"

class DSPKitAllPassNetworkInt : public DSPKitProcessor
{
  public:

    DSPKitAllPassNetworkInt ();
    int setInputAndDelayTime (DSPKitProcessor *ip, double dt);
    int setModInput (DSPKitProcessor *mip);
    void setG (double newG);
    void setReverbTime (double rt);
    double getReverbTime () const;
    double getDelayTime () const;
    double getG () const;

  protected:

    double         reverbTime;
    double         delayTime;
    double         g;
    DSPKitFeedback feedback;
    DSPKitSum      sum;
    DSPKitDelayInt delay;
    DSPKitAmp      amp1;
    DSPKitAmp      amp2;
    DSPKitAmp      amp3;
    DSPKitMux      mux1;
    DSPKitMux      mux2;
};

inline double DSPKitAllPassNetworkInt::getReverbTime () const
{
  return reverbTime;
}

inline double DSPKitAllPassNetworkInt::getDelayTime () const
{
  return delayTime;
}

inline double DSPKitAllPassNetworkInt::getG () const
{
  return g;
}

#endif

/***************************************************************************/
