/****************************************************************************
|                         Digital Audio Processor
|                         =======================
|
| Filename    : DPDefs.h
|
| Object      : None
|
| Description : Standard definitions file
|
| (c) Richard Kent 1996
|
| $Id: DPDefs.h,v 1.1 2003/09/10 00:06:25 rk Exp $
|
****************************************************************************/

#ifndef _DPDefs_h
#define _DPDefs_h

#include <iostream>
#include <iomanip>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <new>
#include <math.h>
#include <ctype.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <signal.h>
#include <string.h>

#ifdef LINUX
#include "libaudio/audio.h"
#else
#include <dmedia/audio.h>
#include <dmedia/audioutil.h>
#endif

// Don't use <dmedia/audiofile.h> any more
#include "libaudiofile/audiofile.h"
#include "libaudiofile/wav.h"
#include "libaudiofile/raw.h"
#include "libaudiofile/macros.h"

#ifndef NOFORMS
#include "forms.h"
#include "DPTich_main.h"
#else
#define FL_OBJECT void
#endif

// Standard boolean values

#ifndef TRUE
#define TRUE  1
#endif
#ifndef FALSE
#define FALSE 0
#endif

#define ERROR   0
#define NOERROR 1

// Standard Functions

#define DPPI         (atan (1.0) * 4.0)
#define SQR(X)       ((X) * (X))
#define TORADIANS(X) (((X) * DPPI) / 180.0)
#define TODEGREES(X) (((X) * 180.0) / DPPI)
#define CLS          system ("clear")
#define WAITRETURN   while (getchar () != '\n') { }

// Miscellaneous defines

#define MAX32   4294967296LL
#define MAX32_1 4294967295U
#define MAX31   2147483648U
#define MAX31_1 2147483647
#define MAX24   16777216
#define MAX24_1 16777215
#define MAX23   8388608
#define MAX23_1 8388607
#define MAX16   65536
#define MAX16_1 65535
#define MAX15   32768
#define MAX15_1 32767
#define MAX8    256
#define MAX8_1  255
#define MAX7    128
#define MAX7_1  127

#endif // _DPDefs_h
