/****************************************************************************
|                         Digital Audio Processor
|                         =======================
|
| Filename    : DPTich_main.h
|
| Object      : None
|
| Description : Main code header file
|
| (c) Richard Kent 1996
|
| $Id: DPTich_main.h,v 1.2 2003/09/15 22:37:04 rk Exp $
|
****************************************************************************/

#ifndef _DPTich_main_h
#define _DPTich_main_h

// #define LINUX - defined in makefile if for linux
// #define BIGENDIAN - defined in makefile for shite pc mode
// #define TEST - to auto setup audio globals properly !!

#include "forms.h"
#include "DPSample.h"
#include "DPResample.h"
#include "DPMixPlay.h"
#include "DPSampleXforms.h"
#include "DPTich_cb.h"
#include "DPTich_DSP.h"
#include "DPTich_prefs.h"
#include "DPTich_macros.h"
#include "tooltips.h"
#include <spkit/spkit.h>

#define VERSIONSTRING "2.1.5"

#ifdef USINGGCC
// Using gcc DPTich is compiled with C linkage
extern "C"
{
  #include "DPTich.h"
}
#else
// Using CC DPTich is compiled with C++ linkage
#include "DPTich.h"
#endif

#ifdef SUN
extern "C"
{
  double rint (double);
  int strcasecmp (const char *,const char *);

  extern char *mktemp (char *);
  extern FILE *popen (const char *,const char *);
  extern int pclose (FILE *);
}
#endif

#define METERQUEUESIZE   1024
#define SINEOUTQUEUESIZE 4096
#define AUDIOUPDATE      50
#define TITLE            "Digital Audio Processor"
#define MAXPARAMS        35
#define MAXENUMS         20
#define MIXER_ROWSIZE    240
#define MIXER_COLSIZE    44
#define MIXER_BORDERX    10
#define MIXER_BORDERY    10
#define MIXER_INTERX     7
#define MIXER_INTERY     7

typedef struct
{
  char *name;
  char *chan;
  int  type;
  
  double realMin;
  double realMax;
  double realStep;
  double realDefault;
  double realValue;
  char   *realUnits;
  char   *realPrintString;
  
  int  enumNo;
  char *enumNames [MAXENUMS];
  int  enumDefault;
  int  enumValue;

} paramType;

typedef struct
{
  char *name;
  int  paramNo;
  paramType param [MAXPARAMS];

} effectType;

typedef struct
{
  int effectNo;
  effectType *effect;

} allEffectsType;

extern FD_mainForm        *mainForm;
extern FD_playForm        *playForm;
extern FD_zoomForm        *zoomForm;
extern FD_displayForm     *displayForm;
extern FD_rangeForm       *rangeForm;
extern FD_loopForm        *loopForm;
extern FD_newForm         *newForm;
extern FD_recordForm      *recordForm;
extern FD_convertForm     *convertForm;
extern FD_mixForm         *mixForm;
extern FD_channelForm     *channelForm;
extern FD_duplicateForm   *duplicateForm;
extern FD_panoramaForm    *panoramaForm;
extern FD_workspaceForm   *workspaceForm;
extern FD_miscForm        *miscForm;
extern FD_rateForm        *rateForm;
extern FD_ampForm         *ampForm;
extern FD_balanceForm     *balanceForm;
extern FD_bounceForm      *bounceForm;
extern FD_rampForm        *rampForm;
extern FD_resampleForm    *resampleForm;
extern FD_pitchForm       *pitchForm;
extern FD_bufferForm      *bufferForm;
extern FD_mixplayForm     *mixplayForm;
extern FD_selectForm      *selectForm;
extern FD_adjustDCForm    *adjustDCForm;
extern FD_initialForm     *initialForm;
extern FD_effectForm      *effectForm;
extern FD_executeForm     *executeForm;
extern FD_postForm        *postForm;
extern FD_aboutForm       *aboutForm;
extern FD_stretchForm     *stretchForm;
extern FD_convert4to1Form *convert4to1Form;
extern FD_convert4to2Form *convert4to2Form;
extern FD_convert2to4Form *convert2to4Form;
extern FD_channel4Form    *channel4Form;
extern FD_bounce4Form     *bounce4Form;
extern FD_prefsForm       *prefsForm;
extern FD_mixerForm       *mixerForm;
extern FD_macroForm       *macroForm;
extern FD_macroexecForm   *macroexecForm;
extern FD_macroinfoForm   *macroinfoForm;
extern FD_rawForm         *rawForm;

extern Display            *display;
extern FL_OBJECT          *format;
extern FL_OBJECT          *compression;

extern DPSample           *buffer [8];
extern DPSample           *undo [2];
extern DPSample           *redo [2];
extern char               *undoStr [2];
extern char               *redoStr [2];
extern DPSample           *clip;

extern int                current;
extern double             currentPitch;

extern ALport             globalInputPort;
extern ALport             globalOutputPort;
extern int               globalChannels;

extern int               DSPCancel;
extern int               DSPStop;
extern int               DSPTime;
extern double             DSPMix;
extern double             DSPMaster;
extern int               DSPPlayStop;

extern DSPKitDPReader     *DSPReader_L;
extern DSPKitDPReader     *DSPReader_R;
extern DSPKitDPWriter     *DSPWriter;

extern allEffectsType     *effects;
extern FL_OBJECT          *DSPname   [MAXPARAMS];
extern FL_OBJECT          *DSPchan   [MAXPARAMS];
extern FL_OBJECT          *DSPinput  [MAXPARAMS];
extern FL_OBJECT          *DSPunits  [MAXPARAMS];
extern FL_OBJECT          *DSPslider [MAXPARAMS];
extern FL_OBJECT          *DSPchoice [MAXPARAMS];

extern double             recordAdjustLeft;
extern double             recordAdjustRight;
extern double             recordAdjustThree;
extern double             recordAdjustFour;
extern int                stretchCancel;
extern int                initialFormHeight;
extern int                recordFormWidth;
extern int                preferencesChanged;
extern int                macrosChanged;

extern int                normalIdle;
extern int                heavyIdle;

#ifdef LINUX
extern FL_OBJECT *mixerSliders [SOUND_MIXER_NRDEVICES * 2];
extern FL_OBJECT *mixerInButtons [SOUND_MIXER_NRDEVICES];
extern FL_OBJECT *mixerOutButtons [SOUND_MIXER_NRDEVICES];
extern FL_OBJECT *mixerRecButtons [SOUND_MIXER_NRDEVICES];
extern FL_OBJECT *mixerLockButtons [SOUND_MIXER_NRDEVICES];
extern FL_OBJECT *mixerMuteButtons [SOUND_MIXER_NRDEVICES];
extern FL_OBJECT *mixerLabels [SOUND_MIXER_NRDEVICES];
extern FL_OBJECT *mixerInGroup;
extern FL_OBJECT *mixerOutGroup;
#endif

int checkAudio ();
void loadSamples (int argc,char *argv []);
void initialiseForms (void);
void initialiseEffects (void);
int  updateAudioGlobals (XEvent *xev,void *data);
void updateConvertMenu (void);
void updateNameBox (void);
void updateDisplayDetails (void);
void checkManualEdit ();
void updateRangeDetails (void);
void updateLoopDetails (void);
void updateNewDetails (void);
void interrupt (int signum,void *data);
void interruptDirect (int sig);
int  closeAll (FL_FORM *form,void *data);
int  fl_show_question_old (const char *s1,const char *s2,const char *s3);
void waitCursorOn ();
void waitCursorOff ();
const char *fl_safe_get_input (FL_OBJECT *ob);
char *fselector (
  char *message,
  char *filter,
  char *defaultfile,
  DPSample *sample);
char *dap_dirname (char *dir);
char *dap_basename (char *dir);
char *dap_no_extension (char *dir);
#ifdef LINUX
void initialiseLinuxForms (void);
void addMixerSlider (
  FL_FORM *form,
  int chan,
  int stereo,
  int rec,
  int row,
  int col);
#endif

#endif // _DPTich_main_h

/***************************************************************************/
