/****************************************************************************
|                         Digital Audio Processor
|                         =======================
|
| Filename    : DPTich_cb.h
|
| Object      : None
|
| Description : Callbacks header file (for additional functions)
|
| (c) Richard Kent 1996
|
| $Id: DPTich_cb.h,v 1.1 2003/09/10 00:06:24 rk Exp $
|
****************************************************************************/

#ifndef _DPTich_cb_h
#define _DPTich_cb_h

#include <X11/cursorfont.h>

#define updateBuffers(string)                                               \
{                                                                           \
  if (fl_get_sample_undomode (mainForm->sample) && !updateUndo (string))    \
  {                                                                         \
    return;                                                                 \
  }                                                                         \
}

#define noSampleWarning                                                     \
{                                                                           \
  if (!sample->getValid ())                                                 \
  {                                                                         \
    fl_show_alert ("This operation requires a valid sample buffer",         \
    "There is no valid sample in this buffer","",TRUE);                     \
    return;                                                                 \
  }                                                                         \
}

#define noRangeWarning                                                      \
{                                                                           \
  if (!sample->getRangeValid ())                                            \
  {                                                                         \
    fl_show_alert ("This operation requires a valid range",                 \
    "There is no range currently selected",                                 \
    "Please select a range and try again",TRUE);                            \
    return;                                                                 \
  }                                                                         \
}

#define zeroRangeWarning                                                    \
{                                                                           \
  if (sample->getRangeStart () == sample->getRangeEnd ())                   \
  {                                                                         \
    fl_show_alert ("This operation requires a non zero range",              \
    "The current range has zero duration",                                  \
    "Please select a larger range and try again",TRUE);                     \
    return;                                                                 \
  }                                                                         \
}

#define noClipWarning                                                       \
{                                                                           \
  if (!clip->getValid ())                                                   \
  {                                                                         \
    fl_show_alert ("This operation requires a valid clip buffer",           \
    "The clip buffer is currently empty",                                   \
    "Please fill the clip buffer and try again",TRUE);                      \
    return;                                                                 \
  }                                                                         \
}

#define noStereoWarning                                                     \
{                                                                           \
  if (sample->getChannels () == 1)                                          \
  {                                                                         \
    fl_show_alert ("This operation requires a stereo or quadro sample",     \
    "The current sample is mono",                                           \
    "You cannot perform this operation on a mono sample",TRUE);             \
    return;                                                                 \
  }                                                                         \
  else if (sample->getChannels () == 2 &&                                   \
  fl_get_sample_edit (mainForm->sample) != 2)                               \
  {                                                                         \
    fl_show_alert ("This operation requires a stereo range",                \
    "The current edit mode is mono",                                        \
    "Please change the edit mode to stereo and try again",TRUE);            \
    return;                                                                 \
  }                                                                         \
  else if (sample->getChannels () == 4 &&                                   \
  fl_get_sample_edit (mainForm->sample) != 2)                               \
  {                                                                         \
    fl_show_alert ("This operation requires a quadro range",                \
    "The current edit mode is mono",                                        \
    "Please change the edit mode to quadro and try again",TRUE);            \
    return;                                                                 \
  }                                                                         \
}

#define numToVol(num)                                                       \
  (int) rint (0.0255 * ((num) * (num)));

#define numToVolOld(num)                                                    \
  (int) rint ((num) * 2.55);

#define volToNum(vol)                                                       \
  (int) rint (sqrt ((double) (vol) / 0.0255));

#define volToNumOld(vol)                                                    \
  (int) rint ((double) (vol) / 2.55);

#define recToNum(vol)                                                       \
  100 - (int) rint (sqrt ((double) (vol) / 0.0254));

#define recToNumOld(vol)                                                    \
  (int) rint ((vol) / 2.55);

int keyboardHandle (
  FL_OBJECT *obj,
  int event,
  FL_Coord mx,
  FL_Coord my,
  int key,
  void *xev);

void saveFileFormat_cb (FL_OBJECT *ob,long data);
void saveFileCompression_cb (FL_OBJECT *ob,long data);
void updateSampleFormatCompression (DPSample *sample);
void updateSaveFormatCompression (int newFormat,int newCompression);
void updateEditModeChoice (int channels);
void updateMixPlot ();
void initialiseRampForm ();
void updateRampForm ();
void updateRampPlot ();
void initialiseResampleForm ();
void updateResampleForm (int mode);
void initialisePitchForm ();
void updatePitchForm ();
void bigSemiToSemi (double bigsemi,int *oct,int *semi,int *cent,int *dir);
void semiToBigSemi (double *bigsemi,int oct,int semi,int cent,int dir);
char *semiToStr (int semi);
int  strToSemi (char *str);
void updateBufferBrowser ();
void updateCopyBrowser (int unselect);
void bufferSelectDbl_cb (FL_OBJECT *ob,long data);
void bufferOKDbl_cb (FL_OBJECT *ob,long data);
int  updateUndo (char *name);
void performUndo ();
void performRedo ();
void mixplaySelectDbl_cb (FL_OBJECT *ob,long data);
void initialiseMixplayForm (int mode);
void initialiseSelectForm ();
void selectOKDbl_cb (FL_OBJECT *ob,long data);
void effectSlider_cb (FL_OBJECT *ob,long data);
void effectInput_cb (FL_OBJECT *ob,long data);
void effectChoice_cb (FL_OBJECT *ob,long data);
char *postMixPlay ();
void postMixGenerate (DPSample *newSample);
void rememberForms (int mode);
void clearBuffers ();
void updateSample (DPSample *sample);
void updateRangeForms ();
void updateClipForms ();
int mainRawEventHandler_cb (FL_FORM *form,void *xevent);
#ifdef LINUX
void closeGlobalPorts ();
void mixerSlider_cb (FL_OBJECT *ob,long data);
void mixerIn_cb (FL_OBJECT *ob,long data);
void mixerOut_cb (FL_OBJECT *ob,long data);
void mixerRec_cb (FL_OBJECT *ob,long data);
void mixerLock_cb (FL_OBJECT *ob,long data);
void mixerMute_cb (FL_OBJECT *ob,long data);
#endif

#endif // _DPTich_cb_h

/***************************************************************************/
