/****************************************************************************
|                         Digital Audio Processor
|                         =======================
|
| Filename    : DPTich_cb.cc
|
| Object      : None
|
| Description : XForms callback code
|
| (c) Richard Kent 1996
|
| $Id: DPTich_cb.cc,v 1.1 2003/09/10 00:06:24 rk Exp $
|
****************************************************************************/

static char DPTich_cb_cc [] = "$Id: DPTich_cb.cc,v 1.1 2003/09/10 00:06:24 rk Exp $";

#include "DPTich_main.h"

/*---------------------------------------------------------------------------
| CALLBACK saveFileFormat_cb
---------------------------------------------------------------------------*/

void saveFileFormat_cb (FL_OBJECT *ob,long)
{
  if (fl_get_choice (ob) == 1)
    fl_set_choice (compression,1);
}

/*---------------------------------------------------------------------------
| CALLBACK saveFileCompression_cb
---------------------------------------------------------------------------*/

void saveFileCompression_cb (FL_OBJECT *ob,long)
{
  if (fl_get_choice (ob) != 1)
    fl_set_choice (format,2);
}

/*---------------------------------------------------------------------------
| CALLBACK aboutDismiss_cb
---------------------------------------------------------------------------*/

void aboutDismiss_cb (FL_OBJECT *,long)
{
  fl_hide_form (aboutForm->aboutForm);
}

/*---------------------------------------------------------------------------
| CALLBACK mainHelpMenu_cb
---------------------------------------------------------------------------*/

void mainHelpMenu_cb (FL_OBJECT *ob,long)
{
  int i;
  int item = 1;
  
  if (ob) item = fl_get_menu (ob);
  
  switch (item)
  {
    case 1 :
      // Initialise about form
      i = 0;
      fl_set_object_label (aboutForm->line [i++],
        "Digital Audio Processor");
      fl_set_object_label (aboutForm->line [i++],
        "Copyright (c) 2002 Richard Kent");
      fl_set_object_label (aboutForm->line [i++],
        "Version " VERSIONSTRING);
      fl_set_object_label (aboutForm->line [i++],
        "");
      fl_set_object_label (aboutForm->line [i++],
        "DAP comes with ABSOLUTELY NO WARRANTY. This is free");
      fl_set_object_label (aboutForm->line [i++],
        "software, and you are welcome to redistribute it under certain");
      fl_set_object_label (aboutForm->line [i++],
        "conditions. See COPYING for further details");
      fl_set_object_label (aboutForm->line [i++],
        "");
      fl_set_object_label (aboutForm->line [i++],
        "Please EMail me with bug reports, suggestions, comments,");
      fl_set_object_label (aboutForm->line [i++],
        "general banter and anything else you can think of !!!!");
      fl_set_object_label (aboutForm->line [i++],
        "");
      fl_set_object_label (aboutForm->line [i++],
        "Email me at: richardk@cee.hw.ac.uk");
      break;
  
    case 2 :
      // Initialise about form
      i = 0;
      fl_set_object_label (aboutForm->line [i++],
        "Keyboard Shortcuts");
      fl_set_object_label (aboutForm->line [i++],
        "");
      fl_set_object_label (aboutForm->line [i++],
        "Play - Sample (S), Display (D), Range (R)");
      fl_set_object_label (aboutForm->line [i++],
        "Stop (Space), Release (Alt-Space)");
      fl_set_object_label (aboutForm->line [i++],
        "Zoom - In (Up), Out (Down), All (A)");
      fl_set_object_label (aboutForm->line [i++],
        "Scroll To - Begin ([), End (])");
      fl_set_object_label (aboutForm->line [i++],
        "Scroll Left - Fast (Left), Slow (Alt-Left)");
      fl_set_object_label (aboutForm->line [i++],
        "Scroll Right - Fast (Right), Slow (Alt-Right)");
      fl_set_object_label (aboutForm->line [i++],
        "");
      fl_set_object_label (aboutForm->line [i++],
        "Other standard shortcuts shown in menus. eg Open (Control-O),");
      fl_set_object_label (aboutForm->line [i++],
        "Save (Control-S), Select All (Control-A), New (Control-N),");
      fl_set_object_label (aboutForm->line [i++],
        "Cut (Control-X), Copy (Control-C), Paste (Control-V)");
      break;
  
    default :
      return;
  }
  
  fl_show_form (aboutForm->aboutForm,
  FL_PLACE_MOUSE,FL_FULLBORDER,"About");
}

/*---------------------------------------------------------------------------
| CALLBACK mainNewButton_cb
---------------------------------------------------------------------------*/
void mainNewButton_cb (FL_OBJECT *,long)
{
  updateNewDetails ();
  fl_show_form (newForm->newForm,
  FL_PLACE_MOUSE,FL_FULLBORDER,"New");
}

/*---------------------------------------------------------------------------
| CALLBACK mainOpenButton_cb
---------------------------------------------------------------------------*/
void mainOpenButton_cb (FL_OBJECT *,long)
{
  DPSample *sample;
  char *error;
  const char *filename;

  if (buffer [current]->getChanged ())
    if (!fl_show_question_old
      ("Warning","This buffer contains unsaved data","Really open ?"))
      return;

  filename = fselector
    ("Please enter the filename to load","*.aiff",0,0);

  if (filename)
  {
    sample = new DPSample;
    waitCursorOn ();
    if ((error = sample->loadAIFF ((char *) filename)))
    {
      waitCursorOff ();
      fl_show_alert ("Warning - Could not load file",
        filename,error,TRUE);
      delete sample;
    }
    else
    {
      waitCursorOff ();
      clearBuffers ();
      fl_set_sample (mainForm->sample,sample);
      delete buffer [current];
      buffer [current] = sample;
      updateSample (sample);
    }
  }
}

/*---------------------------------------------------------------------------
| CALLBACK mainSaveButton_cb
---------------------------------------------------------------------------*/
void mainSaveButton_cb (FL_OBJECT *,long)
{
  DPSample *sample;
  char *error;
  char *filename;
  char filenamebuffer [1024];
  char *newfilename = 0;

  sample = buffer [current];
  noSampleWarning
  filename = sample->getFilename ();
  
  if (filename)
  {
    waitCursorOn ();
    if ((error = sample->saveAIFF
      (0,0,fl_get_sample_soxcompatible (mainForm->sample),0)))
    {
      waitCursorOff ();
      fl_show_alert ("Warning - Could not save file",
        filename,error,TRUE);
    }
    else
    {
      waitCursorOff ();
      sample->consolidate ();
      sample->removeExtra ();
    }
    return;
  }

  // Fall through to "save as"
  
  if (filename)
  {
    sprintf (filenamebuffer,"%s",dap_basename(filename));
    newfilename = filenamebuffer;
  }

  filename = fselector
    ("Please enter the filename to save","*.aiff",newfilename,sample);

  if (filename)
  {
    int irixFile = open (filename,O_RDONLY);
    if (irixFile != -1)
    {
      close (irixFile);
      if (!fl_show_question_old (filename,"exists already - overwrite ?",0))
        return;
    }
    waitCursorOn ();
    if ((error = sample->saveAIFF ((char *) filename,0,
      fl_get_sample_soxcompatible (mainForm->sample),1)))
    {
      waitCursorOff ();
      fl_show_alert ("Warning - Could not save file",
        filename,error,TRUE);
    }
    else
    {
      waitCursorOff ();
      updateNameBox ();
      updateBufferBrowser ();
      sample->consolidate ();
      sample->removeExtra ();
    }
  }
}

/*---------------------------------------------------------------------------
| CALLBACK mainRawEventHandler_cb
---------------------------------------------------------------------------*/
int mainRawEventHandler_cb (FL_FORM *,void *xevent)
{
  if(xevent && ((XEvent *) xevent)->type == KeyPress)
  {
    XKeyPressedEvent *keyevent = (XKeyPressedEvent *) xevent;
    
    if (keyevent->state == ControlMask ||
      keyevent->state == (ShiftMask | ControlMask))
    {
      KeySym key;
      
      /* Control or Control-Shift is held */
      key = XLookupKeysym (keyevent,ShiftMapIndex);
      if (!strcmp (XKeysymToString (key),"q"))
      {
        /* Ctrl-Q = Quit */
        if (closeAll (mainForm->mainForm,0) == FL_OK)
          exit (0);
        return FL_PREEMPT;
      }
    }
  }
  return 0;
}

/*---------------------------------------------------------------------------
| CALLBACK mainCopyButton_cb
---------------------------------------------------------------------------*/
void mainCopyButton_cb (FL_OBJECT *,long)
{
  DPSample *sample = fl_get_sample (mainForm->sample);

  zeroRangeWarning
  waitCursorOn ();
  sample->copy (clip,fl_get_sample_edit (mainForm->sample));
  int rangeStartBak = sample->getRangeStart ();
  int rangeEndBak   = sample->getRangeEnd ();
  for (int i=0; i<4; i++)
  {
    sample->setRangeValid (FALSE);
    fl_redraw_object (mainForm->sample);
    sample->setRange (rangeStartBak,rangeEndBak);
    fl_redraw_object (mainForm->sample);
  }
  waitCursorOff ();
  updateDisplayDetails ();
  updateRangeDetails ();
  updateLoopDetails ();
  fl_redraw_object (mainForm->sample);
  fl_redraw_object (mainForm->scrollBarSlider);
  fl_redraw_object (mainForm->zoomBarSlider);
  updateClipForms ();
}

/*---------------------------------------------------------------------------
| CALLBACK mainCutButton_cb
---------------------------------------------------------------------------*/
void mainCutButton_cb (FL_OBJECT *,long)
{
  DPSample *sample = fl_get_sample (mainForm->sample);

  zeroRangeWarning
  updateBuffers ("Undo Cut")
  waitCursorOn ();
  sample->cut (clip,fl_get_sample_edit (mainForm->sample));
  waitCursorOff ();
  updateDisplayDetails ();
  updateRangeDetails ();
  updateLoopDetails ();
  fl_redraw_object (mainForm->sample);
  fl_redraw_object (mainForm->scrollBarSlider);
  fl_redraw_object (mainForm->zoomBarSlider);
  updateClipForms ();
  updateNameBox ();
}

/*---------------------------------------------------------------------------
| CALLBACK mainPasteButton_cb
---------------------------------------------------------------------------*/
void mainPasteButton_cb (FL_OBJECT *,long)
{
  DPSample *sample = fl_get_sample (mainForm->sample);

  noClipWarning
  updateBuffers ("Undo Paste")
  waitCursorOn ();
  sample->paste (clip,fl_get_sample_edit (mainForm->sample));
  waitCursorOff ();
  updateDisplayDetails ();
  updateRangeDetails ();
  updateLoopDetails ();
  updateNameBox ();
  fl_redraw_object (mainForm->sample);
  fl_redraw_object (mainForm->scrollBarSlider);
  fl_redraw_object (mainForm->zoomBarSlider);
}

/*---------------------------------------------------------------------------
| CALLBACK mainPlaySampleButton_cb
---------------------------------------------------------------------------*/
void mainPlaySampleButton_cb (FL_OBJECT *ob,long data)
{
  playPlayButton_cb (ob, data);
}

/*---------------------------------------------------------------------------
| CALLBACK mainStopButton_cb
---------------------------------------------------------------------------*/
void mainStopButton_cb (FL_OBJECT *ob,long data)
{
  playStopButton_cb (ob, data);
}

/*---------------------------------------------------------------------------
| CALLBACK mainReleaseButton_cb
---------------------------------------------------------------------------*/
void mainReleaseButton_cb (FL_OBJECT *ob,long data)
{
  playReleaseButton_cb (ob, data);
}

/*---------------------------------------------------------------------------
| CALLBACK mainZoomInAllButton_cb
---------------------------------------------------------------------------*/
void mainZoomInAllButton_cb (FL_OBJECT *ob,long data)
{
  zoomOneToOneButton_cb (ob, data);
}

/*---------------------------------------------------------------------------
| CALLBACK mainZoomOutAllButton_cb
---------------------------------------------------------------------------*/
void mainZoomOutAllButton_cb (FL_OBJECT *ob,long data)
{
  zoomAllButton_cb (ob, data);
}

/*---------------------------------------------------------------------------
| CALLBACK mainSelectAllButton_cb
---------------------------------------------------------------------------*/
void mainSelectAllButton_cb (FL_OBJECT *ob,long data)
{
  rangeAllButton_cb(0, 0);
}

/*---------------------------------------------------------------------------
| CALLBACK mainFileMenu_cb
---------------------------------------------------------------------------*/

void mainFileMenu_cb (FL_OBJECT *ob,long)
{
  DPSample *sample;
  char *error;
  char *filename;
  int item = fl_get_menu (ob);
  
  switch (item)
  {
    case 1 : // New
      updateNewDetails ();
      fl_show_form (newForm->newForm,
      FL_PLACE_MOUSE,FL_FULLBORDER,"New");
      return;
      
    case 2 : // Open
      if (buffer [current]->getChanged ())
        if (!fl_show_question_old
          ("Warning","This buffer contains unsaved data","Really open ?"))
          return;

      filename = fselector
        ("Please enter the filename to load","*.aiff",0,0);
      
      if (filename)
      {
        sample = new DPSample;
        waitCursorOn ();
        if ((error = sample->loadAIFF ((char *) filename)))
        {
          waitCursorOff ();
          fl_show_alert ("Warning - Could not load file",
            filename,error,TRUE);
          delete sample;
        }
        else
        {
          waitCursorOff ();
          clearBuffers ();
          fl_set_sample (mainForm->sample,sample);
          delete buffer [current];
          buffer [current] = sample;
          updateSample (sample);
        }
      }
      return;
    
    case 3 : // Save
      sample = buffer [current];
      noSampleWarning
      filename = sample->getFilename ();
      if (filename)
      {
        waitCursorOn ();
        if ((error = sample->saveAIFF (0,0,
          fl_get_sample_soxcompatible (mainForm->sample),0)))
        {
          waitCursorOff ();
          fl_show_alert ("Warning - Could not save file",
            filename,error,TRUE);
        }
        else
        {
          waitCursorOff ();
          sample->consolidate ();
          sample->removeExtra ();
        }
        break;
      }

      // NO BREAK - fall through to "save as"
      
    case 4 : // Save As
    {
      char filenamebuffer [1024];
      char *newfilename = 0;
      
      sample = buffer [current];
      noSampleWarning
      filename = sample->getFilename ();
      if (filename)
      {
        sprintf (filenamebuffer,"%s",dap_basename(filename));
        newfilename = filenamebuffer;
      }
    
      filename = fselector
        ("Please enter the filename to save","*.aiff",newfilename,sample);
      
      if (filename)
      {
        int irixFile = open (filename,O_RDONLY);
        if (irixFile != -1)
        {
          close (irixFile);
          if (!fl_show_question_old (filename,"exists already - overwrite ?",0))
            break;
        }
        waitCursorOn ();
        if ((error = sample->saveAIFF ((char *) filename,0,
          fl_get_sample_soxcompatible (mainForm->sample),1)))
        {
          waitCursorOff ();
          fl_show_alert ("Warning - Could not save file",
            filename,error,TRUE);
        }
        else
        {
          waitCursorOff ();
          updateNameBox ();
          updateBufferBrowser ();
          sample->consolidate ();
          sample->removeExtra ();
        }
      }
      return;
    }
    
    case 5 : // Open Clip
      filename = fselector
        ("Please enter the filename to load to the clipboard","*.aiff",0,0);
      
      if (filename)
      {
        sample = new DPSample;
        waitCursorOn ();
        if ((error = sample->loadAIFF ((char *) filename)))
        {
          waitCursorOff ();
          fl_show_alert ("Warning - Could not load file",
            filename,error,TRUE);
          delete sample;
        }
        else
        {
          waitCursorOff ();
          delete clip;
          clip = sample;
          updateClipForms ();
        }
      }
      return;
     
    case 6 : // Save Clip
      sample = clip;
      noClipWarning
    
      filename = fselector
        ("Please enter the filename to save from the clipboard",
        "*.aiff",0,sample);
            
      if (filename)
      {
        int irixFile = open (filename,O_RDONLY);
        if (irixFile != -1)
        {
          close (irixFile);
          if (!fl_show_question_old (filename,
            "exists already - overwrite ?",0))
            break;
        }
        waitCursorOn ();
        if ((error = sample->saveAIFF ((char *) filename,0,
          fl_get_sample_soxcompatible (mainForm->sample),1)))
        {
          waitCursorOff ();
          fl_show_alert ("Warning - Could not save file",
            filename,error,TRUE);
        }
        else
        {
          waitCursorOff ();
        }
      }
      return;
    
    case 7 : // Clear Buffer
    {
      DPSample *sample = fl_get_sample (mainForm->sample);
      noSampleWarning

      if (sample->getChanged ())
        if (!fl_show_question_old
          ("Warning","This buffer contains unsaved data","Really clear ?"))
          return;

      updateBuffers ("Undo Clear")
      int width    = sample->getWidth ();
      int channels = sample->getChannels ();
      int rate     = (int) sample->getRate ();
      int frames   = 0;
      waitCursorOn ();
      sample->fresh ((double) rate,width,channels,frames);
      waitCursorOff ();
      updateSample (sample);
      return;
    }
    
    case 8 : // Import Raw
    {
      if (buffer [current]->getChanged ())
        if (!fl_show_question_old
          ("Warning","This buffer contains unsaved data","Really import ?"))
          return;
      
      filename = fselector
        ("Please enter the raw sample to import","*.raw",0,0);
      
      if (filename)
      {
        fl_set_input (rawForm->filename,filename);
        fl_set_button (rawForm->byteFormat,1);
        fl_set_button (rawForm->defaultEndian,1);
        fl_set_button (rawForm->signedSign,1);
        fl_set_button (rawForm->mono,1);
        fl_show_object (rawForm->channelsGroup);
        fl_show_form (rawForm->rawForm,
        FL_PLACE_MOUSE,FL_FULLBORDER,"Import Raw");
      }

      return;
    }
    
    case 9 : // Import Wav
    {
      if (buffer [current]->getChanged ())
        if (!fl_show_question_old
          ("Warning","This buffer contains unsaved data","Really import ?"))
          return;

      filename = fselector
        ("Please enter the wav sample to import","*.wav",0,0);
      
      if (filename)
      {
        sample = new DPSample;
        waitCursorOn ();
        if ((error = sample->loadWAV ((char *) filename)))
        {
          waitCursorOff ();
          fl_show_alert ("Warning - Could not import WAV file",
            filename,error,TRUE);
          delete sample;
        }
        else
        {
          char filenamebuffer [1024];
          sprintf (filenamebuffer,"%s.aiff",
            dap_no_extension(dap_basename(filename)));
          sample->setFilename (filenamebuffer);
          waitCursorOff ();
          clearBuffers ();
          fl_set_sample (mainForm->sample,sample);
          delete buffer [current];
          buffer [current] = sample;
          updateSample (sample);
        }
      }

      return;
    }
    
    case 10 : // Export Raw
    {
      char filenamebuffer [1024];
      char *newfilename = 0;
      
      sample = buffer [current];
      noSampleWarning
      filename = sample->getFilename ();
      if (filename)
      {
        sprintf (filenamebuffer,"%s.raw",
          dap_no_extension(dap_basename(filename)));
        newfilename = filenamebuffer;
      }
      
      filename = fselector
        ("Please enter the raw sample to export","*.raw",newfilename,0);
      
      if (filename)
      {
        int irixFile = open (filename,O_RDONLY);
        if (irixFile != -1)
        {
          close (irixFile);
          if (!fl_show_question_old (filename,"exists already - overwrite ?",0))
            return;
        }
        
        fl_set_input (rawForm->filename,filename);
        if (sample->getWidth()==1)
          fl_set_button (rawForm->byteFormat,1);
        else
          fl_set_button (rawForm->shortFormat,1);
        fl_set_button (rawForm->defaultEndian,1);
        fl_set_button (rawForm->signedSign,1);
        if (sample->getChannels()==1)
          fl_set_button (rawForm->mono,1);
        else if (sample->getChannels()==2)
          fl_set_button (rawForm->stereo,1);
        else
          fl_set_button (rawForm->quadro,1);
        fl_hide_object (rawForm->channelsGroup);
        fl_show_form (rawForm->rawForm,
        FL_PLACE_MOUSE,FL_FULLBORDER,"Export Raw");
      }

      return;
    }
    
    case 11 : // Export Wav
    {
      char filenamebuffer [1024];
      char *newfilename = 0;
      
      sample = buffer [current];
      noSampleWarning
      filename = sample->getFilename ();
      if (filename)
      {
        sprintf (filenamebuffer,"%s.wav",
          dap_no_extension(dap_basename(filename)));
        newfilename = filenamebuffer;
      }
    
      filename = fselector
        ("Please enter the wav sample to export","*.wav",newfilename,0);
      
      if (filename)
      {
        int irixFile = open (filename,O_RDONLY);
        if (irixFile != -1)
        {
          close (irixFile);
          if (!fl_show_question_old (filename,"exists already - overwrite ?",0))
            break;
        }
        waitCursorOn ();
        
        // Do we want to save basic WAVs or proper ones ?
        sample->basicWavs (fl_get_sample_basicwavs (mainForm->sample));
        
        if ((error = sample->saveWAV ((char *) filename,0,
          fl_get_sample_soxcompatible (mainForm->sample),0)))
        {
          waitCursorOff ();
          fl_show_alert ("Warning - Could not export WAV file",
            filename,error,TRUE);
        }
        else
        {
          waitCursorOff ();
          updateNameBox ();
          updateBufferBrowser ();
          sample->consolidate ();
          sample->removeExtra ();
        }
      }

      return;
    }
    
    case 12 : // Quit
    {
      if (closeAll (mainForm->mainForm,0) == FL_OK)
        exit (0);
    }
      
    default :
      break;
  }
}

/*---------------------------------------------------------------------------
| FUNCTION updateSampleFormatCompression
---------------------------------------------------------------------------*/

void updateSampleFormatCompression (DPSample *sample)
{
  switch (fl_get_choice (format))
  {
    case 1 :
      sample->setFormat (AF_FILE_AIFF);
      break;
    case 2 :
      sample->setFormat (AF_FILE_AIFFC);
      break;
    default :
      break;
  }

  switch (fl_get_choice (compression))
  {
    case 1 :
      sample->setCompression (AF_COMPRESSION_NONE);
      break;
    case 2 :
      sample->setCompression (AF_COMPRESSION_G722);
      break;
    case 3 :
      sample->setCompression (AF_COMPRESSION_G711_ULAW);
      break;
    case 4 :
      sample->setCompression (AF_COMPRESSION_G711_ALAW);
      break;
    case 5 :
      sample->setCompression (AF_COMPRESSION_AWARE_DEFAULT_MPEG_I);
      break;
    case 6 :
      sample->setCompression (AF_COMPRESSION_AWARE_DEFAULT_MPEG_II);
      break;
    case 7 :
      sample->setCompression (AF_COMPRESSION_AWARE_DEFAULT_MULTIRATE);
      break;
    case 8 :
      sample->setCompression (AF_COMPRESSION_AWARE_DEFAULT_LOSSLESS);
      break;
    default :
      break;
  }
}

/*---------------------------------------------------------------------------
| FUNCTION updateSaveFormatCompression
---------------------------------------------------------------------------*/

void updateSaveFormatCompression (int newFormat,int newCompression)
{
  switch (newFormat)
  {
    case AF_FILE_AIFF :
      fl_set_choice (format,1);
      break;
    case AF_FILE_AIFFC :
      fl_set_choice (format,2);
      break;
    default :
      break;
  }

  switch (newCompression)
  {
    case AF_COMPRESSION_NONE :
      fl_set_choice (compression,1);
      break;
    case AF_COMPRESSION_G722 :
      fl_set_choice (compression,2);
      break;
    case AF_COMPRESSION_G711_ULAW :
      fl_set_choice (compression,3);
      break;
    case AF_COMPRESSION_G711_ALAW :
      fl_set_choice (compression,4);
      break;
    case AF_COMPRESSION_AWARE_DEFAULT_MPEG_I :
      fl_set_choice (compression,5);
      break;
    case AF_COMPRESSION_AWARE_MPEG :
    case AF_COMPRESSION_AWARE_DEFAULT_MPEG_II :
      fl_set_choice (compression,6);
      break;
    case AF_COMPRESSION_AWARE_MULTIRATE :
    case AF_COMPRESSION_AWARE_DEFAULT_MULTIRATE :
      fl_set_choice (compression,7);
     break;
    case AF_COMPRESSION_AWARE_DEFAULT_LOSSLESS :
      fl_set_choice (compression,8);
      break;
    default :
      break;
  }
}

/*---------------------------------------------------------------------------
| FUNCTION updateEditModeChoice
---------------------------------------------------------------------------*/

void updateEditModeChoice (int channels)
{
  if (channels == 1)
  {
    if (fl_get_choice_maxitems (mainForm->editMode) != 1)
    {
      fl_clear_choice (mainForm->editMode);
      fl_addto_choice (mainForm->editMode,"Mono");
      fl_deactivate_object (mainForm->editMode);
    }
    fl_set_sample_edit (mainForm->sample,2); 
    fl_set_choice (mainForm->editMode,1);
  }
  else if (channels == 2)
  {
    if (fl_get_choice_maxitems (mainForm->editMode) != 3)
    {
      fl_clear_choice (mainForm->editMode);
      fl_addto_choice (mainForm->editMode,"Mono (Left)");
      fl_addto_choice (mainForm->editMode,"Mono (Right)");
      fl_addto_choice (mainForm->editMode,"Stereo");
      fl_activate_object (mainForm->editMode);
    }
    switch (fl_get_sample_edit (mainForm->sample))
    {
      case 0:
        fl_set_choice (mainForm->editMode,1);
        break;
      case 1:
        fl_set_choice (mainForm->editMode,2);
        break;
      case 2:
        fl_set_choice (mainForm->editMode,3);
        break;
      case 3:
        fl_set_sample_edit (mainForm->sample,2);
        fl_set_choice (mainForm->editMode,3);
        break;
      case 4:
        fl_set_sample_edit (mainForm->sample,2);
        fl_set_choice (mainForm->editMode,3);
        break;
    }
  }
  else if (channels == 4)
  {
    if (fl_get_choice_maxitems (mainForm->editMode) != 5)
    {
      fl_clear_choice (mainForm->editMode);
      fl_addto_choice (mainForm->editMode,"Mono (1)");
      fl_addto_choice (mainForm->editMode,"Mono (2)");
      fl_addto_choice (mainForm->editMode,"Mono (3)");
      fl_addto_choice (mainForm->editMode,"Mono (4)");
      fl_addto_choice (mainForm->editMode,"Quadro");
      fl_activate_object (mainForm->editMode);
    }
    switch (fl_get_sample_edit (mainForm->sample))
    {
      case 0:
        fl_set_choice (mainForm->editMode,1);
        break;
      case 1:
        fl_set_choice (mainForm->editMode,2);
        break;
      case 2:
        fl_set_choice (mainForm->editMode,5);
        break;
      case 3:
        fl_set_choice (mainForm->editMode,3);
        break;
      case 4:
        fl_set_choice (mainForm->editMode,4);
        break;
    }
  }
}

/*---------------------------------------------------------------------------
| CALLBACK mainEditMenu_cb
---------------------------------------------------------------------------*/

void mainEditMenu_cb (FL_OBJECT *ob,long)
{
  DPSample *sample = fl_get_sample (mainForm->sample);
  int item = fl_get_menu (ob);

  switch (item)
  {
    case 1 :
      waitCursorOn ();
      performUndo ();
      waitCursorOff ();
      return;
     
    case 2 :
      waitCursorOn ();
      performRedo ();
      waitCursorOff ();
      return;

    case 3 :
      rangeAllButton_cb(0, 0);
      return;

    case 16 :
      waitCursorOn ();
      clip->clear ();
      updateClipForms ();
      waitCursorOff ();
      return;
    
     default :
      break;
  }

  noSampleWarning

  switch (item)
  {
    case 10 :
      updateBuffers ("Undo Trim")
      waitCursorOn ();
      sample->trim ();
      waitCursorOff ();
      updateDisplayDetails ();
      updateRangeDetails ();
      updateLoopDetails ();
      updateNameBox ();
      fl_redraw_object (mainForm->sample);
      fl_redraw_object (mainForm->scrollBarSlider);
      fl_redraw_object (mainForm->zoomBarSlider);
      return;
    
    case 15 :
      fl_set_input (workspaceForm->frames,"0");
      fl_set_input (workspaceForm->time,"0.000");
      fl_show_form (workspaceForm->workspaceForm,
      FL_PLACE_MOUSE,FL_FULLBORDER,"Add Workspace");
      return;
    
    default :
      break;
  }

  noRangeWarning  

  switch (item)
  {
    case 4 :
      zeroRangeWarning
      updateBuffers ("Undo Cut")
      waitCursorOn ();
      sample->cut (clip,fl_get_sample_edit (mainForm->sample));
      waitCursorOff ();
      updateDisplayDetails ();
      updateRangeDetails ();
      updateLoopDetails ();
      fl_redraw_object (mainForm->sample);
      fl_redraw_object (mainForm->scrollBarSlider);
      fl_redraw_object (mainForm->zoomBarSlider);
      updateClipForms ();
      updateNameBox ();
      return;
      
    case 5 :
    {
      zeroRangeWarning
      waitCursorOn ();
      sample->copy (clip,fl_get_sample_edit (mainForm->sample));
      int rangeStartBak = sample->getRangeStart ();
      int rangeEndBak   = sample->getRangeEnd ();
      for (int i=0; i<4; i++)
      {
        sample->setRangeValid (FALSE);
        fl_redraw_object (mainForm->sample);
        sample->setRange (rangeStartBak,rangeEndBak);
        fl_redraw_object (mainForm->sample);
      }
      waitCursorOff ();
      updateDisplayDetails ();
      updateRangeDetails ();
      updateLoopDetails ();
      fl_redraw_object (mainForm->sample);
      fl_redraw_object (mainForm->scrollBarSlider);
      fl_redraw_object (mainForm->zoomBarSlider);
      updateClipForms ();
      return;
    }
      
    case 6 :
      noClipWarning
      updateBuffers ("Undo Paste")
      waitCursorOn ();
      sample->paste (clip,fl_get_sample_edit (mainForm->sample));
      waitCursorOff ();
      updateDisplayDetails ();
      updateRangeDetails ();
      updateLoopDetails ();
      updateNameBox ();
      fl_redraw_object (mainForm->sample);
      fl_redraw_object (mainForm->scrollBarSlider);
      fl_redraw_object (mainForm->zoomBarSlider);
      return;
      
    case 7 :
      zeroRangeWarning
      updateBuffers ("Undo Delete")
      waitCursorOn ();
      sample->del (fl_get_sample_edit (mainForm->sample));
      waitCursorOff ();
      updateDisplayDetails ();
      updateRangeDetails ();
      updateLoopDetails ();
      updateNameBox ();
      fl_redraw_object (mainForm->sample);
      fl_redraw_object (mainForm->scrollBarSlider);
      fl_redraw_object (mainForm->zoomBarSlider);
      return;
      
    case 8 :
    {
      zeroRangeWarning
      updateBuffers ("Undo Remove")
      waitCursorOn ();
      sample->copy (clip,fl_get_sample_edit (mainForm->sample));
      int rangeStartBak = sample->getRangeStart ();
      int rangeEndBak   = sample->getRangeEnd ();
      for (int i=0; i<4; i++)
      {
        sample->setRangeValid (FALSE);
        fl_redraw_object (mainForm->sample);
        sample->setRange (rangeStartBak,rangeEndBak);
        fl_redraw_object (mainForm->sample);
      }
      sample->zero (fl_get_sample_edit (mainForm->sample));
      waitCursorOff ();
      updateDisplayDetails ();
      updateRangeDetails ();
      updateLoopDetails ();
      fl_redraw_object (mainForm->sample);
      fl_redraw_object (mainForm->scrollBarSlider);
      fl_redraw_object (mainForm->zoomBarSlider);
      updateClipForms ();
      return;
    }

    case 9 :
      zeroRangeWarning
      updateBuffers ("Undo Keep")
      waitCursorOn ();
      sample->keep (clip,fl_get_sample_edit (mainForm->sample));
      waitCursorOff ();
      updateDisplayDetails ();
      updateRangeDetails ();
      updateLoopDetails ();
      updateNameBox ();
      fl_redraw_object (mainForm->sample);
      fl_redraw_object (mainForm->scrollBarSlider);
      fl_redraw_object (mainForm->zoomBarSlider);
      return;
    
    case 11 :
      noClipWarning
      updateBuffers ("Undo Overwrite")
      waitCursorOn ();
      sample->overwrite (clip,fl_get_sample_edit (mainForm->sample));
      waitCursorOff ();
      updateDisplayDetails ();
      updateRangeDetails ();
      updateLoopDetails ();
      updateNameBox ();
      fl_redraw_object (mainForm->sample);
      fl_redraw_object (mainForm->scrollBarSlider);
      fl_redraw_object (mainForm->zoomBarSlider);
      return;
      
    case 12 :
      noClipWarning
      fl_set_choice (mixForm->mode,1);
      fl_set_input (mixForm->inFrames,"0");
      fl_set_input (mixForm->inTime,"0.000");
      fl_set_input (mixForm->outFrames,"0");
      fl_set_input (mixForm->outTime,"0.000");
      fl_set_slider_value (mixForm->ratio,50.0);
      fl_set_object_label (mixForm->clipboardText,"50");
      fl_set_object_label (mixForm->bufferText,"50");
      updateMixPlot ();
      fl_show_form (mixForm->mixForm,
      FL_PLACE_MOUSE | FL_FREE_SIZE,FL_FULLBORDER,"Mix");
      return;

    case 13 :
      noClipWarning
      zeroRangeWarning
      updateBuffers ("Undo Overwrite Range")
      waitCursorOn ();
      sample->overwriteRange (clip,fl_get_sample_edit (mainForm->sample));
      waitCursorOff ();
      updateDisplayDetails ();
      updateRangeDetails ();
      updateLoopDetails ();
      fl_redraw_object (mainForm->sample);
      fl_redraw_object (mainForm->scrollBarSlider);
      fl_redraw_object (mainForm->zoomBarSlider);
      return;
      
    case 14 :
      noClipWarning
      zeroRangeWarning
      fl_set_choice (mixForm->mode,2);
      fl_set_input (mixForm->inFrames,"0");
      fl_set_input (mixForm->inTime,"0.000");
      fl_set_input (mixForm->outFrames,"0");
      fl_set_input (mixForm->outTime,"0.000");
      fl_set_slider_value (mixForm->ratio,50.0);
      fl_set_object_label (mixForm->clipboardText,"50");
      fl_set_object_label (mixForm->bufferText,"50");
      updateMixPlot ();
      fl_show_form (mixForm->mixForm,
      FL_PLACE_MOUSE | FL_FREE_SIZE,FL_FULLBORDER,"Mix - Range Only");
      return;
    
    default :
      break;
  }
}

/*---------------------------------------------------------------------------
| CALLBACK mainRangeMenu_cb
---------------------------------------------------------------------------*/

void mainRangeMenu_cb (FL_OBJECT *ob,long)
{
  DPSample *sample = fl_get_sample (mainForm->sample);
  int item = fl_get_menu (ob);

  noSampleWarning
  noRangeWarning
  zeroRangeWarning  

  switch (item)
  {
    case 1 :
      updateBuffers ("Undo Reverse")
      waitCursorOn ();
      sample->reverse (fl_get_sample_edit (mainForm->sample));
      waitCursorOff ();
      fl_redraw_object (mainForm->sample);
      return;
      
    case 2 :
      updateBuffers ("Undo Invert")
      waitCursorOn ();
      sample->invert (fl_get_sample_edit (mainForm->sample));
      waitCursorOff ();
      fl_redraw_object (mainForm->sample);
      return;
      
    case 3 :
      updateBuffers ("Undo Zero")
      waitCursorOn ();
      sample->zero (fl_get_sample_edit (mainForm->sample));
      waitCursorOff ();
      fl_redraw_object (mainForm->sample);
      return;
      
    case 4 :
      noStereoWarning
      if (sample->getChannels () == 2 &&
      fl_get_sample_edit (mainForm->sample) == 2)
      {
        fl_set_button (channelForm->leftButton,0);
        fl_set_button (channelForm->leftrightButton,1);
        fl_set_button (channelForm->rightButton,0);
        fl_show_form (channelForm->channelForm,
        FL_PLACE_MOUSE,FL_FULLBORDER,"Channels (stereo)");
      }
      else if (sample->getChannels () == 4 &&
      fl_get_sample_edit (mainForm->sample) == 2)
      {
        fl_set_button (channel4Form->leftButton,0);
        fl_set_button (channel4Form->leftrightButton,1);
        fl_set_button (channel4Form->rightButton,0);
        fl_set_button (channel4Form->oneLButton,1);
        fl_set_button (channel4Form->twoLButton,0);
        fl_set_button (channel4Form->threeLButton,0);
        fl_set_button (channel4Form->fourLButton,0);
        fl_set_button (channel4Form->oneRButton,0);
        fl_set_button (channel4Form->twoRButton,1);
        fl_set_button (channel4Form->threeRButton,0);
        fl_set_button (channel4Form->fourRButton,0);
        fl_show_form (channel4Form->channel4Form,
        FL_PLACE_MOUSE,FL_FULLBORDER,"Channels (quadro)");
      }
      return;
      
    case 5 :
      fl_set_slider_value (duplicateForm->times,1.0);
      fl_set_input (duplicateForm->input,"1");
      fl_show_form (duplicateForm->duplicateForm,
      FL_PLACE_MOUSE,FL_FULLBORDER,"Duplicate");
      return;
      
    case 6 :
      noStereoWarning
      if (sample->getChannels () == 2 &&
      fl_get_sample_edit (mainForm->sample) == 2)
      {
        fl_set_slider_value (panoramaForm->amount,0.0);
        fl_set_object_label (panoramaForm->amountText,"+0");
        fl_set_slider_value (panoramaForm->ltorSlider,0.0);
        fl_set_input (panoramaForm->ltorInput,"0");
        fl_set_slider_value (panoramaForm->rtolSlider,0.0);
        fl_set_input (panoramaForm->rtolInput,"0");
        fl_hide_object (panoramaForm->quadroControls);
        fl_show_form (panoramaForm->panoramaForm,
        FL_PLACE_MOUSE,FL_FULLBORDER,"Panorama");
      }
      else if (sample->getChannels () == 4 &&
      fl_get_sample_edit (mainForm->sample) == 2)
      {
        fl_set_slider_value (panoramaForm->amount,0.0);
        fl_set_object_label (panoramaForm->amountText,"+0");
        fl_set_slider_value (panoramaForm->ltorSlider,0.0);
        fl_set_input (panoramaForm->ltorInput,"0");
        fl_set_slider_value (panoramaForm->rtolSlider,0.0);
        fl_set_input (panoramaForm->rtolInput,"0");
        fl_show_object (panoramaForm->quadroControls);
        fl_set_choice (panoramaForm->quadroLeft,1);
        fl_set_choice (panoramaForm->quadroRight,2);
        fl_show_form (panoramaForm->panoramaForm,
        FL_PLACE_MOUSE,FL_FULLBORDER,"Panorama");
      }
      return;
    
    case 7 :
      fl_set_slider_value (adjustDCForm->amount,0.0);
      fl_set_object_label (adjustDCForm->amountText,"+0");
      fl_show_form (adjustDCForm->adjustDCForm,
      FL_PLACE_MOUSE,FL_FULLBORDER,"Adjust DC");
      return;
      
    default :
      break;
  }
}

/*---------------------------------------------------------------------------
| CALLBACK mainMiscMenu_cb
---------------------------------------------------------------------------*/

void mainMiscMenu_cb (FL_OBJECT *ob,long)
{
  DPSample *sample = fl_get_sample (mainForm->sample);
  int item = fl_get_menu (ob);
  char tempString [50];

  noSampleWarning  
  switch (item)
  {
    case 1 :
      sprintf (tempString,"%d",(int) sample->getRate ());
      fl_set_input (rateForm->input,tempString);
      fl_show_form (rateForm->rateForm,
      FL_PLACE_MOUSE,FL_FULLBORDER,"Sample Rate");
      return;

    case 2 :
      if (sample->getName ())
        fl_set_input (miscForm->name,sample->getName ());
      else
        fl_set_input (miscForm->name,"");
        
      if (sample->getCopyright ())
        fl_set_input (miscForm->copyright,sample->getCopyright ());
      else
        fl_set_input (miscForm->copyright,"");
        
      if (sample->getAuthor ())
        fl_set_input (miscForm->author,sample->getAuthor ());
      else
        fl_set_input (miscForm->author,"");
        
      if (sample->getAnnotation ())
        fl_set_input (miscForm->annotation,sample->getAnnotation ());
      else
        fl_set_input (miscForm->annotation,"");
        
      fl_show_form (miscForm->miscForm,
      FL_PLACE_MOUSE,FL_FULLBORDER,"Textual Details");
      return;
    
    case 3 :
      if (fl_show_question_old ("Clear undo buffers","Are you sure ?",0))
      {
        waitCursorOn ();
        clearBuffers ();
        waitCursorOff ();
      }
      return;

    default :
      break;
  }
}

/*---------------------------------------------------------------------------
| CALLBACK mainAmpMenu_cb
---------------------------------------------------------------------------*/

void mainAmpMenu_cb (FL_OBJECT *ob,long)
{
  DPSample *sample = fl_get_sample (mainForm->sample);
  int item = fl_get_menu (ob);

  noSampleWarning
  noRangeWarning
  zeroRangeWarning  

  switch (item)
  {
    case 1 :
      fl_set_slider_value (ampForm->slider,100.0);
      fl_set_input (ampForm->input,"100");
      fl_show_form (ampForm->ampForm,
      FL_PLACE_MOUSE,FL_FULLBORDER,"Amplitude");
      return;

    case 2 :
      noStereoWarning
      if (sample->getChannels () == 2 &&
      fl_get_sample_edit (mainForm->sample) == 2)
      {
        fl_set_choice (balanceForm->mode,1);
        fl_set_slider_value (balanceForm->leftSlider,50.0);
        fl_set_input (balanceForm->leftInput,"50");
        fl_set_slider_value (balanceForm->rightSlider,50.0);
        fl_set_input (balanceForm->rightInput,"50");
        fl_set_slider_value (balanceForm->slider,50.0);
        fl_show_object (balanceForm->balanceControls);
        fl_hide_object (balanceForm->quadroControls);
        fl_show_form (balanceForm->balanceForm,
        FL_PLACE_MOUSE,FL_FULLBORDER,"Balance (stereo)");
      }
      else if (sample->getChannels () == 4 &&
      fl_get_sample_edit (mainForm->sample) == 2)
      {
        fl_set_choice (balanceForm->mode,1);
        fl_set_slider_value (balanceForm->leftSlider,50.0);
        fl_set_input (balanceForm->leftInput,"50");
        fl_set_slider_value (balanceForm->rightSlider,50.0);
        fl_set_input (balanceForm->rightInput,"50");
        fl_set_slider_value (balanceForm->slider,50.0);
        fl_show_object (balanceForm->balanceControls);
        fl_show_object (balanceForm->quadroControls);
        fl_set_choice (balanceForm->quadroLeft,1);
        fl_set_choice (balanceForm->quadroRight,2);
        fl_show_form (balanceForm->balanceForm,
        FL_PLACE_MOUSE,FL_FULLBORDER,"Balance (quadro)");
      }
      return;
      
    case 3 :
      updateBuffers ("Undo Normalise")
      waitCursorOn ();
      sample->normalise (fl_get_sample_edit (mainForm->sample));
      waitCursorOff ();
      fl_redraw_object (mainForm->sample);
      return;

    case 4 :
      updateBuffers ("Undo Fade In")
      waitCursorOn ();
      sample->fadeIn (fl_get_sample_edit (mainForm->sample));
      waitCursorOff ();
      fl_redraw_object (mainForm->sample);
      return;

    case 5 :
      updateBuffers ("Undo Fade Out")
      waitCursorOn ();
      sample->fadeOut (fl_get_sample_edit (mainForm->sample));
      waitCursorOff ();
      fl_redraw_object (mainForm->sample);
      return;

    case 6 :
      noStereoWarning
      if (sample->getChannels () == 2 &&
      fl_get_sample_edit (mainForm->sample) == 2)
      {
        fl_set_button (bounceForm->LtoR,1);
        fl_set_button (bounceForm->RtoL,0);
        fl_show_form (bounceForm->bounceForm,
        FL_PLACE_MOUSE,FL_FULLBORDER,"Bounce (stereo)");
      }
      else
      if (sample->getChannels () == 4 &&
      fl_get_sample_edit (mainForm->sample) == 2)
      {
        fl_set_button (bounce4Form->LtoR,1);
        fl_set_button (bounce4Form->RtoL,0);
        fl_set_button (bounce4Form->oneLButton,1);
        fl_set_button (bounce4Form->twoLButton,0);
        fl_set_button (bounce4Form->threeLButton,0);
        fl_set_button (bounce4Form->fourLButton,0);
        fl_set_button (bounce4Form->oneRButton,0);
        fl_set_button (bounce4Form->twoRButton,1);
        fl_set_button (bounce4Form->threeRButton,0);
        fl_set_button (bounce4Form->fourRButton,0);
        fl_show_form (bounce4Form->bounce4Form,
        FL_PLACE_MOUSE,FL_FULLBORDER,"Bounce (quadro)");
      }
      return;

    case 7 :
      initialiseRampForm ();
      updateRampForm ();
      updateRampPlot ();
      fl_show_form (rampForm->rampForm,
      FL_PLACE_MOUSE | FL_FREE_SIZE,FL_FULLBORDER,"Ramp");
      return;

    case 8 :
      // Wrap setting - no action - setting uses menu tick
      return;

    default :
      break;
  }
}

/*---------------------------------------------------------------------------
| CALLBACK mainConvertMenu_cb
---------------------------------------------------------------------------*/

void mainConvertMenu_cb (FL_OBJECT *ob,long)
{
  DPSample *sample = fl_get_sample (mainForm->sample);
  int item = fl_get_menu (ob);

  noSampleWarning  
  switch (item)
  {
    case 1 :
      if (sample->getChannels () == 1)
      {
        fl_show_alert ("This operation requires a stereo or quadro sample",
        "The current sample is mono",
        "You cannot perform this operation on a mono sample",TRUE);
      }
      else if (sample->getChannels () == 2)
      {
        fl_set_button (convertForm->leftButton,1);
        fl_set_button (convertForm->rightButton,1);
        fl_show_form (convertForm->convertForm,
        FL_PLACE_MOUSE,FL_FULLBORDER,"Convert 2->1");
      }
      else if (sample->getChannels () == 4)
      {
        fl_set_button (convert4to1Form->oneButton,1);
        fl_set_button (convert4to1Form->twoButton,1);
        fl_set_button (convert4to1Form->threeButton,1);
        fl_set_button (convert4to1Form->fourButton,1);
        fl_show_form (convert4to1Form->convert4to1Form,
        FL_PLACE_MOUSE,FL_FULLBORDER,"Convert 4->1");
      }
      return;
    
    case 2 :
      if (sample->getChannels () == 1)
      {
        updateBuffers ("Undo Conversion (to stereo)")
        waitCursorOn ();
        sample->toStereo (0);
        waitCursorOff ();
        updateConvertMenu ();
        updateEditModeChoice (2);
        updateNameBox ();
        fl_redraw_object (mainForm->sample);
      }
      else if (sample->getChannels () == 2)
      {
        fl_show_alert ("This operation requires a mono or quadro sample",
        "The current sample is stereo",
        "You cannot perform this operation on a stereo sample",TRUE);
      }
      else if (sample->getChannels () == 4)
      {
        fl_set_button (convert4to2Form->oneLButton,1);
        fl_set_button (convert4to2Form->twoLButton,1);
        fl_set_button (convert4to2Form->threeLButton,0);
        fl_set_button (convert4to2Form->fourLButton,0);
        fl_set_button (convert4to2Form->oneRButton,0);
        fl_set_button (convert4to2Form->twoRButton,0);
        fl_set_button (convert4to2Form->threeRButton,1);
        fl_set_button (convert4to2Form->fourRButton,1);
        fl_show_form (convert4to2Form->convert4to2Form,
        FL_PLACE_MOUSE,FL_FULLBORDER,"Convert 4->2");
      }
      return;
    
    case 3 :
      if (sample->getChannels () == 1)
      {
        updateBuffers ("Undo Conversion (to quadro)")
        waitCursorOn ();
        sample->toQuadro (0);
        waitCursorOff ();
        updateConvertMenu ();
        updateEditModeChoice (4);
        updateNameBox ();
        fl_redraw_object (mainForm->sample);
      }
      else if (sample->getChannels () == 2)
      {
        fl_set_button (convert2to4Form->one1Button,1);
        fl_set_button (convert2to4Form->two1Button,0);
        fl_set_button (convert2to4Form->one2Button,1);
        fl_set_button (convert2to4Form->two2Button,0);
        fl_set_button (convert2to4Form->one3Button,0);
        fl_set_button (convert2to4Form->two3Button,1);
        fl_set_button (convert2to4Form->one4Button,0);
        fl_set_button (convert2to4Form->two4Button,1);
        fl_show_form (convert2to4Form->convert2to4Form,
        FL_PLACE_MOUSE,FL_FULLBORDER,"Convert 2->4");
      }
      else if (sample->getChannels () == 4)
      {
        fl_show_alert ("This operation requires a mono or stereo sample",
        "The current sample is quadro",
        "You cannot perform this operation on a quadro sample",TRUE);
      }
      return;
      
    case 4 :
      if (sample->getWidth () == 1)
      {
        fl_show_alert ("This operation requires a 16 bit sample",
        "The current sample is 8 bit",
        "You cannot perform this operation on an 8 bit sample",TRUE);
      }
      else if (sample->getWidth () != 1)
      {
        updateBuffers ("Undo Conversion (to 8 bit)")
        waitCursorOn ();
        sample->to8bit ();
        waitCursorOff ();
        updateConvertMenu ();
        updateNameBox ();
        fl_redraw_object (mainForm->sample);
      }
      return;
    
    case 5 :
      if (sample->getWidth () == 2)
      {
        fl_show_alert ("This operation requires an 8 bit sample",
        "The current sample is 16 bit",
        "You cannot perform this operation on a 16 bit sample",TRUE);
      }
      else if (sample->getWidth () != 2)
      {
        updateBuffers ("Undo Conversion (to 16 bit)")
        waitCursorOn ();
        sample->to16bit ();
        waitCursorOff ();
        updateConvertMenu ();
        updateNameBox ();
        fl_redraw_object (mainForm->sample);
      }
      return;
      
    default :
      break;
  }
}

/*---------------------------------------------------------------------------
| CALLBACK mainResampleMenu_cb
---------------------------------------------------------------------------*/

void mainResampleMenu_cb (FL_OBJECT *ob,long)
{
  DPSample *sample = fl_get_sample (mainForm->sample);
  int item = fl_get_menu (ob);

  noSampleWarning
  noRangeWarning
  zeroRangeWarning

  switch (item)
  {
    case 1 :
      fl_set_choice (resampleForm->mode,1);
      initialiseResampleForm ();
      updateResampleForm (0);
      fl_show_form (resampleForm->resampleForm,
      FL_PLACE_MOUSE,FL_FULLBORDER,"Resample");
      return;
    
    case 2 :
      fl_set_choice (resampleForm->mode,2);
      initialiseResampleForm ();
      updateResampleForm (1);
      fl_show_form (resampleForm->resampleForm,
      FL_PLACE_MOUSE,FL_FULLBORDER,"Resample");
      return;
    
    default :
      break;
  }
}

/*---------------------------------------------------------------------------
| CALLBACK mainGlobalMenu_cb
---------------------------------------------------------------------------*/

void mainGlobalMenu_cb (FL_OBJECT *ob,long)
{
  int item = fl_get_menu (ob);

  switch (item)
  {
    case 1 :
      fl_show_form (prefsForm->prefsForm,
      FL_PLACE_MOUSE,FL_FULLBORDER,"Preferences");
      break;
    case 2 :
      if (!loadPreferences ())
        fl_show_alert ("Warning","Unable to load preferences file :",
          PREFSNAME,TRUE);
      break;
    case 3 :
      if (!savePreferences ())
        fl_show_alert ("Warning","Unable to save preferences file :",
          PREFSNAME,TRUE);
      break;
    case 4 :
      updateMacroForm ();
      fl_show_form (macroForm->macroForm,
      FL_PLACE_MOUSE,FL_FULLBORDER,"Edit Macros");
      break;
    case 5 :
      defaultMacros ();
      if (!loadMacros ())
        fl_show_alert ("Warning","Unable to load macros file :",
          MACROSNAME,TRUE);
      break;
    case 6 :
      if (!saveMacros ())
        fl_show_alert ("Warning","Unable to save macros file :",
          MACROSNAME,TRUE);
      break;
    case 7 :
      fl_show_form (macroexecForm->macroexecForm,
      FL_PLACE_MOUSE | FL_FREE_SIZE,FL_FULLBORDER,"Execute Macro");
      break;
    default:
      break;
  }
}

/*---------------------------------------------------------------------------
| CALLBACK mainDisplayButton_cb
---------------------------------------------------------------------------*/

void mainDisplayButton_cb (FL_OBJECT *ob,long)
{
  if (fl_get_button (ob))
    fl_show_form (displayForm->displayForm,
    FL_PLACE_GEOMETRY,FL_FULLBORDER,"Display");
  else
    fl_hide_form (displayForm->displayForm);
}

/*---------------------------------------------------------------------------
| CALLBACK mainLoopButton_cb
---------------------------------------------------------------------------*/

void mainLoopButton_cb (FL_OBJECT *ob,long)
{
  if (fl_get_button (ob))
    fl_show_form (loopForm->loopForm,
    FL_PLACE_GEOMETRY,FL_FULLBORDER,"Loop");
  else
    fl_hide_form (loopForm->loopForm);
}

/*---------------------------------------------------------------------------
| CALLBACK mainRangeButton_cb
---------------------------------------------------------------------------*/

void mainRangeButton_cb (FL_OBJECT *ob,long)
{
  if (fl_get_button (ob))
    fl_show_form (rangeForm->rangeForm,
    FL_PLACE_GEOMETRY,FL_FULLBORDER,"Range");
  else
    fl_hide_form (rangeForm->rangeForm);
}

/*---------------------------------------------------------------------------
| CALLBACK mainZoomButton_cb
---------------------------------------------------------------------------*/

void mainZoomButton_cb (FL_OBJECT *ob,long)
{
  if (fl_get_button (ob))
    fl_show_form (zoomForm->zoomForm,
    FL_PLACE_GEOMETRY,FL_FULLBORDER,"Zoom");
  else
    fl_hide_form (zoomForm->zoomForm);
}

/*---------------------------------------------------------------------------
| CALLBACK mainPlayButton_cb
---------------------------------------------------------------------------*/

void mainPlayButton_cb (FL_OBJECT *ob,long)
{
  if (fl_get_button (ob))
    fl_show_form (playForm->playForm,
    FL_PLACE_GEOMETRY,FL_FULLBORDER,"Play");
  else
    fl_hide_form (playForm->playForm);
}

/*---------------------------------------------------------------------------
| CALLBACK mainRecordButton_cb
---------------------------------------------------------------------------*/

void mainRecordButton_cb (FL_OBJECT *ob,long)
{
  if (fl_get_button (ob))
  {
    fl_show_form (recordForm->recordForm,
    FL_PLACE_GEOMETRY,FL_FULLBORDER,"Record");
  }
  else
  {
    fl_hide_form (recordForm->recordForm);
    fl_set_button (recordForm->levelsButton,0);
    fl_call_object_callback (recordForm->levelsButton);
  }
}

/*---------------------------------------------------------------------------
| CALLBACK mainBufferButton_cb
---------------------------------------------------------------------------*/

void mainBufferButton_cb (FL_OBJECT *ob,long)
{
  if (fl_get_button (ob))
    fl_show_form (bufferForm->bufferForm,
    FL_PLACE_GEOMETRY,FL_FULLBORDER,"Buffer");
  else
    fl_hide_form (bufferForm->bufferForm);
}

/*---------------------------------------------------------------------------
| CALLBACK mainMixerButton_cb
---------------------------------------------------------------------------*/

void mainMixerButton_cb (FL_OBJECT *ob,long)
{
  if (fl_get_button (ob))
  {
    fl_show_form (mixerForm->mixerForm,
    FL_PLACE_GEOMETRY,FL_FULLBORDER,"Mixer");

    #ifdef LINUX
    // Workaround for "disappearing" buttons
    long pvBuffer [2];
    int devMask;

    pvBuffer [0] = AL_LINUX_MIXER_CHANNELS;
    ALgetparams (AL_DEFAULT_DEVICE,pvBuffer,2);
    devMask = pvBuffer [1];

    for (int i=0; i<SOUND_MIXER_NRDEVICES; i++)
    {
      if (devMask & (1 << i))
      {
        fl_show_object (mixerInButtons [i]);
        fl_show_object (mixerOutButtons [i]);
      }
    }
    #endif
  }
  else
    fl_hide_form (mixerForm->mixerForm);
}

/*---------------------------------------------------------------------------
| CALLBACK mainScrollBarSlider_cb
---------------------------------------------------------------------------*/

extern void mainScrollBarSlider_cb(FL_OBJECT *ob, long)
{
  DPSample *sample = fl_get_sample (mainForm->sample);
  double pos = fl_get_slider_value (ob);
  int frames = sample->getFrames ();
  int displayStart = sample->getDisplayStart ();
  int displayEnd   = sample->getDisplayEnd ();
  int displayDuration = displayEnd - displayStart;

  displayStart = (int) (pos * (frames - displayDuration));
  sample->setDisplay (displayStart,displayStart + displayDuration);
  updateDisplayDetails ();
  fl_redraw_object (mainForm->sample);
}

/*---------------------------------------------------------------------------
| CALLBACK mainScrollLButton_cb
---------------------------------------------------------------------------*/

extern void mainScrollLButton_cb(FL_OBJECT *, long data)
{
  DPSample *sample = fl_get_sample (mainForm->sample);
  int displayStart    = sample->getDisplayStart ();
  int displayEnd      = sample->getDisplayEnd ();
  int displayDuration = displayEnd - displayStart;

  if (data == 0)
    sample->scrollL (displayDuration / 200 + 1);
  else if (data == 1)
    sample->scrollL (displayDuration / 30 + 1);
  else
    sample->scrollLstart ();
  updateDisplayDetails ();
  fl_redraw_object (mainForm->sample);
  fl_redraw_object (mainForm->scrollBarSlider);
  fl_redraw_object (mainForm->zoomBarSlider);
}

/*---------------------------------------------------------------------------
| CALLBACK mainScrollRButton_cb
---------------------------------------------------------------------------*/

extern void mainScrollRButton_cb(FL_OBJECT *, long data)
{
  DPSample *sample = fl_get_sample (mainForm->sample);
  int displayStart    = sample->getDisplayStart ();
  int displayEnd      = sample->getDisplayEnd ();
  int displayDuration = displayEnd - displayStart;

  if (data == 0)
    sample->scrollR (displayDuration / 200 + 1);
  else if (data == 1)
    sample->scrollR (displayDuration / 30 + 1);
  else
    sample->scrollRend ();
  updateDisplayDetails ();
  fl_redraw_object (mainForm->sample);
  fl_redraw_object (mainForm->scrollBarSlider);
  fl_redraw_object (mainForm->zoomBarSlider);
}

/*---------------------------------------------------------------------------
| CALLBACK mainEditMode_cb
---------------------------------------------------------------------------*/
void mainEditMode_cb (FL_OBJECT *ob,long)
{
  DPSample *sample = fl_get_sample (mainForm->sample);
  int editMode;
  
  noSampleWarning
  if (sample->getChannels () == 1)
  {
    return;
  }
  else if (sample->getChannels () == 2)
  {
    editMode = fl_get_choice (ob) - 1;
    fl_set_sample_edit (mainForm->sample,editMode);
  }
  else if (sample->getChannels () == 4)
  {
    editMode = fl_get_choice (ob);
    switch (editMode)
    {
      case 1 :
        fl_set_sample_edit (mainForm->sample,0);
        break;
      case 2 :
        fl_set_sample_edit (mainForm->sample,1);
        break;
      case 3 :
        fl_set_sample_edit (mainForm->sample,3);
        break;
      case 4 :
        fl_set_sample_edit (mainForm->sample,4);
        break;
      case 5 :
        fl_set_sample_edit (mainForm->sample,2);
        break;
      default :
        break;
    }
  }
  fl_redraw_object (mainForm->sample);
}

/*---------------------------------------------------------------------------
| CALLBACK mainManualEdit_cb
---------------------------------------------------------------------------*/
void mainManualEdit_cb (FL_OBJECT *ob,long)
{
  DPSample *sample = fl_get_sample (mainForm->sample);
  
  if (sample->getValid ())
  {
    if (fl_get_sample_freehand (mainForm->sample))
    {
      fl_set_button (ob,0);
      fl_set_sample_freehand (mainForm->sample,0);
    }
    else
    {
      updateBuffers ("Undo Manual Edit")
      fl_set_button (ob,1);
      fl_set_sample_freehand (mainForm->sample,1);
      if ((sample->getDisplayEnd () - sample->getDisplayStart ())
        > (mainForm->sample->w) - (2 * BORDERX))
        fl_call_object_callback (zoomForm->zoomOneToOneButton);
    }
  }
  else
  {
    fl_set_button (ob,0);
    noSampleWarning
  }
}

/*---------------------------------------------------------------------------
| CALLBACK mainEffects_cb
---------------------------------------------------------------------------*/
void mainEffects_cb (FL_OBJECT *ob,long)
{
  DPSample *sample = fl_get_sample (mainForm->sample);
  if (sample->getValid () && fl_get_button (ob))
  {
    fl_deactivate_object (mainForm->effects);
    if (fl_get_sample_autowindows (mainForm->sample))
    {
      rememberForms (0);
      fl_deactivate_all_forms ();
      fl_activate_form (initialForm->initialForm);
      fl_activate_form (effectForm->effectForm);
      fl_activate_form (executeForm->executeForm);
      fl_activate_form (postForm->postForm);
    }
    fl_set_input (initialForm->susLoops,"0");
    fl_set_slider_value (initialForm->susSlider,0.0);
    fl_set_input (initialForm->relLoops,"0");
    fl_set_slider_value (initialForm->relSlider,0.0);
    if (sample->getChannels () == 4)
    {
      fl_set_form_size (
        initialForm->initialForm,
        initialForm->initialForm->w,
        initialFormHeight);
    }
    fl_set_choice (initialForm->quadro1Left,1);
    fl_set_choice (initialForm->quadro1Right,2);
    fl_set_choice (initialForm->quadro2Left,3);
    fl_set_choice (initialForm->quadro2Right,4);
    fl_show_form (initialForm->initialForm,
    FL_PLACE_MOUSE,FL_FULLBORDER,"DSP Initialisation");
  }
  else
  {
    fl_set_button (ob,0);
    noSampleWarning
  }
}

/*---------------------------------------------------------------------------
| CALLBACK mainZoomBarSlider_cb
---------------------------------------------------------------------------*/
void mainZoomBarSlider_cb (FL_OBJECT *ob,long)
{
  DPSample *sample = fl_get_sample (mainForm->sample);
  double pos = fl_get_slider_value (ob);
  int displayWidth;
  int frames;

  frames = sample->getFrames ();
  displayWidth = (int) (frames * (1.0 - pos));
  sample->zoomWidth (displayWidth);
  fl_redraw_object (mainForm->sample);
  fl_redraw_object (mainForm->scrollBarSlider);
  fl_redraw_object (mainForm->zoomBarSlider);
}

/*---------------------------------------------------------------------------
| CALLBACK mainZoomPlusButton_cb
---------------------------------------------------------------------------*/
void mainZoomPlusButton_cb (FL_OBJECT *,long)
{
  fl_call_object_callback (zoomForm->zoomInButton);
}

/*---------------------------------------------------------------------------
| CALLBACK mainZoomZeroButton_cb
---------------------------------------------------------------------------*/
void mainZoomZeroButton_cb (FL_OBJECT *,long)
{
  fl_call_object_callback (zoomForm->zoomAllButton);
}

/*---------------------------------------------------------------------------
| CALLBACK mainZoomMinusButton_cb
---------------------------------------------------------------------------*/
void mainZoomMinusButton_cb (FL_OBJECT *,long)
{
  fl_call_object_callback (zoomForm->zoomOutButton);
}

/*---------------------------------------------------------------------------
| CALLBACK mainVertZoomBarSlider_cb
---------------------------------------------------------------------------*/
void mainVertZoomBarSlider_cb (FL_OBJECT *ob,long)
{
  DPSample *sample = fl_get_sample (mainForm->sample);
  double pos = fl_get_slider_value (ob);
  int displayHeight;

  displayHeight = (int) (MAX24_1 * (1.0 - pos));
  sample->zoomVertHeight (displayHeight);
  fl_redraw_object (mainForm->sample);
  fl_redraw_object (mainForm->vertZoomBarSlider);
  fl_redraw_object (mainForm->vertScrollBarSlider);
}

/*---------------------------------------------------------------------------
| CALLBACK mainVertZoomPlusButton_cb
---------------------------------------------------------------------------*/
void mainVertZoomPlusButton_cb (FL_OBJECT *,long)
{
  DPSample *sample = fl_get_sample (mainForm->sample);
  sample->zoomVertIn (MAX24_1 / 100);
  fl_redraw_object (mainForm->sample);
  fl_redraw_object (mainForm->vertScrollBarSlider);
  fl_redraw_object (mainForm->vertZoomBarSlider);
}

/*---------------------------------------------------------------------------
| CALLBACK mainVertZoomAllButton_cb
---------------------------------------------------------------------------*/
void mainVertZoomAllButton_cb (FL_OBJECT *,long)
{
  DPSample *sample = fl_get_sample (mainForm->sample);
  sample->zoomVertAll ();
  fl_redraw_object (mainForm->sample);
  fl_redraw_object (mainForm->vertScrollBarSlider);
  fl_redraw_object (mainForm->vertZoomBarSlider);
}

/*---------------------------------------------------------------------------
| CALLBACK mainVertZoomMinusButton_cb
---------------------------------------------------------------------------*/
void mainVertZoomMinusButton_cb (FL_OBJECT *,long)
{
  DPSample *sample = fl_get_sample (mainForm->sample);
  sample->zoomVertOut ();
  fl_redraw_object (mainForm->sample);
  fl_redraw_object (mainForm->vertScrollBarSlider);
  fl_redraw_object (mainForm->vertZoomBarSlider);
}

/*---------------------------------------------------------------------------
| CALLBACK mainVertScrollBarSlider_cb
---------------------------------------------------------------------------*/
void mainVertScrollBarSlider_cb (FL_OBJECT *ob,long)
{
  DPSample *sample = fl_get_sample (mainForm->sample);
  double pos = fl_get_slider_value (ob);
  int displayVertLow  = sample->getDisplayVertLow ();
  int displayVertHigh = sample->getDisplayVertHigh ();
  int displayHeight   = displayVertHigh - displayVertLow;

  displayVertLow = (int) (-MAX23 + (pos * (MAX24_1 - displayHeight)));
  sample->setDisplayVert (displayVertLow,displayVertLow + displayHeight);
  fl_redraw_object (mainForm->sample);
  fl_redraw_object (mainForm->vertScrollBarSlider);
  fl_redraw_object (mainForm->vertZoomBarSlider);
}

/*---------------------------------------------------------------------------
| CALLBACK mainVertScrollUpButton_cb
---------------------------------------------------------------------------*/
void mainVertScrollUpButton_cb (FL_OBJECT *,long)
{
  DPSample *sample = fl_get_sample (mainForm->sample);
  int displayVertLow  = sample->getDisplayVertLow ();
  int displayVertHigh = sample->getDisplayVertHigh ();
  int displayHeight   = displayVertHigh - displayVertLow;

  sample->scrollVertUp (displayHeight / 30 + 1);
  fl_redraw_object (mainForm->sample);
  fl_redraw_object (mainForm->vertScrollBarSlider);
  fl_redraw_object (mainForm->vertZoomBarSlider);
}

/*---------------------------------------------------------------------------
| CALLBACK mainVertScrollCentreButton_cb
---------------------------------------------------------------------------*/
void mainVertScrollCentreButton_cb (FL_OBJECT *,long)
{
  DPSample *sample = fl_get_sample (mainForm->sample);

  sample->scrollVertCentre ();
  fl_redraw_object (mainForm->sample);
  fl_redraw_object (mainForm->vertScrollBarSlider);
  fl_redraw_object (mainForm->vertZoomBarSlider);
}

/*---------------------------------------------------------------------------
| CALLBACK mainVertScrollDownButton_cb
---------------------------------------------------------------------------*/
void mainVertScrollDownButton_cb (FL_OBJECT *,long)
{
  DPSample *sample = fl_get_sample (mainForm->sample);
  int displayVertLow  = sample->getDisplayVertLow ();
  int displayVertHigh = sample->getDisplayVertHigh ();
  int displayHeight   = displayVertHigh - displayVertLow;

  sample->scrollVertDown (displayHeight / 30 + 1);
  fl_redraw_object (mainForm->sample);
  fl_redraw_object (mainForm->vertScrollBarSlider);
  fl_redraw_object (mainForm->vertZoomBarSlider);
}

/*---------------------------------------------------------------------------
| CALLBACK playPlayButton_cb
---------------------------------------------------------------------------*/

void playPlayButton_cb (FL_OBJECT *,long data)
{
  char *error;
  DPSample *sample = fl_get_sample (mainForm->sample);
  noSampleWarning
  fl_deactivate_object (mainForm->playSampleButton);
  fl_deactivate_object (mainForm->playRangeButton);
  fl_deactivate_object (playForm->playSampleButton);
  fl_deactivate_object (playForm->playRangeButton);
  fl_deactivate_object (playForm->playDisplayButton);
  fl_show_object (playForm->playing);
  
  #ifdef LINUX
  closeGlobalPorts ();
  #endif

  #ifndef LINUX
  long pvBuffer1 [2];
  long pvBuffer2 [2];
  pvBuffer1 [0] = AL_MONITOR_CTL;
  pvBuffer2 [0] = AL_MONITOR_CTL;
  pvBuffer2 [1] = 0;
  ALgetparams (AL_DEFAULT_DEVICE,pvBuffer1,2);
  if (fl_get_sample_autoglobals (mainForm->sample))
    ALsetparams (AL_DEFAULT_DEVICE,pvBuffer2,2);
  #endif
  
  if ((error = sample->play (data,mainForm->sample)))
    fl_show_alert ("Warning","Could not play sample",error,TRUE);

  #ifndef LINUX
  if (fl_get_sample_autoglobals (mainForm->sample))
    ALsetparams (AL_DEFAULT_DEVICE,pvBuffer1,2);
  #endif

  fl_activate_object (mainForm->playSampleButton);
  fl_activate_object (mainForm->playRangeButton);
  fl_activate_object (playForm->playSampleButton);
  fl_activate_object (playForm->playRangeButton);
  fl_activate_object (playForm->playDisplayButton);
  fl_hide_object (playForm->playing);
}

/*---------------------------------------------------------------------------
| CALLBACK playStopButton_cb
---------------------------------------------------------------------------*/

void playStopButton_cb (FL_OBJECT *,long)
{
  DPSampleStopCatch (0);
}

/*---------------------------------------------------------------------------
| CALLBACK playReleaseButton_cb
---------------------------------------------------------------------------*/

void playReleaseButton_cb (FL_OBJECT *,long)
{
  DPSampleReleaseCatch (0);
}

/*---------------------------------------------------------------------------
| CALLBACK playLeftSlider_cb
---------------------------------------------------------------------------*/

void playLeftSlider_cb (FL_OBJECT *ob,long)
{
  long pvBuffer [2];
  double num;

  num = fl_get_slider_value (ob);

  #ifndef LINUX
  int vol;
  vol = numToVol (num);
  pvBuffer [0] = AL_LEFT_SPEAKER_GAIN;
  pvBuffer [1] = vol;
  ALsetparams (AL_DEFAULT_DEVICE,pvBuffer,2);
  fl_set_slider_value (mixplayForm->leftSlider,num);
  fl_set_slider_value (postForm->leftSlider,num);

  #else  
  int currentOutput;
  pvBuffer [0] = AL_LINUX_CURRENT_OUTPUT;
  ALgetparams (AL_DEFAULT_DEVICE,pvBuffer,2);
  currentOutput = pvBuffer [1];
  fl_set_slider_value (mixerSliders [2 * currentOutput],num);
  fl_call_object_callback (mixerSliders [2 * currentOutput]);
  #endif

  if (fl_get_button (playForm->lockButton))
  {
    #ifndef LINUX
    fl_set_slider_value (playForm->rightSlider,num);
    pvBuffer [0] = AL_RIGHT_SPEAKER_GAIN;
    ALsetparams (AL_DEFAULT_DEVICE,pvBuffer,2);
    fl_set_slider_value (mixplayForm->rightSlider,num);
    fl_set_slider_value (postForm->rightSlider,num);
    #endif
  }
}

/*---------------------------------------------------------------------------
| CALLBACK playRightSlider_cb
---------------------------------------------------------------------------*/

void playRightSlider_cb (FL_OBJECT *ob,long)
{
  long pvBuffer [2];
  double num;

  num = fl_get_slider_value (ob);

  #ifndef LINUX
  int vol;
  vol = numToVol (num);
  pvBuffer [0] = AL_RIGHT_SPEAKER_GAIN;
  pvBuffer [1] = vol;
  ALsetparams (AL_DEFAULT_DEVICE,pvBuffer,2);
  fl_set_slider_value (mixplayForm->rightSlider,num);
  fl_set_slider_value (postForm->rightSlider,num);

  #else
  int currentOutput;
  pvBuffer [0] = AL_LINUX_CURRENT_OUTPUT;
  ALgetparams (AL_DEFAULT_DEVICE,pvBuffer,2);
  currentOutput = pvBuffer [1];
  fl_set_slider_value (mixerSliders [(2 * currentOutput) + 1],num);
  fl_call_object_callback (mixerSliders [(2 * currentOutput) + 1]);
  #endif

  if (fl_get_button (playForm->lockButton))
  {
    #ifndef LINUX
    fl_set_slider_value (playForm->leftSlider,num);
    pvBuffer [0] = AL_LEFT_SPEAKER_GAIN;
    ALsetparams (AL_DEFAULT_DEVICE,pvBuffer,2);
    fl_set_slider_value (mixplayForm->leftSlider,num);
    fl_set_slider_value (postForm->leftSlider,num);
    #endif
  }
}

/*---------------------------------------------------------------------------
| CALLBACK playLockButton_cb
---------------------------------------------------------------------------*/

void playLockButton_cb (FL_OBJECT *ob,long)
{
  long pvBuffer [2];

  fl_set_button (mixplayForm->lockButton,fl_get_button (ob));
  fl_set_button (postForm->lockButton,fl_get_button (ob));
  if (fl_get_button (ob))
  {    
    #ifndef LINUX
    double num;
    int vol;
    num = fl_get_slider_value (playForm->leftSlider);
    vol = numToVol (num);
    pvBuffer [0] = AL_RIGHT_SPEAKER_GAIN;
    pvBuffer [1] = vol;
    ALsetparams (AL_DEFAULT_DEVICE,pvBuffer,2);
    fl_set_slider_value (playForm->rightSlider,num);
    fl_set_slider_value (mixplayForm->rightSlider,num);
    fl_set_slider_value (postForm->rightSlider,num);

    #else
    int currentOutput;
    pvBuffer [0] = AL_LINUX_CURRENT_OUTPUT;
    ALgetparams (AL_DEFAULT_DEVICE,pvBuffer,2);
    currentOutput = pvBuffer [1];
    fl_set_button (mixerLockButtons [currentOutput],fl_get_button (ob));
    fl_call_object_callback (mixerLockButtons [currentOutput]);
    #endif
  }  
  else
  {
    #ifdef LINUX
    int currentOutput;
    pvBuffer [0] = AL_LINUX_CURRENT_OUTPUT;
    ALgetparams (AL_DEFAULT_DEVICE,pvBuffer,2);
    currentOutput = pvBuffer [1];
    fl_set_button (mixerLockButtons [currentOutput],fl_get_button (ob));
    fl_call_object_callback (mixerLockButtons [currentOutput]);
    #endif
  }
}

/*---------------------------------------------------------------------------
| CALLBACK playScrollButton_cb
---------------------------------------------------------------------------*/

void playScrollButton_cb (FL_OBJECT *ob,long)
{
  fl_set_sample_scroll (mainForm->sample,fl_get_button (ob));
  fl_set_button (recordForm->scrollButton,fl_get_button (ob));
}

/*---------------------------------------------------------------------------
| CALLBACK playMuteButton_cb
---------------------------------------------------------------------------*/

void playMuteButton_cb (FL_OBJECT *ob,long)
{
  #ifdef LINUX
  long pvBuffer [2];
  int currentOutput;
  pvBuffer [0] = AL_LINUX_CURRENT_OUTPUT;
  ALgetparams (AL_DEFAULT_DEVICE,pvBuffer,2);
  currentOutput = pvBuffer [1];
  fl_set_button (mixerMuteButtons [currentOutput],fl_get_button (ob));
  fl_call_object_callback (mixerMuteButtons [currentOutput]);
  #endif
}

/*---------------------------------------------------------------------------
| CALLBACK playMuteHiddenButton_cb
---------------------------------------------------------------------------*/

void playMuteHiddenButton_cb (FL_OBJECT *ob,long)
{
  long pvBuffer [2];
  if (fl_get_button (ob))
  {
    pvBuffer [0] = AL_SPEAKER_MUTE_CTL;
    ALgetparams (AL_DEFAULT_DEVICE,pvBuffer,2);
    if (pvBuffer [1])
    {
      pvBuffer [1] = 0;
      ALsetparams (AL_DEFAULT_DEVICE,pvBuffer,2);
      fl_set_button (playForm->muteButton,0);
      fl_set_button (mixplayForm->muteButton,0);
      fl_set_button (postForm->muteButton,0);
    }
    else
    {
      pvBuffer [1] = 1;
      ALsetparams (AL_DEFAULT_DEVICE,pvBuffer,2);
      fl_set_button (playForm->muteButton,1);
      fl_set_button (mixplayForm->muteButton,1);
      fl_set_button (postForm->muteButton,1);
    }
  }
}

/*---------------------------------------------------------------------------
| CALLBACK playModeChoice_cb
---------------------------------------------------------------------------*/
void playModeChoice_cb (FL_OBJECT *,long)
{
  long pvBuffer [2];
  int num = fl_get_choice (playForm->modeChoice);
  pvBuffer [0] = AL_CHANNEL_MODE;
  
  if (num == 1 && globalChannels == 4)
  {
    pvBuffer [1] = AL_STEREO;
    ALsetparams (AL_DEFAULT_DEVICE,pvBuffer,2);
    globalChannels = 2;
    fl_set_form_size (
      recordForm->recordForm,
      recordFormWidth - 230,
      recordForm->recordForm->h);
  }
  else if (num == 2 && globalChannels == 2)
  {
    pvBuffer [1] = AL_4CHANNEL;
    ALsetparams (AL_DEFAULT_DEVICE,pvBuffer,2);
    globalChannels = 4;
    fl_set_form_size (
      recordForm->recordForm,
      recordFormWidth,
      recordForm->recordForm->h);
  }
}

/*---------------------------------------------------------------------------
| CALLBACK playRateChoice_cb
---------------------------------------------------------------------------*/

void playRateChoice_cb (FL_OBJECT *,long)
{
  long pvBuffer [2];
  int num = fl_get_choice (playForm->rateChoice);
  pvBuffer [0] = AL_OUTPUT_RATE;
  switch (num)
  {
    case 1 :
      pvBuffer [1] = AL_RATE_8000;      break;
    case 2 :
      pvBuffer [1] = AL_RATE_11025;     break;
    case 3 :
      pvBuffer [1] = AL_RATE_16000;     break;
    case 4 :
      pvBuffer [1] = AL_RATE_22050;     break;
    case 5 :
      pvBuffer [1] = AL_RATE_32000;     break;
    case 6 :
      pvBuffer [1] = AL_RATE_44100;     break;
    case 7 :
      pvBuffer [1] = AL_RATE_48000;     break;
    case 8 :
      pvBuffer [1] = AL_RATE_AES_1;     break;
    case 9 :
      pvBuffer [1] = AL_RATE_INPUTRATE; break;
    default :
      return; // Error - do not set output rate
  }
  ALsetparams (AL_DEFAULT_DEVICE,pvBuffer,2);
}

/*---------------------------------------------------------------------------
| CALLBACK playRateMenu_cb
---------------------------------------------------------------------------*/

void playRateMenu_cb (FL_OBJECT *ob,long)
{
  int  item;
  char tempString [50];
  
  item=fl_get_menu (ob);
  switch (item)
  {
    case 1 :
      sprintf (tempString,"%d",8000);
      fl_set_input (playForm->rateInput,tempString);
      break;
    case 2 :
      sprintf (tempString,"%d",11025);
      fl_set_input (playForm->rateInput,tempString);
      break;
    case 3 :
      sprintf (tempString,"%d",16000);
      fl_set_input (playForm->rateInput,tempString);
      break;
    case 4 :
      sprintf (tempString,"%d",22050);
      fl_set_input (playForm->rateInput,tempString);
      break;
    case 5 :
      sprintf (tempString,"%d",32000);
      fl_set_input (playForm->rateInput,tempString);
      break;
    case 6 :
      sprintf (tempString,"%d",44100);
      fl_set_input (playForm->rateInput,tempString);
      break;
    case 7 :
      sprintf (tempString,"%d",48000);
      fl_set_input (playForm->rateInput,tempString);
      break;
    default:
      break;
  }
  fl_call_object_callback (playForm->rateInput);
}

/*---------------------------------------------------------------------------
| CALLBACK playRateInput_cb
---------------------------------------------------------------------------*/

void playRateInput_cb (FL_OBJECT *,long)
{
  int rate;
  
  if (!sscanf (fl_safe_get_input (playForm->rateInput),"%d",&rate)) return;
  if (rate < 1)
  {
    rate = 1;
    fl_set_input (playForm->rateInput,"1");
  }

  long pvBuffer [2];
  pvBuffer [0] = AL_OUTPUT_RATE;
  pvBuffer [1] = rate;
  ALsetparams (AL_DEFAULT_DEVICE,pvBuffer,2);
  updateAudioGlobals (0,0);

  #ifdef LINUX
  char tempString [50];
  sprintf (tempString,"%ld",pvBuffer [1]);
  fl_set_input (playForm->rateInput,tempString);
  fl_set_input (mixplayForm->rateInput,tempString);
  fl_set_input (postForm->rateInput,tempString);
  #endif
}

/*---------------------------------------------------------------------------
| FUNCTION beforeRecord
---------------------------------------------------------------------------*/

void beforeRecord()
{
  #ifdef LINUX
  closeGlobalPorts ();
  #endif

  fl_deactivate_object (recordForm->recordSampleButton);
  fl_deactivate_object (recordForm->recordRangeButton);
  fl_deactivate_object (recordForm->recordDisplayButton);
  fl_deactivate_object (recordForm->triggerSlider);
  fl_deactivate_object (recordForm->triggerButton);
  fl_deactivate_object (recordForm->calibrateButton);
  fl_deactivate_object (recordForm->levelsButton);
  fl_show_object (recordForm->recording);
}

/*---------------------------------------------------------------------------
| FUNCTION afterRecord
---------------------------------------------------------------------------*/

void afterRecord()
{
  fl_activate_object (recordForm->recordSampleButton);
  fl_activate_object (recordForm->recordRangeButton);
  fl_activate_object (recordForm->recordDisplayButton);
  fl_activate_object (recordForm->triggerSlider);
  fl_activate_object (recordForm->triggerButton);
  fl_activate_object (recordForm->calibrateButton);
  fl_activate_object (recordForm->levelsButton);
  fl_hide_object (recordForm->recording);
}

/*---------------------------------------------------------------------------
| CALLBACK recordRecordButton_cb
---------------------------------------------------------------------------*/

void recordRecordButton_cb (FL_OBJECT *,long data)
{
  char *error;
  int trigger;
  DPSample *sample = fl_get_sample (mainForm->sample);
  noSampleWarning
  beforeRecord();

  if (fl_get_button (recordForm->triggerButton))
    trigger = (int) fl_get_slider_value (recordForm->triggerSlider);
  else
    trigger = -1;
 
  updateBuffers ("Undo Record")
  if ((error = sample->record (data,trigger,mainForm->sample)))
    fl_show_alert ("Warning","Could not record sample",error,TRUE);
  
  if (!(sample->consolidate ()))
  {
    fl_show_alert (
      "Warning",
      "Could not defragment sample - out of memory",
      "Please save sample immediately",TRUE);
    
    const char *filename = fselector
      ("Please enter the filename to save","*.aiff",0,sample);

    if (filename)
    {
      int irixFile = open (filename,O_RDONLY);
      int writeFile = TRUE;
      if (irixFile != -1)
      {
        close (irixFile);
        if (!fl_show_question_old (filename,"exists already - overwrite ?",0))
        {
          writeFile = FALSE;
        }
      }
      
      if (writeFile)
      {
        waitCursorOn ();
        if ((error = sample->saveAIFF ((char *) filename,0,
          fl_get_sample_soxcompatible (mainForm->sample),1)))
        {
          waitCursorOff ();
          fl_show_alert ("Warning","Could not save file",error,TRUE);
        }
        else
        {
          waitCursorOff ();
          updateNameBox ();
          updateBufferBrowser ();
          sample->removeExtra ();
        }
      }
    }
  }

  afterRecord();
  updateDisplayDetails ();
  updateRangeDetails ();
  updateLoopDetails ();
  fl_redraw_object (mainForm->sample);
  fl_redraw_object (mainForm->scrollBarSlider);
  fl_redraw_object (mainForm->zoomBarSlider);
}
/*---------------------------------------------------------------------------
| CALLBACK recordStopButton_cb
---------------------------------------------------------------------------*/

void recordStopButton_cb (FL_OBJECT *,long)
{
  DPSampleStopCatch (0);
}

/*---------------------------------------------------------------------------
| CALLBACK recordLeftSlider_cb
---------------------------------------------------------------------------*/

void recordLeftSlider_cb (FL_OBJECT *ob,long)
{
  long pvBuffer [2];
  double num;

  num = fl_get_slider_value (ob);

  #ifndef LINUX
  int vol;
  vol = numToVol (100 - num);
  pvBuffer [0] = AL_LEFT_INPUT_ATTEN;
  pvBuffer [1] = vol;
  ALsetparams (AL_DEFAULT_DEVICE,pvBuffer,2);

  #else
  int currentInput;
  pvBuffer [0] = AL_LINUX_CURRENT_INPUT;
  ALgetparams (AL_DEFAULT_DEVICE,pvBuffer,2);
  currentInput = pvBuffer [1];
  fl_set_slider_value (mixerSliders [2 * currentInput],num);
  fl_call_object_callback (mixerSliders [2 * currentInput]);
  #endif
  
  if (fl_get_button (recordForm->lockButton))
  {
    #ifndef LINUX
    fl_set_slider_value (recordForm->rightSlider,num);
    pvBuffer [0] = AL_RIGHT_INPUT_ATTEN;
    ALsetparams (AL_DEFAULT_DEVICE,pvBuffer,2);
    
    if (globalChannels == 4)
    {
      fl_set_slider_value (recordForm->threeSlider,num);
      pvBuffer [0] = AL_LEFT2_INPUT_ATTEN;
      ALsetparams (AL_DEFAULT_DEVICE,pvBuffer,2);
      fl_set_slider_value (recordForm->fourSlider,num);
      pvBuffer [0] = AL_RIGHT2_INPUT_ATTEN;
      ALsetparams (AL_DEFAULT_DEVICE,pvBuffer,2);
    }
    #endif
  }
}

/*---------------------------------------------------------------------------
| CALLBACK recordRightSlider_cb
---------------------------------------------------------------------------*/

void recordRightSlider_cb (FL_OBJECT *ob,long)
{
  long pvBuffer [2];
  double num;

  num = fl_get_slider_value (ob);

  #ifndef LINUX
  int vol;
  vol = numToVol (100 - num);
  pvBuffer [0] = AL_RIGHT_INPUT_ATTEN;
  pvBuffer [1] = vol;
  ALsetparams (AL_DEFAULT_DEVICE,pvBuffer,2);

  #else
  int currentInput;
  pvBuffer [0] = AL_LINUX_CURRENT_INPUT;
  ALgetparams (AL_DEFAULT_DEVICE,pvBuffer,2);
  currentInput = pvBuffer [1];
  fl_set_slider_value (mixerSliders [(2 * currentInput) + 1],num);
  fl_call_object_callback (mixerSliders [(2 * currentInput) + 1]);
  #endif
  
  if (fl_get_button (recordForm->lockButton))
  {
    #ifndef LINUX
    fl_set_slider_value (recordForm->leftSlider,num);
    pvBuffer [0] = AL_LEFT_INPUT_ATTEN;
    ALsetparams (AL_DEFAULT_DEVICE,pvBuffer,2);
    
    if (globalChannels == 4)
    {
      fl_set_slider_value (recordForm->threeSlider,num);
      pvBuffer [0] = AL_LEFT2_INPUT_ATTEN;
      ALsetparams (AL_DEFAULT_DEVICE,pvBuffer,2);
      fl_set_slider_value (recordForm->fourSlider,num);
      pvBuffer [0] = AL_RIGHT2_INPUT_ATTEN;
      ALsetparams (AL_DEFAULT_DEVICE,pvBuffer,2);
    }
    #endif
  }
}

/*---------------------------------------------------------------------------
| CALLBACK recordLockButton_cb
---------------------------------------------------------------------------*/

void recordLockButton_cb (FL_OBJECT *ob,long)
{
  long pvBuffer [2];
  
  if (fl_get_button (ob))
  {
    #ifndef LINUX
    double num;
    int vol;
    num = fl_get_slider_value (recordForm->leftSlider);
    vol = numToVol (100 - num);
    pvBuffer [0] = AL_RIGHT_INPUT_ATTEN;
    pvBuffer [1] = vol;
    ALsetparams (AL_DEFAULT_DEVICE,pvBuffer,2);
    fl_set_slider_value (recordForm->rightSlider,num);

    #else
    int currentInput;
    pvBuffer [0] = AL_LINUX_CURRENT_INPUT;
    ALgetparams (AL_DEFAULT_DEVICE,pvBuffer,2);
    currentInput = pvBuffer [1];
    fl_set_button (mixerLockButtons [currentInput],fl_get_button (ob));
    fl_call_object_callback (mixerLockButtons [currentInput]);
    #endif
    
    #ifndef LINUX
    if (globalChannels == 4)
    {
      pvBuffer [0] = AL_LEFT2_INPUT_ATTEN;
      ALsetparams (AL_DEFAULT_DEVICE,pvBuffer,2);
      fl_set_slider_value (recordForm->threeSlider,num);
      pvBuffer [0] = AL_RIGHT2_INPUT_ATTEN;
      ALsetparams (AL_DEFAULT_DEVICE,pvBuffer,2);
      fl_set_slider_value (recordForm->fourSlider,num);
    }
    #endif
  }
  else
  {
    #ifdef LINUX
    int currentInput;
    pvBuffer [0] = AL_LINUX_CURRENT_INPUT;
    ALgetparams (AL_DEFAULT_DEVICE,pvBuffer,2);
    currentInput = pvBuffer [1];
    fl_set_button (mixerLockButtons [currentInput],fl_get_button (ob));
    fl_call_object_callback (mixerLockButtons [currentInput]);
    #endif
  }
}

/*---------------------------------------------------------------------------
| CALLBACK recordScrollButton_cb
---------------------------------------------------------------------------*/

void recordScrollButton_cb (FL_OBJECT *ob,long)
{
  fl_set_sample_scroll (mainForm->sample,fl_get_button (ob));
  fl_set_button (playForm->scrollButton,fl_get_button (ob));
}

/*---------------------------------------------------------------------------
| CALLBACK recordMuteButton_cb
---------------------------------------------------------------------------*/

void recordMuteButton_cb (FL_OBJECT *ob,long)
{
  #ifdef LINUX
  long pvBuffer [2];
  int currentInput;
  pvBuffer [0] = AL_LINUX_CURRENT_INPUT;
  ALgetparams (AL_DEFAULT_DEVICE,pvBuffer,2);
  currentInput = pvBuffer [1];
  fl_set_button (mixerMuteButtons [currentInput],fl_get_button (ob));
  fl_call_object_callback (mixerMuteButtons [currentInput]);
  #endif
}

/*---------------------------------------------------------------------------
| CALLBACK recordMonitorButton_cb
---------------------------------------------------------------------------*/

void recordMonitorButton_cb (FL_OBJECT *,long)
{
}

/*---------------------------------------------------------------------------
| CALLBACK recordMonitorHiddenButton_cb
---------------------------------------------------------------------------*/

void recordMonitorHiddenButton_cb (FL_OBJECT *ob,long)
{
  long pvBuffer [2];
  if (fl_get_button (ob))
  {
    pvBuffer [0] = AL_MONITOR_CTL;
    ALgetparams (AL_DEFAULT_DEVICE,pvBuffer,2);
    if (pvBuffer [1])
    {
      pvBuffer [1] = 0;
      ALsetparams (AL_DEFAULT_DEVICE,pvBuffer,2);
      fl_set_button (recordForm->monitorButton,0);
    }
    else
    {
      pvBuffer [1] = 1;
      ALsetparams (AL_DEFAULT_DEVICE,pvBuffer,2);
      fl_set_button (recordForm->monitorButton,1);
    }
  }
}

/*---------------------------------------------------------------------------
| CALLBACK recordRateChoice_cb
---------------------------------------------------------------------------*/

void recordRateChoice_cb (FL_OBJECT *,long)
{
  long pvBuffer [2];
  int num = fl_get_choice (recordForm->rateChoice);
  pvBuffer [0] = AL_INPUT_RATE;
  switch (num)
  {
    case 1 :
      pvBuffer [1] = AL_RATE_8000;      break;
    case 2 :
      pvBuffer [1] = AL_RATE_11025;     break;
    case 3 :
      pvBuffer [1] = AL_RATE_16000;     break;
    case 4 :
      pvBuffer [1] = AL_RATE_22050;     break;
    case 5 :
      pvBuffer [1] = AL_RATE_32000;     break;
    case 6 :
      pvBuffer [1] = AL_RATE_44100;     break;
    case 7 :
      pvBuffer [1] = AL_RATE_48000;     break;
    case 8 :
      pvBuffer [1] = AL_RATE_AES_1;     break;
    case 9 :
      pvBuffer [1] = AL_RATE_INPUTRATE; break;
    default :
      return; // Error - do not set output rate
  }
  ALsetparams (AL_DEFAULT_DEVICE,pvBuffer,2);
}

/*---------------------------------------------------------------------------
| CALLBACK recordSourceChoice_cb
---------------------------------------------------------------------------*/

void recordSourceChoice_cb (FL_OBJECT *,long)
{
  long pvBuffer [4];
  int set;
  int num = fl_get_choice (recordForm->sourceChoice);
  pvBuffer [0] = AL_INPUT_SOURCE;
  pvBuffer [2] = AL_MIC_MODE;
  switch (num)
  {
    case 1 :
      pvBuffer [1] = AL_INPUT_LINE;
      set=2;
      break;
    case 2 :
      pvBuffer [1] = AL_INPUT_DIGITAL;
      set=2;
      break;
    case 3 :
      pvBuffer [1] = AL_INPUT_MIC;
      pvBuffer [3] = AL_MONO;
      set=4;
      break;
    case 4 :
      pvBuffer [1] = AL_INPUT_MIC;
      pvBuffer [3] = AL_STEREO;
      set=4;
      break;
    default :
      return; // Error - do not set output rate
  }
  ALsetparams (AL_DEFAULT_DEVICE,pvBuffer,set);
}

/*---------------------------------------------------------------------------
| CALLBACK recordTriggerButton_cb
---------------------------------------------------------------------------*/

void recordTriggerButton_cb (FL_OBJECT *,long)
{
}

/*---------------------------------------------------------------------------
| CALLBACK recordTriggerSlider_cb
---------------------------------------------------------------------------*/

void recordTriggerSlider_cb (FL_OBJECT *,long)
{
}

/*---------------------------------------------------------------------------
| CALLBACK recordLeftLevel_cb
---------------------------------------------------------------------------*/

void recordLeftLevel_cb (FL_OBJECT *,long)
{
}

/*---------------------------------------------------------------------------
| CALLBACK recordRightLevel_cb
---------------------------------------------------------------------------*/

void recordRightLevel_cb (FL_OBJECT *,long)
{
}

/*---------------------------------------------------------------------------
| CALLBACK recordLevelsButton_cb
---------------------------------------------------------------------------*/

void recordLevelsButton_cb (FL_OBJECT *ob,long)
{
  if (fl_get_button (ob))
  {
    ALconfig audioConfig;
    int     queueSize;
    
    // Disable void handler
    ALseterrorhandler (0);
    
    // Remove idle delta
    fl_set_idle_delta (0);

    // Set up new audio configuration 
    audioConfig = ALnewconfig ();
    if (!audioConfig)
    {
      return;
    }

    // Set sample format and width
    ALsetsampfmt (audioConfig,AL_SAMPFMT_TWOSCOMP);
    ALsetwidth (audioConfig,AL_SAMPLE_8);

    // Set number of channels
    ALsetchannels (audioConfig,globalChannels);

    // Set queue size
    queueSize = globalChannels * METERQUEUESIZE;
    limitQueueSize (globalChannels,&queueSize);
    
    if (ALsetqueuesize (audioConfig,queueSize))
    {
      ALfreeconfig (audioConfig);
      return;
    }

    // Open new audio port with given configuration
    globalInputPort = ALopenport ("GlobalAudioInputPort","r",audioConfig);

    ALfreeconfig (audioConfig);
    return;
  }
  else
  {
    if (globalInputPort)
    {
      ALcloseport (globalInputPort);
      globalInputPort = 0;
      fl_set_slider_value (recordForm->leftLevel,0.0);
      fl_set_slider_value (recordForm->rightLevel,0.0);
      fl_set_object_color (recordForm->leftOverload,FL_COL1,FL_COL1);
      fl_set_object_color (recordForm->rightOverload,FL_COL1,FL_COL1);
      fl_set_object_color (recordForm->triggerOverload,FL_COL1,FL_COL1);
      fl_set_slider_value (recordForm->threeLevel,0.0);
      fl_set_slider_value (recordForm->fourLevel,0.0);
      fl_set_object_color (recordForm->threeOverload,FL_COL1,FL_COL1);
      fl_set_object_color (recordForm->fourOverload,FL_COL1,FL_COL1);
    }
    
    // Restore idle delta
    fl_set_idle_delta (normalIdle);
  }
}

/*---------------------------------------------------------------------------
| CALLBACK recordResetButton_cb
---------------------------------------------------------------------------*/

void recordResetButton_cb (FL_OBJECT *,long )
{
  recordAdjustLeft  = 0.0;
  recordAdjustRight = 0.0;
  recordAdjustThree = 0.0;
  recordAdjustFour  = 0.0;

  fl_show_alert (
    "Calibration",
    "Recording DC voltage calibration reset","",TRUE);
}

/*---------------------------------------------------------------------------
| CALLBACK recordCalibrateButton_cb
---------------------------------------------------------------------------*/

void recordCalibrateButton_cb (FL_OBJECT *,long)
{
  fl_show_alert (
    "Calibration",
    "Recording DC voltage calibration",
    "Please ensure inputs are receiving a zero signal",TRUE);

  beforeRecord();
  waitCursorOn ();

  char *error;
  DPSample *sample = fl_get_sample (mainForm->sample);
  DPSample tempSamp;
  if (sample->getValid ())
  {
    if (!(tempSamp.fresh
      (sample->getRate (),sample->getWidth (),
      globalChannels,(int) sample->getRate ())))
    {
      waitCursorOff ();
      afterRecord();
      fl_show_alert ("Warning","Could not calibrate inputs",
      "Out of memory",TRUE);
      return;
    }
  }
  else
  {
    if (!(tempSamp.fresh (44100.0,2,globalChannels,(int) 44100.0)))
    {
      waitCursorOff ();
      afterRecord();
      fl_show_alert ("Warning","Could not calibrate inputs",
      "Out of memory",TRUE);
      return;
    }
  }
  tempSamp.rangeAll ();
  if ((error = tempSamp.record (0,-1,0)))
  {
    waitCursorOff ();
    afterRecord();
    fl_show_alert ("Warning","Could not calibrate inputs",error,TRUE);
    return;
  }
  long long i;
  long long frames = tempSamp.getFrames ();
  long long temp;
  long long suml = 0;
  long long sumr = 0;
  long long sum3 = 0;
  long long sum4 = 0;
  int avgl      = 0;
  int avgr      = 0;
  int avg3      = 0;
  int avg4      = 0;
  double amountl = 0;
  double amountr = 0;
  double amount3 = 0;
  double amount4 = 0;
  int stereo = (tempSamp.getChannels ()) == 2;
  int quadro = (tempSamp.getChannels ()) == 4;
  
  for (i=0; i<frames; i++)
  {
    temp = tempSamp.getFrame24 (i,0);
    suml += temp;
    if (stereo || quadro)
    {
      temp = tempSamp.getFrame24 (i,1);
      sumr += temp;
    }
    if (quadro)
    {
      temp = tempSamp.getFrame24 (i,2);
      sum3 += temp;
      temp = tempSamp.getFrame24 (i,3);
      sum4 += temp;
    }
  }
  
  avgl = (int) (suml / frames);
  if (stereo || quadro)
    avgr = (int) (sumr / frames);
  if (quadro)
  {
    avg3 = (int) (sum3 / frames);
    avg4 = (int) (sum4 / frames);
  }
  
  amountl = - (100.0 * avgl / MAX23);
  if (stereo || quadro)
    amountr = - (100.0 * avgr / MAX23);
  if (quadro)
  {
    amount3 = - (100.0 * avg3 / MAX23);
    amount4 = - (100.0 * avg4 / MAX23);
  }
  
  if (amountl > 100.0) amountl = 100.0;
  else if (amountl < -100.0) amountl = -100.0;
  if (amountr > 100.0) amountr = 100.0;
  else if (amountr < -100.0) amountr = -100.0;
  if (amount3 > 100.0) amount3 = 100.0;
  else if (amount3 < -100.0) amount3 = -100.0;
  if (amount4 > 100.0) amount4 = 100.0;
  else if (amount4 < -100.0) amount4 = -100.0;
  
  recordAdjustLeft  = amountl;
  recordAdjustRight = amountr;
  recordAdjustThree = amount3;
  recordAdjustFour  = amount4;

  waitCursorOff ();
  afterRecord();
}

/*---------------------------------------------------------------------------
| CALLBACK recordThreeSlider_cb
---------------------------------------------------------------------------*/

void recordThreeSlider_cb (FL_OBJECT *ob,long)
{
  long pvBuffer [2];
  double num;
  int vol;
  num = 100 - fl_get_slider_value (ob);
  vol = numToVol (num);
  pvBuffer [0] = AL_LEFT2_INPUT_ATTEN;
  pvBuffer [1] = vol;
  ALsetparams (AL_DEFAULT_DEVICE,pvBuffer,2);
  if (fl_get_button (recordForm->lockButton))
  {
    fl_set_slider_value (recordForm->fourSlider,100 - num);
    pvBuffer [0] = AL_RIGHT2_INPUT_ATTEN;
    ALsetparams (AL_DEFAULT_DEVICE,pvBuffer,2);
    fl_set_slider_value (recordForm->leftSlider,100 - num);
    pvBuffer [0] = AL_LEFT_INPUT_ATTEN;
    ALsetparams (AL_DEFAULT_DEVICE,pvBuffer,2);
    fl_set_slider_value (recordForm->rightSlider,100 - num);
    pvBuffer [0] = AL_RIGHT_INPUT_ATTEN;
    ALsetparams (AL_DEFAULT_DEVICE,pvBuffer,2);
  }
}

/*---------------------------------------------------------------------------
| CALLBACK recordFourSlider_cb
---------------------------------------------------------------------------*/

void recordFourSlider_cb (FL_OBJECT *ob,long)
{
  long pvBuffer [2];
  double num;
  int vol;
  num = 100 - fl_get_slider_value (ob);
  vol = numToVol (num);
  pvBuffer [0] = AL_RIGHT2_INPUT_ATTEN;
  pvBuffer [1] = vol;
  ALsetparams (AL_DEFAULT_DEVICE,pvBuffer,2);
  if (fl_get_button (recordForm->lockButton))
  {
    fl_set_slider_value (recordForm->threeSlider,100 - num);
    pvBuffer [0] = AL_LEFT2_INPUT_ATTEN;
    ALsetparams (AL_DEFAULT_DEVICE,pvBuffer,2);
    fl_set_slider_value (recordForm->leftSlider,100 - num);
    pvBuffer [0] = AL_LEFT_INPUT_ATTEN;
    ALsetparams (AL_DEFAULT_DEVICE,pvBuffer,2);
    fl_set_slider_value (recordForm->rightSlider,100 - num);
    pvBuffer [0] = AL_RIGHT_INPUT_ATTEN;
    ALsetparams (AL_DEFAULT_DEVICE,pvBuffer,2);
  }
}

/*---------------------------------------------------------------------------
| CALLBACK recordThreeLevel_cb
---------------------------------------------------------------------------*/

void recordThreeLevel_cb (FL_OBJECT *,long)
{
}

/*---------------------------------------------------------------------------
| CALLBACK recordFourLevel_cb
---------------------------------------------------------------------------*/

void recordFourLevel_cb (FL_OBJECT *,long)
{
}

/*---------------------------------------------------------------------------
| CALLBACK recordRateMenu_cb
---------------------------------------------------------------------------*/

void recordRateMenu_cb (FL_OBJECT *ob,long)
{
  int  item;
  char tempString [50];
  
  item=fl_get_menu (ob);
  switch (item)
  {
    case 1 :
      sprintf (tempString,"%d",8000);
      fl_set_input (recordForm->rateInput,tempString);
      break;
    case 2 :
      sprintf (tempString,"%d",11025);
      fl_set_input (recordForm->rateInput,tempString);
      break;
    case 3 :
      sprintf (tempString,"%d",16000);
      fl_set_input (recordForm->rateInput,tempString);
      break;
    case 4 :
      sprintf (tempString,"%d",22050);
      fl_set_input (recordForm->rateInput,tempString);
      break;
    case 5 :
      sprintf (tempString,"%d",32000);
      fl_set_input (recordForm->rateInput,tempString);
      break;
    case 6 :
      sprintf (tempString,"%d",44100);
      fl_set_input (recordForm->rateInput,tempString);
      break;
    case 7 :
      sprintf (tempString,"%d",48000);
      fl_set_input (recordForm->rateInput,tempString);
      break;
    default:
      break;
  }
  fl_call_object_callback (recordForm->rateInput);
}

/*---------------------------------------------------------------------------
| CALLBACK recordRateInput_cb
---------------------------------------------------------------------------*/

void recordRateInput_cb (FL_OBJECT *,long)
{
  int rate;
  
  if (!sscanf (fl_safe_get_input (recordForm->rateInput),"%d",&rate)) return;
  if (rate < 1)
  {
    rate = 1;
    fl_set_input (recordForm->rateInput,"1");
  }

  long pvBuffer [2];
  pvBuffer [0] = AL_INPUT_RATE;
  pvBuffer [1] = rate;
  ALsetparams (AL_DEFAULT_DEVICE,pvBuffer,2);
  updateAudioGlobals (0,0);

  #ifdef LINUX
  char tempString [50];
  sprintf (tempString,"%ld",pvBuffer [1]);
  fl_set_input (recordForm->rateInput,tempString);
  #endif
}

/*---------------------------------------------------------------------------
| CALLBACK zoomInButton_cb
---------------------------------------------------------------------------*/

void zoomInButton_cb (FL_OBJECT *,long)
{
  DPSample *sample = fl_get_sample (mainForm->sample);
  sample->zoomIn ();
  updateDisplayDetails ();
  fl_redraw_object (mainForm->sample);
  fl_redraw_object (mainForm->scrollBarSlider);
  fl_redraw_object (mainForm->zoomBarSlider);
}

/*---------------------------------------------------------------------------
| CALLBACK zoomOutButton_cb
---------------------------------------------------------------------------*/

void zoomOutButton_cb (FL_OBJECT *,long)
{
  DPSample *sample = fl_get_sample (mainForm->sample);
  sample->zoomOut ();
  updateDisplayDetails ();
  fl_redraw_object (mainForm->sample);
  fl_redraw_object (mainForm->scrollBarSlider);
  fl_redraw_object (mainForm->zoomBarSlider);
}

/*---------------------------------------------------------------------------
| CALLBACK zoomAllButton_cb
---------------------------------------------------------------------------*/

void zoomAllButton_cb (FL_OBJECT *,long)
{
  DPSample *sample = fl_get_sample (mainForm->sample);
  sample->zoomAll ();
  updateDisplayDetails ();
  fl_redraw_object (mainForm->sample);
  fl_redraw_object (mainForm->scrollBarSlider);
  fl_redraw_object (mainForm->zoomBarSlider);
}

/*---------------------------------------------------------------------------
| CALLBACK zoomRangeButton_cb
---------------------------------------------------------------------------*/

void zoomRangeButton_cb (FL_OBJECT *,long)
{
  DPSample *sample = fl_get_sample (mainForm->sample);
  sample->zoomRange ();
  updateDisplayDetails ();
  fl_redraw_object (mainForm->sample);
  fl_redraw_object (mainForm->scrollBarSlider);
  fl_redraw_object (mainForm->zoomBarSlider);
}

/*---------------------------------------------------------------------------
| CALLBACK zoomOneToOneButton_cb
---------------------------------------------------------------------------*/

void zoomOneToOneButton_cb (FL_OBJECT *,long)
{
  DPSample *sample = fl_get_sample (mainForm->sample);
  sample->zoomWidth ((mainForm->sample->w) - (2 * BORDERX));
  updateDisplayDetails ();
  fl_redraw_object (mainForm->sample);
  fl_redraw_object (mainForm->scrollBarSlider);
  fl_redraw_object (mainForm->zoomBarSlider);
}

/*---------------------------------------------------------------------------
| CALLBACK displayStartLeft_cb
---------------------------------------------------------------------------*/

void displayStartLeft_cb (FL_OBJECT *,long data)
{
  DPSample *sample = fl_get_sample (mainForm->sample);
  int start    = sample->getDisplayStart ();
  int end      = sample->getDisplayEnd ();
  int duration = end - start;
  int frames   = sample->getFrames ();
  int lock     = fl_get_button (displayForm->lock);
  int newStart = 0;
  int newEnd   = 0;
  
  switch (data)
  {
    case 0 :
      newStart = sample->getL (start,duration / 200 + 1);
      break;
    case 1 :
      newStart = sample->getL (start,duration / 30 + 1);
      break;
    case 2 :
      newStart = sample->getLzero (start);
      break;
    case 3 :
      newStart = 0;
      break;
  }
  if (lock)
  {
    newEnd = newStart + duration;
    if (newEnd > frames) newStart -= newEnd - frames;
    sample->setDisplay (newStart,newEnd);
  }
  else
  {
    sample->setDisplayStart (newStart);
  }
  updateDisplayDetails ();
  fl_redraw_object (mainForm->sample);
  fl_redraw_object (mainForm->scrollBarSlider);
  fl_redraw_object (mainForm->zoomBarSlider);
}

/*---------------------------------------------------------------------------
| CALLBACK displayStartRight_cb
---------------------------------------------------------------------------*/

void displayStartRight_cb (FL_OBJECT *,long data)
{
  DPSample *sample = fl_get_sample (mainForm->sample);
  int start    = sample->getDisplayStart ();
  int end      = sample->getDisplayEnd ();
  int duration = end - start;
  int frames   = sample->getFrames ();
  int lock     = fl_get_button (displayForm->lock);
  int newStart = 0;
  int newEnd   = 0;
  
  switch (data)
  {
    case 0 :
      newStart = sample->getR (start,duration / 200 + 1);
      break;
    case 1 :
      newStart = sample->getR (start,duration / 30 + 1);
      break;
    case 2 :
      newStart = sample->getRzero (start);
      break;
    case 3 :
      newStart = frames;
      break;
  }
  if (lock)
  {
    newEnd = newStart + duration;
    if (newEnd > frames) newStart -= newEnd - frames;
    sample->setDisplay (newStart,newEnd);
  }
  else
  {
    sample->setDisplayStart (newStart);
  }
  updateDisplayDetails ();
  fl_redraw_object (mainForm->sample);
  fl_redraw_object (mainForm->scrollBarSlider);
  fl_redraw_object (mainForm->zoomBarSlider);
}

/*---------------------------------------------------------------------------
| CALLBACK displayStartText_cb
---------------------------------------------------------------------------*/

void displayStartText_cb (FL_OBJECT *ob,long data)
{
  DPSample *sample = fl_get_sample (mainForm->sample);
  double rate      = sample->getRate ();
  int frames       = sample->getFrames ();

  int newStart = 0;
  int newEnd   = 0;
  
  const char *input = fl_safe_get_input (ob);
  
  if (strlen(input) == 0)
  {
    return;
  }
  
  if (data)
  {
    double newStartTime;
    if (!sscanf (input,"%lf",&newStartTime)) return;
    newStart = (int) (newStartTime * rate);
  }
  else
  {
    if (!sscanf (input,"%d",&newStart)) return;
  }
  
  int start       = sample->getDisplayStart ();
  int end         = sample->getDisplayEnd ();
  int duration    = end - start;
  int lock        = fl_get_button (displayForm->lock);

  if (newStart < 0) newStart = 0;
  if (lock)
  {
    newEnd = newStart + duration;
    if (newEnd > frames) newStart -= newEnd - frames;
    sample->setDisplay (newStart,newEnd);
  }
  else
  {
    sample->setDisplayStart (newStart);
  }
  updateDisplayDetails ();
  fl_redraw_object (mainForm->sample);
  fl_redraw_object (mainForm->scrollBarSlider);
  fl_redraw_object (mainForm->zoomBarSlider);
}

/*---------------------------------------------------------------------------
| CALLBACK displayEndLeft_cb
---------------------------------------------------------------------------*/

void displayEndLeft_cb (FL_OBJECT *,long data)
{
  DPSample *sample = fl_get_sample (mainForm->sample);
  int start    = sample->getDisplayStart ();
  int end      = sample->getDisplayEnd ();
  int duration = end - start;
  int lock     = fl_get_button (displayForm->lock);
  int newStart = 0;
  int newEnd   = 0;
  
  switch (data)
  {
    case 0 :
      newEnd = sample->getL (end,duration / 200 + 1);
      break;
    case 1 :
      newEnd = sample->getL (end,duration / 30 + 1);
      break;
    case 2 :
      newEnd = sample->getLzero (end);
      break;
    case 3 :
      newEnd = 0;
      break;
  }
  if (lock)
  {
    newStart = newEnd - duration;
    if (newStart < 0) newEnd += -newStart;
    sample->setDisplay (newStart,newEnd);
  }
  else
  {
    sample->setDisplayEnd (newEnd);
  }
  updateDisplayDetails ();
  fl_redraw_object (mainForm->sample);
  fl_redraw_object (mainForm->scrollBarSlider);
  fl_redraw_object (mainForm->zoomBarSlider);
}

/*---------------------------------------------------------------------------
| CALLBACK displayEndRight_cb
---------------------------------------------------------------------------*/

void displayEndRight_cb (FL_OBJECT *,long data)
{
  DPSample *sample = fl_get_sample (mainForm->sample);
  int start    = sample->getDisplayStart ();
  int end      = sample->getDisplayEnd ();
  int duration = end - start;
  int frames   = sample->getFrames ();
  int lock     = fl_get_button (displayForm->lock);
  int newStart = 0;
  int newEnd   = 0;
  
  switch (data)
  {
    case 0 :
      newEnd = sample->getR (end,duration / 200 + 1);
      break;
    case 1 :
      newEnd = sample->getR (end,duration / 30 + 1);
      break;
    case 2 :
      newEnd = sample->getRzero (end);
      break;
    case 3 :
      newEnd = frames;
      break;
  }
  if (lock)
  {
    newStart = newEnd - duration;
    if (newStart < 0) newEnd += -newStart;
    sample->setDisplay (newStart,newEnd);
  }
  else
  {
    sample->setDisplayEnd (newEnd);
  }
  updateDisplayDetails ();
  fl_redraw_object (mainForm->sample);
  fl_redraw_object (mainForm->scrollBarSlider);
  fl_redraw_object (mainForm->zoomBarSlider);
}

/*---------------------------------------------------------------------------
| CALLBACK displayEndText_cb
---------------------------------------------------------------------------*/

void displayEndText_cb (FL_OBJECT *ob,long data)
{
  DPSample *sample = fl_get_sample (mainForm->sample);
  double rate      = sample->getRate ();

  int newStart = 0;
  int newEnd   = 0;
  
  const char *input = fl_safe_get_input (ob);
  
  if (strlen(input) == 0)
  {
    return;
  }
  
  if (data)
  {
    double newEndTime;
    if (!sscanf (input,"%lf",&newEndTime)) return;
    newEnd = (int) (newEndTime * rate);
  }
  else
  {
    if (!sscanf (input,"%d",&newEnd)) return;
  }
  
  int start       = sample->getDisplayStart ();
  int end         = sample->getDisplayEnd ();
  int duration    = end - start;
  int  lock        = fl_get_button (displayForm->lock);

  if (newEnd < 0) newEnd = 0;
  if (lock)
  {
    newStart = newEnd - duration;
    if (newStart < 0) newEnd += -newStart;
    sample->setDisplay (newStart,newEnd);
  }
  else
  {
    sample->setDisplayEnd (newEnd);
  }
  updateDisplayDetails ();
  fl_redraw_object (mainForm->sample);
  fl_redraw_object (mainForm->scrollBarSlider);
  fl_redraw_object (mainForm->zoomBarSlider);
}

/*---------------------------------------------------------------------------
| CALLBACK displayLock_cb
---------------------------------------------------------------------------*/

void displayLock_cb (FL_OBJECT *,long)
{
}

/*---------------------------------------------------------------------------
| CALLBACK rangeStartLeft_cb
---------------------------------------------------------------------------*/

void rangeStartLeft_cb (FL_OBJECT *,long data)
{
  DPSample *sample = fl_get_sample (mainForm->sample);
  if (!sample->getRangeValid ()) return;
  int start    = sample->getRangeStart ();
  int end      = sample->getRangeEnd ();
  int duration = end - start;
  int frames   = sample->getFrames ();
  int lock     = fl_get_button (rangeForm->lock);
  int displayStart    = sample->getDisplayStart ();
  int displayEnd      = sample->getDisplayEnd ();
  int displayDuration = displayEnd - displayStart;
  int newStart = 0;
  int newEnd   = 0;
  
  switch (data)
  {
    case 0 :
      newStart = sample->getL (start,displayDuration / 200 + 1);
      break;
    case 1 :
      newStart = sample->getL (start,displayDuration / 30 + 1);
      break;
    case 2 :
      newStart = sample->getLzero (start);
      break;
    case 3 :
      newStart = 0;
      break;
  }
  if (lock)
  {
    newEnd = newStart + duration;
    if (newEnd > frames) newStart -= newEnd - frames;
    sample->setRange (newStart,newEnd);
  }
  else
  {
    sample->setRangeStart (newStart);
  }
  updateRangeDetails ();
  fl_redraw_object (mainForm->sample);
}

/*---------------------------------------------------------------------------
| CALLBACK rangeStartRight_cb
---------------------------------------------------------------------------*/

void rangeStartRight_cb (FL_OBJECT *,long data)
{
  DPSample *sample = fl_get_sample (mainForm->sample);
  if (!sample->getRangeValid ()) return;
  int start    = sample->getRangeStart ();
  int end      = sample->getRangeEnd ();
  int duration = end - start;
  int frames   = sample->getFrames ();
  int lock     = fl_get_button (rangeForm->lock);
  int displayStart    = sample->getDisplayStart ();
  int displayEnd      = sample->getDisplayEnd ();
  int displayDuration = displayEnd - displayStart;
  int newStart = 0;
  int newEnd   = 0;
  
  switch (data)
  {
    case 0 :
      newStart = sample->getR (start,displayDuration / 200 + 1);
      break;
    case 1 :
      newStart = sample->getR (start,displayDuration / 30 + 1);
      break;
    case 2 :
      newStart = sample->getRzero (start);
      break;
    case 3 :
      newStart = frames;
      break;
  }
  if (lock)
  {
    newEnd = newStart + duration;
    if (newEnd > frames) newStart -= newEnd - frames;
    sample->setRange (newStart,newEnd);
  }
  else
  {
    if (fl_get_sample_rangecross (mainForm->sample))
    {
      if (newStart > end)
        sample->setRange (newStart,newStart);
      else
        sample->setRangeStart (newStart);
    }
    else
    {
      if (newStart > end) newStart = end;
      sample->setRangeStart (newStart);
    }
  }
  updateRangeDetails ();
  fl_redraw_object (mainForm->sample);
}

/*---------------------------------------------------------------------------
| CALLBACK rangeStartText_cb
---------------------------------------------------------------------------*/

void rangeStartText_cb (FL_OBJECT *ob,long data)
{
  DPSample *sample = fl_get_sample (mainForm->sample);
  double rate      = sample->getRate ();
  int frames      = sample->getFrames ();

  int newStart = 0;
  int newEnd   = 0;
  
  const char *input = fl_safe_get_input (ob);
  
  if (strlen(input) == 0)
  {
    return;
  }
  
  if (data)
  {
    double newStartTime;
    if (!sscanf (input,"%lf",&newStartTime)) return;
    newStart = (int) (newStartTime * rate);
  }
  else
  {
    if (!sscanf (input,"%d",&newStart)) return;
  }
  
  if (!sample->getRangeValid ())
  {
    sample->setRangeValid (1);
    sample->setRange (frames,frames);
  }
  
  int start    = sample->getRangeStart ();
  int end      = sample->getRangeEnd ();
  int duration = end - start;
  int  lock     = fl_get_button (rangeForm->lock);
  
  if (newStart < 0) newStart = 0;
  if (lock)
  {
    newEnd = newStart + duration;
    if (newEnd > frames) newStart -= newEnd - frames;
    sample->setRange (newStart,newEnd);
  }
  else
  {
    if (fl_get_sample_rangecross (mainForm->sample))
    {
      if (newStart > end)
        sample->setRange (newStart,newStart);
      else
        sample->setRangeStart (newStart);
    }
    else
    {
      if (newStart > end) newStart = end;
      sample->setRangeStart (newStart);
    }
  }
  updateRangeDetails ();
  fl_redraw_object (mainForm->sample);
}

/*---------------------------------------------------------------------------
| CALLBACK rangeEndLeft_cb
---------------------------------------------------------------------------*/

void rangeEndLeft_cb (FL_OBJECT *,long data)
{
  DPSample *sample = fl_get_sample (mainForm->sample);
  if (!sample->getRangeValid ()) return;
  int start    = sample->getRangeStart ();
  int end      = sample->getRangeEnd ();
  int duration = end - start;
  int lock     = fl_get_button (rangeForm->lock);
  int displayStart    = sample->getDisplayStart ();
  int displayEnd      = sample->getDisplayEnd ();
  int displayDuration = displayEnd - displayStart;
  int newStart = 0;
  int newEnd   = 0;
  
  switch (data)
  {
    case 0 :
      newEnd = sample->getL (end,displayDuration / 200 + 1);
      break;
    case 1 :
      newEnd = sample->getL (end,displayDuration / 30 + 1);
      break;
    case 2 :
      newEnd = sample->getLzero (end);
      break;
    case 3 :
      newEnd = 0;
      break;
  }
  if (lock)
  {
    newStart = newEnd - duration;
    if (newStart < 0) newEnd += -newStart;
    sample->setRange (newStart,newEnd);
  }
  else
  {
    if (fl_get_sample_rangecross (mainForm->sample))
    {
      if (newEnd < start)
        sample->setRange (newEnd,newEnd);
      else
        sample->setRangeEnd (newEnd);
    }
    else
    {
      if (newEnd < start) newEnd = start;
      sample->setRangeEnd (newEnd);
    }
  }
  updateRangeDetails ();
  fl_redraw_object (mainForm->sample);
}

/*---------------------------------------------------------------------------
| CALLBACK rangeEndRight_cb
---------------------------------------------------------------------------*/

void rangeEndRight_cb (FL_OBJECT *,long data)
{
  DPSample *sample = fl_get_sample (mainForm->sample);
  if (!sample->getRangeValid ()) return;
  int start    = sample->getRangeStart ();
  int end      = sample->getRangeEnd ();
  int duration = end - start;
  int frames   = sample->getFrames ();
  int lock     = fl_get_button (rangeForm->lock);
  int displayStart    = sample->getDisplayStart ();
  int displayEnd      = sample->getDisplayEnd ();
  int displayDuration = displayEnd - displayStart;
  int newStart = 0;
  int newEnd   = 0;
  
  switch (data)
  {
    case 0 :
      newEnd = sample->getR (end,displayDuration / 200 + 1);
      break;
    case 1 :
      newEnd = sample->getR (end,displayDuration / 30 + 1);
      break;
    case 2 :
      newEnd = sample->getRzero (end);
      break;
    case 3 :
      newEnd = frames;
      break;
  }
  if (lock)
  {
    newStart = newEnd - duration;
    if (newStart < 0) newEnd += -newStart;
    sample->setRange (newStart,newEnd);
  }
  else
  {
    sample->setRangeEnd (newEnd);
  }
  updateRangeDetails ();
  fl_redraw_object (mainForm->sample);
}

/*---------------------------------------------------------------------------
| CALLBACK rangeEndText_cb
---------------------------------------------------------------------------*/

void rangeEndText_cb (FL_OBJECT *ob,long data)
{
  DPSample *sample = fl_get_sample (mainForm->sample);
  double rate      = sample->getRate ();
  int newStart = 0;
  int newEnd   = 0;
  
  const char *input = fl_safe_get_input (ob);
  
  if (strlen(input) == 0)
  {
    return;
  }
  
  if (data)
  {
    double newEndTime;
    if (!sscanf (input,"%lf",&newEndTime)) return;
    newEnd = (int) (newEndTime * rate);
  }
  else
  {
    if (!sscanf (input,"%d",&newEnd)) return;
  }

  if (!sample->getRangeValid ())
  {
    sample->setRangeValid (1);
    sample->setRange (0,0);
  }

  int start    = sample->getRangeStart ();
  int end      = sample->getRangeEnd ();
  int duration = end - start;
  int  lock     = fl_get_button (rangeForm->lock);
  
  if (newEnd < 0) newEnd = 0;
  if (lock)
  {
    newStart = newEnd - duration;
    if (newStart < 0) newEnd += -newStart;
    sample->setRange (newStart,newEnd);
  }
  else
  {
    if (fl_get_sample_rangecross (mainForm->sample))
    {
      if (newEnd < start)
        sample->setRange (newEnd,newEnd);
      else
        sample->setRangeEnd (newEnd);
    }
    else
    {
      if (newEnd < start) newEnd = start;
      sample->setRangeEnd (newEnd);
    }
  }
  updateRangeDetails ();
  fl_redraw_object (mainForm->sample);
}

/*---------------------------------------------------------------------------
| CALLBACK rangeLock_cb
---------------------------------------------------------------------------*/

void rangeLock_cb (FL_OBJECT *,long)
{
}

/*---------------------------------------------------------------------------
| CALLBACK rangeAllButton_cb
---------------------------------------------------------------------------*/

void rangeAllButton_cb (FL_OBJECT *,long)
{
  DPSample *sample = fl_get_sample (mainForm->sample);
  sample->rangeAll ();
  updateRangeDetails ();
  fl_redraw_object (mainForm->sample);
}

/*---------------------------------------------------------------------------
| CALLBACK rangeDisplayButton_cb
---------------------------------------------------------------------------*/

void rangeDisplayButton_cb (FL_OBJECT *,long)
{
  DPSample *sample = fl_get_sample (mainForm->sample);
  sample->rangeDisplay ();
  updateRangeDetails ();
  fl_redraw_object (mainForm->sample);
}

/*---------------------------------------------------------------------------
| CALLBACK rangeSustainButton_cb
---------------------------------------------------------------------------*/

void rangeSustainButton_cb (FL_OBJECT *,long)
{
  DPSample *sample = fl_get_sample (mainForm->sample);
  sample->setRangeSusLoop ();
  updateRangeDetails ();
  fl_redraw_object (mainForm->sample);
}

/*---------------------------------------------------------------------------
| CALLBACK rangeReleaseButton_cb
---------------------------------------------------------------------------*/

void rangeReleaseButton_cb (FL_OBJECT *,long)
{
  DPSample *sample = fl_get_sample (mainForm->sample);
  sample->setRangeRelLoop ();
  updateRangeDetails ();
  fl_redraw_object (mainForm->sample);
}

/*---------------------------------------------------------------------------
| CALLBACK rangeClearButton_cb
---------------------------------------------------------------------------*/

void rangeClearButton_cb (FL_OBJECT *,long)
{
  DPSample *sample = fl_get_sample (mainForm->sample);
  sample->rangeClear ();
  updateRangeDetails ();
  fl_redraw_object (mainForm->sample);
}

/*---------------------------------------------------------------------------
| CALLBACK loopSusStartLeft_cb
---------------------------------------------------------------------------*/

void loopSusStartLeft_cb (FL_OBJECT *,long data)
{
  DPSample *sample = fl_get_sample (mainForm->sample);
  if (sample->getSusLoopMode () == AF_LOOP_MODE_NOLOOP) return;
  int start    = sample->getSusLoopStart ();
  int end      = sample->getSusLoopEnd ();
  int duration = end - start;
  int frames   = sample->getFrames ();
  int lock     = fl_get_button (loopForm->susLock);
  int displayStart    = sample->getDisplayStart ();
  int displayEnd      = sample->getDisplayEnd ();
  int displayDuration = displayEnd - displayStart;
  int newStart = 0;
  int newEnd   = 0;
  
  switch (data)
  {
    case 0 :
      newStart = sample->getL (start,displayDuration / 200 + 1);
      break;
    case 1 :
      newStart = sample->getL (start,displayDuration / 30 + 1);
      break;
    case 2 :
      newStart = sample->getLzero (start);
      break;
    case 3 :
      newStart = 0;
      break;
  }
  if (lock)
  {
    newEnd = newStart + duration;
    if (newEnd > frames) newStart -= newEnd - frames;
    sample->setSusLoop (newStart,newEnd);
  }
  else
  {
    sample->setSusLoopStart (newStart);
  }
  updateLoopDetails ();
  fl_redraw_object (mainForm->sample);
}

/*---------------------------------------------------------------------------
| CALLBACK loopSusStartRight_cb
---------------------------------------------------------------------------*/

void loopSusStartRight_cb (FL_OBJECT *,long data)
{
  DPSample *sample = fl_get_sample (mainForm->sample);
  if (sample->getSusLoopMode () == AF_LOOP_MODE_NOLOOP) return;
  int start    = sample->getSusLoopStart ();
  int end      = sample->getSusLoopEnd ();
  int duration = end - start;
  int frames   = sample->getFrames ();
  int lock     = fl_get_button (loopForm->susLock);
  int displayStart    = sample->getDisplayStart ();
  int displayEnd      = sample->getDisplayEnd ();
  int displayDuration = displayEnd - displayStart;
  int newStart = 0;
  int newEnd   = 0;
  
  switch (data)
  {
    case 0 :
      newStart = sample->getR (start,displayDuration / 200 + 1);
      break;
    case 1 :
      newStart = sample->getR (start,displayDuration / 30 + 1);
      break;
    case 2 :
      newStart = sample->getRzero (start);
      break;
    case 3 :
      newStart = frames;
      break;
  }
  if (lock)
  {
    newEnd = newStart + duration;
    if (newEnd > frames) newStart -= newEnd - frames;
    sample->setSusLoop (newStart,newEnd);
  }
  else
  {
    sample->setSusLoopStart (newStart);
  }
  updateLoopDetails ();
  fl_redraw_object (mainForm->sample);
}

/*---------------------------------------------------------------------------
| CALLBACK loopSusStartText_cb
---------------------------------------------------------------------------*/

void loopSusStartText_cb (FL_OBJECT *ob,long data)
{
  DPSample *sample = fl_get_sample (mainForm->sample);
  double rate      = sample->getRate ();
  int frames      = sample->getFrames ();
  
  int newStart = 0;
  int newEnd   = 0;
  
  const char *input = fl_safe_get_input (ob);
  
  if (strlen(input) == 0)
  {
    return;
  }
  
  if (data)
  {
    double newStartTime;
    if (!sscanf (input,"%lf",&newStartTime)) return;
    newStart = (int) (newStartTime * rate);
  }
  else
  {
    if (!sscanf (input,"%d",&newStart)) return;
  }

  if (sample->getSusLoopMode () == AF_LOOP_MODE_NOLOOP)
  {
    sample->setSusLoopMode (AF_LOOP_MODE_FORW);
    sample->setSusLoop (frames,frames);
  }
  
  int start    = sample->getSusLoopStart ();
  int end      = sample->getSusLoopEnd ();
  int duration = end - start;
  int  lock     = fl_get_button (loopForm->susLock);
  
  if (newStart < 0) newStart = 0;
  if (lock)
  {
    newEnd = newStart + duration;
    if (newEnd > frames) newStart -= newEnd - frames;
    sample->setSusLoop (newStart,newEnd);
  }
  else
  {
    sample->setSusLoopStart (newStart);
  }
  updateLoopDetails ();
  fl_redraw_object (mainForm->sample);
}

/*---------------------------------------------------------------------------
| CALLBACK loopSusEndLeft_cb
---------------------------------------------------------------------------*/

void loopSusEndLeft_cb (FL_OBJECT *,long data)
{
  DPSample *sample = fl_get_sample (mainForm->sample);
  if (sample->getSusLoopMode () == AF_LOOP_MODE_NOLOOP) return;
  int start    = sample->getSusLoopStart ();
  int end      = sample->getSusLoopEnd ();
  int duration = end - start;
  int lock     = fl_get_button (loopForm->susLock);
  int displayStart    = sample->getDisplayStart ();
  int displayEnd      = sample->getDisplayEnd ();
  int displayDuration = displayEnd - displayStart;
  int newStart = 0;
  int newEnd   = 0;
  
  switch (data)
  {
    case 0 :
      newEnd = sample->getL (end,displayDuration / 200 + 1);
      break;
    case 1 :
      newEnd = sample->getL (end,displayDuration / 30 + 1);
      break;
    case 2 :
      newEnd = sample->getLzero (end);
      break;
    case 3 :
      newEnd = 0;
      break;
  }
  if (lock)
  {
    newStart = newEnd - duration;
    if (newStart < 0) newEnd += -newStart;
    sample->setSusLoop (newStart,newEnd);
  }
  else
  {
    sample->setSusLoopEnd (newEnd);
  }
  updateLoopDetails ();
  fl_redraw_object (mainForm->sample);
}

/*---------------------------------------------------------------------------
| CALLBACK loopSusEndRight_cb
---------------------------------------------------------------------------*/

void loopSusEndRight_cb (FL_OBJECT *,long data)
{
  DPSample *sample = fl_get_sample (mainForm->sample);
  if (sample->getSusLoopMode () == AF_LOOP_MODE_NOLOOP) return;
  int start    = sample->getSusLoopStart ();
  int end      = sample->getSusLoopEnd ();
  int duration = end - start;
  int frames   = sample->getFrames ();
  int lock     = fl_get_button (loopForm->susLock);
  int displayStart    = sample->getDisplayStart ();
  int displayEnd      = sample->getDisplayEnd ();
  int displayDuration = displayEnd - displayStart;
  int newStart = 0;
  int newEnd   = 0;
  
  switch (data)
  {
    case 0 :
      newEnd = sample->getR (end,displayDuration / 200 + 1);
      break;
    case 1 :
      newEnd = sample->getR (end,displayDuration / 30 + 1);
      break;
    case 2 :
      newEnd = sample->getRzero (end);
      break;
    case 3 :
      newEnd = frames;
      break;
  }
  if (lock)
  {
    newStart = newEnd - duration;
    if (newStart < 0) newEnd += -newStart;
    sample->setSusLoop (newStart,newEnd);
  }
  else
  {
    sample->setSusLoopEnd (newEnd);
  }
  updateLoopDetails ();
  fl_redraw_object (mainForm->sample);
}

/*---------------------------------------------------------------------------
| CALLBACK loopSusEndText_cb
---------------------------------------------------------------------------*/

void loopSusEndText_cb (FL_OBJECT *ob,long data)
{
  DPSample *sample = fl_get_sample (mainForm->sample);
  double rate      = sample->getRate ();
  
  int newStart = 0;
  int newEnd   = 0;
  
  const char *input = fl_safe_get_input (ob);
  
  if (strlen(input) == 0)
  {
    return;
  }
  
  if (data)
  {
    double newEndTime;
    if (!sscanf (input,"%lf",&newEndTime)) return;
    newEnd = (int) (newEndTime * rate);
  }
  else
  {
    if (!sscanf (input,"%d",&newEnd)) return;
  }

  if (sample->getSusLoopMode () == AF_LOOP_MODE_NOLOOP)
  {
    sample->setSusLoopMode (AF_LOOP_MODE_FORW);
    sample->setSusLoop (0,0);
  }
  
  int start    = sample->getSusLoopStart ();
  int end      = sample->getSusLoopEnd ();
  int duration = end - start;
  int  lock     = fl_get_button (loopForm->susLock);
  
  if (newEnd < 0) newEnd = 0;
  if (lock)
  {
    newStart = newEnd - duration;
    if (newStart < 0) newEnd += -newStart;
    sample->setSusLoop (newStart,newEnd);
  }
  else
  {
    sample->setSusLoopEnd (newEnd);
  }
  updateLoopDetails ();
  fl_redraw_object (mainForm->sample);
}

/*---------------------------------------------------------------------------
| CALLBACK loopSusLock_cb
---------------------------------------------------------------------------*/

void loopSusLock_cb (FL_OBJECT *,long)
{
}

/*---------------------------------------------------------------------------
| CALLBACK loopSusRangeButton_cb
---------------------------------------------------------------------------*/

void loopSusRangeButton_cb (FL_OBJECT *,long)
{
  DPSample *sample = fl_get_sample (mainForm->sample);
  sample->setSusLoopRange ();
  updateLoopDetails ();
  fl_redraw_object (mainForm->sample);
}

/*---------------------------------------------------------------------------
| CALLBACK loopSusModeChoice_cb
---------------------------------------------------------------------------*/

void loopSusModeChoice_cb (FL_OBJECT *ob,long)
{
  DPSample *sample = fl_get_sample (mainForm->sample);
  int  choice      = fl_get_choice (ob);
  int loopStart;
  int loopEnd;
  switch (choice)
  {
    case 1 :
      sample->setSusLoopMode (AF_LOOP_MODE_NOLOOP);
      fl_deactivate_object (loopForm->susBeats);
      updateLoopDetails ();
      fl_redraw_object (mainForm->sample);
      break;
      
    case 2 :
      sample->setSusLoopMode (AF_LOOP_MODE_FORW);
      loopStart = sample->getSusLoopStart ();
      loopEnd   = sample->getSusLoopEnd ();
      sample->setSusLoop (loopStart,loopEnd);
      fl_activate_object (loopForm->susBeats);
      updateLoopDetails ();
      fl_redraw_object (mainForm->sample);
      break;

    case 3 :
      sample->setSusLoopMode (AF_LOOP_MODE_FORWBAKW);
      loopStart = sample->getSusLoopStart ();
      loopEnd   = sample->getSusLoopEnd ();
      sample->setSusLoop (loopStart,loopEnd);
      fl_activate_object (loopForm->susBeats);
      updateLoopDetails ();
      fl_redraw_object (mainForm->sample);
      break;
  }
}

/*---------------------------------------------------------------------------
| CALLBACK loopSusBeats_cb
---------------------------------------------------------------------------*/

void loopSusBeats_cb (FL_OBJECT *ob,long)
{
  int beats;
  if (!sscanf (fl_safe_get_input (ob),"%d",&beats)) return;
  if (beats < 1)
    fl_set_input (ob,"1");
  updateLoopDetails ();
}

/*---------------------------------------------------------------------------
| CALLBACK loopRelStartLeft_cb
---------------------------------------------------------------------------*/

void loopRelStartLeft_cb (FL_OBJECT *,long data)
{
  DPSample *sample = fl_get_sample (mainForm->sample);
  if (sample->getRelLoopMode () == AF_LOOP_MODE_NOLOOP) return;
  int start    = sample->getRelLoopStart ();
  int end      = sample->getRelLoopEnd ();
  int duration = end - start;
  int frames   = sample->getFrames ();
  int lock     = fl_get_button (loopForm->relLock);
  int displayStart    = sample->getDisplayStart ();
  int displayEnd      = sample->getDisplayEnd ();
  int displayDuration = displayEnd - displayStart;
  int newStart = 0;
  int newEnd   = 0;
  
  switch (data)
  {
    case 0 :
      newStart = sample->getL (start,displayDuration / 200 + 1);
      break;
    case 1 :
      newStart = sample->getL (start,displayDuration / 30 + 1);
      break;
    case 2 :
      newStart = sample->getLzero (start);
      break;
    case 3 :
      newStart = 0;
      break;
  }
  if (lock)
  {
    newEnd = newStart + duration;
    if (newEnd > frames) newStart -= newEnd - frames;
    sample->setRelLoop (newStart,newEnd);
  }
  else
  {
    sample->setRelLoopStart (newStart);
  }
  updateLoopDetails ();
  fl_redraw_object (mainForm->sample);
}

/*---------------------------------------------------------------------------
| CALLBACK loopRelStartRight_cb
---------------------------------------------------------------------------*/

void loopRelStartRight_cb (FL_OBJECT *,long data)
{
  DPSample *sample = fl_get_sample (mainForm->sample);
  if (sample->getRelLoopMode () == AF_LOOP_MODE_NOLOOP) return;
  int start    = sample->getRelLoopStart ();
  int end      = sample->getRelLoopEnd ();
  int duration = end - start;
  int frames   = sample->getFrames ();
  int lock     = fl_get_button (loopForm->relLock);
  int displayStart    = sample->getDisplayStart ();
  int displayEnd      = sample->getDisplayEnd ();
  int displayDuration = displayEnd - displayStart;
  int newStart = 0;
  int newEnd   = 0;
  
  switch (data)
  {
    case 0 :
      newStart = sample->getR (start,displayDuration / 200 + 1);
      break;
    case 1 :
      newStart = sample->getR (start,displayDuration / 30 + 1);
      break;
    case 2 :
      newStart = sample->getRzero (start);
      break;
    case 3 :
      newStart = frames;
      break;
  }
  if (lock)
  {
    newEnd = newStart + duration;
    if (newEnd > frames) newStart -= newEnd - frames;
    sample->setRelLoop (newStart,newEnd);
  }
  else
  {
    sample->setRelLoopStart (newStart);
  }
  updateLoopDetails ();
  fl_redraw_object (mainForm->sample);
}

/*---------------------------------------------------------------------------
| CALLBACK loopRelStartText_cb
---------------------------------------------------------------------------*/

void loopRelStartText_cb (FL_OBJECT *ob,long data)
{
  DPSample *sample = fl_get_sample (mainForm->sample);
  double rate      = sample->getRate ();
  int frames      = sample->getFrames ();
  
  int newStart = 0;
  int newEnd   = 0;
  
  const char *input = fl_safe_get_input (ob);
  
  if (strlen(input) == 0)
  {
    return;
  }
  
  if (data)
  {
    double newStartTime;
    if (!sscanf (input,"%lf",&newStartTime)) return;
    newStart = (int) (newStartTime * rate);
  }
  else
  {
    if (!sscanf (input,"%d",&newStart)) return;
  }
  
  if (sample->getRelLoopMode () == AF_LOOP_MODE_NOLOOP)
  {
    sample->setRelLoopMode (AF_LOOP_MODE_FORW);
    sample->setRelLoop (frames,frames);
  }

  int start    = sample->getRelLoopStart ();
  int end      = sample->getRelLoopEnd ();
  int duration = end - start;
  int  lock     = fl_get_button (loopForm->relLock);

  if (newStart < 0) newStart = 0;
  if (lock)
  {
    newEnd = newStart + duration;
    if (newEnd > frames) newStart -= newEnd - frames;
    sample->setRelLoop (newStart,newEnd);
  }
  else
  {
    sample->setRelLoopStart (newStart);
  }
  updateLoopDetails ();
  fl_redraw_object (mainForm->sample);
}

/*---------------------------------------------------------------------------
| CALLBACK loopRelEndLeft_cb
---------------------------------------------------------------------------*/

void loopRelEndLeft_cb (FL_OBJECT *,long data)
{
  DPSample *sample = fl_get_sample (mainForm->sample);
  if (sample->getRelLoopMode () == AF_LOOP_MODE_NOLOOP) return;
  int start    = sample->getRelLoopStart ();
  int end      = sample->getRelLoopEnd ();
  int duration = end - start;
  int lock     = fl_get_button (loopForm->relLock);
  int displayStart    = sample->getDisplayStart ();
  int displayEnd      = sample->getDisplayEnd ();
  int displayDuration = displayEnd - displayStart;
  int newStart = 0;
  int newEnd   = 0;
  
  switch (data)
  {
    case 0 :
      newEnd = sample->getL (end,displayDuration / 200 + 1);
      break;
    case 1 :
      newEnd = sample->getL (end,displayDuration / 30 + 1);
      break;
    case 2 :
      newEnd = sample->getLzero (end);
      break;
    case 3 :
      newEnd = 0;
      break;
  }
  if (lock)
  {
    newStart = newEnd - duration;
    if (newStart < 0) newEnd += -newStart;
    sample->setRelLoop (newStart,newEnd);
  }
  else
  {
    sample->setRelLoopEnd (newEnd);
  }
  updateLoopDetails ();
  fl_redraw_object (mainForm->sample);
}

/*---------------------------------------------------------------------------
| CALLBACK loopRelEndRight_cb
---------------------------------------------------------------------------*/

void loopRelEndRight_cb (FL_OBJECT *,long data)
{
  DPSample *sample = fl_get_sample (mainForm->sample);
  if (sample->getRelLoopMode () == AF_LOOP_MODE_NOLOOP) return;
  int start    = sample->getRelLoopStart ();
  int end      = sample->getRelLoopEnd ();
  int duration = end - start;
  int frames   = sample->getFrames ();
  int lock     = fl_get_button (loopForm->relLock);
  int displayStart    = sample->getDisplayStart ();
  int displayEnd      = sample->getDisplayEnd ();
  int displayDuration = displayEnd - displayStart;
  int newStart = 0;
  int newEnd   = 0;
  
  switch (data)
  {
    case 0 :
      newEnd = sample->getR (end,displayDuration / 200 + 1);
      break;
    case 1 :
      newEnd = sample->getR (end,displayDuration / 30 + 1);
      break;
    case 2 :
      newEnd = sample->getRzero (end);
      break;
    case 3 :
      newEnd = frames;
      break;
  }
  if (lock)
  {
    newStart = newEnd - duration;
    if (newStart < 0) newEnd += -newStart;
    sample->setRelLoop (newStart,newEnd);
  }
  else
  {
    sample->setRelLoopEnd (newEnd);
  }
  updateLoopDetails ();
  fl_redraw_object (mainForm->sample);
}

/*---------------------------------------------------------------------------
| CALLBACK loopRelEndText_cb
---------------------------------------------------------------------------*/

void loopRelEndText_cb (FL_OBJECT *ob,long data)
{
  DPSample *sample = fl_get_sample (mainForm->sample);
  double rate      = sample->getRate ();
  
  int newStart = 0;
  int newEnd   = 0;
  
  const char *input = fl_safe_get_input (ob);
  
  if (strlen(input) == 0)
  {
    return;
  }
  
  if (data)
  {
    double newEndTime;
    if (!sscanf (input,"%lf",&newEndTime)) return;
    newEnd = (int) (newEndTime * rate);
  }
  else
  {
    if (!sscanf (input,"%d",&newEnd)) return;
  }

  if (sample->getRelLoopMode () == AF_LOOP_MODE_NOLOOP)
  {
    sample->setRelLoopMode (AF_LOOP_MODE_FORW);
    sample->setRelLoop (0,0);
  }
  
  int start    = sample->getRelLoopStart ();
  int end      = sample->getRelLoopEnd ();
  int duration = end - start;
  int  lock     = fl_get_button (loopForm->relLock);
  
  if (newEnd < 0) newEnd = 0;
  if (lock)
  {
    newStart = newEnd - duration;
    if (newStart < 0) newEnd += -newStart;
    sample->setRelLoop (newStart,newEnd);
  }
  else
  {
    sample->setRelLoopEnd (newEnd);
  }
  updateLoopDetails ();
  fl_redraw_object (mainForm->sample);
}

/*---------------------------------------------------------------------------
| CALLBACK loopRelLock_cb
---------------------------------------------------------------------------*/

void loopRelLock_cb (FL_OBJECT *,long)
{
}

/*---------------------------------------------------------------------------
| CALLBACK loopRelRangeButton_cb
---------------------------------------------------------------------------*/

void loopRelRangeButton_cb (FL_OBJECT *,long)
{
  DPSample *sample = fl_get_sample (mainForm->sample);
  sample->setRelLoopRange ();
  updateLoopDetails ();
  fl_redraw_object (mainForm->sample);
}

/*---------------------------------------------------------------------------
| CALLBACK loopRelModeChoice_cb
---------------------------------------------------------------------------*/

void loopRelModeChoice_cb (FL_OBJECT *ob,long)
{
  DPSample *sample = fl_get_sample (mainForm->sample);
  int  choice      = fl_get_choice (ob);
  int loopStart;
  int loopEnd;
  
  switch (choice)
  {
    case 1 :
      sample->setRelLoopMode (AF_LOOP_MODE_NOLOOP);
      fl_deactivate_object (loopForm->relBeats);
      updateLoopDetails ();
      fl_redraw_object (mainForm->sample);
      break;
      
    case 2 :
      sample->setRelLoopMode (AF_LOOP_MODE_FORW);
      loopStart = sample->getRelLoopStart ();
      loopEnd   = sample->getRelLoopEnd ();
      sample->setRelLoop (loopStart,loopEnd);
      fl_activate_object (loopForm->relBeats);
      updateLoopDetails ();
      fl_redraw_object (mainForm->sample);
      break;

    case 3 :
      sample->setRelLoopMode (AF_LOOP_MODE_FORWBAKW);
      loopStart = sample->getRelLoopStart ();
      loopEnd   = sample->getRelLoopEnd ();
      sample->setRelLoop (loopStart,loopEnd);
      fl_activate_object (loopForm->relBeats);
      updateLoopDetails ();
      fl_redraw_object (mainForm->sample);
      break;
  }
  updateLoopDetails ();
  fl_redraw_object (mainForm->sample);
}

/*---------------------------------------------------------------------------
| CALLBACK loopRelBeats_cb
---------------------------------------------------------------------------*/

void loopRelBeats_cb (FL_OBJECT *ob,long)
{
  int beats;
  if (!sscanf (fl_safe_get_input (ob),"%d",&beats)) return;
  if (beats < 1)
    fl_set_input (ob,"1");
  updateLoopDetails ();
}

/*---------------------------------------------------------------------------
| CALLBACK newRateMenu_cb
---------------------------------------------------------------------------*/

void newRateMenu_cb (FL_OBJECT *ob,long)
{
  int item;
  char tempString [50];
  
  item = fl_get_menu (ob);
  switch (item)
  {
    case 1 :
      sprintf (tempString,"%d",8000);
      fl_set_input (newForm->rateInput,tempString);
      break;
    case 2 :
      sprintf (tempString,"%d",11025);
      fl_set_input (newForm->rateInput,tempString);
      break;
    case 3 :
      sprintf (tempString,"%d",16000);
      fl_set_input (newForm->rateInput,tempString);
      break;
    case 4 :
      sprintf (tempString,"%d",22050);
      fl_set_input (newForm->rateInput,tempString);
      break;
    case 5 :
      sprintf (tempString,"%d",32000);
      fl_set_input (newForm->rateInput,tempString);
      break;
    case 6 :
      sprintf (tempString,"%d",44100);
      fl_set_input (newForm->rateInput,tempString);
      break;
    case 7 :
      sprintf (tempString,"%d",48000);
      fl_set_input (newForm->rateInput,tempString);
      break;
    default:
      break;
  }
  fl_call_object_callback (newForm->rateInput);
}

/*---------------------------------------------------------------------------
| CALLBACK newRateInput_cb
---------------------------------------------------------------------------*/

void newRateInput_cb (FL_OBJECT *,long)
{
  int rate;
  int frames;
  char tempString [50];
  if (!sscanf (fl_safe_get_input (newForm->rateInput),"%d",&rate)) return;
  if (!sscanf (fl_safe_get_input (newForm->frames),"%d",&frames)) return;
  if (rate < 1)
  {
    rate = 1;
    fl_set_input (newForm->rateInput,"1");
  }
  sprintf (tempString,"%.3f",frames / (double) rate);
  fl_set_input (newForm->time,tempString);
}

/*---------------------------------------------------------------------------
| CALLBACK newChannels_cb
---------------------------------------------------------------------------*/

void newChannels_cb (FL_OBJECT *,long)
{
}

/*---------------------------------------------------------------------------
| CALLBACK newFrames_cb
---------------------------------------------------------------------------*/

void newFrames_cb (FL_OBJECT *,long)
{
  int rate;
  int frames;
  char tempString [50];
  if (!sscanf (fl_safe_get_input (newForm->rateInput),"%d",&rate)) return;
  if (!sscanf (fl_safe_get_input (newForm->frames),"%d",&frames)) return;
  if (rate < 1)
  {
    rate = 1;
    fl_set_input (newForm->rateInput,"1");
  }
  sprintf (tempString,"%.3f",frames / (double) rate);
  fl_set_input (newForm->time,tempString);
}

/*---------------------------------------------------------------------------
| CALLBACK newTime_cb
---------------------------------------------------------------------------*/

void newTime_cb (FL_OBJECT *,long)
{
  int rate;
  double time;
  char tempString [50];
  if (!sscanf (fl_safe_get_input (newForm->rateInput),"%d",&rate)) return;
  if (!sscanf (fl_safe_get_input (newForm->time),"%lf",&time)) return;
  if (rate < 1)
  {
    rate = 1;
    fl_set_input (newForm->rateInput,"1");
  }
  sprintf (tempString,"%d",(int) (time * rate));
  fl_set_input (newForm->frames,tempString);
}

/*---------------------------------------------------------------------------
| CALLBACK newResolution_cb
---------------------------------------------------------------------------*/

void newResolution_cb (FL_OBJECT *,long)
{
}

/*---------------------------------------------------------------------------
| CALLBACK newOK_cb
---------------------------------------------------------------------------*/

void newOK_cb (FL_OBJECT *,long)
{
  fl_hide_form (newForm->newForm);
  
  if (buffer [current]->getChanged ())
    if (!fl_show_question_old
      ("Warning","This buffer contains unsaved data","Really new ?"))
      return;

  DPSample *sample = new DPSample;
  int width = fl_get_choice (newForm->resolution);
  int channels;
  int rate;
  int frames;
  double time;
  channels = fl_get_choice (newForm->channels);
  if (channels == 3) channels = 4;
  if (!sscanf (fl_safe_get_input (newForm->rateInput),"%d",&rate)) return;
  if (rate < 1) rate = 1;
  if (!sscanf (fl_safe_get_input (newForm->frames),"%d",&frames)) return;
  
  // For common use often enter time without clicking OK so if
  // zero frames grab the time
  if (frames <= 0)
  {
    if (!sscanf (fl_safe_get_input (newForm->time),"%lf",&time)) return;
    frames = (int) (rate * time);
    
    // If still no frames default to one second
    if (frames <= 0) frames = (int) (rate * 1.0);
  }
  
  waitCursorOn ();
  if (!(sample->fresh ((double) rate,width,channels,frames)))
  {
    waitCursorOff ();
    delete sample;
    fl_show_alert ("Error","Out of memory while",
    "creating new sample",TRUE);
    return;
  }
  waitCursorOff ();
  clearBuffers ();
  fl_set_sample (mainForm->sample,sample);
  delete buffer [current];
  buffer [current] = sample;
  updateSample (sample);
}

/*---------------------------------------------------------------------------
| CALLBACK newCancel_cb
---------------------------------------------------------------------------*/

void newCancel_cb (FL_OBJECT *,long)
{
  fl_hide_form (newForm->newForm);
}

/*---------------------------------------------------------------------------
| CALLBACK convertButton_cb
---------------------------------------------------------------------------*/
void convertButton_cb (FL_OBJECT *,long)
{
}

/*---------------------------------------------------------------------------
| CALLBACK convertOK_cb
---------------------------------------------------------------------------*/
void convertOK_cb (FL_OBJECT *,long)
{
  DPSample *sample = fl_get_sample (mainForm->sample);
  int mode;
  noSampleWarning
  if (fl_get_button (convertForm->leftButton) &&
  fl_get_button (convertForm->rightButton))
    mode = 1;
  else if (fl_get_button (convertForm->leftButton))
    mode = 0;
  else if (fl_get_button (convertForm->rightButton))
    mode = 2;
  else
  {
    fl_show_alert ("Warning","You must select at least one channel",
    "to use for each resultant channel",TRUE);
    return;
  }
  
  fl_hide_form (convertForm->convertForm);
  updateBuffers ("Undo Conversion (to mono)")
  
  waitCursorOn ();
  sample->toMono (mode);
  waitCursorOff ();
  
  updateConvertMenu ();
  updateEditModeChoice (1);
  updateNameBox ();
  fl_redraw_object (mainForm->sample);
}

/*---------------------------------------------------------------------------
| CALLBACK convertCancel_cb
---------------------------------------------------------------------------*/
void convertCancel_cb (FL_OBJECT *,long)
{
  fl_hide_form (convertForm->convertForm);
}

/*---------------------------------------------------------------------------
| CALLBACK convert4to1Button_cb
---------------------------------------------------------------------------*/
void convert4to1Button_cb (FL_OBJECT *,long)
{
}

/*---------------------------------------------------------------------------
| CALLBACK convert4to1OK_cb
---------------------------------------------------------------------------*/
void convert4to1OK_cb (FL_OBJECT *,long)
{
  DPSample *sample = fl_get_sample (mainForm->sample);
  int mode = 0;
  noSampleWarning
  if (fl_get_button (convert4to1Form->oneButton))
    mode += 1;
  if (fl_get_button (convert4to1Form->twoButton))
    mode += 2;
  if (fl_get_button (convert4to1Form->threeButton))
    mode += 4;
  if (fl_get_button (convert4to1Form->fourButton))
    mode += 8;
  if (mode == 0)
  {
    fl_show_alert ("Warning","You must select at least one channel",
    "to use for each resultant channel",TRUE);
    return;
  }
  
  fl_hide_form (convert4to1Form->convert4to1Form);
  updateBuffers ("Undo Conversion (to mono)")
  
  waitCursorOn ();
  sample->toMono (mode);
  waitCursorOff ();
  
  updateConvertMenu ();
  updateEditModeChoice (1);
  updateNameBox ();
  fl_redraw_object (mainForm->sample);
}

/*---------------------------------------------------------------------------
| CALLBACK convert4to1Cancel_cb
---------------------------------------------------------------------------*/
void convert4to1Cancel_cb (FL_OBJECT *,long)
{
  fl_hide_form (convert4to1Form->convert4to1Form);
}

/*---------------------------------------------------------------------------
| CALLBACK convert4to2Button_cb
---------------------------------------------------------------------------*/
void convert4to2Button_cb (FL_OBJECT *,long)
{
}

/*---------------------------------------------------------------------------
| CALLBACK convert4to2OK_cb
---------------------------------------------------------------------------*/
void convert4to2OK_cb (FL_OBJECT *,long)
{
  DPSample *sample = fl_get_sample (mainForm->sample);
  int modeL = 0;
  int modeR = 0;
  noSampleWarning
  if (fl_get_button (convert4to2Form->oneLButton))
    modeL += 1;
  if (fl_get_button (convert4to2Form->twoLButton))
    modeL += 2;
  if (fl_get_button (convert4to2Form->threeLButton))
    modeL += 4;
  if (fl_get_button (convert4to2Form->fourLButton))
    modeL += 8;

  if (fl_get_button (convert4to2Form->oneRButton))
    modeR += 16;
  if (fl_get_button (convert4to2Form->twoRButton))
    modeR += 32;
  if (fl_get_button (convert4to2Form->threeRButton))
    modeR += 64;
  if (fl_get_button (convert4to2Form->fourRButton))
    modeR += 128;
    
  if (modeL == 0 || modeR == 0)
  {
    fl_show_alert ("Warning","You must select at least one channel",
    "to use for each resultant channel",TRUE);
    return;
  }
  
  fl_hide_form (convert4to2Form->convert4to2Form);
  updateBuffers ("Undo Conversion (to stereo)")
  
  waitCursorOn ();
  sample->toStereo (modeL + modeR);
  waitCursorOff ();
  
  updateConvertMenu ();
  updateEditModeChoice (2);
  updateNameBox ();
  fl_redraw_object (mainForm->sample);
}

/*---------------------------------------------------------------------------
| CALLBACK convert4to2Cancel_cb
---------------------------------------------------------------------------*/
void convert4to2Cancel_cb (FL_OBJECT *,long)
{
  fl_hide_form (convert4to2Form->convert4to2Form);
}

/*---------------------------------------------------------------------------
| CALLBACK convert2to4Button_cb
---------------------------------------------------------------------------*/
void convert2to4Button_cb (FL_OBJECT *,long)
{
}

/*---------------------------------------------------------------------------
| CALLBACK convert2to4OK_cb
---------------------------------------------------------------------------*/
void convert2to4OK_cb (FL_OBJECT *,long)
{
  DPSample *sample = fl_get_sample (mainForm->sample);
  int mode1 = 0;
  int mode2 = 0;
  int mode3 = 0;
  int mode4 = 0;
  noSampleWarning
  if (fl_get_button (convert2to4Form->one1Button))
    mode1 += 1;
  if (fl_get_button (convert2to4Form->two1Button))
    mode1 += 2;

  if (fl_get_button (convert2to4Form->one2Button))
    mode2 += 4;
  if (fl_get_button (convert2to4Form->two2Button))
    mode2 += 8;

  if (fl_get_button (convert2to4Form->one3Button))
    mode3 += 16;
  if (fl_get_button (convert2to4Form->two3Button))
    mode3 += 32;

  if (fl_get_button (convert2to4Form->one4Button))
    mode4 += 64;
  if (fl_get_button (convert2to4Form->two4Button))
    mode4 += 128;

  if (mode1 == 0 || mode2 == 0 || mode3 == 0 || mode4 == 0)
  {
    fl_show_alert ("Warning","You must select at least one channel",
    "to use for each resultant channel",TRUE);
    return;
  }
  
  fl_hide_form (convert2to4Form->convert2to4Form);
  updateBuffers ("Undo Conversion (to quadro)")
  
  waitCursorOn ();
  sample->toQuadro (mode1 + mode2 + mode3 + mode4);
  waitCursorOff ();
  
  updateConvertMenu ();
  updateEditModeChoice (4);
  updateNameBox ();
  fl_redraw_object (mainForm->sample);
}

/*---------------------------------------------------------------------------
| CALLBACK convert2to4Cancel_cb
---------------------------------------------------------------------------*/
void convert2to4Cancel_cb (FL_OBJECT *,long)
{
  fl_hide_form (convert2to4Form->convert2to4Form);
}

/*---------------------------------------------------------------------------
| FUNCTION updateUndo
---------------------------------------------------------------------------*/
int updateUndo (char *name)
{
  DPSample *sample = fl_get_sample (mainForm->sample);
  
  delete redo [0];
  delete [] redoStr [0];
  delete redo [1];
  delete [] redoStr [1];
  redo [0]    = 0;
  redoStr [0] = 0;
  redo [1]    = 0;
  redoStr [1] = 0;
  
  int success = 1;
  
  delete undo [1];
  delete [] undoStr [1];
  undo [1] = undo [0];
  undoStr [1] = undoStr [0];
  
  undo [0] = new DPSample;
  undoStr [0] = new char [strlen (name) + 3];
  strcpy (undoStr [0],name);
  if (!(undo [0]->clone (*sample)))
  {
    delete undo [1];
    delete [] undoStr [1];
    undo [1] = 0;
    undoStr [1] = 0;
    if (!(undo [0]->clone (*sample)))
    {
      delete undo [0];
      delete undoStr [0];
      undo [0] = 0;
      undoStr [0] = 0;
      if (!fl_show_question_old (
        "Not enough memory for undo buffers",
        "Operation will not be",
        "Do you want to continue ?"))
      {
        success = 0;
      }
    }
  }
  
  if (undoStr [0])
  {
    fl_replace_menu_item (mainForm->editMenu,1,name);
    fl_set_menu_item_mode (mainForm->editMenu,1,FL_PUP_NONE);
  }
  else
  {
    fl_replace_menu_item (mainForm->editMenu,1,"Undo");
    fl_set_menu_item_mode (mainForm->editMenu,1,FL_PUP_GREY);
  }
  fl_replace_menu_item (mainForm->editMenu,2,"Redo%l");
  fl_set_menu_item_mode (mainForm->editMenu,2,FL_PUP_GREY);
  
  return success;
}


/*---------------------------------------------------------------------------
| FUNCTION performUndo
---------------------------------------------------------------------------*/
void performUndo ()
{
  DPSample *sample = fl_get_sample (mainForm->sample);
  int tempEditMode = fl_get_sample_edit (mainForm->sample);

  if (undo [0])
  {
    delete redo [1];
    delete [] redoStr [1];

    redo [1] = redo [0];
    redoStr [1] = redoStr [0];

    redo [0] = sample;
    redoStr [0] = undoStr [0];
    if (redoStr [0])
    {
      int len = strlen (redoStr [0]);
      (redoStr [0])[0]     = 'R';
      (redoStr [0])[1]     = 'e';
      (redoStr [0])[len]   = '%';
      (redoStr [0])[len+1] = 'l';
      (redoStr [0])[len+2] = 0;
    }
    
    sample = undo [0];
    buffer [current] = sample;
    fl_set_sample (mainForm->sample,sample);

    undo [0] = undo [1];
    undoStr [0] = undoStr [1];
    
    undo [1] = 0;
    undoStr [1] = 0;
    
    if (undoStr [0])
    {
      fl_replace_menu_item (mainForm->editMenu,1,undoStr [0]);
      fl_set_menu_item_mode (mainForm->editMenu,1,FL_PUP_NONE);
    }
    else
    {
      fl_replace_menu_item (mainForm->editMenu,1,"Undo");
      fl_set_menu_item_mode (mainForm->editMenu,1,FL_PUP_GREY);
    }
    if (redoStr [0])
    {
      fl_replace_menu_item (mainForm->editMenu,2,redoStr [0]);
      fl_set_menu_item_mode (mainForm->editMenu,2,FL_PUP_NONE);
    }
    else
    {
      fl_replace_menu_item (mainForm->editMenu,2,"Redo%l");
      fl_set_menu_item_mode (mainForm->editMenu,2,FL_PUP_GREY);
    }
    updateSample (sample);
    fl_set_sample_edit (mainForm->sample,tempEditMode);
    fl_redraw_object (mainForm->sample);
  }
}

/*---------------------------------------------------------------------------
| FUNCTION performRedo
---------------------------------------------------------------------------*/
void performRedo ()
{
  DPSample *sample = fl_get_sample (mainForm->sample);
  int tempEditMode = fl_get_sample_edit (mainForm->sample);

  if (redo [0])
  {
    delete undo [1];
    delete [] undoStr [1];

    undo [1] = undo [0];
    undoStr [1] = undoStr [0];

    undo [0] = sample;
    undoStr [0] = redoStr [0];
    if (undoStr [0])
    {
      int len = strlen (redoStr [0]);
      (undoStr [0])[0]     = 'U';
      (undoStr [0])[1]     = 'n';
      (undoStr [0])[len-2] = 0;
    }
    
    sample = redo [0];
    buffer [current] = sample;
    fl_set_sample (mainForm->sample,sample);

    redo [0] = redo [1];
    redoStr [0] = redoStr [1];
    
    redo [1] = 0;
    redoStr [1] = 0;
    
    if (undoStr [0])
    {
      fl_replace_menu_item (mainForm->editMenu,1,undoStr [0]);
      fl_set_menu_item_mode (mainForm->editMenu,1,FL_PUP_NONE);
    }
    else
    {
      fl_replace_menu_item (mainForm->editMenu,1,"Undo");
      fl_set_menu_item_mode (mainForm->editMenu,1,FL_PUP_GREY);
    }
    if (redoStr [0])
    {
      fl_replace_menu_item (mainForm->editMenu,2,redoStr [0]);
      fl_set_menu_item_mode (mainForm->editMenu,2,FL_PUP_NONE);
    }
    else
    {
      fl_replace_menu_item (mainForm->editMenu,2,"Redo%l");
      fl_set_menu_item_mode (mainForm->editMenu,2,FL_PUP_GREY);
    }
    updateSample (sample);
    fl_set_sample_edit (mainForm->sample,tempEditMode);
    fl_redraw_object (mainForm->sample);
  }
}

/*---------------------------------------------------------------------------
| FUNCTION rememberForms
---------------------------------------------------------------------------*/
void rememberForms (int mode)
{
  static int displayShown;
  static int rangeShown;
  static int loopShown;
  static int zoomShown;
  static int playShown;
  static int recordShown;
  static int bufferShown;
  static int mixerShown;
  
  if (mode == 0)
  {
    // Remember state of main form pages

    if ((displayShown = fl_get_button (mainForm->displayButton)))
    {
      fl_set_button (mainForm->displayButton,0);
      fl_call_object_callback (mainForm->displayButton);
    }
    if ((rangeShown = fl_get_button (mainForm->rangeButton)))
    {
      fl_set_button (mainForm->rangeButton,0);
      fl_call_object_callback (mainForm->rangeButton);
    }
    if ((loopShown = fl_get_button (mainForm->loopButton)))
    {
      fl_set_button (mainForm->loopButton,0);
      fl_call_object_callback (mainForm->loopButton);
    }
    if ((zoomShown = fl_get_button (mainForm->zoomButton)))
    {
      fl_set_button (mainForm->zoomButton,0);
      fl_call_object_callback (mainForm->zoomButton);
    }
    if ((playShown = fl_get_button (mainForm->playButton)))
    {
      fl_set_button (mainForm->playButton,0);
      fl_call_object_callback (mainForm->playButton);
    }
    if ((recordShown = fl_get_button (mainForm->recordButton)))
    {
      fl_set_button (mainForm->recordButton,0);
      fl_call_object_callback (mainForm->recordButton);
    }
    if ((bufferShown = fl_get_button (mainForm->bufferButton)))
    {
      fl_set_button (mainForm->bufferButton,0);
      fl_call_object_callback (mainForm->bufferButton);
    }
    if ((mixerShown = fl_get_button (mainForm->mixerButton)))
    {
      fl_set_button (mainForm->mixerButton,0);
      fl_call_object_callback (mainForm->mixerButton);
    }
  }
  else
  {
    // Recall stste of main form pages

    if (displayShown)
    {
      fl_set_button (mainForm->displayButton,1);
      fl_call_object_callback (mainForm->displayButton);
    }
    if (rangeShown)
    {
      fl_set_button (mainForm->rangeButton,1);
      fl_call_object_callback (mainForm->rangeButton);
    }
    if (loopShown)
    {
      fl_set_button (mainForm->loopButton,1);
      fl_call_object_callback (mainForm->loopButton);
    }
    if (zoomShown)
    {
      fl_set_button (mainForm->zoomButton,1);
      fl_call_object_callback (mainForm->zoomButton);
    }
    if (playShown)
    {
      fl_set_button (mainForm->playButton,1);
      fl_call_object_callback (mainForm->playButton);
    }
    if (recordShown)
    {
      fl_set_button (mainForm->recordButton,1);
      fl_call_object_callback (mainForm->recordButton);
    }
    if (bufferShown)
    {
      fl_set_button (mainForm->bufferButton,1);
      fl_call_object_callback (mainForm->bufferButton);
    }
    if (mixerShown)
    {
      fl_set_button (mainForm->mixerButton,1);
      fl_call_object_callback (mainForm->mixerButton);
    }
  }
}

/*---------------------------------------------------------------------------
| FUNCTION clearBuffers
---------------------------------------------------------------------------*/
void clearBuffers ()
{
  delete undo [0];
  delete [] undoStr [0];
  delete undo [1];
  delete [] undoStr [1];
  delete redo [0];
  delete [] redoStr [0];
  delete redo [1];
  delete [] redoStr [1];
  undo [0]    = 0;
  undoStr [0] = 0;
  undo [1]    = 0;
  undoStr [1] = 0;
  redo [0]    = 0;
  redoStr [0] = 0;
  redo [1]    = 0;
  redoStr [1] = 0;
  fl_replace_menu_item (mainForm->editMenu,1,"Undo");
  fl_replace_menu_item (mainForm->editMenu,2,"Redo%l");
  fl_set_menu_item_mode (mainForm->editMenu,1,FL_PUP_GREY);
  fl_set_menu_item_mode (mainForm->editMenu,2,FL_PUP_GREY);
}

/*---------------------------------------------------------------------------
| FUNCTION updateSample
---------------------------------------------------------------------------*/
void updateSample (DPSample *sample)
{
  long pvBuffer [4];
  pvBuffer [0] = AL_INPUT_RATE;
  pvBuffer [1] = (int) sample->getRate ();
  pvBuffer [2] = AL_OUTPUT_RATE;
  #ifndef LINUX
  pvBuffer [3] = AL_RATE_INPUTRATE;
  #else
  pvBuffer [3] = (int) sample->getRate ();
  #endif
  if (fl_get_sample_autoglobals (mainForm->sample))
  {
    ALsetparams (AL_DEFAULT_DEVICE,pvBuffer,4);
    #ifdef LINUX
    char rateString [50];
    sprintf (rateString,"%d",(int)pvBuffer[1]);
	fl_set_input (playForm->rateInput,rateString);
	fl_set_input (mixplayForm->rateInput,rateString);
	fl_set_input (postForm->rateInput,rateString);
	fl_set_input (recordForm->rateInput,rateString);
    #endif
  }
  updateAudioGlobals (0,0);
  updateSamplePrefs ();
  updateDisplayDetails ();
  updateRangeDetails ();
  updateLoopDetails ();
  int sampleFormat = sample->getFormat ();
  int sampleCompression = sample->getCompression ();
  updateSaveFormatCompression (sampleFormat,sampleCompression);
  updateConvertMenu ();
  updateNameBox ();
  
  /* Maintain edit mode if possible */
  if (sample->getChannels () == 1)
  {
    if (fl_get_sample_edit (mainForm->sample) != 2)
      fl_set_sample_edit (mainForm->sample,2);
  }
  else if (sample->getChannels () == 2)
  {
    if (fl_get_sample_edit (mainForm->sample) > 2)
      fl_set_sample_edit (mainForm->sample,2);
  }
  
  updateEditModeChoice (sample->getChannels ());
  updateBufferBrowser ();
  updateNameBox ();
  fl_redraw_object (mainForm->sample);
  fl_redraw_object (mainForm->scrollBarSlider);
  fl_redraw_object (mainForm->zoomBarSlider);
}

/*---------------------------------------------------------------------------
| FUNCTION updateRangeForms
---------------------------------------------------------------------------*/
void updateRangeForms ()
{
  if (fl_form_is_visible (mixForm->mixForm))
  {
    if (fl_get_choice (mixForm->mode) == 2)
      updateMixPlot ();
  }
  if (fl_form_is_visible (rampForm->rampForm))
  {
    // NB Plot then form as plot may change point values
    updateRampPlot ();
    updateRampForm ();
  }
  if (fl_form_is_visible (resampleForm->resampleForm))
  {
    if (fl_get_choice (resampleForm->mode) == 1)
      updateResampleForm (0);
    else
      updateResampleForm (1);
  }
}

/*---------------------------------------------------------------------------
| FUNCTION updateClipForms
---------------------------------------------------------------------------*/
void updateClipForms ()
{
  if (fl_form_is_visible (mixForm->mixForm))
  {
    if (fl_get_choice (mixForm->mode) == 1)
      updateMixPlot ();
  }
}

#ifdef LINUX
/*---------------------------------------------------------------------------
| FUNCTION closeGlobalPorts
---------------------------------------------------------------------------*/
void closeGlobalPorts ()
{
  if (globalInputPort)
  {
    fl_set_button (recordForm->levelsButton,0);
    fl_call_object_callback (recordForm->levelsButton);
  }
  if (globalOutputPort)
  {
    ALcloseport (globalOutputPort);
    globalOutputPort = 0;
  }
}

/*---------------------------------------------------------------------------
| CALLBACK mixerSlider_cb
---------------------------------------------------------------------------*/
void mixerSlider_cb (FL_OBJECT *ob,long data)
{
  double num;
  int vol;
  long pvBuffer [8];
  int stereo;
  int lock;
  int channel;
  int left;
  int right;
  
  channel = data / 2;
  left    = (!(data % 2));
  right   = (data % 2);
  
  pvBuffer [0] = AL_LINUX_CHANNEL_BASE + channel;
  pvBuffer [2] = AL_LINUX_MIXER_STEREO;
  pvBuffer [4] = AL_LINUX_CURRENT_INPUT;
  pvBuffer [6] = AL_LINUX_CURRENT_OUTPUT;

  ALgetparams (AL_DEFAULT_DEVICE,pvBuffer,8);

  num    = fl_get_slider_value (ob);
  vol    = (int) num;
  stereo = pvBuffer [3] & (1 << (channel));
  lock   = 0;
  if (stereo)
    lock = fl_get_button (mixerLockButtons [channel]);

  // Work out linux global and set mixer form sliders if locked
  if (stereo && lock)
  {
    pvBuffer [1] = (vol << 8) | vol;
    if (left)
      fl_set_slider_value (mixerSliders [data + 1],num);
    else
      fl_set_slider_value (mixerSliders [data - 1],num);
  }
  else if (left)
    pvBuffer [1] = (pvBuffer [1] & 0x0000ff00) | vol;
  else
    pvBuffer [1] = (pvBuffer [1] & 0x000000ff) | (vol << 8);
  
  // Set linux globals
  ALsetparams (AL_DEFAULT_DEVICE,pvBuffer,2);
  if (fl_get_button (mixerMuteButtons [channel]))
    fl_call_object_callback (mixerMuteButtons [channel]);
  
  // Update record, play, post and mixplay sliders
  if (channel == pvBuffer [5])
  {
    // Current input
    if (stereo && lock)
    {
      fl_set_slider_value (recordForm->leftSlider,num);
      fl_set_slider_value (recordForm->rightSlider,num);
    }
    else if (left)
    {
      fl_set_slider_value (recordForm->leftSlider,num);
    }
    else
    {
      fl_set_slider_value (recordForm->rightSlider,num);
    }
  }
  if (channel == pvBuffer [7])
  {
    // Current output
    if (stereo && lock)
    {
      fl_set_slider_value (playForm->leftSlider,vol);
      fl_set_slider_value (playForm->rightSlider,vol);
      fl_set_slider_value (postForm->leftSlider,vol);
      fl_set_slider_value (postForm->rightSlider,vol);
      fl_set_slider_value (mixplayForm->leftSlider,vol);
      fl_set_slider_value (mixplayForm->rightSlider,vol);
    }
    else if (left)
    {
      fl_set_slider_value (playForm->leftSlider,vol);
      fl_set_slider_value (postForm->leftSlider,vol);
      fl_set_slider_value (mixplayForm->leftSlider,vol);
    }
    else
    {
      fl_set_slider_value (playForm->rightSlider,vol);
      fl_set_slider_value (postForm->rightSlider,vol);
      fl_set_slider_value (mixplayForm->rightSlider,vol);
    }
  }
}

/*---------------------------------------------------------------------------
| CALLBACK mixerIn_cb
---------------------------------------------------------------------------*/
void mixerIn_cb (FL_OBJECT *,long data)
{
  int channel;
  int oldChannel;
  long pvBuffer [4];
  int stereoMask;
  
  channel = data;
  
  // Get current input
  pvBuffer [0] = AL_LINUX_CURRENT_INPUT;
  ALgetparams (AL_DEFAULT_DEVICE,pvBuffer,2);
  oldChannel = pvBuffer [1];
  
  // Set new current input
  pvBuffer [1] = channel;
  ALsetparams (AL_DEFAULT_DEVICE,pvBuffer,2);
   
  // Update record form
  pvBuffer [0] = AL_LINUX_CHANNEL_BASE + channel;
  pvBuffer [2] = AL_LINUX_MIXER_STEREO;
  ALgetparams (AL_DEFAULT_DEVICE,pvBuffer,4);
  stereoMask = pvBuffer [3];

  // Set slider values
  fl_set_slider_value
    (recordForm->leftSlider,
    fl_get_slider_value (mixerSliders [2 * channel]));
  if (stereoMask & (1 << channel))
    fl_set_slider_value
      (recordForm->rightSlider,
      fl_get_slider_value (mixerSliders [(2 * channel) + 1]));

  // Show or hide if changing between stereo and mono
  if (!(stereoMask & (1 << channel)) &&
    (stereoMask & (1 << oldChannel)))
  {
    fl_hide_object (recordForm->rightSlider);
    fl_hide_object (recordForm->lockButton);
    fl_set_object_position (recordForm->leftSlider,
      recordForm->leftSlider->x + 15,
      recordForm->leftSlider->y);
    fl_set_object_label (recordForm->leftSlider,"");
  }

  if ((stereoMask & (1 << channel)) &&
    !(stereoMask & (1 << oldChannel)))
  {
    fl_show_object (recordForm->rightSlider);
    fl_show_object (recordForm->lockButton);
    fl_set_object_position (recordForm->leftSlider,
      recordForm->leftSlider->x - 15,
      recordForm->leftSlider->y);
    fl_set_object_label (recordForm->leftSlider,"L");
  }
  
  // Update label, mute button and lock buttton
  fl_set_object_label
    (recordForm->channelName,globalLabels [channel]);
  fl_set_button (recordForm->muteButton,
    fl_get_button (mixerMuteButtons [channel]));
  if (stereoMask & (1 << channel))
    fl_set_button (recordForm->lockButton,
      fl_get_button (mixerLockButtons [channel]));
}

/*---------------------------------------------------------------------------
| CALLBACK mixerOut_cb
---------------------------------------------------------------------------*/
void mixerOut_cb (FL_OBJECT *,long data)
{
  int channel;
  int oldChannel;
  long pvBuffer [4];
  int stereoMask;
  
  channel = data;
  
  // Get current output
  pvBuffer [0] = AL_LINUX_CURRENT_OUTPUT;
  ALgetparams (AL_DEFAULT_DEVICE,pvBuffer,2);
  oldChannel = pvBuffer [1];
  
  // Set new current input
  pvBuffer [1] = channel;
  ALsetparams (AL_DEFAULT_DEVICE,pvBuffer,2);
   
  // Update play, post and mixplay forms
  pvBuffer [0] = AL_LINUX_CHANNEL_BASE + channel;
  pvBuffer [2] = AL_LINUX_MIXER_STEREO;
  ALgetparams (AL_DEFAULT_DEVICE,pvBuffer,4);
  stereoMask = pvBuffer [3];

  // Set slider values
  fl_set_slider_value
    (playForm->leftSlider,
    fl_get_slider_value (mixerSliders [2 * channel]));
  fl_set_slider_value
    (postForm->leftSlider,
    fl_get_slider_value (mixerSliders [2 * channel]));
  fl_set_slider_value
    (mixplayForm->leftSlider,
    fl_get_slider_value (mixerSliders [2 * channel]));
  if (stereoMask & (1 << channel))
  {
    fl_set_slider_value
      (playForm->rightSlider,
      fl_get_slider_value (mixerSliders [(2 * channel) + 1]));
    fl_set_slider_value
      (postForm->rightSlider,
      fl_get_slider_value (mixerSliders [(2 * channel) + 1]));
    fl_set_slider_value
      (mixplayForm->rightSlider,
      fl_get_slider_value (mixerSliders [(2 * channel) + 1]));
  }
  
  // Show or hide if changing between stereo and mono
  if (!(stereoMask & (1 << channel)) &&
    (stereoMask & (1 << oldChannel)))
  {
    fl_hide_object (playForm->rightSlider);
    fl_hide_object (playForm->lockButton);
    fl_set_object_position (playForm->leftSlider,
      playForm->leftSlider->x + 15,
      playForm->leftSlider->y);
    fl_set_object_label (playForm->leftSlider,"");

    fl_hide_object (postForm->rightSlider);
    fl_hide_object (postForm->lockButton);
    fl_set_object_position (postForm->leftSlider,
      postForm->leftSlider->x + 15,
      postForm->leftSlider->y);
    fl_set_object_label (postForm->leftSlider,"");

    fl_hide_object (mixplayForm->rightSlider);
    fl_hide_object (mixplayForm->lockButton);
    fl_set_object_position (mixplayForm->leftSlider,
      mixplayForm->leftSlider->x + 15,
      mixplayForm->leftSlider->y);
    fl_set_object_label (mixplayForm->leftSlider,"");
  }

  if ((stereoMask & (1 << channel)) &&
    !(stereoMask & (1 << oldChannel)))
  {
    fl_show_object (playForm->rightSlider);
    fl_show_object (playForm->lockButton);
    fl_set_object_position (playForm->leftSlider,
      playForm->leftSlider->x - 15,
      playForm->leftSlider->y);
    fl_set_object_label (playForm->leftSlider,"L");

    fl_show_object (postForm->rightSlider);
    fl_show_object (postForm->lockButton);
    fl_set_object_position (postForm->leftSlider,
      postForm->leftSlider->x - 15,
      postForm->leftSlider->y);
    fl_set_object_label (postForm->leftSlider,"L");

    fl_show_object (mixplayForm->rightSlider);
    fl_show_object (mixplayForm->lockButton);
    fl_set_object_position (mixplayForm->leftSlider,
      mixplayForm->leftSlider->x - 15,
      mixplayForm->leftSlider->y);
    fl_set_object_label (mixplayForm->leftSlider,"L");
  }
  
  // Update label, mute button and lock buttton
  fl_set_object_label
    (playForm->channelName,globalLabels [channel]);
  fl_set_object_label
    (postForm->channelName,globalLabels [channel]);
  fl_set_object_label
    (mixplayForm->channelName,globalLabels [channel]);
  fl_set_button (playForm->muteButton,
    fl_get_button (mixerMuteButtons [channel]));
  fl_set_button (postForm->muteButton,
    fl_get_button (mixerMuteButtons [channel]));
  fl_set_button (mixplayForm->muteButton,
    fl_get_button (mixerMuteButtons [channel]));
  if (stereoMask & (1 << channel))
  {
    fl_set_button (playForm->lockButton,
      fl_get_button (mixerLockButtons [channel]));
    fl_set_button (postForm->lockButton,
      fl_get_button (mixerLockButtons [channel]));
    fl_set_button (mixplayForm->lockButton,
      fl_get_button (mixerLockButtons [channel]));
  }
}

/*---------------------------------------------------------------------------
| CALLBACK mixerRec_cb
---------------------------------------------------------------------------*/
void mixerRec_cb (FL_OBJECT *,long)
{
  int devMask;
  int recMask;
  int recSource;
  long pvBuffer [4];
  int i;
  
  // Compile record sources from buttons
  recSource = 0x00000000;
  pvBuffer [0] = AL_LINUX_MIXER_CHANNELS;
  pvBuffer [2] = AL_LINUX_MIXER_RECORD;
  ALgetparams (AL_DEFAULT_DEVICE,pvBuffer,4);
  devMask = pvBuffer [1];
  recMask = pvBuffer [3];
  
  for (i=0; i<SOUND_MIXER_NRDEVICES; i++)
  {
    if ((devMask & (1 << i)) && (recMask & (1 << i)))
    {
      if (fl_get_button (mixerRecButtons [i]))
        recSource = recSource | (1 << i);
    }
  }
  
  // Set linux global record source
  pvBuffer [0] = AL_LINUX_CURRENT_REC;
  pvBuffer [1] = recSource;
  ALsetparams (AL_DEFAULT_DEVICE,pvBuffer,2);
  recSource = pvBuffer [1];
  
  // Reset record buttons as appropriate
  for (i=0; i<SOUND_MIXER_NRDEVICES; i++)
  {
    if ((devMask & (1 << i)) && (recMask & (1 << i)))
    {
      if (recSource & (1 << i))
        fl_set_button (mixerRecButtons [i],1);
      else
        fl_set_button (mixerRecButtons [i],0);
    }
  }
}

/*---------------------------------------------------------------------------
| CALLBACK mixerLock_cb
---------------------------------------------------------------------------*/
void mixerLock_cb (FL_OBJECT *ob,long data)
{
  int channel;
  int lock;
  long pvBuffer [4];
  
  if (fl_get_button (ob))
  {
    // Even up volumes
    channel = data;
    lock    = TRUE;
    fl_set_slider_value (mixerSliders [(2 * channel) + 1],
      fl_get_slider_value (mixerSliders [2 * channel]));
    fl_call_object_callback (mixerSliders [2 * channel]);
  }
  else
  {
    channel = data;
    lock    = FALSE;
  }
  
  // Set appropriate record, play, mixplay and post lock button
  pvBuffer [0] = AL_LINUX_CURRENT_INPUT;
  pvBuffer [2] = AL_LINUX_CURRENT_OUTPUT;
  ALgetparams (AL_DEFAULT_DEVICE,pvBuffer,4);
  
  if (channel == pvBuffer [1])
  {
    // Current input
    fl_set_button (recordForm->lockButton,lock);
  }
  if (channel == pvBuffer [3])
  {
    // Current output
    fl_set_button (playForm->lockButton,lock);
    fl_set_button (postForm->lockButton,lock);
    fl_set_button (mixplayForm->lockButton,lock);
  }
}

/*---------------------------------------------------------------------------
| CALLBACK mixerMute_cb
---------------------------------------------------------------------------*/
void mixerMute_cb (FL_OBJECT *ob,long data)
{
  int channel;
  int mute;
  long pvBuffer [4];
  static int storedVolumes [SOUND_MIXER_NRDEVICES];
  
  if (fl_get_button (ob))
  {
    // Get and store linux globals
    channel = data;
    mute    = TRUE;
    pvBuffer [0] = AL_LINUX_CHANNEL_BASE + channel;
    ALgetparams (AL_DEFAULT_DEVICE,pvBuffer,2);
    storedVolumes [channel] = pvBuffer [1];
    
    // Set linux global to zero
    pvBuffer [1] = 0x00000000;
    ALsetparams (AL_DEFAULT_DEVICE,pvBuffer,2);
  }
  else
  {
    // Reset linux global to current global value
    channel = data;
    mute    = FALSE;
    pvBuffer [0] = AL_LINUX_CHANNEL_BASE + channel;
    pvBuffer [1] = storedVolumes [channel];
    ALsetparams (AL_DEFAULT_DEVICE,pvBuffer,2);
  }

  // Set appropiate record, play, mixplay and post mute button
  pvBuffer [0] = AL_LINUX_CURRENT_INPUT;
  pvBuffer [2] = AL_LINUX_CURRENT_OUTPUT;
  ALgetparams (AL_DEFAULT_DEVICE,pvBuffer,4);
  
  if (channel == pvBuffer [1])
  {
    // Current input
    fl_set_button (recordForm->muteButton,mute);
  }
  if (channel == pvBuffer [3])
  {
    // Current output
    fl_set_button (playForm->muteButton,mute);
    fl_set_button (postForm->muteButton,mute);
    fl_set_button (mixplayForm->muteButton,mute);
  }
}
#endif

/*---------------------------------------------------------------------------
| CALLBACK rawOK_cb
---------------------------------------------------------------------------*/

void rawOK_cb (FL_OBJECT *,long)
{
  DPSample *sample;
  char *error;
  char *filename;
  int exporting = 1;
  int format;
  int signedSign;
  int endian;
  int channels;
  
  if (rawForm->channelsGroup->visible) exporting = 0;
  fl_hide_form (rawForm->rawForm);
  
  filename = (char *) fl_get_input (rawForm->filename);
  
  if (fl_get_button (rawForm->byteFormat))
    format = AF_BYTE_FORMAT;
  else if (fl_get_button (rawForm->shortFormat))
    format = AF_SHORT_FORMAT;
  else if (fl_get_button (rawForm->long24Format))
    format = AF_LONG24_FORMAT;
  else if (fl_get_button (rawForm->long32Format))
    format = AF_LONG32_FORMAT;
  else if (fl_get_button (rawForm->floatFormat))
    format = AF_FLOAT_FORMAT;
  else
    format = AF_DOUBLE_FORMAT;
  
  if (fl_get_button (rawForm->signedSign))
    signedSign = AF_SIGNED_FORMAT;
  else
    signedSign = AF_UNSIGNED_FORMAT;
  
  if (fl_get_button (rawForm->defaultEndian))
    endian = AF_DEF_ENDIAN_FORMAT;
  else if (fl_get_button (rawForm->bigEndian))
    endian = AF_BIG_ENDIAN_FORMAT;
  else
    endian = AF_LITTLE_ENDIAN_FORMAT;
  
  if (fl_get_button (rawForm->mono))
    channels = 1;
  else if (fl_get_button (rawForm->stereo))
    channels = 2;
  else
    channels = 4;
  
  if (exporting)
  {
    // Export Raw
    
    sample = buffer [current];
    noSampleWarning
      
    waitCursorOn ();
    if ((error = sample->saveRAW ((char *) filename,0,
      fl_get_sample_soxcompatible (mainForm->sample),0,
      format,signedSign,endian)))
    {
      waitCursorOff ();
      fl_show_alert ("Warning - Could not export RAW file",
        filename,error,TRUE);
    }
    else
    {
      waitCursorOff ();
      updateNameBox ();
      updateBufferBrowser ();
      sample->consolidate ();
      sample->removeExtra ();
    }
  }
  else
  {
    // Import Raw
    
    sample = new DPSample;
    waitCursorOn ();
    
    if ((error = sample->loadRAW ((char *) filename,
      channels,format,signedSign,endian)))
    {
      waitCursorOff ();
      fl_show_alert ("Warning - Could not import RAW file",
        filename,error,TRUE);
      delete sample;
    }
    else
    {
      char filenamebuffer [1024];
      sprintf (filenamebuffer,"%s.aiff",
        dap_no_extension(dap_basename(filename)));
      sample->setFilename (filenamebuffer);
      waitCursorOff ();
      clearBuffers ();
      fl_set_sample (mainForm->sample,sample);
      delete buffer [current];
      buffer [current] = sample;
      updateSample (sample);
    }
  }
}

/*---------------------------------------------------------------------------
| CALLBACK rawCancel_cb
---------------------------------------------------------------------------*/

void rawCancel_cb (FL_OBJECT *,long)
{
  fl_hide_form (rawForm->rawForm);
}

/*---------------------------------------------------------------------------
| CALLBACK rawEmpty_cb
---------------------------------------------------------------------------*/

void rawEmpty_cb (FL_OBJECT *,long)
{
}

/***************************************************************************/
