/****************************************************************************
|                         Digital Audio Processor
|                         =======================
|
| Filename    : DPTich_DSP.h
|
| Object      : None
|
| Description : Effects function prototypes
|
| (c) Richard Kent 1996
|
| $Id: DPTich_DSP.h,v 1.1 2003/09/10 00:06:24 rk Exp $
|
****************************************************************************/

#ifndef _DPTich_DSP_h
#define _DPTich_DSP_h

#include "DPTich_main.h"

char *DSPReverberation
  (DPSample *inputSample,DPSample *outputSample,int susLoop,int relLoop);

char *DSPReverberation
  (DPSample *inputSample,DPSample *outputSample,int susLoop,int relLoop,
  int first,int channel_a,int channel_b);

char *DSPGatedReverberation
  (DPSample *inputSample,DPSample *outputSample,int susLoop,int relLoop);

char *DSPGatedReverberation
  (DPSample *inputSample,DPSample *outputSample,int susLoop,int relLoop,
  int first,int channel_a,int channel_b);

char *DSPStereoDelay
  (DPSample *inputSample,DPSample *outputSample,int susLoop,int relLoop);

char *DSPStereoDelay
  (DPSample *inputSample,DPSample *outputSample,int susLoop,int relLoop,
  int first,int channel_a,int channel_b);

char *DSPModulatedDelay
  (DPSample *inputSample,DPSample *outputSample,int susLoop,int relLoop);

char *DSPModulatedDelay
  (DPSample *inputSample,DPSample *outputSample,int susLoop,int relLoop,
  int first,int channel_a,int channel_b);

char *DSPMultiTapDelay
  (DPSample *inputSample,DPSample *outputSample,int susLoop,int relLoop);

char *DSPMultiTapDelay
  (DPSample *inputSample,DPSample *outputSample,int susLoop,int relLoop,
  int first,int channel_a,int channel_b);

char *DSPMultiDelay
  (DPSample *inputSample,DPSample *outputSample,int susLoop,int relLoop);

char *DSPMultiDelay
  (DPSample *inputSample,DPSample *outputSample,int susLoop,int relLoop,
  int first,int channel_a,int channel_b);

char *DSPFlanger
  (DPSample *inputSample,DPSample *outputSample,int susLoop,int relLoop);

char *DSPFlanger
  (DPSample *inputSample,DPSample *outputSample,int susLoop,int relLoop,
  int first,int channel_a,int channel_b);

char *DSPPhaser
  (DPSample *inputSample,DPSample *outputSample,int susLoop,int relLoop);

char *DSPPhaser
  (DPSample *inputSample,DPSample *outputSample,int susLoop,int relLoop,
  int first,int channel_a,int channel_b);

char *DSPDistortion
  (DPSample *inputSample,DPSample *outputSample,int susLoop,int relLoop);

char *DSPDistortion
  (DPSample *inputSample,DPSample *outputSample,int susLoop,int relLoop,
  int first,int channel_a,int channel_b);

char *DSPFilter
  (DPSample *inputSample,DPSample *outputSample,int susLoop,int relLoop);

char *DSPFilter
  (DPSample *inputSample,DPSample *outputSample,int susLoop,int relLoop,
  int first,int channel_a,int channel_b);

char *DSPAutoPan
  (DPSample *inputSample,DPSample *outputSample,int susLoop,int relLoop);

char *DSPAutoPan
  (DPSample *inputSample,DPSample *outputSample,int susLoop,int relLoop,
  int first,int channel_a,int channel_b);

char *DSPEqualizer
  (DPSample *inputSample,DPSample *outputSample,int susLoop,int relLoop);

char *DSPEqualizer
  (DPSample *inputSample,DPSample *outputSample,int susLoop,int relLoop,
  int first,int channel_a,int channel_b);

char *DSPGate
  (DPSample *inputSample,DPSample *outputSample,int susLoop,int relLoop);

char *DSPGate
  (DPSample *inputSample,DPSample *outputSample,int susLoop,int relLoop,
  int first,int channel_a,int channel_b);

char *DSPCompressor
  (DPSample *inputSample,DPSample *outputSample,int susLoop,int relLoop);

char *DSPCompressor
  (DPSample *inputSample,DPSample *outputSample,int susLoop,int relLoop,
  int first,int channel_a,int channel_b);

double calcFeedbackTime (double feedback,double delayTime);

#endif //_DPTich_DSP_h

/***************************************************************************/
