/****************************************************************************
|                         Digital Audio Processor
|                         =======================
|
| Filename    : raw.h
|
| Object      : None
|
| Description : Audiofile replacement code for linux (raw files)
|
| (c) Richard Kent 1998
|
| $Id: raw.h,v 1.1 2003/09/10 00:06:24 rk Exp $
|
****************************************************************************/

#ifndef _raw_h
#define _raw_h

#include "macros.h"

#ifdef __cplusplus
extern "C"
{
#endif
  
AFfilehandle AFreadRAW (FHandle file, rawType details);
AFfilehandle AFwriteRAW (FHandle file,AFfilesetup setup);
int AFclosefileRAW (AFfilehandle handle);
int AFreadframesRAW (AFfilehandle handle,void *frames,int count);
int AFwriteframesRAW (AFfilehandle handle,void *frames,int count);

signed int AFlimitIValue (int value,int min,int max);
unsigned int AFlimitUIValue (unsigned int value,unsigned int min,unsigned int max);
float AFlimitFValue (float value,float min,float max);
double AFlimitDValue (double value,double min,double max);

#ifdef __cplusplus
}
#endif

#endif // _raw_h

/***************************************************************************/
