/****************************************************************************
|                         Digital Audio Processor
|                         =======================
|
| Filename    : audio.h
|
| Object      : None
|
| Description : Audio replacement code for linux
|
| (c) Richard Kent 1997
|
| $Id: audio.h,v 1.1 2003/09/10 00:06:24 rk Exp $
|
****************************************************************************/

#ifdef LINUX

#ifndef _audio_h
#define _audio_h

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <fcntl.h>
#include <limits.h>
#include <math.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/ioctl.h>
#ifdef __NetBSD__
#include <soundcard.h>
#else
#include <sys/soundcard.h>
#endif

#ifdef __cplusplus
extern "C"
{
#endif

#define MAX32   4294967296LL
#define MAX32_1 4294967295U
#define MAX31   2147483648U
#define MAX31_1 2147483647
#define MAX24   16777216
#define MAX24_1 16777215
#define MAX23   8388608
#define MAX23_1 8388607
#define MAX16   65536
#define MAX16_1 65535
#define MAX15   32768
#define MAX15_1 32767
#define MAX8    256
#define MAX8_1  255
#define MAX7    128
#define MAX7_1  127

typedef struct
{
  int channels;
  int queuesize;
  int sampfmt;
  int width;
  double floatmax;
} configType;

typedef struct
{
  int number;
  int mode;
  char *name;
  configType config;
  void *queue;
  int head;
  int tail;
  int filled;
  int fillable;
  unsigned long long total;
  int numberErrors;
  unsigned long long lastError;
  int lastErrorLength;
  int lastErrorType;
  int file;
  int deviceFormat;
  int deviceStereo;
  int deviceSpeed;
  int deviceQueueSize;
} portType;

typedef struct
{
  int type;
  int min;
  int max;
  int def;
  char *name;
  int value;
} globalType;

typedef configType *ALconfig;
typedef portType *ALport;
typedef void (*ALerrfunc) (long,const char*,...);

#define AL_RATE_48000 	         48000
#define AL_RATE_44100	         44100
#define AL_RATE_32000	         32000
#define AL_RATE_22050	         22050
#define AL_RATE_16000	         16000
#define AL_RATE_11025	         11025
#define AL_RATE_8000	         8000
#define AL_RATE_INPUTRATE        (-1)
#define AL_RATE_AES_1            (-2)
#define AL_RATE_AES_2	         (-3)
#define AL_RATE_AES_3	         (-4)
#define AL_RATE_AES_4		     (-5)
#define AL_RATE_AES_6		     (-6)
#define AL_RATE_AES_1s		     (-7)
#define AL_RATE_UNDEFINED     	 (-8)
#define AL_RATE_NO_DIGITAL_INPUT (-9)
#define AL_RATE_UNACQUIRED	     (-10)
#define AL_SAMPFMT_TWOSCOMP      1
#define AL_SAMPFMT_FLOAT         32
#define AL_SAMPFMT_DOUBLE        64
#define AL_SAMPLE_8	             1
#define AL_SAMPLE_16	         2
#define AL_SAMPLE_24	         4
#define AL_MONO                  1
#define AL_STEREO                2
#define AL_4CHANNEL              4
#define AL_INPUT_LINE		     0
#define AL_INPUT_MIC		     1
#define AL_INPUT_DIGITAL	     2
#define AL_MONITOR_OFF           0
#define AL_MONITOR_ON            1
#define AL_SPEAKER_MUTE_OFF      0
#define AL_SPEAKER_MUTE_ON       1
#define AL_DEFAULT_DEVICE	     1
#define AL_MAX_PBUFSIZE		     64
#define AL_INPUT_SOURCE		     0
#define AL_LEFT_INPUT_ATTEN	     1
#define AL_RIGHT_INPUT_ATTEN	 2
#define AL_INPUT_RATE		     3
#define AL_OUTPUT_RATE		     4
#define AL_LEFT_SPEAKER_GAIN	 5
#define AL_RIGHT_SPEAKER_GAIN	 6
#define AL_INPUT_COUNT		     7
#define AL_OUTPUT_COUNT		     8
#define AL_UNUSED_COUNT		     9
#define AL_SYNC_INPUT_TO_AES     10
#define AL_SYNC_OUTPUT_TO_AES    11
#define AL_MONITOR_CTL           12
#define AL_LEFT_MONITOR_ATTEN    13
#define AL_RIGHT_MONITOR_ATTEN   14
#define AL_CHANNEL_MODE		     15
#define AL_SPEAKER_MUTE_CTL	     16
#define	AL_MIC_MODE		         17
#define AL_LEFT1_INPUT_ATTEN     1
#define AL_RIGHT1_INPUT_ATTEN    2
#define AL_LEFT2_INPUT_ATTEN     18
#define AL_RIGHT2_INPUT_ATTEN    19 
#define AL_DIGITAL_INPUT_RATE	 20

#define AL_LINUX_DSP_PRESENT	 21
#define AL_LINUX_MIXER_PRESENT	 22
#define AL_LINUX_MIXER_CHANNELS	 23
#define AL_LINUX_MIXER_RECORD	 24
#define AL_LINUX_MIXER_STEREO	 25
#define AL_LINUX_CURRENT_INPUT	 26
#define AL_LINUX_CURRENT_OUTPUT	 27
#define AL_LINUX_CURRENT_REC	 28
#define AL_LINUX_CHANNEL_BASE	 29

#define AL_ENUM_VALUE	         1
#define AL_RANGE_VALUE	         2

#define MAXPORTSOPEN             1
#define INPUTONLY                0
#define OUTPUTONLY               1
#define DEFAULTPORTNAME          "DefaultPort"

#define NUMBEROFSTATES           AL_LINUX_CHANNEL_BASE + SOUND_MIXER_NRDEVICES

#ifndef FALSE
#define FALSE 0
#endif
#ifndef TRUE
#define TRUE  1
#endif

ALerrfunc ALseterrorhandler (ALerrfunc efunc);
ALconfig ALnewconfig (void);
int ALfreeconfig (ALconfig config);
int ALsetchannels (ALconfig config,int channels);
int ALgetchannels (ALconfig config);
int ALsetqueuesize (ALconfig config,int queuesize);
int ALgetqueuesize (ALconfig config);
int ALsetsampfmt (ALconfig config,int sampleformat);
int ALgetsampfmt (ALconfig config);
int ALsetwidth (ALconfig config,int samplesize);
int ALgetwidth (ALconfig config);
int ALsetfloatmax (ALconfig config,double maximum_value);
double ALgetfloatmax (ALconfig config);
ALconfig ALgetconfig (ALport port);
int	ALsetconfig (ALport port,ALconfig config);
ALport ALopenport (const char *name,const char *direction,ALconfig config);
int ALcloseport (ALport port);
int ALflush (ALport port,int unknown);
int ALgetfillable (ALport port);
int ALgetfilled (ALport port);
int ALgetstatus (ALport port,long *pvBuffer,int bufferlength);
int ALgetfd (ALport port);
int ALreadsamps (ALport port,void *samples,int samplecount);
int ALwritesamps (ALport port,void *samples,int samplecount);
int ALgetframenumber (ALport port,unsigned long long *framenum);
int ALqueryparams (int device,long *pvBuffer,int bufferlength);
int ALgetminmax (int device,int param,long *minparam,long *maxparam);
int ALgetdefault (int device,int parameter);
char *ALgetname (int device,int parameter);
int ALgetparams (int device,long *pvBuffer,int bufferlength);
int ALsetparams (int device,long *pvBuffer,int bufferlength);
void initialiseConfig (ALconfig config);
void initialiseAudio (const char *dsp,const char *mixer);
void finishAudio ();
char *ALgetlabel (int channel);
char *ALgetglobalname (int channel);
inline void get8BitSample (
  ALport port,
  void *samples,
  int copied,
  unsigned char *sample);
inline void get16BitSample (
  ALport port,
  void *samples,
  int copied,
  signed short *sample);
inline void put8BitSample (
  ALport port,
  void *samples,
  int copied,
  unsigned char sample);
inline void put16BitSample (
  ALport port,
  void *samples,
  int copied,
  signed short sample);

extern char *globalLabels [];
extern char *globalNames [];

/* Unused defines */

#define AL_PORTSTYLE_SERIAL        0
#define AL_PORTSTYLE_DIRECT        1
#define AL_ERROR_NUMBER            0
#define AL_ERROR_TYPE              1
#define AL_ERROR_LOCATION_LSP      2
#define AL_ERROR_LOCATION_MSP      3
#define AL_ERROR_LENGTH            4
#define AL_ERROR_INPUT_OVERFLOW    0
#define AL_ERROR_OUTPUT_UNDERFLOW  1
#define AL_BAD_NOT_IMPLEMENTED	   0 /* not implemented yet */
#define AL_BAD_PORT		           1 /* tried to use an invalid port */
#define AL_BAD_CONFIG		       2 /* tried to use an invalid configuration */
#define AL_BAD_DEVICE		       3 /* tried to use an invalid device */
#define AL_BAD_DEVICE_ACCESS	   4 /* unable to access the device */
#define AL_BAD_DIRECTION	       5 /* illegal direction given for port */
#define AL_BAD_OUT_OF_MEM	       6 /* operation has run out of memory */
#define AL_BAD_NO_PORTS		       7 /* not able to allocate a port */
#define AL_BAD_WIDTH		       8 /* invalid sample width given */
#define AL_BAD_ILLEGAL_STATE	   9 /* an illegal state has occurred */
#define AL_BAD_QSIZE		       10 /* attempt to set an invalid queue size */
#define AL_BAD_FILLPOINT	       11 /* attempt to set an invalid fillpoint */
#define AL_BAD_BUFFER_NULL	       12 /* null buffer pointer */
#define AL_BAD_COUNT_NEG	       13 /* negative count */
#define AL_BAD_PVBUFFER		       14 /* param/val buffer doesn't make sense */
#define AL_BAD_BUFFERLENGTH_NEG	   15 /* negative buffer length */
#define AL_BAD_BUFFERLENGTH_ODD	   16 /* odd length parameter/value buffer */
#define AL_BAD_CHANNELS		       17 /* invalid channel specifier */
#define AL_BAD_PARAM		       18 /* invalid parameter */
#define AL_BAD_SAMPFMT             19 /* attempt to set invalid sample format */
#define AL_BAD_RATE                20 /* invalid sample rate token */
#define AL_BAD_TRANSFER_SIZE	   21 /* invalid size for sample read/write */
#define AL_BAD_FLOATMAX		       22 /* invalid size for floatmax */
#define AL_BAD_PORTSTYLE	       23 /* invalid port style */

/* Unimplemented code

int ALgetframetime (
  ALport port,
  unsigned long long *fnum,
  unsigned long long *ustime);
int ALgetfillpoint (ALport port);
int ALsetfillpoint (ALport port,int fillpoint);

*/

#ifdef __cplusplus
}
#endif

#endif // _audio_h

#endif // LINUX

/***************************************************************************/
