/* $Id: cs4235_regs.h,v 1.1.1.1 2000/10/09 00:13:18 jmcneill Exp $ */

/*
 * cs4235_regs.h
 * Copyright (C) 2000 Jared D. McNeill <jmcneill@invisible.yi.org>
 *
 * Incomplete list of registers for the Crystal Sound CS4235 chipset
 */

#ifndef _CS4235_REGS_H_
#define _CS4235_REGS_H_

#define WSS_BASE	0x534		/* Default to 0x534 */

/*
 * Direct Registers
 */
#define R0		WSS_BASE + 0	/* Index Address Register */
#define R1		WSS_BASE + 1	/* Indexed Data Register */
#define R2		WSS_BASE + 2	/* Status Register */
#define R3		WSS_BASE + 3	/* PIO Data Register */

/*
 * Indirect Registers
 */
#define I12		0x0c	/* MODE and ID */
#define I23		0x17	/* Enable access to extended registers */

/*
 * Extended Registers
 */
#define X18		0x24	/* Enable 3D & RAM port */
#define X23		0x74	/* 3D space control */

/*
 * Modes (for I12)
 */
#define MODE1		0x80
#define MODE2		0xc0
#define MODE3		0xe0

/*
 * Settings
 */
#define X18_3D_ENABLE	0x10

#endif /* !_CS4235_REGS_H_ */
