/* $Id: cs4235_ctl.c,v 1.1 2000/10/09 13:55:19 jmcneill Exp $ */

/*
 * cs4235_ctl.c
 * Copyright (C) 2000 Jared D. McNeill <jmcneill@invisible.yi.org>
 *
 * Functions for the CS4235
 */

#include <sys/types.h>

#include <stdio.h>
#include <string.h>

#include <machine/sysarch.h>
#include <machine/pio.h>

#include "cs4235_regs.h"
#include "cs4235_ctl.h"

int
cs4235_set_mode(int mode)
{
	short new_mode;
	int settings;

	cs4235_enable_access_indirect();

	switch(mode)
	{
	case 1:
		new_mode = MODE1;
		break;
	case 2:
		new_mode = MODE2;
		break;
	case 3:
		new_mode = MODE3;
		break;
	default:
		return(-1);
	}

	/* Check the card's current mode */
	settings = inb(R1);

	/* Set appropriate mode */
	outb(R1, new_mode);
	settings = inb(R1);

	return(0);
}

void
cs4235_enable_access_indirect(void)
{

	/* Enable access to indirect registers */
	outb(R0, I12);
}

void
cs4235_enable_access_extended(void)
{

	/* Enable access to extended registers */
	outb(R0, I23);
}

void
cs4235_enable_3d(void)
{
	int settings;

	cs4235_enable_access_extended();

	/* Access 3D Enable register */ 
	outb(R1, X18 ^ 0x0b);

	/* Get current settings */
	settings = inb(R1);

	/* Change settings */
	outb(R1, X18_3D_ENABLE);
	settings = inb(R1);
}

int
cs4235_set_spacectl(int volume)
{

	if (volume < 0 || volume > 15)
		return(-1);

	cs4235_enable_access_extended();

        /* Access 3D Space Control register */
        outb(R1, X23 ^ 0x0b);
	
        /* Set new space control settings */
        outb(R1, volume * 0x10);

	return(0);
}

int
cs4235_get_spacectl(void)
{

	cs4235_enable_access_extended();

	/* Access 3D Space Control register */
	outb(R1, X23 ^ 0x0b);

	return(inb(R1));
}
