/* $Id: cs4235_3dctl.c,v 1.2 2000/10/09 13:55:19 jmcneill Exp $ */

/*
 * cs4235_3dctl.c
 * Copyright (C) 2000 Jared D. McNeill <jmcneill@invisible.yi.org>
 *
 * Enable 3D mode on Crystal Sound CS4235 chipsets and toggles 3D space control
 */

#include <sys/types.h>

#include <stdio.h>

#include <machine/sysarch.h>
#include <machine/pio.h>

#include "cs4235_ctl.h"

extern	char *	__progname;

void	usage	__P((void));

int
main(int argc, char *argv[])
{
	long volume;
	int old_volume, new_volume;

	if (argc != 2)
	{
		usage();
		return(-1);
	}

	volume = strtol(argv[1], NULL, 10);

	if (volume < 0 || volume > 15)
	{
		printf("Volume MUST be a value from 0 to 15!\n");
		usage();
		return(-1);
	}

	/* Enable access to IO ports */
	if (i386_iopl(3))
	{
		perror("i386_iopl");
		return(1);
	}

	if (cs4235_set_mode(3))
	{
		perror("cs4235_set_mode");
		return(2);
	}

	cs4235_enable_3d();

	old_volume = cs4235_get_spacectl();
	cs4235_set_spacectl(volume);
	new_volume = cs4235_get_spacectl();
	printf("cs4235.spacectl: %i -> %i\n", old_volume / 16, new_volume / 16);

	/* Disable access to IO ports */
	i386_iopl(0);

	/* All done */
	return(0);
}

void
usage(void)
{
	printf("usage: %s <volume>\n", __progname);
	printf("   volume must be a value from 0 to 15\n");
	printf("   note that a higher value means less 3d effect\n");
}

