#! /usr/bin/env python
#
# This script benchmarks throughput for
# the various AES cipher modes and sizes

from aes.aes import aes
import time

# Encryption Keys and Initialization Vector
key128='a'*16
key192='a'*24
key256='a'*32
IV='i'*16

# The engines
ECB128 = aes(key128,"ECB",IV)
ECB192 = aes(key192,"ECB",IV)
ECB256 = aes(key256,"ECB",IV)
CBC128 = aes(key128,"CBC",IV)
CBC192 = aes(key192,"CBC",IV)
CBC256 = aes(key256,"CBC",IV)

# A 1-Megabyte string of q's
teststr = 'q'*1024000
global totbytes
totbytes=0
start=time.time()

# A test function
def gamut(encoder,rounds,out,rekey=0):
	global totbytes
	code=[]
	decode=[]
	s=time.time()
	for i in range(rounds):
		code.append(encoder.encrypt(teststr))

	# Analysis of encrypt
	stop=time.time()
	print out + " Encrypt = " + str(len(teststr)*rds) \
		+" Bytes in " + str(stop-s) \
		+" s @ " + str((len(teststr)*rds)/(stop-s)) \
		+" B/s"

	s=time.time()
	for i in range(rounds):
		# Re-set the IV if in CBC mode
		if rekey:
			if out=="CBC128": encoder = aes(key128,"CBC",IV)
			if out=="CBC192": encoder = aes(key192,"CBC",IV)
			if out=="CBC256": encoder = aes(key256,"CBC",IV)

		decode.append(encoder.decrypt(code[i]))

		if decode[i] != teststr:
			print 'OH NO - A decryption error has occurred!'
			print decode[i]+" -- "+teststr

	# Analysis of decrypt
	stop=time.time()
	print out + " Decrypt = " + str(len(teststr)*rds) \
		+" Bytes in " + str(stop-s) \
		+" s @ " + str((len(teststr)*rds)/(stop-s)) \
		+" B/s"

	totbytes += rds*2*len(teststr)


rds=5
for i in range(6):
	if i == 0:
		gamut(ECB128,rds,"ECB128")
	if i == 1:
		gamut(ECB192,rds,"ECB192")
	if i == 2:
		gamut(ECB256,rds,"ECB256")
	if i == 3:
		gamut(CBC128,rds,"CBC128",1)
	if i == 4:
		gamut(CBC192,rds,"CBC192",1)
	if i == 5:
		gamut(CBC256,rds,"CBC256",1)

# Final Analysis

stop=time.time()
print "== Benchmark complete =="
print "Mean throughput: " + str(totbytes) \
	+" Bytes in " + str(stop-start) \
	+" s @ " + str(totbytes/(stop-start)) \
	+" B/s"



# This is the output of this test script on the author's
# overburdened 800 Mhz PIII - Linux 2.4.8 - 512 MB RAM
#
# ECB128 Encrypt = 5120000 Bytes in 0.483245968819 s @ 10595018.542 B/s
# ECB128 Decrypt = 5120000 Bytes in 0.521327018738 s @ 9821090.82394 B/s
# ECB192 Encrypt = 5120000 Bytes in 0.424638986588 s @ 12057300.8172 B/s
# ECB192 Decrypt = 5120000 Bytes in 0.474702954292 s @ 10785692.3023 B/s
# ECB256 Encrypt = 5120000 Bytes in 0.606157064438 s @ 8446655.66135 B/s
# ECB256 Decrypt = 5120000 Bytes in 0.506448984146 s @ 10109606.6144 B/s
# CBC128 Encrypt = 5120000 Bytes in 0.478181004524 s @ 10707242.5537 B/s
# CBC128 Decrypt = 5120000 Bytes in 0.445245027542 s @ 11499286.1981 B/s
# CBC192 Encrypt = 5120000 Bytes in 0.511945009232 s @ 10001074.1538 B/s
# CBC192 Decrypt = 5120000 Bytes in 0.595669031143 s @ 8595377.18483 B/s
# CBC256 Encrypt = 5120000 Bytes in 0.546512961388 s @ 9368487.77932 B/s
# CBC256 Decrypt = 5120000 Bytes in 0.526459932327 s @ 9725336.50826 B/s
# == Benchmark complete ==
# Mean throughput: 61440000 Bytes in 6.14340102673 s @ 10000974.9864 B/s
#
# As you can see, on my machine I average 10 MB/s, 3 times slower
# than Crypto++ but still fast enough for many applications.
