/************************************
     Copyright 2008 Google Inc.

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.

 ************************************/

/** @file usage.c
 *  @brief contains functions for parsing arguments and printing usage info.
 *
 *  generated by cgener.  http://code.google.com/p/cgener/
 */


#ifdef HAVE_CONFIG_H
# include <config.h>
#endif
#include "reorder_main.h"

/** prints application help information.
 * @param bin application name as invoked on the commandline
 */
void usage( char *bin ) {
  fprintf(stderr, "\nreorder: swaps columns in a delimited flat file\n");
  fprintf(stderr, "\nusage: %s <options> [file(s)] \n", bin);
  fprintf(stderr, "options:\n");
	fprintf(stderr, "  -h, --help             print this message and exit\n");
	fprintf(stderr, "  -V, --version          print version info and exit\n");
	fprintf(stderr, "  -v, --verbose          print verbose messages during execution\n");
	fprintf(stderr, "  -d, --delim <delim>    specifies delimiting string\n");
	fprintf(stderr, "  -s, --swap <swap>      specifies two fields to swap (ex: -s 1,3)\n");
	fprintf(stderr, "  -m, --move <move>      specifies a field to move to a new position (ex: -s 3,1)\n");
	fprintf(stderr, "  -f, --fields <fields>  specifies fields to use to create a new string (ex: -f\n                         3,4,1,5,2)\n");
	fprintf(stderr, "  -F, --field-labels <field_labels>\n                         a list of labels specifying the output field order\n");
	fprintf(stderr, "\nthe fields param is exclusive of swap and move - if -f and -m or -s are\nspecified, only -f will be used.\n\nexample: reorder -d : -s 1,3 -m 2,4 /etc/passwd\n\nwould swap fields 1 and 3, and then would move field 2 to position 4.");
	printf("\n\n");
	return;
} 

/* this won't be used outside of this file */
void init_cmdargs( struct cmdargs * );

#include <getopt.h>

/** long option structure list */
static struct option long_options[] = {
	{"help", no_argument, 0, 'h'},
	{"version", no_argument, 0, 'V'},
	{"verbose", no_argument, 0, 'v'},
	{"delim", required_argument, 0, 'd'},
	{"swap", required_argument, 0, 's'},
	{"move", required_argument, 0, 'm'},
	{"fields", required_argument, 0, 'f'},
	{"field-labels", required_argument, 0, 'F'},
	{0, 0, 0, 0}
};

/** parses commandline arguments and puts the info into a cmdargs struct.
 * @param argc number of arguments
 * @param argv array of argument strings
 * @param args structure to hold the parsed options & arguments
 */
void parse_args ( int argc, char **argv, struct cmdargs *args){
  int c, option_index=0;

  init_cmdargs(args);

  while( (c = getopt_long(argc, argv, "hVvd:s:m:f:F:", long_options, &option_index)) != -1 ){
    switch (c) {
      case '0':
        if ( long_options[option_index].flag != 0 )
          break;
			case 'h':
				args->help = 1;
				break;
			case 'V':
				args->version = 1;
				break;
			case 'v':
				args->verbose++;;
				break;
			case 'd':
				args->delim = optarg;
				break;
			case 's':
								if( pushswap(optarg, REORDER_TYPE_SWAP ) != 0 ){
					fprintf(stderr, "invalid fields in \"-s %s\"\n", optarg);
					exit(EXIT_HELP);
				}
;
				break;
			case 'm':
								if( pushswap(optarg, REORDER_TYPE_MOVE ) != 0 ){
					fprintf(stderr, "invalid fields in \"-s %s\"\n", optarg);
					exit(EXIT_HELP);
				}
;
				break;
			case 'f':
				args->fields = optarg;
				break;
			case 'F':
				args->field_labels = optarg;
				break;
			default: break;
		}
	}
	return;
}


/** @brief initializes all elements in the cmdargs struct to NULL or 0.
 *  @param args pointer to the argument structure to be cleared out.
 */
void init_cmdargs( struct cmdargs *args ){
  /* this set all pointers to null, int values to 0 */
  memset( args, 0, sizeof(struct cmdargs) );
}

/** @brief prints application version.
  */
void version ( void ){
  fprintf(stderr, "%s\n", APPLICATION_VERSION);
}

