/************************************
     Copyright 2008 Google Inc.

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.

 ************************************/

/** @file usage.c
 *  @brief contains functions for parsing arguments and printing usage info.
 *
 *  generated by cgener.  http://code.google.com/p/cgener/
 */


#ifdef HAVE_CONFIG_H
# include <config.h>
#endif
#include "pivot_main.h"

/** prints application help information.
 * @param bin application name as invoked on the commandline
 */
void usage( char *bin ) {
  fprintf(stderr, "\npivot: pivots flat-file data from rows to columns\n");
  fprintf(stderr, "\nusage: %s <options> [file ...] \n", bin);
  fprintf(stderr, "options:\n");
	fprintf(stderr, "  -h, --help                   print this message and exit\n");
	fprintf(stderr, "  -V, --version                print version info and exit\n");
	fprintf(stderr, "  -d, --delimiter <delim>      field separator string\n");
	fprintf(stderr, "  -k, --keep-header            indicates that the first line of input should be\n                               treated as header info\n");
	fprintf(stderr, "  -f, --output-fields <keys>   indexes of row fields to output\n");
	fprintf(stderr, "  -F, --output-labels <key_labels>\n                               labels of row fields to output\n");
	fprintf(stderr, "  -p, --pivot-fields <pivots>  indexes of column fields to pivot on\n");
	fprintf(stderr, "  -P, --pivot-labels <pivot_labels>\n                               labels of column fields to pivot on\n");
	fprintf(stderr, "  -v, --value-fields <values>  indexes of data fields to put into the pivoted\n                               cells\n");
	fprintf(stderr, "  -A, --value-labels <value_labels>\n                               labels of data fields to put into the pivoted cells\n");
	fprintf(stderr, "\n-f, -p, and -v values are comma-separated numbers or ranges.  for example:\n\n1,2-5,7");
	printf("\n\n");
	return;
} 

/* this won't be used outside of this file */
void init_cmdargs( struct cmdargs * );

#include <getopt.h>

/** long option structure list */
static struct option long_options[] = {
	{"help", no_argument, 0, 'h'},
	{"version", no_argument, 0, 'V'},
	{"delimiter", required_argument, 0, 'd'},
	{"keep-header", no_argument, 0, 'k'},
	{"output-fields", required_argument, 0, 'f'},
	{"output-labels", required_argument, 0, 'F'},
	{"pivot-fields", required_argument, 0, 'p'},
	{"pivot-labels", required_argument, 0, 'P'},
	{"value-fields", required_argument, 0, 'v'},
	{"value-labels", required_argument, 0, 'A'},
	{0, 0, 0, 0}
};

/** parses commandline arguments and puts the info into a cmdargs struct.
 * @param argc number of arguments
 * @param argv array of argument strings
 * @param args structure to hold the parsed options & arguments
 */
void parse_args ( int argc, char **argv, struct cmdargs *args){
  int c, option_index=0;

  init_cmdargs(args);

  while( (c = getopt_long(argc, argv, "hVd:kf:F:p:P:v:A:", long_options, &option_index)) != -1 ){
    switch (c) {
      case '0':
        if ( long_options[option_index].flag != 0 )
          break;
			case 'h':
				args->help = 1;
				break;
			case 'V':
				args->version = 1;
				break;
			case 'd':
				args->delim = optarg;
				break;
			case 'k':
				args->keep_header = 1;
				break;
			case 'f':
				args->keys = optarg;
				break;
			case 'F':
				args->key_labels = optarg;
				break;
			case 'p':
				args->pivots = optarg;
				break;
			case 'P':
				args->pivot_labels = optarg;
				break;
			case 'v':
				args->values = optarg;
				break;
			case 'A':
				args->value_labels = optarg;
				break;
			default: break;
		}
	}
	return;
}


/** @brief initializes all elements in the cmdargs struct to NULL or 0.
 *  @param args pointer to the argument structure to be cleared out.
 */
void init_cmdargs( struct cmdargs *args ){
  /* this set all pointers to null, int values to 0 */
  memset( args, 0, sizeof(struct cmdargs) );
}

/** @brief prints application version.
  */
void version ( void ){
  fprintf(stderr, "%s\n", APPLICATION_VERSION);
}

