/************************************
     Copyright 2008 Google Inc.

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.

 ************************************/

/** @file usage.c
 *  @brief contains functions for parsing arguments and printing usage info.
 *
 *  generated by cgener.  http://code.google.com/p/cgener/
 */


#ifdef HAVE_CONFIG_H
# include <config.h>
#endif
#include "indexof_main.h"

/** prints application help information.
 * @param bin application name as invoked on the commandline
 */
void usage( char *bin ) {
  fprintf(stderr, "\nindexof: prints the column number matching a given header, or 0 if not found.\n");
  fprintf(stderr, "\nusage: %s <options>  \n", bin);
  fprintf(stderr, "options:\n");
	fprintf(stderr, "  -h, --help             print this message and exit\n");
	fprintf(stderr, "  -V, --version          print version info and exit\n");
	fprintf(stderr, "  -v, --verbose          print verbose messages during execution\n");
	fprintf(stderr, "  -d, --delim <delim>    field separator string\n");
	fprintf(stderr, "  -l, --label <label>    the header label to look for (required)\n");
	fprintf(stderr, "  -f, --file <file>      specifies file to read (default = stdin)\n");
	fprintf(stderr, "  -s, --string <string>  use <string> instead of a header from a file\n");
	fprintf(stderr, "  -r, --row <row>        header line number in file (default = 1)\n");
	printf("\n\n");
	return;
} 

/* this won't be used outside of this file */
void init_cmdargs( struct cmdargs * );

#include <getopt.h>

/** long option structure list */
static struct option long_options[] = {
	{"help", no_argument, 0, 'h'},
	{"version", no_argument, 0, 'V'},
	{"verbose", no_argument, 0, 'v'},
	{"delim", required_argument, 0, 'd'},
	{"label", required_argument, 0, 'l'},
	{"file", required_argument, 0, 'f'},
	{"string", required_argument, 0, 's'},
	{"row", required_argument, 0, 'r'},
	{0, 0, 0, 0}
};

/** parses commandline arguments and puts the info into a cmdargs struct.
 * @param argc number of arguments
 * @param argv array of argument strings
 * @param args structure to hold the parsed options & arguments
 */
void parse_args ( int argc, char **argv, struct cmdargs *args){
  int c, option_index=0;

  init_cmdargs(args);

  while( (c = getopt_long(argc, argv, "hVvd:l:f:s:r:", long_options, &option_index)) != -1 ){
    switch (c) {
      case '0':
        if ( long_options[option_index].flag != 0 )
          break;
			case 'h':
				args->help = 1;
				break;
			case 'V':
				args->version = 1;
				break;
			case 'v':
				args->verbose++;;
				break;
			case 'd':
				args->delim = optarg;
				break;
			case 'l':
				args->label = optarg;
				break;
			case 'f':
				args->file = optarg;
				break;
			case 's':
				args->string = optarg;
				break;
			case 'r':
				args->row = optarg;
				break;
			default: break;
		}
	}
	return;
}


/** @brief initializes all elements in the cmdargs struct to NULL or 0.
 *  @param args pointer to the argument structure to be cleared out.
 */
void init_cmdargs( struct cmdargs *args ){
  /* this set all pointers to null, int values to 0 */
  memset( args, 0, sizeof(struct cmdargs) );
}

/** @brief prints application version.
  */
void version ( void ){
  fprintf(stderr, "%s\n", APPLICATION_VERSION);
}

