/************************************
     Copyright 2008 Google Inc.

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.

 ************************************/

/** @file usage.c
 *  @brief contains functions for parsing arguments and printing usage info.
 *
 *  generated by cgener.  http://code.google.com/p/cgener/
 */


#ifdef HAVE_CONFIG_H
# include <config.h>
#endif
#include "foreach_parallel_main.h"

/** prints application help information.
 * @param bin application name as invoked on the commandline
 */
void usage( char *bin ) {
  fprintf(stderr, "\nforeach_parallel: processes a block of shell in parallel for multiple inputs\n");
  fprintf(stderr, "\nusage: %s <options> <input ...> \n", bin);
  fprintf(stderr, "options:\n");
	fprintf(stderr, "  -h, --help                 print this message and exit\n");
	fprintf(stderr, "  -V, --verbose              print verbose runtime messages.\n");
	fprintf(stderr, "  -v, --variable <variable>  the variable name to hold the input value\n");
	fprintf(stderr, "  -l, --limit <max_procs>    the maximum number of processes to spawn at one time\n");
	fprintf(stderr, "  -f, --file <file>          execute code read from <file> (default: stdin)\n");
	printf("\n\n");
	return;
} 

/* this won't be used outside of this file */
void init_cmdargs( struct cmdargs * );

#include <getopt.h>

/** long option structure list */
static struct option long_options[] = {
	{"help", no_argument, 0, 'h'},
	{"verbose", no_argument, 0, 'V'},
	{"variable", required_argument, 0, 'v'},
	{"limit", required_argument, 0, 'l'},
	{"file", required_argument, 0, 'f'},
	{0, 0, 0, 0}
};

/** parses commandline arguments and puts the info into a cmdargs struct.
 * @param argc number of arguments
 * @param argv array of argument strings
 * @param args structure to hold the parsed options & arguments
 */
void parse_args ( int argc, char **argv, struct cmdargs *args){
  int c, option_index=0;

  init_cmdargs(args);

  while( (c = getopt_long(argc, argv, "hVv:l:f:", long_options, &option_index)) != -1 ){
    switch (c) {
      case '0':
        if ( long_options[option_index].flag != 0 )
          break;
			case 'h':
				args->help = 1;
				break;
			case 'V':
				args->verbose = 1;
				break;
			case 'v':
				args->variable = optarg;
				break;
			case 'l':
				args->max_procs = optarg;
				break;
			case 'f':
				args->file = optarg;
				break;
			default: break;
		}
	}
	return;
}


/** @brief initializes all elements in the cmdargs struct to NULL or 0.
 *  @param args pointer to the argument structure to be cleared out.
 */
void init_cmdargs( struct cmdargs *args ){
  /* this set all pointers to null, int values to 0 */
  memset( args, 0, sizeof(struct cmdargs) );
}

/** @brief prints application version.
  */
void version ( void ){
  fprintf(stderr, "%s\n", APPLICATION_VERSION);
}

