/************************************
  copyright 2009

 ************************************/

/** @file fieldsplit_main.h
 *  @brief defines structure to hold command-line arguments and protypes
 *  some functions.
 *
 *  generated by cgener.  http://code.google.com/p/cgener/
 */

#ifdef __cplusplus
extern "C" {
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

#ifndef FIELDSPLIT_MAIN_H
#define FIELDSPLIT_MAIN_H

/* user-defined things in arg table */

/* end user-defined things */

/** exit code to use when invoked with usage() or version(). */
#define EXIT_HELP 1
/** exit code to use when everything was okay. */
#define EXIT_OKAY 0
/** exit code to use when there was an i/o-related error. */
#define EXIT_FILE_ERR -1
/** exit code to use when there was an error allocating memory. */
#define EXIT_MEM_ERR -2

/** current version of the application. */
#define APPLICATION_VERSION "2.1"
/** short description of what the app does. */
#define APPLICATION_DESCRIPTION "splits a file into multiple files according to a particular field value."

/** structure to hold commandline options & arguments.
 */
struct cmdargs {
	int help;	/**< @brief print this message and exit */
	int version;	/**< @brief print version info and exit */
	char *field;	/**< @brief index of field to split on */
	char *field_label;	/**< @brief label of field to split on */
	char *delim;	/**< @brief field separator string (default: 0xfe) */
	char *path;	/**< @brief directory in which output files should be placed (default: ./) */
	char *name;	/**< @brief output file prefix */
	char *suffix;	/**< @brief output file suffix */
	int keep_header;	/**< @brief preserve the input header row in all output files */
	char *buffer_line_count;	/**< @brief line buffer size - DEPRECATED. */
	char *buckets;	/**< @brief split data into BUCKETS files, guaranteeing that like field values are in the same output file. */
	char *xform_names;	/**< @brief user-supplied substitution regex to transform output names (e.g. 's/[^-\w]//g') */
};


/** parses commandline arguments and puts the info into a cmdargs struct.
 * @param argc number of arguments
 * @param argv array of argument strings
 * @param args structure to hold the parsed options & arguments
 */
void parse_args ( int, char **, struct cmdargs *);

/** prints application help information.
 * @param bin application name as invoked on the commandline
 */
void usage ( char * );

/** @brief prints application version.
  */
void version ( void );

/** @brief beginning of primary application logic section called by main().
  * 
  * @param args contains the parsed cmd-line options & arguments.
  * @param argc number of cmd-line arguments.
  * @param argv list of cmd-line arguments
  * @param optind index of the first non-option cmd-line argument.
  * 
  * @return exit status for main() to return.
  */
int fieldsplit( struct cmdargs *args, int argc, char *argv[], int optind );

#endif

#ifdef __cplusplus
}
#endif
