/************************************
  
   Copyright 2008 Google Inc.

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.

 ************************************/

/** @file usage.c
 *  @brief contains functions for parsing arguments and printing usage info.
 *
 *  generated by cgener.  http://code.google.com/p/cgener/
 */


#ifdef HAVE_CONFIG_H
# include <config.h>
#endif
#include "buffer_main.h"

/** prints application help information.
 * @param bin application name as invoked on the commandline
 */
void usage( char *bin ) {
  fprintf(stderr, "\nbuffer: buffers all input and prints it out all at once.\n");
  fprintf(stderr, "\nusage: %s <options> [input-file(s)] \n", bin);
  fprintf(stderr, "options:\n");
	fprintf(stderr, "  -h, --help   print this message and exit\n");
	fprintf(stderr, "  -o <output>  specifies output file for writing\n");
	fprintf(stderr, "  -a           specifies if the output file should be appended to\n");
	fprintf(stderr, "\n\n  This is useful if the output should go to one of the input files.\n\n  * If no files are specified, stdin is used for input, and stdout for output.\n  * Warning: this has potential to consume large amounts of memory.\n\n  NOTE: When redirecting output, your shell may open the target file for writing\n        before the processes begin executing.  so using the '-o' option is safer\n        than redirecting to a file.\n");
	printf("\n\n");
	return;
} 

/* this won't be used outside of this file */
void init_cmdargs( struct cmdargs * );

#include <getopt.h>

/** long option structure list */
static struct option long_options[] = {
	{"help", no_argument, 0, 'h'},
	{"", required_argument, 0, 'o'},
	{"", no_argument, 0, 'a'},
	{0, 0, 0, 0}
};

/** parses commandline arguments and puts the info into a cmdargs struct.
 * @param argc number of arguments
 * @param argv array of argument strings
 * @param args structure to hold the parsed options & arguments
 */
void parse_args ( int argc, char **argv, struct cmdargs *args){
  int c, option_index=0;

  init_cmdargs(args);

  while( (c = getopt_long(argc, argv, "ho:a", long_options, &option_index)) != -1 ){
    switch (c) {
      case '0':
        if ( long_options[option_index].flag != 0 )
          break;
			case 'h':
				args->help = 1;
				break;
			case 'o':
				args->output = optarg;
				break;
			case 'a':
				args->append = 1;
				break;
			default: break;
		}
	}
	return;
}


/** @brief initializes all elements in the cmdargs struct to NULL or 0.
 *  @param args pointer to the argument structure to be cleared out.
 */
void init_cmdargs( struct cmdargs *args ){
  /* this set all pointers to null, int values to 0 */
  memset( args, 0, sizeof(struct cmdargs) );
}

/** @brief prints application version.
  */
void version ( void ){
  fprintf(stderr, "%s\n", APPLICATION_VERSION);
}

