/************************************
     Copyright 2008 Google Inc.

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.

 ************************************/

/** @file usage.c
 *  @brief contains functions for parsing arguments and printing usage info.
 *
 *  generated by cgener.  http://code.google.com/p/cgener/
 */


#ifdef HAVE_CONFIG_H
# include <config.h>
#endif
#include "aggregate_main.h"

/** prints application help information.
 * @param bin application name as invoked on the commandline
 */
void usage( char *bin ) {
  fprintf(stderr, "\naggregate: aggregates data from delimited files\n");
  fprintf(stderr, "\nusage: %s <options> [file ...] \n", bin);
  fprintf(stderr, "options:\n");
	fprintf(stderr, "  -h, --help                   print this message and exit\n");
	fprintf(stderr, "  -V, --version                print version info and exit\n");
	fprintf(stderr, "  -v, --verbose                print verbose messages during execution\n");
	fprintf(stderr, "  -k, --keys <keys>            cells for aggregation levels & output\n");
	fprintf(stderr, "  -K, --key-labels <key_labels>\n                               labels of fields for aggregation levels & output\n");
	fprintf(stderr, "  -s, --sum-fields <sums>      fields of numeric values to be summed\n");
	fprintf(stderr, "  -S, --sum-labels <sum_labels>\n                               labels of numeric fields to be summed\n");
	fprintf(stderr, "  -a, --average-fields <averages>\n                               fields of numeric values to be averaged\n");
	fprintf(stderr, "  -A, --average-labels <average_labels>\n                               labels of numeric fields to be averaged\n");
	fprintf(stderr, "  -c, --count-fields <counts>  fields to be counted if non-blank\n");
	fprintf(stderr, "  -C, --count-label <count_labels>\n                               labels of fields to be counted if non-blank\n");
	fprintf(stderr, "  -n, --mins <mins>            report the minimum values at the indexes\n");
	fprintf(stderr, "  -N, --min-labels <min_labels>\n                               report the minimum values at the labels\n");
	fprintf(stderr, "  -x, --maxs <maxs>            report the maximum values at the indexes\n");
	fprintf(stderr, "  -X, --max-labels <max_labels>\n                               report the maximum values at the labels\n");
	fprintf(stderr, "  -d, --delim <delim>          field separator string (default: 0xfe)\n");
	fprintf(stderr, "  -p, --preserve-header        specifies that the first line of input should not\n                               be included in the aggregation\n");
	fprintf(stderr, "  -r, --no-sort                specifies that the output need not be sorted.\n");
	fprintf(stderr, "  -l, --labels <labels>        delimiter-separated list of labels for the\n                               aggregation fields (default: unchanged)\n");
	fprintf(stderr, "  -L, --auto-label             add \"-Sum\", \"-Count\", and \"-Average\" suffixes\n                               to aggregation fields\n");
	fprintf(stderr, "\nAll column indexes are 1-based.  Either -k or -K must be specified.\n\nThe use of label options -K, -S, -A, or -C implies that the header row should\nbe preserved (-p).");
	printf("\n\n");
	return;
} 

/* this won't be used outside of this file */
void init_cmdargs( struct cmdargs * );

#include <getopt.h>

/** long option structure list */
static struct option long_options[] = {
	{"help", no_argument, 0, 'h'},
	{"version", no_argument, 0, 'V'},
	{"verbose", no_argument, 0, 'v'},
	{"keys", required_argument, 0, 'k'},
	{"key-labels", required_argument, 0, 'K'},
	{"sum-fields", required_argument, 0, 's'},
	{"sum-labels", required_argument, 0, 'S'},
	{"average-fields", required_argument, 0, 'a'},
	{"average-labels", required_argument, 0, 'A'},
	{"count-fields", required_argument, 0, 'c'},
	{"count-label", required_argument, 0, 'C'},
	{"mins", required_argument, 0, 'n'},
	{"min-labels", required_argument, 0, 'N'},
	{"maxs", required_argument, 0, 'x'},
	{"max-labels", required_argument, 0, 'X'},
	{"delim", required_argument, 0, 'd'},
	{"preserve-header", no_argument, 0, 'p'},
	{"no-sort", no_argument, 0, 'r'},
	{"labels", required_argument, 0, 'l'},
	{"auto-label", no_argument, 0, 'L'},
	{0, 0, 0, 0}
};

/** parses commandline arguments and puts the info into a cmdargs struct.
 * @param argc number of arguments
 * @param argv array of argument strings
 * @param args structure to hold the parsed options & arguments
 */
void parse_args ( int argc, char **argv, struct cmdargs *args){
  int c, option_index=0;

  init_cmdargs(args);

  while( (c = getopt_long(argc, argv, "hVvk:K:s:S:a:A:c:C:n:N:x:X:d:prl:L", long_options, &option_index)) != -1 ){
    switch (c) {
      case '0':
        if ( long_options[option_index].flag != 0 )
          break;
			case 'h':
				args->help = 1;
				break;
			case 'V':
				args->version = 1;
				break;
			case 'v':
				args->verbose++;;
				break;
			case 'k':
				args->keys = optarg;
				break;
			case 'K':
				args->key_labels = optarg;
				break;
			case 's':
				args->sums = optarg;
				break;
			case 'S':
				args->sum_labels = optarg;
				break;
			case 'a':
				args->averages = optarg;
				break;
			case 'A':
				args->average_labels = optarg;
				break;
			case 'c':
				args->counts = optarg;
				break;
			case 'C':
				args->count_labels = optarg;
				break;
			case 'n':
				args->mins = optarg;
				break;
			case 'N':
				args->min_labels = optarg;
				break;
			case 'x':
				args->maxs = optarg;
				break;
			case 'X':
				args->max_labels = optarg;
				break;
			case 'd':
				args->delim = optarg;
				break;
			case 'p':
				args->preserve = 1;
				break;
			case 'r':
				args->nosort = 1;
				break;
			case 'l':
				args->labels = optarg;
				break;
			case 'L':
				args->auto_label = 1;
				break;
			default: break;
		}
	}
	return;
}


/** @brief initializes all elements in the cmdargs struct to NULL or 0.
 *  @param args pointer to the argument structure to be cleared out.
 */
void init_cmdargs( struct cmdargs *args ){
  /* this set all pointers to null, int values to 0 */
  memset( args, 0, sizeof(struct cmdargs) );
}

/** @brief prints application version.
  */
void version ( void ){
  fprintf(stderr, "%s\n", APPLICATION_VERSION);
}

