/************************************
     Copyright 2008 Google Inc.

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.

 ************************************/

/** @file aggregate_main.h
 *  @brief defines structure to hold command-line arguments and protypes
 *  some functions.
 *
 *  generated by cgener.  http://code.google.com/p/cgener/
 */

#ifdef __cplusplus
extern "C" {
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

#ifndef AGGREGATE_MAIN_H
#define AGGREGATE_MAIN_H

/* user-defined things in arg table */
#include <crush/crush_version.h>
/* end user-defined things */

/** exit code to use when invoked with usage() or version(). */
#define EXIT_HELP 1
/** exit code to use when everything was okay. */
#define EXIT_OKAY 0
/** exit code to use when there was an i/o-related error. */
#define EXIT_FILE_ERR -1
/** exit code to use when there was an error allocating memory. */
#define EXIT_MEM_ERR -2

/** current version of the application. */
#define APPLICATION_VERSION ""CRUSH_PACKAGE_VERSION""
/** short description of what the app does. */
#define APPLICATION_DESCRIPTION "aggregates data from delimited files"

/** structure to hold commandline options & arguments.
 */
struct cmdargs {
	int help;	/**< @brief print this message and exit */
	int version;	/**< @brief print version info and exit */
	int verbose;	/**< @brief print verbose messages during execution */
	char *keys;	/**< @brief cells for aggregation levels & output */
	char *key_labels;	/**< @brief labels of fields for aggregation levels & output */
	char *sums;	/**< @brief fields of numeric values to be summed */
	char *sum_labels;	/**< @brief labels of numeric fields to be summed */
	char *averages;	/**< @brief fields of numeric values to be averaged */
	char *average_labels;	/**< @brief labels of numeric fields to be averaged */
	char *counts;	/**< @brief fields to be counted if non-blank */
	char *count_labels;	/**< @brief labels of fields to be counted if non-blank */
	char *mins;	/**< @brief report the minimum values at the indexes */
	char *min_labels;	/**< @brief report the minimum values at the labels */
	char *maxs;	/**< @brief report the maximum values at the indexes */
	char *max_labels;	/**< @brief report the maximum values at the labels */
	char *delim;	/**< @brief field separator string (default: 0xfe) */
	int preserve;	/**< @brief specifies that the first line of input should not be included in the aggregation */
	int nosort;	/**< @brief specifies that the output need not be sorted. */
	char *labels;	/**< @brief delimiter-separated list of labels for the aggregation fields (default: unchanged) */
	int auto_label;	/**< @brief add \"-Sum\", \"-Count\", and \"-Average\" suffixes to aggregation fields */
};


/** parses commandline arguments and puts the info into a cmdargs struct.
 * @param argc number of arguments
 * @param argv array of argument strings
 * @param args structure to hold the parsed options & arguments
 */
void parse_args ( int, char **, struct cmdargs *);

/** prints application help information.
 * @param bin application name as invoked on the commandline
 */
void usage ( char * );

/** @brief prints application version.
  */
void version ( void );

/** @brief beginning of primary application logic section called by main().
  * 
  * @param args contains the parsed cmd-line options & arguments.
  * @param argc number of cmd-line arguments.
  * @param argv list of cmd-line arguments
  * @param optind index of the first non-option cmd-line argument.
  * 
  * @return exit status for main() to return.
  */
int aggregate( struct cmdargs *args, int argc, char *argv[], int optind );

#endif

#ifdef __cplusplus
}
#endif
