/* This file was modified in 2000-2002 by David Gay, Jeff Foster, and
   Simon Goldsmith
   for cqual.  The changes are Copyright (c) 2000-2002 The Regents of
   the University of California.

   This file is distributed under the terms of the GNU General Public License
   (see below).  */
/* Top level of GNU C compiler
   Copyright (C) 1987, 88, 89, 92-7, 1998 Free Software Foundation, Inc.

This file is part of GNU CC.

GNU CC is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

GNU CC is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU CC; see the file COPYING.  If not, write to
the Free Software Foundation, 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */

#include <stdio.h>
#include <string.h>
#include "parser.h"
#include "config.h"
#include "input.h"
#include "semantics.h"
#include "c-parse.h"

extern int do_parse() deletes;  /* in c-parse.y */

/* for the RC parser, a wrapper to factor some parsing stuff */

/* Print a fatal error message.  NAME is the text.
   Also include a system error message based on `errno'.  */
static void pfatal_with_name(const char *name)
{
  fprintf(stderr, "%s: ", progname);
  perror(name);
  exit(FATAL_EXIT_CODE);
}


int parse(char *name)
{
  FILE *ifile;
  int result;

#if !USE_CPPLIB
  /* Open input file.  */

  if (name == 0 || !strcmp (name, "-"))
    {
      ifile = stdin;
      name = "stdin";
    }
  else
    ifile = fopen (name, "r");
  if (ifile == 0)
    pfatal_with_name (name);

#ifdef IO_BUFFER_SIZE
  setvbuf(ifile, (char *) xmalloc (IO_BUFFER_SIZE), _IOFBF, IO_BUFFER_SIZE);
#endif
#endif /* !USE_CPPLIB */

  set_input(ifile, name);
  init_lex(); /* needs to go before init_semantics, since inits
				 dummy_location */
  init_semantics();

  result = do_parse();
  fclose(ifile);
  
  if (orig_main_input_filename == NULL)
    orig_main_input_filename = name;

  return result;
}
