/* This file is part of cqual.
   Copyright (C) 2003 The Regents of the University of California.

cqual is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

cqual is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with cqual; see the file COPYING.  If not, write to
the Free Software Foundation, 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA. */

/**************************************************************************
 *                                                                        *
 * Low-level PAM communication                                            *
 *                                                                        *
 **************************************************************************/

void init_pam_generic(void);

void pam_clear_buffer(const char *);      /* Erase the buffer contents */
void pam_change_buffer(const char *);     /* Switch to the buffer */
void pam_set_lower_buffer(const char *);   /* ? */
void pam_set_upper_buffer(const char *);     /* ? */
void pam_close_buffer(const char *);      /* Close (delete?) the buffer */
void pam_split_buffer(const char *);      /* ? */
void pam_goto_char_buffer(const char *, unsigned long);
                                          /* Go to character pos in a buffer */
void pam_goto_anchor_buffer(const char *, const char *);
                                          /* Go to anchor in a buffer */

void pam_clear_file(const char *);        /* See above */
void pam_change_file(const char *);
void pam_set_lower_file(const char *);
void pam_set_upper_file(const char *);
void pam_close_file(const char *);
void pam_split_file(const char *);
void pam_goto_char_file(const char *, unsigned long);
void pam_goto_anchor_file(const char *, const char *);
void pam_add_anchor(const char *name, int start, int end);


int pam_waiting(void);                  /* Tell PAM we've finished dealing
					   with the last action and we're
					   waiting for a click */
void pam_debug(const char *, ...);        /* Print a debugging message */
int pam_message(const char *, ...);       /* Print a text message */
void pam_default_path(const char *);      /* Set the default path */

void pam_blobs_begin(void);               /* Begin printing marked-up text */
void pam_blobs_end(void);                 /* End printing marked-up text */
void pam_overlays_begin(void);            /* Begin marking-up file */
void pam_overlays_end(void);              /* End marking-up file */

void pam_markup_file(const char *f);      /* Start marking up file f */
void pam_markup_buffer(const char *b);    /* Start marking up buffer b */


/* Add some text to a mark-up */
int pam_add_text(const char *, ...);

/* Add a hyperlink to a markup.  ``text'' is displayed marked up with
   color.  ``name'' is the internal name of the hyperlink. */
void pam_add_link(const char *name, const char *color, const char *text);

/* Add some marked-up text -- no link */
void pam_add_marked_text(const char *color, const char *text);

/* Add a hyperlink on top of some text.  The text to add a link to
   ranges from positions start-end in the current markup buffer, and
   is marked up with color.  ``name'' is the internal name of the
   hyperlink. */
void pam_add_overlink(const char *name, const char *color, int start, int end);

void pam_add_overlink_anchor(const char *name, const char *anchor_name,
			     const char *color, int start, int end);

/* Add a color on top of some text -- no link */
void pam_add_overmark(const char *color, int start, int end);
