/****************************************************************************
 *
 *  Filename: cpia2stv_image.h
 *
 *  Copyright 2001, STMicrolectronics, Inc.
 *
 *  Description:
 *     Definitions for image parameters, including jpeg header stuff.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 * 
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 ****************************************************************************/
/* $Id: cpia2_jpeg.h,v 1.2 2001/09/02 17:47:49 sbertin Exp $ */

#ifndef STV_IMAGE_HEADER
#define STV_IMAGE_HEADER

/****
 * JPEG header info 
 ****/
/*  Definition of start of frame markers */
/* Non-differencial Huffman-coding frames */
#define JPEG_SOF_0  0xC0	/* Baseline DCT                        */
#define JPEG_SOF_1  0xC1	/* Extended sequential DCT             */
#define JPEG_SOF_2  0xC2	/* Progressive DCT                     */
#define JPEG_SOF_3  0xC3	/* Lossless (sequential) */

/* Differential Huffman encoding...*/
#define JPEG_SOF_5  0xC5	/* Differential sequential DCT   */
#define JPEG_SOF_6  0xC6	/* Differential progressive DCT   */
#define JPEG_SOF_7  0xC7	/* Differential lossless          */

/* Nondifferential arithmetic-coding frames...  */
#define JPEG_SOF_9  0xC9	/* Extended sequential DCT        */
#define JPEG_SOF_10 0xCA	/* Progressive DCT                */
#define JPEG_SOF_11 0xCB	/* Lossless (sequential)          */

/* Differential arithmetic-coding frames...  */
#define JPEG_SOF_13 0xCD	/* Differential sequential        */
#define JPEG_SOF_14 0xCE	/* Differential progressive       */
#define JPEG_SOF_15 0xCF	/* Differential lossless          */

/* DEFINITION OF NON START OF FRAME MARKERS */
#define JPEG_APP_2  0xE2	/* CPIA Insert Frame */
#define JPEG_COM    0xFE	/* JPEG Comment */
#define JPEG_DAC    0xCC	/* Define arithmetic conditioning table */
#define JPEG_DHP    0xDE	/* Define heirarchical progression */
#define JPEG_DHT    0xC4	/* Define Huffman table(s) */
#define JPEG_DNL    0xDC	/* Define number of lines  */
#define JPEG_DQT    0xDB	/* Define quantisation table(s) */
#define JPEG_DRI    0xDD	/* Define restart interval */
#define JPEG_EOI    0xD9	/* End of image */
#define JPEG_EXP    0xDF	/* Expand reference image(s) */
#define JPEG_RST_0  0xD0	/* Restart with modulo-8 counter 0 */
#define JPEG_RST_1  0xD1	/* Restart with modulo-8 counter 1 */
#define JPEG_RST_2  0xD2	/* Restart with modulo-8 counter 2 */
#define JPEG_RST_3  0xD3	/* Restart with modulo-8 counter 3 */
#define JPEG_RST_4  0xD4	/* Restart with modulo-8 counter 4 */
#define JPEG_RST_5  0xD5	/* Restart with modulo-8 counter 5 */
#define JPEG_RST_6  0xD6	/* Restart with modulo-8 counter 6 */
#define JPEG_RST_7  0xD7	/* Restart with modulo-8 counter 7 */
#define JPEG_SOI    0xD8	/* Start of image */
#define JPEG_SOS    0xDA	/* Start of scan */
#define JPEG_TEM    0x01	/* temporary use in arithmetic coding NL */

/***
 *  Definition of jpeg standard structures
 */
typedef struct {
	unsigned char app[2];	/* Segment ID - should be FFC0 (for baseline DCT) */
	unsigned char length[2];	/* Length of frame header */
	unsigned char sample_precision;	/* Sample precision */
	unsigned char line_count[2];	/* Number of lines */
	unsigned char samples_per_line[2];	/* Number of samples/line */
	unsigned char comp_per_frame;	/* Number of components in frame */
	unsigned char component_id;	/* Component identifier */
	unsigned char h_and_v_samp_factor;	/* 4:4 = horiz:vert sampling factor */
	unsigned char qtable_dsel;	/* Quantisation table destination selector */
} jpeg_frame_header;

typedef struct {
	unsigned char sig[2];	/* Segment ID - should be FFDA */
	unsigned char length[2];	/* Length of scan header */
	unsigned char components_in_scan;	/* Number of components in scan */
	unsigned char scan_csel;	/* Scan component selector */
	unsigned char dc_ac_entropy;	/* 4:4 = DC:AC entropy coding table selector */
	unsigned char spec_start;	/* Start of spectral selection or 
					   predictor selection */
	unsigned char spec_end;	/* End of spectral selection */
	unsigned char s_a_b_pos;	/* 4:4 = low:high successive approximation bit position */
} jpeg_scan_header;

typedef struct {
	unsigned char app_sig[2];	/* Segment ID - should be FFE2 */
	unsigned char app_len[2];	/* Length of CPIA2 info */
	unsigned char app_vvl[3];	/* Segment ID, should be VVL */
	unsigned char app_version;	/* Bit7 = DoubleSqueezeEnabled,
					   bits3:0 = Compression revision */
	unsigned char app_dc_squeeze;	/* DC squeeze */
	unsigned char app_ac_squeeze;	/* AC squeeze */
	unsigned char app_sent_kb;	/* Total number of bytes??? in the
					   last frame */
	unsigned char app_zz01_cnt;	/* Bits5:0 = zz01cnt, bit7 = ival_aborted */
	unsigned char app_zz03_cnt;	/* zz03cnt */
	unsigned char app_zz06_cnt;	/* zz06cnt */
	unsigned char app_zz10_cnt;	/* zz10cnt */
	unsigned char app_zzdb_cnt;	/* zzDBcnt */
} jpeg_vvl_app2;

typedef struct {
	unsigned char sig[2];	/* Segment ID - should be FFDD */
	int length;		/* Length of Restart Interval structure */
	int interval;		/* Restart interval; */
} jpeg_restart_interval;


#define JPEG_LOGQP1			5
#define JPEG_QFACTOR		(1<<(JPEG_LOGQP1-1))

#define JPEG_IZ_TABLE_MAX	64
#define JPEG_Q_TABLE_MAX	64


/********
 * Tables
 ********/
short int jpeg_iz[JPEG_IZ_TABLE_MAX] = {
	00, 1, 8, 16, 9, 2, 3, 10,
	17, 24, 32, 25, 18, 11, 4, 5,
	12, 19, 26, 33, 40, 48, 41, 34,
	27, 20, 13, 6, 7, 14, 21, 28,
	35, 42, 49, 56, 57, 50, 43, 36,
	29, 22, 15, 23, 30, 37, 44, 51,
	58, 59, 52, 45, 38, 31, 39, 46,
	53, 60, 61, 54, 47, 55, 62, 63
};

short int jpeg_lq_table[JPEG_Q_TABLE_MAX] = {
	16, 11, 10, 16, 24, 40, 51, 61,
	12, 12, 14, 19, 26, 58, 60, 55,
	14, 13, 16, 24, 40, 57, 69, 56,
	14, 17, 22, 29, 51, 87, 80, 62,
	18, 22, 37, 56, 68, 109, 103, 77,
	24, 35, 55, 64, 81, 104, 113, 92,
	49, 64, 78, 87, 103, 121, 120, 101,
	72, 92, 95, 98, 112, 100, 103, 99
};

short int jpeg_cq_table[JPEG_Q_TABLE_MAX] = {
	17, 18, 24, 47, 99, 99, 99, 99,
	18, 21, 26, 66, 99, 99, 99, 99,
	24, 26, 56, 99, 99, 99, 99, 99,
	47, 66, 99, 99, 99, 99, 99, 99,
	99, 99, 99, 99, 99, 99, 99, 99,
	99, 99, 99, 99, 99, 99, 99, 99,
	99, 99, 99, 99, 99, 99, 99, 99,
	99, 99, 99, 99, 99, 99, 99, 99
};


unsigned char jpeg_vvl_dhtseg[] = {
	0xff, 0xc4, 0x01, 0xa2, 0x00, 0x00, 0x01, 0x05, 0x01, 0x01,
	0x01, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08,
	0x09, 0x0a, 0x0b, 0x10, 0x00, 0x02, 0x01, 0x03, 0x03, 0x02,
	0x04, 0x03, 0x05, 0x05, 0x04, 0x04, 0x00, 0x00, 0x01, 0x7d,
	0x01, 0x02, 0x03, 0x00, 0x04, 0x11, 0x05, 0x12, 0x21, 0x31,
	0x41, 0x06, 0x13, 0x51, 0x61, 0x07, 0x22, 0x71, 0x14, 0x32,
	0x81, 0x91, 0xa1, 0x08, 0x23, 0x42, 0xb1, 0xc1, 0x15, 0x52,
	0xd1, 0xf0, 0x24, 0x33, 0x62, 0x72, 0x82, 0x09, 0x0a, 0x16,
	0x17, 0x18, 0x19, 0x1a, 0x25, 0x26, 0x27, 0x28, 0x29, 0x2a,
	0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x3a, 0x43, 0x44, 0x45,
	0x46, 0x47, 0x48, 0x49, 0x4a, 0x53, 0x54, 0x55, 0x56, 0x57,
	0x58, 0x59, 0x5a, 0x63, 0x64, 0x65, 0x66, 0x67, 0x68, 0x69,
	0x6a, 0x73, 0x74, 0x75, 0x76, 0x77, 0x78, 0x79, 0x7a, 0x83,
	0x84, 0x85, 0x86, 0x87, 0x88, 0x89, 0x8a, 0x92, 0x93, 0x94,
	0x95, 0x96, 0x97, 0x98, 0x99, 0x9a, 0xa2, 0xa3, 0xa4, 0xa5,
	0xa6, 0xa7, 0xa8, 0xa9, 0xaa, 0xb2, 0xb3, 0xb4, 0xb5, 0xb6,
	0xb7, 0xb8, 0xb9, 0xba, 0xc2, 0xc3, 0xc4, 0xc5, 0xc6, 0xc7,
	0xc8, 0xc9, 0xca, 0xd2, 0xd3, 0xd4, 0xd5, 0xd6, 0xd7, 0xd8,
	0xd9, 0xda, 0xe1, 0xe2, 0xe3, 0xe4, 0xe5, 0xe6, 0xe7, 0xe8,
	0xe9, 0xea, 0xf1, 0xf2, 0xf3, 0xf4, 0xf5, 0xf6, 0xf7, 0xf8,
	0xf9, 0xfa, 0x01, 0x00, 0x03, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x01, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0a,
	0x0b, 0x11, 0x00, 0x02, 0x01, 0x02, 0x04, 0x04, 0x03, 0x04,
	0x07, 0x05, 0x04, 0x04, 0x00, 0x01, 0x02, 0x77, 0x00, 0x01,
	0x02, 0x03, 0x11, 0x04, 0x05, 0x21, 0x31, 0x06, 0x12, 0x41,
	0x51, 0x07, 0x61, 0x71, 0x13, 0x22, 0x32, 0x81, 0x08, 0x14,
	0x42, 0x91, 0xa1, 0xb1, 0xc1, 0x09, 0x23, 0x33, 0x52, 0xf0,
	0x15, 0x62, 0x72, 0xd1, 0x0a, 0x16, 0x24, 0x34, 0xe1, 0x25,
	0xf1, 0x17, 0x18, 0x19, 0x1a, 0x26, 0x27, 0x28, 0x29, 0x2a,
	0x35, 0x36, 0x37, 0x38, 0x39, 0x3a, 0x43, 0x44, 0x45, 0x46,
	0x47, 0x48, 0x49, 0x4a, 0x53, 0x54, 0x55, 0x56, 0x57, 0x58,
	0x59, 0x5a, 0x63, 0x64, 0x65, 0x66, 0x67, 0x68, 0x69, 0x6a,
	0x73, 0x74, 0x75, 0x76, 0x77, 0x78, 0x79, 0x7a, 0x82, 0x83,
	0x84, 0x85, 0x86, 0x87, 0x88, 0x89, 0x8a, 0x92, 0x93, 0x94,
	0x95, 0x96, 0x97, 0x98, 0x99, 0x9a, 0xa2, 0xa3, 0xa4, 0xa5,
	0xa6, 0xa7, 0xa8, 0xa9, 0xaa, 0xb2, 0xb3, 0xb4, 0xb5, 0xb6,
	0xb7, 0xb8, 0xb9, 0xba, 0xc2, 0xc3, 0xc4, 0xc5, 0xc6, 0xc7,
	0xc8, 0xc9, 0xca, 0xd2, 0xd3, 0xd4, 0xd5, 0xd6, 0xd7, 0xd8,
	0xd9, 0xda, 0xe2, 0xe3, 0xe4, 0xe5, 0xe6, 0xe7, 0xe8, 0xe9,
	0xea, 0xf2, 0xf3, 0xf4, 0xf5, 0xf6, 0xf7, 0xf8, 0xf9, 0xfa
};

#endif
