/*
 * This file is part of cparser.
 * Copyright (C) 2007-2009 Matthias Braun <matze@braunis.de>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */
#ifndef SYMBOL_T_H
#define SYMBOL_T_H

#include <stdbool.h>
#include "symbol.h"
#include "entity.h"
#include "token_t.h"

struct symbol_t {
	char const      *string;
	unsigned short   ID;
	pp_token_kind_t  pp_ID;
	entity_t        *entity;
	pp_definition_t *pp_definition;
};

#endif
