package gui

import (
	"fmt"

	"github.com/coyim/gotk3adapter/gdki"
)

var mucIcon = map[string]*icon{
	"room": {
		size:   "40x32",
		width:  40,
		height: 32,
		encoded: "" +
			"89504e470d0a1a0a0000000d494844520000002800000020080600000060ad3a0000000009704859" +
			"7300000b1300000b1301009a9c18000000017352474200aece1ce90000000467414d410000b18f0b" +
			"fc61050000077b494441547801c5987d6c14c715c0dfeceeedddf96c7c8e6b1bec733953b043a8c0" +
			"f42a11a100e756ad02252a091669aaaaa0aaa29f44a85525d2088528244da5446a52350d2d7fb855" +
			"1ba92d884ba968abaab113910f45109f23128c71ec030ece1f1ce78ff3dddeeece4ee663777d476c" +
			"7321903c693dbbb36fe6fdf6bd376fe68ca00c799e9cf036e5fd75793f593a09d3ea553c55610096" +
			"4dd065f65e01150788aa7b40c12da4711a4c23b9bda22309b740d0422f8fe6ba430caa1f5fac3d6d" +
			"f467df266767d264ca841bc866695df5064f7bb05eaebaea0314ff0eda320537297302fe85bcb5c8" +
			"80c975af16fa3cc7add7d3e540cd27bbe4cd0df77857656f16f42380b1c26b779d928796ff5e3f36" +
			"fa49c0ae979fa8db839bacd5a91dde8def7f9c7125807f26dd5ffea779f28e23fa2b69b80df2a0fc" +
			"95da6f48ebae7d57fdfaa972c7b88047f593773f8bffa1be61bd3b03b751d64bab033f931f9cee54" +
			"d7f796a32fb13f2ce77aa4bebadb0dc784d97855ea0d1d25dda172f439e0553df5b5df168e5c814f" +
			"4998ad61737c6539baca31edff5ff883f5bf0cdc02094a81aa46541b51912752003da213a3d24478" +
			"896b8cc82905c9293ff806baadf8e08bda91c40f7d9de7179a131d26ffddf8fddcd3f386f6c7f27d" +
			"8d4faabb1f0ba240244bb4817dfaa19fff0ebf9c2ad65921354502e08b2e922ab63ea7eca96a9796" +
			"439c0cc2fd85fd90b0842a42b3eb91100201c94f3648abd10ce4bbaad445074ea0272fcc09f82be3" +
			"a57b1fd1ff383e1fe0b4ffc44b95c8d7ea3c4f90e9d335f96ffec0f158982cde9d22e987c6c83578" +
			"a7e230b4a3e5eed81e1c870e6d2f41148f502cde523806cb9edb50331ab092104275b04c5edce5d7" +
			"028fffa7e6e944b17d691265fdb08014c371285415616d182d6eadc58bfefa1e1efed618a61962a1" +
			"12382651b91d10a63416f504bd684b10c50471cfc7b03689c7e1943eb0ebb23cd27d6f665fb80410" +
			"6e20cc63c5cf59d006a8d75a2dd33c3484af2c3131468ec11e335e32368e07693c05188541f63d87" +
			"45ce3316570e17e08c99080fa24bbd5b32bf687701fde0d717027c543ffc38cb3d013b73fa61edf9" +
			"670d6c3c73098f57224ca3650903d4207c6fe6d7020a04ec03d9fd0c90501d578f0112ec7894c6db" +
			"0506aefb8171399880d157b6e41f5dcae6519a48fdf442802fe0e3575ec81fffb6f3bc062f7b2665" +
			"a41bf974769de77fe9d3056b142213bb450721f6bbd9fca32e43eedec07291f5b130133109625df4" +
			"a15fbf58d3007774d1de0ea9465187d8e903ca9015b82932aa67a2e084a8c80ba5179abd48b12e12" +
			"4b98ded742354c1a33ae57dd96f0748033fa70f4becc239ba4eda823f955e54b7239807eecd93a66" +
			"664a610873cc5c90b6317c5d1f96386c08ea61d4c8d8e901620139a0f4ba664e818ecd5d7c91b428" +
			"75677f2a3fd0742340cd30da8a579ff85a7b0130af12c773847b811a428e476c7ddeb6a025705e4b" +
			"727d1662c2e0982e83c5c8cdd711331de580cc8b516fe4d27ae9aec042803a31577083cc63c4f58a" +
			"c8236668365cc8f62eb8abd786af2615f4fcad40ded40898041c28fb8338acfd414437cdb05b663a" +
			"d1fade3dbece5c273d12cd4b681bb66b1b0d1f6d31f7004b70378c6ead73c267876d31d4402da986" +
			"01ea3d3e9656c5d93ca60b8982f1b93138f94b4aeae043a8e3d40eefa6e48fa4fb6be6e2938994e2" +
			"9e62a5838582083064970e27171d60075aa1bb70ab1c02d55060389f72f3cdbdd85cc5055da40e54" +
			"80b74fb91e6207daf83e3d7e2523665bfb49dc57d985ff3deabcab9603a7910e5b59c888f87e644f" +
			"27b65a1a4edac9760bc646545050835c43d76b000de552246f15f83c12888dd9e2b177e701bb1bd8" +
			"14acad5203f1057f34b173223b8a3d81bb92ecf87f67ae29323633f9e22416670b643bc9a963acf5" +
			"2005e8a1016aa56aee8db4310569ba229955bee26d02e06510441f72f66970f59a3d75b0c6b7bc43" +
			"811bc8883c6e5103fcb7494b3034b80e569d7b3bdb7fa76d88933985dab9d2fa2449e01144771c00" +
			"b144c0f6aa703571063955db2ee64287f7b5f81b63b1e6833dca42de1bc0e737fc8bbc39bac7dbd9" +
			"b8d4acd356292bce1fcafe6db3a24bbdfddac5a0880f101b907b44384118414e638bb8610e224422" +
			"12e2a58014bd64744882b0a72111f4faf7960c2e96bf93d7ea248ceed688714d5594cc08643f7818" +
			"6d2938efb70dffb2fd5c3ed93d58b81c74679edddf1c87f27d4d503b7e41420501b8e185a2afa377" +
			"cbd425132b2b9a3b622d4fc5e7052c47b60def0b5fc88d770f1546c2394b13064416b9e174f24944" +
			"95d74fe41c5c8920457643e87f25509bbf2911f6356e3bb6ec893e28f1facd429edd179e02edb1e1" +
			"c2e8cea431cecd22db2bce2a770e0a028aaf60fe6236ba8434abf5a8cd177ace9b370ec4d6fe66a2" +
			"d8c627022c069dc4da810cceee4ceae3308573e01288cdcecd4f6ed4ced1666fc344ab2ff4272ff2" +
			"c4622b0ff6cc35f72d0174417bf706c15b192d584634634dadd1b019368919766a23f5dec4c5c258" +
			"304734cedae26d442bbda1b5b12f3e159f6fce5b0a588e6c3bb37fd7887175e784998db21ad9ecab" +
			"4f7c1ed576c4d696fe1681cf0ad09103e70e7d2e5eb8744f018c4d5e490dd2bdf8e5d8ea83b1ebf5" +
			"3e04af6cf8cfd806dd090000000049454e44ae426082",
	},
	"room-offline": {
		size:   "40x32",
		width:  40,
		height: 32,
		encoded: "" +
			"89504e470d0a1a0a0000000d494844520000002800000020080600000060ad3a0000000009704859" +
			"7300000b1300000b1301009a9c18000000017352474200aece1ce90000000467414d410000b18f0b" +
			"fc610500000740494441547801cd575b6f5cd5155efbcc99197b3c973337db93386450183731a1a4" +
			"759552d450472d5551538948ad445b5589a5aa6a55556ac50fc07d4f1ffa5095f06278404848c801" +
			"1105f140cc030a888b13022164024cec2133e39933f733b773d9ecb5cfc563c797212488657966ce" +
			"d96beff5edf57d6b9d7d080c60e974da0bc3c3715d277b35957a3aedae4f350c17a5860bc7091174" +
			"8f8bf40441d0fd415f0340cba62626b270078c6c3798ce66271054a5da8a56aaf566be58533a5d55" +
			"831d2c39110bc52292e41f7197dc7af7622a95aac36ddaa60059c682aacbf7e3fcaaecce644bf220" +
			"a0b6b2fdfb1263e3a352f37681de02f0462e37b52ab7efbb7c3553f826c036dac1034929110de652" +
			"7b1357becebc7500af2edffcd1f2ca6ae47aa620c35db0fb9263d17bf68c96f7dfb3ebbd41e73800" +
			"bfc8e61ffae0e3654fa15451e02eda582c3cf2fd83c9466af7e8d220fe027ea0e6f272257eb7c1a1" +
			"618c7c5e9ec0021cc49f036c51f7a34b1f2ddf846fc92e332d35ebbd0383f88ae9e5e57de974b102" +
			"77c0884708843c43d3c4254c1bba316d1886dfa034618f0b84e458cfccb944e1da4abe7cfdca9595" +
			"ccd4d49ef4b66b5ef9fce6238b172e6f49ed546af7ae9f3c38f994c7e39e5655edda3b97af3fc932" +
			"90ebf709f97dd384c08cd72d1e3b72782a108f04a154a9c3abe73f807aa3856158335ff3a714c0eb" +
			"1169221e26aaa63d3becf1cefdfae73fbcb1597ca1d96af9601b7bf8d08153080e7fbbdde2e4e183" +
			"fbe69cdd09422018f03da9b43aa757e5daef8f1cbe9f83438b8583f08b871f008a78a801067e1a06" +
			"e8ba0178cd5a1854ea0aace4e493374b72e6c5b317e617ce5d48de0250d3f4e1ed00baddc264ffb5" +
			"0dd6e7f54e7a45e179b95c7fa2d96a03068f4702ebe64e8c47c1608f22c3a0c0d0215213ac618234" +
			"7feb3ccbf9a27cb2d6ea9cdf0852801dacd753dfefbf469a7d5e7152d5d4d3d5ba92d0348db0a818" +
			"1cb2b9f5edb358ae813586d92386e587ff786d7df3ff6e4f85a25c4d96eacda517cfbe75c801e872" +
			"89bded005eb874eddf08ca06fbe6bb9ffca7dd554f551b8a9fd145386d3c0885736fbe0f8c6a3e6f" +
			"25578285d7dfb1c09959b4c1d8fe167030c7cceb72a52ed51aca1b2f9d7d6b2faeb363916c349fd7" +
			"7daa20576798ec515ef8b1fd8983db7a5ffcc68f706804e44ac372e91b60b677d7d8e21f1e7fe428" +
			"c18699feb43099c9976a3b8561e0a61b4aebb4d2ea5a77289eb5d8d64d8ce60fb362cd587cdc8e69" +
			"03e16ec3431e3ea3a9743686e1fbc0f1895da333029edb1289b00b063046c7b146b3ed50c5a9419a" +
			"a98134dada3229d4cda2c06fd357378bc3a05c1623be215e1cba7ddfa69b9af3957607d46eef242f" +
			"127fd0f3c9fd93bb77ef04b0a3f6be67569f25769e222c46469fd94f9ca2700ac1bc027b1c418402" +
			"3e582d55a0af68a8ceab9d6f8c506b8375459911313066319d598d57ebadc097f9ad9fc7ba66a4b0" +
			"9f994450c20c776c71dacf639f2c09250e71ccbc5e3707c50a8eed8bdafd1b95612ec12443ccb5a9" +
			"aaea49d15e27951c5dc2e316e33ebad571cb6a0d68888db70e13035832b4c46809cdc667fff6335a" +
			"0597008562d902c59723968e713edb315f8e6b1707d7f5413ca7dd3b31963d90da13de0c205b2747" +
			"edf6c0a9c006cc6843805c47f8456d4d999432490844a011c9cfef974a55d0717e5f0fe4cd5c5f6b" +
			"45388e3a74b9844b5b1cf96576e4ef1ecaaf96fc573fcb15ecfba240e7b2b9d231ab3ad7ba869905" +
			"d8785f60a783c0c830b845173e9b19659a955fbbea2d56a9250342cc8956bbb977cfd8b3dbbf3431" +
			"a02dda78f4d2879f679becf8ef16607a55ae3eddeef6ac08f496f9eccd0e8698ceb04d60969aacea" +
			"b122c1ee4226915c67768be2d77da0f17728300289b1d05111b6b532282d6234ad7793b1d1d8f568" +
			"d8ffe917cbf9fd2842d27744e9ab6c36a7436bf5266195c9334aedacd96d114199a9b3354c0cabff" +
			"e1a6711f9150e0ccecef1e5b14b7ce5e3a58eb08476e640b85079838fdc3dece78389c7e6df1edc7" +
			"58e0a542b122d9d9308b906f9c5a69226bcd993a15ea70cf4605446e584e64ed21821b8884fc19d1" +
			"37f44f6b68537071f0480fe9d02bbb40a8406ffcb3548ad88f0f78e6f9d70f15e5e279a62b09ac85" +
			"c1ce85a32793526256a303649d2facb520eec7fe629160351e891ffdcb1f7f79714b8083d8ff5f38" +
			"97ac956be74be55a928b9f67c9e18c6790cb8b380580254dec88dcd7f263654e593d11f6429591a2" +
			"d2e37f7de25797ec38b70dd004b990ec2ac65372b571a25a6b5a77fbf56e72ee8004ab230338bd11" +
			"8146a411128f4afff503cccdce1eaff6c7f846001da0f30bc9b6a6cdb594ee894aa3099d4e0ffab8" +
			"a44edd3a41cd4c46a46075342a3d27bac5337ffbd36f16375bfb8e00b46d7e7e416a03cca8ba3ed3" +
			"eef41eec695a929d19938458da1448b5526948dd9ec69f71b148888cc7a41ffc7df6f8c5add6bca3" +
			"0007b1ffcd2f9cac37db2794567ba6c15e15a2522013908247ff357b3c03df0580b6bdf2ca7bb11b" +
			"f2ca4fb59ef633b74794d871e6e57ffcf9b76736fa7d058385c74d17f48a2c0000000049454e44ae" +
			"426082",
	},
	"send": {
		size:   "16x16",
		width:  16,
		height: 16,
		encoded: "" +
			"89504e470d0a1a0a0000000d49484452000000100000001008060000001ff3ff6100000009704859" +
			"7300000b1300000b1301009a9c18000000017352474200aece1ce90000000467414d410000b18f0b" +
			"fc6105000000e8494441547801cd913d0ac240108567a2b56e61a336962a0173148f666ea027d01b" +
			"e80db41049994610b45850fc419ce726444c4242348d4eb1cceece7cf3de2ed1afa3122cad9ebdac" +
			"351ab7e361bfa22f832300a2ad6f92197077779ee79700c46f3016e1c9ce5b2fca01deb16288bbf5" +
			"36e35c40b36bcf994999d4c9e764dbe37459bbdf771e622966380c56a662009062cbc0110e49d8b3" +
			"d2808788666105581a8c3a013a50c7b15908c0090b3d7b6a5287091dca75409a84dcf3f534d2beaf" +
			"5fc7d5883234dccc3e237f0192c9f5729ec51b1380ccc6f0c1c82dfac6ea27320b014532ff3b9efe",
	},
	"occupant-online": {
		size:   "16x16",
		width:  16,
		height: 16,
		encoded: "" +
			"89504e470d0a1a0a0000000d4948445200000020000000200806000000737a7af400000009704859" +
			"7300000b1300000b1301009a9c18000000017352474200aece1ce90000000467414d410000b18f0b" +
			"fc610500000442494441547801c557cd6e1c4510fe7ad633bbce8f775749ec48083316c228d11267" +
			"05071c82607309c7f809129e203e72036e1ced378027488e481c6c0b391142ca1a610cc9010f8982" +
			"b01dd81f127b7fb2d3a9eaf91fcfec4e944429a9777aba6bfafbbababaaa5620a3ac34ea2563a05f" +
			"d172f84402e7a9990228f11cf59bd4b7a86dd803acf572fd9bb572b599655d9101d81c877e7d005c" +
			"f300332efc6d07fdaf898835422f15b89487fe257517f162b2d47588343313e05de761ac90714dbc" +
			"14115617bd5a92354402f87902bf9106deb5fba8b7b7b1f5e421dafd7db5c2296342b50f8bb39818" +
			"1b471a0909b9f051b9b2914a60d4ceb71e3fc0ea7f5be8110999309fd774cc9766519d98411a89b8" +
			"2544089ccedca8a781d75bdb04fe9bfb46f042404a490b08e73db4a7cb27e770f6f89b1842a2eaf9" +
			"84e6b3570e970cde7a7a805bcdbb2e9003266de9401309e9e2f393df99281f55b248d3756ef804d8" +
			"f418e2edb71b7fa03be8f960523a446c3b44c81de36767d0c79dd69f18228b2ea643a0106294247b" +
			"ddb60bcccd860c707d42debc9aa0cee6ff0f862d09c3d6d586353e7bfae4da30e5dd4ed34372c19d" +
			"9d06633232cf2aadde93614b4268b8cad8631c5e911baaeb800a19f89aeb805e5f01bb4fa58f0c21" +
			"96a2aa0aed1cdb47694ee8e301b8ef03013b19d8df1fe3b8304a185be3c4324ab1727cda3d67c96e" +
			"e693f05a9898d7b210606c26608e527cbffc36f2622c76e688b4604ca220745c38710619c4d4b264" +
			"388e709726e7829b0019d9ad6719ef365c38790645fd083248690c19a5529c46c7ee617d6f8b6242" +
			"df713edfdd08d806c673062e4d9d23ddb7b22e0bb1ded86c3c4f9e6f51025a7ff4bbba9a3b1d27c3" +
			"f26edf23d00f4ebca3acf51cd214b71a9b14ff473be22b920d8de2e92f784dc2259c26a5b68ad724" +
			"e4366b42159bd0b7b3fa019ffbee415339a4724638b7a4681ca376045385ccee042ad5ca2a62aeff" +
			"fbeb92d0c4f524a5bf1eefe1fefe2eeed373a7d3f041c3120fbdd3474f519bc46cf18d54425cb4ce" +
			"972b9fabef6e536a9464056f92d3e9cf8feee15efba102450840fa3f7e1a709eb171f54aefa5fc31" +
			"5c9c3c8b73e5991881fecc3c55463e71cf0a0cfac3df77289bedbb8b4877c1687a09c60fcf79f30e" +
			"19678eafeac7a72b8a08cd2c536db818f9927de1a77feed67fdcd93471d85cb1a22b648db84eec3c" +
			"442873f2f0c5a98a75f9f4bbd5aa5b9245a87fb6f28599436e85864d195a3ea8fbdca8874ce91651" +
			"eaaa6f0d30a87d5ffbc6f234b4b03a4fc8be5c2008cbfb249ee5c2d5909a8e5446d177a74483972b" +
			"2c2ecbc3e03e465cd8129ad49425c23b70aa60a46f3fc534346c4961d7e2e0872ce0092b1ac2a812" +
			"e2b25f847ae0deeea453198777ee64e3a8b5a46d2f1f88fd6a12f8b0bdf8c2d6c0407c458a5713bf" +
			"9689ab3609fd3b99c3521a7078894cf2e98dc552e168e10a77e9baced9fcf75cca927bcdd8a3e94e" +
			"8b0d5bd86b9d76e7e6eac252a6bfe7cf00dcf88246932695200000000049454e44ae426082",
	},
	"occupant-busy": {
		size:   "16x16",
		width:  16,
		height: 16,
		encoded: "" +
			"89504e470d0a1a0a0000000d4948445200000020000000200806000000737a7af400000009704859" +
			"7300000b1300000b1301009a9c18000000017352474200aece1ce90000000467414d410000b18f0b" +
			"fc61050000042a494441547801c5574f6f134714ffcdae6dc5988249482b24feb8378c906a732b02" +
			"da08c101893fb9c189f413c037a07c83e41bb4121738d00824240e28cd01724276254472c3805a55" +
			"4a509d2ab19d849de1bdf1cc7a77bdeb5d0488278db43bf3667ebff7e6ed7b6f05328a6a34ca5e3e" +
			"7fc575dd9f20444d01152855d68b42b405d0a2f7a6e7798beececebca8d7db59ce15a9c0cbcb1502" +
			"b84180333e60b6837feb01b78bd56a2b452f01982c46b1784b2975139f2042885974bbb7933c124b" +
			"80ad268b17c06efe3cd2da02a6e2bc314460fbc58b5ace75ff4802579d0e369e3c41776909efdfbd" +
			"d307e40f1e44eed0217c73f122dc8909249178ef79d385e3c79b8904d22cef3c7b86f57bf7208944" +
			"9c38bb76610f91289d3d8b2412514ff804f8ced5d85823099cad5ebf7b172ab091e2832f794877df" +
			"cc0c4a274f228984e8f5ea36261c7f9a022e09dc2357af3f7c08c9a06648025704ce24f4308478b4" +
			"c94b2ac14b1aa38f059f8076fd88686f3f78006f7373006601a5f4090549b0eeffe4b12461ac2e7f" +
			"de1878e01646c8d69b3761700b16b03a3abff1f4e9a8235130063bfaee39c98c90edb76ffb6e8771" +
			"bd0196d139fb4c637b7575d491108e739db1739c5e1d8c161d6cf6393227ec9c21611663833372a8" +
			"4eed8eceed29e2eedfef5b6badb42231f0860a0cce0da9e712b643915c4b53dc4d9f54f09e6148c8" +
			"8478e0f9c2e1c34815c266ef57d2f4cae7ce41509209dd33c2160789b0eef8a54b69c7b26ec5c952" +
			"e138c34d5ebd3a1cf191613d3271f93272746de90c5439878cb2e7d42978945cd6e6e7e175bb4345" +
			"848173a512bebd764deb6615215756fefb983abfb3b6a649706ee8d160c993b57b0974fcfc79edad" +
			"ece8d4c810810611480dc42f21d42b341d4aa77fe16b09b5708e23e59ff84ae2018b42a7e262f155" +
			"d638e8bd7e8d2edd3d07a4672a9e4bf75ea038e03176e408b20a95e57d3a98bd972f67e93e6ec429" +
			"6d2e2f636365059b343a041e6d466c1a1681d45baa56b1fbe851ec3d7122911037ada25afd45ef32" +
			"9dd02bbbc896ad3e7e8cf5e7cfb5c5fd1d06209086f59ccdfbd179a35b989cc477d3d3183f7d3a44" +
			"803aa3efb933f2695b2f30e8df77ee609b3eb7fe197d80b8ef5e8c28387eb1323afca91e602267ce" +
			"f0da9c7becd84de309b38162e19f478f1affdebf5fd1ef18543a11b050050e0d5644eb85e03e4b40" +
			"93353a44a275e0c205bf250b99b054ab55f2aebb60fe7a060b0630587a53cb6d8c08a55a3b524efd" +
			"d86cb6ec5ca815e0852d6a9d89714b1716668f70950bd6fd682b36d41f86e75b5b524e07c1ad5143" +
			"c29e701c6781162b2ab860bdf2b1d61338919f8a820f79c00a2b76a4ac53933117b22ac623691592" +
			"32ed1cf57ff538706d0b5284bd41a0bf52305d474621fdb623c4ef043e9b049c99809546ad56a614" +
			"748536fc4caf3f70a0d27319fd28e7886ed1b535a5948b540fe7ebcd66a6dff30fa8cbcfab4cf4ed" +
			"170000000049454e44ae426082",
	},
	"occupant-extended-away": {
		size:   "16x16",
		width:  16,
		height: 16,
		encoded: "" +
			"89504e470d0a1a0a0000000d4948445200000020000000200806000000737a7af400000009704859" +
			"7300000b1300000b1301009a9c18000000017352474200aece1ce90000000467414d410000b18f0b" +
			"fc61050000044e494441547801c557cd6e1c4510aeea1e7b6d61e35d27d9684d22cd4601018ac81a" +
			"c121b222f01b3847c421c913d8c7884bc80571344f4072401c93272038e21022249b03428a1d7924" +
			"475ad88d3dfe8b93fd992eaa7b7e76763db33316a07c72bb67ba6bebabeaaaeeea41c889cd4db7f8" +
			"d6a45c10123e23a01a12da0450d47308b04b480e2a5c53042b2f0fbc07d56a69378f5ecc12a8d75d" +
			"db1ab51611e94648984b31c1dd4edbbb53a9949ca1726913dae389a2751b8896e0df8070d912dd3b" +
			"a552f28a241aa0bd1e29c887ecb10dff0198c4e9b4bcf9a4d5386640a3e1d68425efa792ab36c89d" +
			"3f41ec6d00760ecd108d4d0315a6c13b7d19686422d508d5f5ae95cba535483320cb734d2aeb4f00" +
			"d908c204ebe5281b51036ffa434833627025221d3ae693537235957cfb0f907f3d817450a4ce7be7" +
			"2aa8e2c55423247ab3614e887042275ceab2b70f41fcbdcaf9a898873721371868ba0be744fd315b" +
			"d14e33d3ee2a4eee9e41c1562bc84d4881d87a04c25df7a53513a2dfc7fd0ae7fc0750673f362d0d" +
			"dd9657d5a1302b30322a6fc330bcdaf6952bdf4352ca5ff1a8a9de1c3feb1e779e0e55294785d9de" +
			"c275dd2227d48d61c278f4c2901a62151812bcfb8d4cf3e7c0ef5fefc3509d88d735b7d5f1e4028a" +
			"a1b28624ccd6de22078aa2318a7a88cd0f4151735b02f5d99e01dedbd43a88d8a8c7ea1351d0638c" +
			"78fc346482eb8a20c45a969c3af55e107b8a7a08dfa3d8f7c260c6c6a7b3d472bda01a2f3ed99992" +
			"673f32874c18fff4ad188cb32ccd7c0ad9405b473fbbc2c902d0f9b95e964749487dcf5172ce7c02" +
			"5098841c285a901767ded79b17e0f9af7e1f40a71e9ae4e0f4b7c6f898b9eacbe6043677f65d3841" +
			"9d87d63ed0161fc92f9b00874dbd9db8104d02963f00a8703a5905380176d9808355f6233311ff1f" +
			"d09ae098fe0e6f08bc7a6b8237f5cff086a03c58417d1c76c914a25c7940870d137b9d88142423ea" +
			"b88fbd6d1a4e94212f2cf44a96aecb8dedbd7bbc1c8b8984bb5b40aedf4ce2755ad12d82a8770788" +
			"1fcfa2749edd390778e662aa419cbb7735b75f8e5d2ec7142bc7ec99dafa0da8b90174d04c322b54" +
			"03f18b4822d1f81488ea15c0caa5bef12e72392e959ce8972fb6f796f9585e548d75504f7f027ab5" +
			"17d312fca31831fa05c06cc3f08e103385fa64f98fc3232ecc8198b9a4e7be2b9f9a5a8acb83ce85" +
			"d6b3c7ab6ae317bbdfbbc1e7a4f7fc9017e69ca377afcc5607af643a1eb4be32cf7a1d881fb9e69c" +
			"57fdc528788fd780c19e926a049173f4ecd17c35f68d702c78cf7ff8aac65f41f7797bda91972775" +
			"f8d895cde87088f0dab92fbf49bf9687a8ff78cbe69af29075d890c505c9c1e90b2093b705cc57bf" +
			"f8d619fc7de25da8c282edf6eb599d2c61f90def84f1920cf1ab583c0cb171ad43eb4a220f0d1e8a" +
			"cdef6fd952a8af59f07aba140df80e1c63bad75572b97a339938b7013d43968a12461658f1e7bca4" +
			"97c17c4360d1dc80511302ef69e2cf73b1e241e741f5e672aecff37f00fc6fafd075d25caa000000" +
			"0049454e44ae426082",
	},
	"occupant-away": {
		size:   "16x16",
		width:  16,
		height: 16,
		encoded: "" +
			"89504e470d0a1a0a0000000d4948445200000020000000200806000000737a7af400000009704859" +
			"7300000b1300000b1301009a9c18000000017352474200aece1ce90000000467414d410000b18f0b" +
			"fc610500000476494441547801c5574b6fdc5414fe8eed7826cf4e081405a8f00045b455d589da0a" +
			"42444b102b5450ba60ddfe836483c42ee90e894dfa0fe89a452bc12a8886522182849824aa00154a" +
			"463421a28466d257e661fb70aeedf1d8d3f18c255af5d3dcb94f9ff39d738fefb926a404af15734e" +
			"7f654ad7e824980a4c6c8191f3260965622a8178d971f98a7e3f7b89f263e53472a9db02defcde82" +
			"a14d8bc2b3a1c23482099f55ea7cae7774bcd4715dd284b21803b55906cfe07f4014ccc3c89ca3e1" +
			"f61e694b4059cd3db428165b78142094aa759e6ce78d8708d46e7d573034fd629272b62bb0d77f82" +
			"fbf735b8953b9e00ea7f06dae0b3305e1c0765f7208984ed3aa7cdbd13cb4822d0cd727bf31aecdf" +
			"2f7b24644d5c82f4a92703c39a80b1ef189248b47a2224a0f69c07abc544e57ffe88daf5af7d4dea" +
			"31f931b354d41c0b6af3d07b30460f2792203d33d688092d9c90804b74fb6e19b51bdf825d570afb" +
			"b5e3005edb09c69b75ed97af7c2fb515263aecea6c930f02d71bb486045457bf40fdafd5a89088d5" +
			"886c43d33be62b6f493981449936e7d556f81ee8a1597480bdb32916bb4171229e08dab171bf5fbf" +
			"b9d249244c9dbcd75be3edc59c103fdb69b153de8c096fb63932c67e913664ccb97bbb934839a8e8" +
			"0c6f17738653cf4e695dce434f68ec61f6bdedb57dcf376a7f1029c039a75e9932d4d91e3e98c4b6" +
			"7708eefd7218e751cd1c8c45df03053d378a6ed04127359151e8b6d0dc57f0dccad1d2b2e76ade6d" +
			"d452d4c1d41584820a42abdbbaccfe098916d357e4f88a38521092606f8e7413d983ef74132bde22" +
			"4b11e89ae1a8278bbeb1535e9029eb1ade7083c261dff1e6b287de85d63f8ceee09c819430f347d1" +
			"57dbc5eeca021ca9899a3beec580fce9995ef41dfd0099978ea5150b72ff59da06d2e779e7de3676" +
			"571760dfdef08ada486d6018d9978fa3f7c0099099457a505911284aab6b203e0e880f97e52de015" +
			"3c2990109028fc064f08eafe48de516cf7aa44942a0eec7fd751dfda00d71ec0adee7a639ad90b7d" +
			"7004fad05330465e405a909119366878b2ecdc5aba20413ddd6e5175e3ba64c2df5095626fddf495" +
			"524b0244e44896b6f9fc7e98cfbd8a6cfe088ca7db135297567527689b8eb9fa00f7562ea3f2c7b2" +
			"285d47fc706f776efbaf24b759690c8d60e0f829f41d188f1b16a4e370bdb3b5342f3966ba72a388" +
			"9dab9fc3b9b3d5b490a282db2b6b456b5ed285c8e0ebef0b913795ccf3fade3766a2f350b1b07375" +
			"a178f7872f2d5fbafc7170d884a92ed20fd9353451eca2a2285230ee5fddfcb69028ed39fce158e3" +
			"c32566c4dac7af593ab44519b6e2ae8e2ae6684a6cb1b5b5fdd058c9813b99ffe4d75254420c6b1f" +
			"1d2c68e45ef4493c2a78644a2ed3e9fca73f275fcb4312e209aaf3a2186cc52e19b190471b439b91" +
			"11db11b19c7bb498e51d09782466ac9ca4c139694e870b29beede9e09e975c3d979f2fa5ff346b21" +
			"62b1abcf894567549f2331d840c3d28863ca2ee18206675e14973ac94f757b0b88e4e41234a531bd" +
			"2d5f1347e0caf6c8e919c4a5b2ae24297a5982ec8aaee35292c5adf80fb2668ade0ed28369000000" +
			"0049454e44ae426082",
	},
	"occupant-offline": {
		size:   "16x16",
		width:  16,
		height: 16,
		encoded: "" +
			"89504e470d0a1a0a0000000d4948445200000020000000200806000000737a7af400000009704859" +
			"7300000b1300000b1301009a9c18000000017352474200aece1ce90000000467414d410000b18f0b" +
			"fc6105000004b4494441547801c5574b6f1b5514feeeccc4499338b16949705b12bb0d49a388e208" +
			"0add20c83f4896ac5a1620b14a5608b169ba018458a4ab4a6c687e41bb61894aa042a2488d5bd1a6" +
			"15794c495aa769123bcf26b6670ee7ce78ec19c7e37104a8c71acfccb98ff39d73cf6b04eaa48585" +
			"4ca425ac0e2b2a3e20505290881310916302c892205d98226512a676b68c1b8944345bcfbe226842" +
			"3a9d896b216d5408bae808ac6b63c2b57cceb81c8b45f59af3fc06a4c6ad11ed1288c6f06f88c484" +
			"a6142e47a3d52d521580d4baa151bdc91ac7f11f100bd1f3fbc650356b1c00b0b292492a9a7add4f" +
			"78a150c0fce2732c2daf61776fdfe2b5b736a32ddc8cdef86b38d2d4083f1066c118e9e888a67c01" +
			"0469be985ec5fdbf96906310207bb5b301f17b83a6a2efd4719c7abd137e202a2d510220cf3cdcae" +
			"4efb099f5b5cc69f8f16614bb6977234581b10bc9a0c0e24d0157bd517842a8c41c7271467403a9c" +
			"9ff0dd17fb98997d02934c981c67f665828acf54e2d9fc7b0f1f232fad5485a48c82c9ce5d240b80" +
			"347d2d6f9f9965b3e772b650b285942eb279440e8f786e1eb3fa327c49d09825d301d010522fa106" +
			"6536b75d9a3a028b974925c10e4f3eeb4bcf6a6d0935a4580a2b994c264202176b4d5ecf6e79b50e" +
			"ba18c4d6ce8b5a5b42087141cad6f2863a2c949a73ad0d1d67937f42d85eef4481e384527b392888" +
			"500745a46c4d1132b7d7a6e6a6107676f7004798b540582f64fd5c40c88e8d487b0b0289eb8a4242" +
			"2483e6254e7696bcdc3a738f234a9e6d76724542241c0c80c126d9f8140f9ad877fa2434552d8661" +
			"d9fbed0830cb808a3c9990de3c13b8ad841097a71f58e1420d1ade39db53d4de8e7f8ff7bb2384ef" +
			"6759786b7313eaa088863ae974770cfbb90252f7e790cbe74b874e824ac931146ac0bbc93ef4f0dc" +
			"7a493c5fdfcce010757e9bc36b9a41ac6f6c632db369f1c2ac6d4fe204067abb2d6b1d82b20c606b" +
			"9a550874c4ff8728a5b013ddc54b224e4629850ff167bc24320d4c09990e0ba42ea04e3f585ddfb4" +
			"ce7e9f0b8e2c3ad2ff1a431ac2dc94845b9a71ec9536d44b9a30a29aaccb2b6b1b936c8ed16a939e" +
			"70e7f3f4d92a9ef27d757dc312ec29fee5f6a094938f771ec389cea34874c57c0171c6be26655b5b" +
			"a533dcf9da56b0480ab9fb600ef37fa7b1c61abb536d59aa28f2a8f8e48cbbc78036b6cc390ecdfe" +
			"9e2e0f80823012b168542fe9b2bab631c1697974fe711abffc7e0f5bdbbb5e059d0a54aa44f0d600" +
			"7851ba0d23491ed17b8367d0ff46b72c5a573a8eb68fb9c7217de1d73b8fa66fdf7918472d7230f8" +
			"8e1727b89f5dbcf383fdfac0dbbd8389ca964c9ec76fb7678638b5ea7e75de6a3638151b01bdc081" +
			"e7128ff45b7f3c184ab8be110eb4e55f7efb7dd234d4eb0c38eed61a4ed975d4f73402159b54f0ec" +
			"75d085628c7cf5f9a7fe6db9435f7c7d354e68b8c92be39ed3741a0d51b99c3c163f484217b9fcd0" +
			"37e39fe995236ab5e9b77efa317beefd914905c611def3bc25d7dadd9665f77eb04ab17d2f6323cf" +
			"385f26aee40ada47df8d7f52b54b0dfc381d1bbf1ae756609c03eb4249598f05a86c18e1bc53965f" +
			"260d832626aa687d280065203f4414ec0db38c0f79d95bec5671be17b327714251746e6e53ec7153" +
			"269a6e4c8c7f5cd7e7f93f281e19d0c19963920000000049454e44ae426082",
	},
	"occupant-chat": {
		size:   "16x16",
		width:  16,
		height: 16,
		encoded: "" +
			"89504e470d0a1a0a0000000d4948445200000020000000200806000000737a7af400000009704859" +
			"7300000b1300000b1301009a9c18000000017352474200aece1ce90000000467414d410000b18f0b" +
			"fc61050000047c494441547801c5575b6f1b4514feceac6f4973d984424a142abb45012a2a362951" +
			"2510171711518150f20b5a7e41fcc85be91b8fce3f28bf20e52934222411e2a12014a70aea5362a3" +
			"d0042a2536b93876e29d6166bdbb5e275eefd28bfa4993ac67cf9cf3cd996fe6cc124262262ff41e" +
			"ad3201c63e2201031049d9addbaf4b0015042107ce9776cdc4ddc91495c2f8a52083d9fc6132a669" +
			"5344fca627602004d19da3637efb7aaaa3802721a066ac6bd55b7256193c0584409699f1db699f8c" +
			"b424a0661d8fd202049278162014aac722dd2a1ba708ccfdb56f441099f10b5ea909fcba7e80078f" +
			"0e512c9b968381de28ce7547f0c17017f40e0d7e246aa84d8e0f75e5e0472068e62b1b65ccfdb16b" +
			"9150b905a9e1c276239088307cf84637aea6cec08fc4c94cb804d49af746abcb7ec1efafefe3deea" +
			"bff00e14adc3e04ba30fc6f94e5f12741c1f7134c19c7e2538bfe0a5720d8b0f6570c1e5c465e35c" +
			"eeb6c6f3c936b75a44e5d8879e8cc1552c1b160195fa766a5f7c58c2e151cd0a0a2eea819de0a2be" +
			"1c4234facb5513f7d776fddca995cba8982e815894dd421bfc5daacac0f5e09c9bf6739d00e46fe1" +
			"b646df7261b79d4bc4185913660bf9a24e42dc6c67bcb553958e8527cdf68c79bd71d914392b1376" +
			"5676f68edab90431bab1207517e15a6222e8385469759f9dbfc2fbdbfeeff4098160089dcba33da2" +
			"ce76040c507bbb7870dc4c823cfbe0e470f9ea553d8e2030199bc9f41b418646aac716585d686eaa" +
			"3dcbd22444f9fb5c6f2cc8adb2379408934186ef0deb8847c80dca3d5b0eb61eb82b4c752011ae5d" +
			"3e8b6050521108ac70899886cfaf0cd4cf016bb60d029c37fa9ce76b975f867e268a604811222446" +
			"2fe838acd6f0e3ca63548ecc5345446d820e49f48bb1418c5e0c5db5413f6d548af81f75beb87f84" +
			"f9dc3fd82a56b0b95d562ed0d715c395d7fbf0fea5b356b6c2834a8ac0b27c0a14e273428ec9dcad" +
			"e0058188724cd68045bc2048d12e913a8a45a4238f903a50ebaedaa11462458a5241ad7b7f771c7d" +
			"b20dbed489b0a05abccf12f3fc9fe52c3136d5ca686d7317ebb2ad6deee1d1f6810c6a7a3c38c72e" +
			"35ed8a8b833db830d88db753fdbe8464faefa487e25f59e31654398e50de79a9b6dbcf0fb6b09adf" +
			"b195fee45099f9f4dd218cbdf94a33819a48a5e5cdc8253ebf21b30036b5babe8def7f29a0b85769" +
			"2a301eeaf0ab1ded6e49fddd098c8f49226f0d289be94f5e4b649c311694167ef8fdf1f2bddf3692" +
			"4e0027964c97956af7066817228707798c4ff325b73a2abbf1abe70b9f8d0ebb57b2a603cdf87a36" +
			"09ae599752af2b3a71ee0934d65d004db3278fcdc971ea3e0866a673df5e2fc033ae099732734654" +
			"e3335045caf62a3ca129f863ea146c620532d9642e3bee7f2d77606466939c61c1fefef39886b968" +
			"b44481714ae7b28d993b60adac9521e3951179b79b6ebaf17aea7dd826ef90d38c57475a0577a6d5" +
			"164666266972ed1ba9a61beeae20cf5a7bb68a25b8faeb923c61bf8ba096cd65270bedfc875ed064" +
			"6646ef3431a111fb580679a72e54e8b68392129810f26c87b9a469b82b0387fa3cff0f2c3ab727a6" +
			"94c7a00000000049454e44ae426082",
	},
	"occupant-online-large": {
		size:   "100x100",
		width:  100,
		height: 100,
		encoded: "" +
			"89504e470d0a1a0a0000000d4948445200000080000000800806000000c33e61cb00000009704859" +
			"7300000b1300000b1301009a9c18000000017352474200aece1ce90000000467414d410000b18f0b" +
			"fc610500001b07494441547801ed5deb8f1d45763fd5f7cec3063c33806d60c1be048cb43086b120" +
			"12b6d7bb9eac88308a84911225f904fe0b806f2c8a648fb259ad940f6bff0580946f89b483b45910" +
			"2cf2006b3b1b127bb218108fc00543c0afcc8cf1633ce3e9b355dd5d55e75455dfb93373e776dff1" +
			"fc607cbbebdd757e75cea9aa7e08588138f6ed891a7655866211d5aa116c46807e195c4310b53405" +
			"d6c239455dc64d0a00f92726e571fd5a0c5f628ce3118ac99d1b06c7618541408743093beeeada5d" +
			"a9c04331c06e29ec9a4805de72c8b22723807159fe783c17bf7db532373e3cb0ad0e1d8c8e23c0e1" +
			"8913fdd56bd5a1aeaa783206b1377f34b70d0921ae5dc35776addf3a061d868e21c0bb67dfdf5dad" +
			"8aa7e528dfbb5c237ca9c834c428cec5afeeb8f5c151e800949a0047ce9c188ababae548c7e7ca2a" +
			"f47c88ba001c9b86d991329b895212201bedfbe588da0d2b00b293c7a4891829a389281501569ae0" +
			"7d883acee1c8ce5b075f8692a0140458f98277511e22144a00e9d1d77aa1eba5eb47f01c1188d12b" +
			"30f37c913e4221045053b95ee87e16010fc02aa410c481699839248930096d46db09a0d47da51abd" +
			"5482f97bc920ea7310efdb35d05e47b16d0450a3be07baf6cbc3e760158d7070c7c0e0f3d026b485" +
			"00cad6f740f7e1d551df2c44fd2acc0cb7c337886099716ce2e4d3ddd0756255f80b01ca01d375e2" +
			"e8f993cbae2d9755031c9d38f92b5855f94b827210b70f3c3002cb846521406aefabd2d1539b35ab" +
			"583ac4a83409fb966396d07202a4f6beebd7f270084a80abf12c9c9db90067672fa4bff2ef6a7c0d" +
			"bebf76456edea049b7aeba56fead819ea80beeecbd19d677af833b7b6e81f26079fc829612a02cce" +
			"9e12fad7d3e7e1c4f7f554e073b3e64a11118468eeb25332dc02f7acd900f7df7817148fd693a065" +
			"042883f095e04f5ca84bc17f9e8c7217b9c297e140c3dd7380443b28323cda775f725c1c5a4b8296" +
			"10a068e1a782ff2219f1ea586976a5de85ba3c7d854adbabe34cb8860cce3923892e47a7cbca7bb4" +
			"6f4ba2118a2342eb48b06402142dfcffbd7c1ade38379e8c786ad33584fe979a00009352c7a78401" +
			"af04430aa7ab6e92c2dfde7f9f24c29d500c5a4382251120f5f6bb0b99e3ab91fe1f939fc07139f2" +
			"15b4f0447684813c828818dd3c9976f00800102c4bc76d5bf767f068ff96c45f2800e35761767829" +
			"b383252d04a553bdf60bff82f4e0ffe5ffde31c25740f31b12a23071e968b7ccd731d9ff5ebea0f0" +
			"d1fe1cbff079d216d5a602302407e04bb0042c9a00c7263ed85fc43c5f75f4bf7e7b34ed702bf5fc" +
			"610aa9da37c744d8e60fd198009229ac47287bb2f3a44ddf1d2b8804b8375b705b141665028e4e7c" +
			"f82c407c10da0c2bfccbe02b67abd0bd2006dfc3a7515e31744610103e3d576b097f73dbf6429c43" +
			"518167b6af1b7c051688051340397d6a6dbfdd37694e49e1ffdb7752f8b344f85430e43c35e7d66b" +
			"07e42e9f4da44f685a9bc46a0547eac9ac000265614a82db7714418249e90f6c5ba853b86013a03c" +
			"fe760b5f397c4af85352f854eb5bd5cfa466856fa204b8c24fd28834812913a9547dcfdf46694732" +
			"6b80ae4e12436ba9643ada5e2887fcb072cc1792694104486d4dfb9dbe63139f24235f9049bd71de" +
			"ccbfc2ccdbf5b40e4cacfd4b7d00245ac23a8256dcc1e10dfee491a4c7ec4f1e2b13a5dadc7e24bb" +
			"88fb1792a36902a83b79a0809dbd0f2e9e4a3c6d052402a05ebf9df8a117c65d006744a31f8e8c3a" +
			"68ce5d4732711c915817a04e653a3bf8ecf27750009e7b7722915553688a004aada4b771b517caee" +
			"1f9bf8986bd94cb442ab754700995607ade1f9f82542cc1223baaadf66a086839a7d1aa6cb2216c5" +
			"e08db3e3459802a840f452b3a6a02902a81b388b50fd1f7e7f4aaa7e3bb5d2c2b2bf68c28de0497e" +
			"44eb2220b104c6b1d782164c83136204f2831df5d4d5d079c09ec2b4dc843a3ef505b41f58eb8eab" +
			"4d69eb7909a0bcfe22eedebda047bf1aed9ec7ee03e9a8759cfd46e9edb1a34a02c7c211328b47bf" +
			"7c95fef8d4e78568011189fd4a76f3a59b970072b56fd18b0c4b81167e62ef59e75a471088dd374e" +
			"1eb3cbe8ab77c729f4153b403324cb6f03ad5bcd606612121401f5ccc57c691a12e0c8b993cf4041" +
			"77f59cba720efc8979c81bf7566e20e4c523d5efeccf05128d40660fc89d4cabff69bd82d79fb5b7" +
			"282d206bdf3d9f43d89000a222f64301f840dafea964c1c7e954d7cbd2705438060664788a478c3c" +
			"2115ab86f8093640982d642b6c52ac764eb34c4af8a7a6cf4311a8426319e612201dfdc56cf17e76" +
			"e95ba7c33952010beb9939038f2973779e961d6867d296972570f5bc70f30a938ef9048435480bce" +
			"da7562b21833309f16c8254051a35fe1eb2be78d2c5cef1d5da9213b244a03ad6170e3c1311e4287" +
			"38e9d0291fc10a354b43a79d743a48b227387d75aa1033a0d0480b0409902efa1433fa95ed9f261d" +
			"e55b69bb06e82873709546680d4f0b972df864c40a2eeab0dc1cb64c64ad733d1485197573aa2441" +
			"1168a4058204508f6a4341509d1476cdf4011f964c03ebf3cc042349e3ba6bfe722e8943ccb50096" +
			"34e8948540b7905d2da0fe4e5fbd0045214f0b780448e7fdc53daeadeee6a5a35b2fbb82e7d9830d" +
			"43bb640b48bc7821bcc99dc8d268222150fd0e5687ebdad96a8f4e42d25027809812430fd2f6b333" +
			"c56880ac25bb8f4c9cf46ed5f708d0bbc0cd845643ad9ef189bf1ea944b9a233eeb3a8b4fff5fa2c" +
			"f9212313cd322090e189769547a4bac278104cf6948882187c6475da36f265c222099020466f4aef" +
			"11402abfdd5020a6929b3d324191551da4ce97065daf157e9e541b68e102786ebf48a77382baf3b4" +
			"cce41c88d901eb35d27201fcfcbacd246efa5a314ea0865c1d7cd60d630478e7dc1f0b7fef5e7ac3" +
			"0704fd000fae7e0f2571d66f593244b3a710ccee7a854eb8bfca98df3c850b7385dc3748d1ef3a83" +
			"8c005d95e8492819dc4e66de4040f3fa69786c6866a0c3dd32160beaf8f188a594da1a4867f0697a" +
			"ce08a05ec20805a3992e12e00b2fcfe3d76154e86cf118ed7e3f92919d371361debfa30968197a26" +
			"51bcc839647bf6d2ad62430035f717257819a327cc6cc9d5747ed6c93a9d0e176669969a63647e81" +
			"cd471781b423e97bfad43c18410a7e5bb92760c7e4b0e960093480447f15aa66366008a05ec30a25" +
			"807ae2265d6727a398dd84994db31ccf9b3dea453c7511106cfa0bbe53080e29688dc431b48ebfe0" +
			"5b41cecda2ac8df2b8afeb062803a2d86ef0190260491ee7ee554fd8b82a957b6ed9af3f06914c0f" +
			"f55a4078d4599260c08b77e7feb60c24f148ca175914d315246f1a56ec43a5167236607cbd8400d9" +
			"8d03a520c0869ebeec88b9dd0041572f0f08cd5bdf50ba26ac37ba69e7afafa0c7c702c0daf12b1f" +
			"6e564709012a739552085fc112607e2cd4a4e6dde62d16330710e1b4bec611a6fcbbd6dc0a65c195" +
			"4bf1b0fa4d09208a5dfca1584f0910b2a759786af303713a5f4086de6c1f49b89b07795921b285cc" +
			"8bfffe01bb0ab9a1b779722f3b44aaf11302449178084a02a501523f8087532f3fbd1f43b03803ea" +
			"22e4098f08dbce38d08bd3e1a98347c2b23caed3c7ea778e7b4457a9348088e027ea3721405c12fb" +
			"afa0ec24d502743a663a1cadb36f9c44e423129da9988e77efef1799032740781a225ded15d9cc0e" +
			"3d2d441715a8b3ca770ad3f3bbd69647f8196aea9fe8c8c489a132ccff291e1eb827f9d5021264ea" +
			"a7ff13c055bad9ecc97ee923e1360f0f0bf9043cbd15ac6907218bdda9e461c9b15e4ccad2df7be3" +
			"ed5032f42b47308aaf554bf7250ea52a7ba26a72ac85ee8292c31bb90e19145cc2e8b2dd3c79e5b8" +
			"ff65112cdecb97b57d5dd71a185cb709ca868bd3b02d9273c2d2a87f0d65061e1eb8373d69e0a007" +
			"473231076c3938609b538b122698e783b80dd1eabf11b2f832d97e8a6a1cd72251d257b82a33d0ab" +
			"e7cdde6210302fdd78f114da3f439286c47959d0f9759602d0dd2206eb5bd87311740277dcfa4328" +
			"2364f36a512582cd5042182d4057e5b444436470d76e4223388f349e6045b8cc240dfa5550475047" +
			"64f977def243e8abae8532228aa02f928ab2b45fe3525a80ae9ea12b1533c421309c315c2871daec" +
			"394faf6ff9f2f61bb2fa5d1f20af2ab5f4fb40096d3f414d12a0bc9f6353c2df73fbc3e65c7bd766" +
			"9ddf31c48e8b0680212288405abd814c42118983c94963c2890db0e96c7d3ba5eaefeb2ae7e85750" +
			"9fd295eb00e5d5000a5b6ebc031eb9f91e2baa6c11c8e8824cc876bae6c20adc08cb5d2370498236" +
			"463f868e012f1263eb309875a7ccbc28ed35b86e33941d9200e57f8fff0e6947fb93ad543bfa3df3" +
			"ecde010299309c65400ca649038c451140f4881dd5764a9ae902e35620dbbeee97a37e67491d3f0e" +
			"ac2dfb07235a01650afef6ae5d723ebd96bd94810a3119a7e45e0cbd8a676c39062c82e72892f08c" +
			"3c6487d9fce870b3c248cae8eb5e2bdbfae312edfc354647104041d9d2bf931dabdec285e8c7db91" +
			"4cc310c20e1a36959fc651b2b1705d9c485f13a7da5866bbefa26308a090906093ee606f7ed66429" +
			"99b482e1f31d8373e7988d4b84bfa9b384afd0510450e024507074b4418321cdecbbfecd5bd6e3de" +
			"063a8e0726b77aad85bfef40e12b88a313279b1d3aa582fa08c491731fc27bffff59b61d4cd43d79" +
			"a78cb6d546c4e6a10ee22730b864a004cb6c3ff1431eb9f95ef8d1fafb3bc6e6bb903b2ea2de0933" +
			"01173d952ef88b8d0fc1fade7e387aee23989ab96485aa176cd0befb5fb882d5c2cf246ad30a9b00" +
			"2849b8165853e9863d773c9c4c533b17a25e850ec7d6becdb069ed7a38395587df9ffd8878e6e403" +
			"10595abaece3ee1499d502a20fcdf210da7c6a7fe2915bee95237f4bc78e7a0b9cacca2eaa637673" +
			"40a7a22f9977df0f837d3569163e82af2e9d85a9d94bde8e2045683d413430862b4bf029e4b54f56" +
			"318ebf54bb022b018a084f644bc7ef4f7e099f5dfc4692217de18467d5b5ea77c30994a0d57d7c4a" +
			"e89b6e58bf6204af21bb60aa2ac7c0a4809587adfd9b933f85af2e9f8533d393f2f79c741e679217" +
			"50290d41a1c8d39b08bc3f11bafadd28ff569ad0292401ea8a00f59548000ae523a83f3592576121" +
			"e55e8f628cebb08aeb1273118e475d95b97158c57589489bff23132727ca7667f02a961d933b0606" +
			"0712f75fd90258c5750529f344f32704c018df86555c578863f81ff59b2e00a058f503ae33cc45d1" +
			"98fa4d9f0daccc8ec12aae2b74c1556b02b6279f1a539b42abb84e30be3dfbbc9c7d43481cbf0aab" +
			"b82ea01d4005438038825158c575816b80afe8e3c8065e1b979b218bfe0af52a3a0693bb06b68ee9" +
			"134300f50972b16a06563ca4fa679a9eed03cf45e26558c58ac62c446c907b1b819dbe2cacb67aa7" +
			"e596ef992b93c996efa43c575bc02a6c6a267d0f7172ce3e4a913eeaa5dee3d75be94e6e37eb957f" +
			"e9b9da221e487e37aee9f8ede1ba5cfebd9b06f8b784c57808a2e23e18d12cd4e757be93423e7365" +
			"22f91c4b22f0998b4cb0fc3640e7a1527a736816ae0863ee1308dd1b2ac0dc33d05bed4eb69837ae" +
			"19e81862c8e68f05c238d257c6749d8092e1b4baa1e3d219f93b055f5d3cc36fe870046ac25cb85f" +
			"7ea47713bbf9845346289e60a3d412eaa61275e7d0a61b37243793940d0266efdeee7c5e3e782fc8" +
			"b1899387b1c0af862868817f32f54d729c7c70490b2aef091ec8b9a00679681afdf431345b468824" +
			"59239446b84d6a872d37dd510a42a8d1bf7d6070d80d0fde152ce7892395367f3842abf44f2f7c03" +
			"ef4f7c917e3904b2bb7b9ddbb9f3e0dfe16fdf0246c3d2b4c24d0ca1b788b8f1ecd5708147d1747d" +
			"eab9852fa5a6527f0a7ddd3724da616bffddb0f9c6f5d06e289986c273ef066b9716f8f2e259787f" +
			"f20bf8440a5e759a27f079c0deca251676735b7e5dd9730590ff2631fae632ef85d4f35c837232ef" +
			"5bf703b8ef26f9d7f70368033ce74f23f7b980e5d4024ae89f7eff0dfc518ef4ab73d669cbeb4c85" +
			"d0dbc068b8ce87c4a67321a5a90d61cc831fb44e6ee0693a4f0b09e7d90361cba68464cf2264e5a9" +
			"1989ba76f5d79f68860db06be303cbf63671d98291bcb88643a6955a40a9f88fa7be96eabd9ed876" +
			"260ca41d691a6de4613a929e93b786a64ff900b802766d3a1592067beb271033401c0a2a3c57b8e9" +
			"83237e3b6801489e4fa36dd74f1ce9fc9b2511b60ed4e0c181e0605d2c7247bf42c327835aa10594" +
			"2d7fefdc27f2ef6363d7b9b0c31f7b081874d389b603c1791f00f2a7828093c47b2d2c1dd4187a0a" +
			"d87eacc22d5bb7c99d3420656e4063792fac2049b5cff0fbd31fc29fdfba05b64833a134c452d068" +
			"f4eb7637c462b54048f0cd80a9544f282228fc503c0f37cf81b0df34121a3a960b417efdf9d7d4a8" +
			"8cfe9e1ba5d3584bb4c2e2882046770c3cf054c314300f8e251f92ecfa021680774f7f308fe04313" +
			"b6505833f9da095e7f0bb91324b4869a41ecda38284d430d16546660deefa7690247cebf7f4034b1" +
			"3aa8d4d76fbefe034c5dbd0430df63d7f439eb46614b462b4893cd0a72661a8b9981b8e5f347d5c3" +
			"6d564478ec8e213983b8139a287164e7c0d603f3a56baad5ea2b533de9ea602d14af3cf9774e9f4c" +
			"54beaede14ed0ad57dc05ee4a49ba78cd42ebbf15c50e6e1d045088dc60767276ed981770eb07c0b" +
			"2037fbfe51a0de076fbe3bd1080dcc427d0dcc6edb267778611e344d5bf5c141e9101e76c393517f" +
			"ea0fc9260c7f8fbe76b87887984a1b9082f1df7bc41b781966361018a1be93c0eb237973f338d760" +
			"bc76a78db965851c101a072e997c12030027847a2b8914fe5fd77e94ec45b898031ca67bfe8db020" +
			"bd254dc141faf9d1ff9476fecd6f4e98c653011b2152c190f912132410c1363086e8948d4e7e416b" +
			"77884305c388e8e677c86ada94934fe70db5dd0bcf7edd6b0767c000f87d47bf9740d7437e7cdb60" +
			"a20d489d87760e0c3e074d624104a0a6e05da9f2dff9ee24d8a5517a612253878e17ef94470569e3" +
			"055b60a179c3b4f0c1dcb424a3dfb918ca434883a4812ee9781df3954bd60b9a4c13ba1e6c704c48" +
			"d070ce1fc2825e0c90dc3504b3c3af9d7a6f52093f01f2d7b3eaf1ad3b322474fd07248f8dcb8465" +
			"469b3071ba3e9d278fbd48cb42f4eacb23123a44312e48209f7b1d4c7868db6aae07787b05fb45af" +
			"7cd62e278f1bae64f1dad7ff95c806168805bf19424d2bfefbfce7cfbb8d30e798763ad89f3090e6" +
			"0917c68d850eb45d162c3b6fa1c5a95b003882025fd2b995f0b2bcb2ad6ee7260175ffb0aae72fb3" +
			"89e61c3ff7e9c87c53be1016f56a90df0effe3cb620e0ee916b1ce4c74a6e043344947ded1ab3b49" +
			"777c6828670402bad4e709086dfd40ea3775d282800d512443d27e3e16989e36ef8ca23d4febc32c" +
			"42370d89f6d2e508415a85b66f4873d1bd3e337ad0b97e724cda20172947fe7df89f0ec222b0201f" +
			"c0c55f1dfe875fcbaedc6b8bcab354005ecf5209e878d79bf6a67b006c0cb8e1d4c336650087f109" +
			"68bb80d5190661872ec3bd8ea01d20f909e9056b9f73ed8c896e9b919529b38dfe66f7cf1baef635" +
			"c2925e0e5485ea3ed988ec2103d2782a17ae1eb2085700d9b9c36c9b5d6b0f33ac6c1a4a0aad699c" +
			"32d8f0cdeab69e0b2f8fd46aaf87946137a58453be5159ac465d06dbcc729d0bd6562fc2bb0eab6c" +
			"b17e112fee8325604904181d3e303907d79e42a11e2f27fa92b2dcbb30dba1d4bea3a711828a1db4" +
			"4b87ec9c1ff371824e6d56250b2f2775ca042fc155e510d21442db36c7794576664c10257fb0446c" +
			"7006f5399c1b1e1b3eb8a4673904b4008f1f7ea11641e5b02caca6c3b4864c8e4965ae22f3b4a6f0" +
			"0c8349e796edfd3a6969b98dda02e08a3c709ea3d11b0173ae29d108d9ca21b32660e999bf2d9da0" +
			"3e0773c3af0fffb20e4b444bde0fa71a12cb06c9b6d6332d6c046335419618c13a4960c30438f1e4" +
			"5c6b4133ee586f0a4f1b9b918e3e19889e32e5026f8a49678aa46cb083dcb6494f3503e5519fcf5e" +
			"36926be5f522bd7e1a690f5b267c8596bd2050934036b1ee0984102285301d43afd578dd5a256636" +
			"953ae99610da14202317932e2d97d4434cb54d033c9c850912005cc84993cdc521bf4e322b302adf" +
			"2389a12bd154f69a0419194af8710b856fea6d25943910184973206ae6e2d8aa5e8ed26582139e20" +
			"356990a68190e276d1289d70f2880665036b3759592602b579ed35674a5d806f46e6056d038ec722" +
			"7eaa95c25768f92b4255037b44f73679b5d93368b42342d69fe8781dc3e462f361aea74ce13a9218" +
			"e8f81c12b238971c68ae2315269a3faf7446782479a9eac9fb053f9dc0d1cbe2f270ab859fb41596" +
			"114fbcf5e201d91bfbc323ceed60da287a03685e1eaad781980e5ea6d1dcc4b4787621d0026e23c2" +
			"e5b3624483fcc1765b728a5c2924443af4da4f7fd1f4e6ce42b1ac0450d8f3d6cf9e1310ed972c36" +
			"4f46d0751add175c50049939ccd9faf7fb590762b82ca075e4687b7776e186d3bc6112f09d515e5f" +
			"0ef1dcf2404cca93e77ffbd35fbc0ccb8865278082f50ba0c63ac1150019d0ac718ef9b6bb8581ce" +
			"77066e929dd6078e1cf2cdbc979ed69737e8a9b2605361b4c9426d65d5ca751514f1b2a87c176d21" +
			"80c69edfbd785044f02c1dd5c6db265d1a1eb899fd6569b30597d0a80c94e1b978aee641877c01cd" +
			"a49d50779732af3e0fb9edd339e24357a2e9034b5de069166d2580c2e36fbeb05b44e225354bf0b4" +
			"77065f418686b8208334accb69bc151892dc9c786e39267fd050f334790a25ef5a048b4b1851c7b9" +
			"cabed71ffbf918b4116dff50c0eb8ffd72ac27ead906318cb8eeb9f67d934e44f77e027dae43d335" +
			"001be60a522ffed26ed669d2ef04504f3dcf11d3a35f90735ba72514fd45d2024e01e2fc916bc258" +
			"8c5c1157b6b55bf8000568008ac75f934bc8ddd1af6467643b8afe48f5e0e9ee1422132ab129763a" +
			"9677958e3d10ac5ed7c3cbc2483b8df6d16da2240c3a0c7cdccbc331ace0be76d8fa3c144a008dc7" +
			"df78e1195151d3455163de5223030b1048473a3c948f813920105422ba4cb36eef10aa91ee87066d" +
			"062978c411a50da1609482001a8fbf258900920828670b0efc99412618ef18204f797871a1b48df2" +
			"cf07973c7e99a511bc46a908a091388ac90252938fa42d45680b29b3413d8d9400aa57b3944cf01a" +
			"a5248086f211a002eaa9a49fc8d39afb64af0bf6304716c63682a0194d9d5f0712db9f3755257927" +
			"d52a9edcb31f7df32fffb9b42fe32e350128f6fcee677b31c6bd920c4f4a4124ab8ad6110b080443" +
			"ef1a48ff75851812ba7628e923e5a1ba8c1b90a69d94e946638c5f29e3680fa1630840a14c84ecf9" +
			"6724191e921d3f643cf8c09d22fef3f8961c4cb0c49fb06581d11e7c46417c8e08ea620e5e95ab77" +
			"a3d317a7c7c79e6acf024eabd09104a0506622ee8a872a71b41b2378488a6f4806f7b311ec3a8b64" +
			"9a9826cb7720d8533952adab8f6c4528dec60a8cc30c8cbdbea7b8295c2bd0f10408e189375e1c92" +
			"7be79204f15084510d22b159990d498efec47c0466190984f9748efaad8b18a6a4e4ebc92add2c8e" +
			"77bab043f813672dc7f6fdc732030000000049454e44ae426082",
	},
	"occupant-busy-large": {
		size:   "100x100",
		width:  100,
		height: 100,
		encoded: "" +
			"89504e470d0a1a0a0000000d4948445200000080000000800806000000c33e61cb00000009704859" +
			"7300000b1300000b1301009a9c18000000017352474200aece1ce90000000467414d410000b18f0b" +
			"fc610500001761494441547801ed5d4d8c1c57b53eb7bbe7c7f9b3e3384aa297c4c35b608f1594b1" +
			"93f72448023608d800b661c98204d82711122c6def41c45b104a2cf664022cf8f744c90b6f91d8f3" +
			"44f01816d076223da4183376627b6c4ff7e59cdb756bce3d756e75f5cf7455cfcc27f554d5adfb37" +
			"f79c7bfeeead2a031b1037ce9e9d99989a9a330033b55a6d3758bb039367921fd8e42881f99b60cc" +
			"32e65f7647bc6eb7db17daadd6a2c5ebc9c71e5b840d0603630e47ec898983f546e371bc3ce888db" +
			"21f8f0814c60ac5dc4e362abdd7efd361eb7cdce36618c31760c60cf9eddb1da68cc3526260e23a1" +
			"8fc466f3a8609009b01f8babababa7263ef1890518338c0d03dcfed39f0e361a8d6fa0283eb26e33" +
			"7c507424c47ccbdad71afbf6cdc318a0d20c70ebdd77e726eaf5c348f4172a4bf4389a38b80b2b00" +
			"27aaac262ac900c96c3f86e2fd206c001023a08a38514515512906d8688457d0448fe244e3b1c75e" +
			"818aa0120cb009082f511946289501ecd2d20c1e5ede44840f61ccfc4d6b5f2cd346288501c89583" +
			"e9e9e791f0c7610b4484e3b0b272d2ecdfbf0c23c6c81980c43d066d5e8692fdf70aa2d902786e62" +
			"76760146889131809bf5dbb61db3d6be005b8802034b2f99bd7b5f841161240c40ba1ec5fd69d89a" +
			"f545d1bc09706814b6410dd619487c8ade9d852de2f78299291cb3d6b973eb2e2dd75502d8f3e77f" +
			"b825f2070319886676f604ac13d6850148dfdb6ddb5ea6c51ad8c2e04077d1dcb8f1dc7a78094367" +
			"00a7ef8d7915893f071580bd7e1d6ebfff7ee777f122acbef71eb46fdc80d6e5cb78d3a6f9eaf7dd" +
			"e77eb53bee80c93d7b60e2e18761f2e31f870a615dec82a13240558c3d22facdbffe15aefdfef7b0" +
			"8a846fe135fda38edc4874b4b43bf9207f001c3320134c3dfe38dcf1a94f4105307426181a035481" +
			"f844f88f90e8d7fef00768e37936832571ea4e53864890774de7241d8819eefed297a0be6b179488" +
			"a132c15018a06ce26b84b76ca67b044496cce0af59bacce7414c40128198a2240c8d09066680b289" +
			"bfb2b808cba74e75088fc4ca8875413c4f50c720fc3e4b4f8bfafb0a13d477ee84bbbffce53255c3" +
			"509860200670d6fef474293e3ecdfaabbff8859bf904e389eaf5bbb599325c22f8bc5252c8722661" +
			"00ae0e5cbee4de9d9ffb1cdc8312c1a0bd307218b388dec1a141bc838118a07dfefcab65b87aad7f" +
			"fe133ef8fef7ddb1080c9bd9e9391ea59ed788af319204a982fbbff39d726c0374116b7bf71e853e" +
			"d177241045ffb1d288ff831f14263e8113313da7594de7c9cf0a316f010a11dff7e912f5e9d22518" +
			"3968632c06dca04ff42501b0c1e771705e8211c3cffc553cc6ac76ed1fb205f2c4d04bfe064a825d" +
			"25490253ab3d6bf6ec39053da2670648023d6747bd499313df83eb637ecd8db98c9857ce2196a618" +
			"7f79edd275a32c7560ccf24d6bf7f76a14f6ac029cc53f62e293c1e7884f22968b70c812518a6e2b" +
			"ee11bcbe4f499be4cf887ca3cf8fb45d5f8ed5bd9aa828abc521d613489329a48d5b76ef013d3140" +
			"a26b6660c4b882d6be9bf934b37da262b973e247f5b7b7e8b981e7eb323d0ac4487eeaebd55ffe12" +
			"4ac00cedb9e8a5406106a09d3c65acec5d7beb2df8f077bf73e79a31c7dd397ecfa74946b091735e" +
			"96d7cd7f324f5efad5dffe961e5b83518368747b69e960d1fc851880c44ab28d6ba420bd4fbebeeb" +
			"434254934801232c769f07781c80ce3d23405c5258459d7829619874f0f98c9018be0e1979bc8c01" +
			"aa91ab02449d36da165405c524c0f4f4f35082e8a7d9bfca5c2bcb5cb760f671638dcf78efe669e9" +
			"9c583edaa794b5a27c102f90d2855f639ded6bd7e0c324503562ccb427270b49ebae0c90847a8fc3" +
			"8841b3ffcacf7fdeb960badfc60a707d2e899b973f398fd51ba42b81a1a84a49988cd457195200dd" +
			"c263373adbee73d15d0218d3779061102c23f1356b9bbb5cda2f9db90019b19f5b2e720cd8871b90" +
			"4afe206bd2362d455f4d6c985103bd8297bbe5c96580d577df7dd696b4abe7e65ffe929ecb596673" +
			"ca69f73d63e4958be5e58c14d81a5a39d0db2735d02e410a200e7633087319a056af1f831240baff" +
			"f6006155d505ecc5c5d3f22a694543c5ed64834a1940833097865106a0d90f252df15e47f7c9e410" +
			"2c6f0612f88e9fc0f217756831839884d1a44a6cb1887b15fef761496a00ba488128039435fb092b" +
			"28fe53b12bf4b92468c6a54bea48ed011e3ce26a80b988da9e81bcfa8336bc3dc03d13ee5524656f" +
			"5ebc58961ac895022a0350d007cadae081c40f062acf8a8fb8760191a5cbe69940b88899a0912060" +
			"b40f9075ff348f8436a2de7aef3d28095129a032003daa0d25c10d9224a4bbc8ce7c9e9e890330e9" +
			"012c2814e449cac9762cafcfdf178c144422212b2d3252007f253240540a641820f1fb0f424970e2" +
			"3f19301f74b1c282575d41e6fe71516f780c81a9848c7887acfe97f781d723d28cec9b6207dc4235" +
			"50220ed22b7764a226014a9bfd84745327640dbb40f76a50248755666c1e8c28c721fba4a5c7f210" +
			"ca9400843abd604b202b014a7e59830ffdda4898358f7cd29ad7ea51a1ac2bf4039bd31f425946a0" +
			"87a9d79f97690103ac9e3b471c320325e2368680bd8be59137aba4e8d6240740c810565e5b9bab0a" +
			"b4b6027defdb12f902771420d8cc520aacdd218dc1800150441c869291d1ef72565b65f54e4a8788" +
			"f59e1a77ccbe586b38596564754882c72213325f1a8e16b6cb20d2655868007c835f070c60151d31" +
			"6ae42db6a4e0ae96bc6616bf3410f9fdc0ff6796bae575687d93de003be78c67b57e56004463be54" +
			"9c3280f3fdabf032461e5db36cb38715913b992ecaf97c329014105f103a50235c35488922994729" +
			"cff72782564759401aaf4e4fa7de40ca00f41a56a8006853a51b3c36c8decf0680a871e7376404aa" +
			"01201352e64c22ebf4e99930b4ac976d0ee19140e9a948f555f23385296a6c812f6500140d95789c" +
			"db6cdb16cc58a94725021dcb079c4b8b9c72d2bbb0a0331744eec7ce799a4f9d28ef59c20086d97a" +
			"8e01dcfbfa2af23cffd4a38faae97266f3f45ed08f101eb45d9fb756c6e3633a66ecdffeb69b4e1c" +
			"03b42a427cc22432402a0192347fd43c04ae1e4094c9308d66d829e93672ceeb55d51284333eed77" +
			"52ffd49e3d5015b4ae5f3f44c706fd31157a53e7e4238f04d72901686039a1b8ce15f738c3585187" +
			"64984e729892ba8872ebb96c83b5cbed037eedf31162d2ad0c985acd4d7a27016ac63c0e15c11432" +
			"802a2a15d74f0eba04277c264dde9379a48b28982faf5d0df43f6dab9004a8d56a9f7147fa531503" +
			"90400335c5a58015ebec2cbd73b099b4cc392366c66813dbbe03f09882b5901b8ed68c41d6c72a11" +
			"9f6093886fcdad1055ec630cdb3ffff9c06f3762ff7dc6ef8735ddcb9763ad5286d76322c19ef467" +
			"c2c7caf9330941bdbe3d562f6fcfbd4760ff7ea81490e66408d64c05bfc441b3a586ee20a12d66ad" +
			"8715b353dee3bad721275fc0386186b57c367c2621534fc405a51fc536ee7eea29a81c5656f6d76a" +
			"f57a65c4bf07a9811d280508728e0643afe9677e4f1a71b20e1ea5cb6bc7e7ed13d37bf74215d1a6" +
			"cfea41c9ab7f3110037863d0cf520e69654bf70f58ba94064649b3e298f116b436b408a1d2c7fbbe" +
			"f215a828666ac801bba182f052401b508d1962f18014224c2b091a9431267a2f238158ba5c5226ec" +
			"3c72041a1509014ba0f7b7bd86ff6c65bfc6e5a440620b3848dd1b392f94a6ec1e5a6b4658f15dd2" +
			"639840c2df538d174caa204fa0662bcc0024051ef8d6b7d612a43ba6b86d72fd2046a48c152fd359" +
			"7b6bcdc75d46cd88dc79f87065677f82994a7a011c771d3800f7922a60ee1677b3028b3bb9efe155" +
			"03bfcf45b5af4f6396749327731d41e4e38c06c23524e9754f152d7f819aada811c8413389c469a0" +
			"bb5964302a8aadb29aa8480d50dc464d9f4bbf3f6dc3974dd226eebf1fee3b5cfae6aa229859f70f" +
			"460c03a40a1efedef79c3fad6dc4e0113be07a5ace5e85610276d0f60e4886611b51b4be10f11ffe" +
			"ee77abb4f2978bb16000024980479009dc9abab57a4c5fb30900f4052050dc3ca5de40eaf8764051" +
			"25d0d9cc42c49fa8b6de0f30360c40a0817592800db00521a645ba3fcfac0c325896c7e4d4e9a02c" +
			"1dd3afe119748c884f182b06204cb08156672b406197b0d73cdaaca7eb8931253ec1b497968a8c4d" +
			"e5400f595c9a9f87cbbff94d66ef3f9fa3e99a4172f433dcaff99b1e43bcbc0c9deffcc217601706" +
			"7bc645e74b18bbb4f4f771f00462b8f2e69b70e9b5d7dc0b25f8460e49604f747f0e008598215ddd" +
			"5b4b7087fa9d77c24318a32037758cd11c7b062010f11d23a044e096b9d1f6ff13f266bd8811c872" +
			"1499a4594fbf719df51e865e378f0c70da6e908f37132310135c3f7f1e6e25cf189ad84e9e9cf354" +
			"5a3006a8e18cdf89c19d8d4078868506aeb75fe8550f561564843df4ed6fbb7392081f9e39e398c1" +
			"3d94c95501770fad0d3f28056baaa18eb37dfad1471dd1efc025dd0d44f80eacbd429b4247fec5ea" +
			"5160fbd34fbb1f819860e5e24577a4d7b691a4a01ff71a269179dc763424f834fb6d38a233e0ffdd" +
			"240668c20607cd5efad14cde428026ad0534610b9b126d34026b75fc035bd89468b45acbce326a9f" +
			"3fff2fa8f8b2f016860c63966b7bf7deeb43c14dd8c2e682b54ef2771e0c69b75f872d6c2aa0fbfb" +
			"7f74ec3c1ad66e6fd9019b0c48f885e488a8d717600b9b0a2b89f1ef18c0ccce36cd961db069406b" +
			"00fef372e97e000c09bf065bd81c480c40c21a0318330f5bd814580538e5cfd75e12b5b2b248be21" +
			"6c616303693c313bbbe02f5306a04f90a33bb8a506363870253490f4c19e405403afc016363684ad" +
			"97d90830ee61615ae66d5dbb063770f9f756b2ec4b4bc0f4bbf5c1072e0f7dbc81f2a4483682d07e" +
			"823a2effd2762f3a4e26d7b42c4c69ee38decbc3cddaececc7784243e6b0add649fae61c541c44d0" +
			"950b171ca169ad9f8eb791c02df6466ebe0f905fcba3df05e4f60974294b0c30b57b3734f078272e" +
			"316fc3f371610c93047f445a087a654ca35e1ffd476fbb8088fd51b2b1e3a3a52537bbf9264f4958" +
			"0df21ebf8e6d182d5a761a1981240631c55df8a3ebaae126c0c7e4e7e5d5bd60eda5a5d350f23e41" +
			"4ff02b67ceb8f3569177edf30da07d20f615b07e401281a4c33d070e5485211650fc1f9289ea68d1" +
			"3be5eb00a76184f0229d08feaf37de4809decfde7d0fad2c7fe9539a06918128505fd1fb5e3aecfc" +
			"f4a7dd71d468011ce2ee9f47f4bf199514b886e2fcf29b6fc2d577de8155227a8f04e76fe54adfe2" +
			"053a5133cf068832329fd51e2661e5209687a5a56d3190fd70cf134f38e9b01d8f2340c6f8f3888e" +
			"f47a4a01223acdf4cb6ca6f381e39db3daf66d0ef9d44f6c5f3fbfafbc74320aed5902f9cc813cca" +
			"3c49f94cff1093f7df0f77cdcec203478eb8f3f5401be0b9c6ecec2bdabddca9364c294084be82b3" +
			"9cc43be976872e03b8d64b937f9da465081c2b177b5640b6cbcbe5f5b71b3345face5f754bb86bdf" +
			"3eb8f7e9a761e733cfc010119dfdae0f390587220588f0977efd6bf8e057bf72e74e4c2a84f0fbf3" +
			"f55e6609ceeb49adf1bc873c206bc543243dad1b84cda0300b7f88843f63d04d8959512757315328" +
			"09767df18bb01d55c4a052216ff6bb6e43b70afa940244ec0f90f044fcd524e892ead04847fca058" +
			"293e211c6400e87e3f49d7ea34229fc6181a5368f983ff41302a67ccd440b4d97710687d251023dc" +
			"8bd260274a85be180117f86a7bf71ecdcd025d907c48f2efd003fef1eaab8ef841b42dd2b885f1c5" +
			"30ddc6bcbac88378f0ab5fed5935687e7fa65d2880d69fff7cbc4874900234177ffc63b88911b942" +
			"22b040daa018669ddd9e205e8fba398811fee3eb5f87ed4f3e095deb0338519f9d3dde2d5fa15ed3" +
			"57a6ecf434450767b4fb24eeddac473d9f349e56aee960295201201ea60550ddb4c0159365957702" +
			"64fea71831d73280f698392fafba7ac245e48f961765111b714ffdbdfb3096f0e0d1a3796aa16956" +
			"56f6d30a2f744161b68d198434eb2ffce8479d67edf25ca6e43c735f7426cd97e40908daad0ec114" +
			"79e849fd74f31c72ea2d626364eae76991b6481afce70b2fb868a3442ce8a3a127b9d53a77ee251c" +
			"e0f4f3a3a4e7dfffe94f75e248a269ffa0cf9b5c73eb5b45cc0dcb6b23cf2d9344d5882cfa9829d7" +
			"437ac0e05a7eed5eec7f4df0e0d7be060f1d3dca8adb93f57dfb5e8082e88901b82af8ff9ffd0ce8" +
			"6734574e719334e272cb1844b98c1ba7b84cfc3caf1dd6e05a3bd2e0126dcb378446fb9a53afd5ca" +
			"2a9e0a28f7d25becbe741d7d3a63825c9f5f434f0ce0fe29f40a2efce427672f9d3ebd4375bd84ab" +
			"d62964332e4eda01ae2f214b50e95f6be572ff41c55db45df249312dfb55a49d581edfe780313a89" +
			"85da88e5ddf5d9cf2e3ff0cd6feeef66f567ea843ef0ce8103cf5a635e865ea1ccbcdc81d366eab0" +
			"30e4ba65d8b7a7ba87d017a4c78bfff5f6db2f418fe8eb35714f9c39f30a1e4ea609a63b1f05ba8f" +
			"95c99d35d61633d472dab7909d51b1be14ae97ab3d7fb4d99749ca32d1ff45e4b790ed77de3820f1" +
			"4ff4437cd72d18006f3ff1c4abd8b123bc2255bc0244dd3cedc8cb70cb5ed6cf3b6f4117dddab5ac" +
			"47f653bb0ed492d26f09abd49da62b2e64acadd8f8b03ae79f7ce79ddc685f1e067a5164bdd57a0e" +
			"0fee2103cfb106d88008ddcd8f1a31548e37ece34fa27e3953d273662cca3a833ccacc93465ca68f" +
			"8afeb5a0cc5a59b70ddf2c0e90ed7ba6adc891d5dd4c68d037066280fd8b8bcbabadd651636dd3a7" +
			"05039c23f63c51d3eb6e3a90a98c8050bc5c9e0e9604a73c057d7bcfc8413f20d24d7fafa8ebd82d" +
			"2d729fc6fc76ab758868000360e057c57e7271b179bbdd3e64191310028e6683cfdfdccd6795498e" +
			"b600e12c77998cd119c9bb4e967d32ce3386ec8b06d1669bd56515e9a1fddf60b3afa1e7f96c4e3f" +
			"645b3c18867fdd98d3d8c38018c806e0f8e3dcdc4cbd563b0d49b8d898ecca5dcc0d5457ff64f450" +
			"763ca7ced8fd204a18f1f3b96ba66e1e01e8eaf269a160cfe045cae7d54b13ad3524e2bb3a618890" +
			"4c10b664b2229820d314319ed97d53045a5d79e595fc8508a5897ade56d13ec7f287d74325beab1e" +
			"860c62829a31a771f066e8da71bf32087e56744390af0706f0b9bab551b41f1928f6433ad341f99f" +
			"7b615ead6fd62eb6ac3d3a4ce21386feba78eae0a4b5fbb1f3f352f4112461a4f51c1850329fb0ee" +
			"e5705aa50d5e0e94fc4694d1ea93ed7bbb43b559604d6205fd64d790730400cdb3999fb0f6d0b089" +
			"effa0aeb883f1e38701c39ec18f488bc1d3b699e487a06cc78eaab7c1f7517698bc739f2eac03b27" +
			"fffbcc99c28b3bbd625d3f18f1c933678edb76fb4590afa3d5ac68cd920765063329500891c1cd2d" +
			"cf3c15359dd71d13eb36ff6be396d7016adbcbb49f6f3d89ef9a871180ec02c3ec826e9056bb763f" +
			"b398d2433dddca15694f6e086199839885bab9b44b3b78d26caf93c89718090378fcef81032f6183" +
			"cf7bd11775e562b302407517d36c00990d24a98e572c73ee5d04f9923ef0bab4fb41df043304c467" +
			"e926766fad9e9353edf6f141033c4531520620a0343868682591a4418ce8fdb87addee6bee1abfee" +
			"a77e9e871f398ab89d1d3491319ec359bf0023c4c83f1a45ffe054c74b3891191a6f1bf820900cd7" +
			"b2ebc0808a8955a983852d912b7558bae5f77d7b9281f891ff62083d8a133426a326be6b1e4a848b" +
			"19d46a3fc4013892260a9de9924011a3a22ebee79efbe2da0e9b98572167a515f9b9cbc8dbe3f59a" +
			"48d948db0bd099f54d2809a532800732c2b338a2c7408b20ae13628c9097afdf10ae0222fc893266" +
			"bc442518c083180107f9985518a188153d06a80ce13d2a399a64282612e160d1325cfcf26b992ef3" +
			"c644b8962f6fb0725d4b6b17f06fa508ef51e9e94436020efc711cd8cfe0e58cd5ac6c0ee6b2052b" +
			"6fe2be4bd78a8b3cb1fa8376f83d00eede2dd3166d3c9d7f6a71b1b22fe31e1b79fad6dc1c198a47" +
			"70600f63a73b6f3153dc3c1e620d889fa475b21ac83c6c1273dfa49bc7da0aca76ee2d9b5a6d7eb5" +
			"dd3ef54c0567bb86b154a86fa08aa8033c8ba78fe3b0cf69163c415aeb729d3e43588f8269895a68" +
			"e2e1b516cef4bb00164715c01916c6daa222909ab88d4cd0e8d80b1d8630660727badf71c4211982" +
			"a0b97c10462b89b84dbcf73ae65ba477ee97e9c20d0363cf001afe676e6e0e1752e8c195b95ac7a3" +
			"d84d6aa3dd511df49bd1cad16cb66bc7269e5ea123966b4e20c1c79dd81afe0d22f2b8c65d53e273" +
			"0000000049454e44ae426082",
	},
	"occupant-extended-away-large": {
		size:   "100x100",
		width:  100,
		height: 100,
		encoded: "" +
			"89504e470d0a1a0a0000000d4948445200000080000000800806000000c33e61cb00000009704859" +
			"7300000b1300000b1301009a9c18000000017352474200aece1ce90000000467414d410000b18f0b" +
			"fc61050000195c494441547801ed5ddb6f1dc779ff66f750926d5d4859a24d59b28e6cb789133b92" +
			"0ad440938750680ab44f96fb5024285a5b7f8165b4455da080a48706065a20d65f203b7968d117d3" +
			"4ff6430bd148f2d0a28958c07612388968490e135212a98b2d91e79cfd3233bb33f3cd65f7ece165" +
			"770fc51f71b8bb73dff92ef37d33b3bb0c3621e6e6eeb5a391ceb188611b203acc221c4580360371" +
			"0d80c8daa17c8ce12c4fb7c4cff88f1f13360b907cda4da29918d9d2f8f8ce19d8646030e410c48e" +
			"473a938cb1a31025938c13971371143600bcb39690c10c678c9904f183a4d39b9998189b8521c6d0" +
			"31c0e5cb8ba33b77b68e41042fb228399927cd9581e10ce30cd149d8db13fb774dc3906168186061" +
			"e1ce246be1cb807072a3247cad101a82b76faa87f0ee63fb764fc110a0d10c303f7ff7181bc11719" +
			"e2e9a6123d0fbc636739334c77567ae79a3c4c34920184b4430bcff00e9c84cd0006d3dd2e3bd7c4" +
			"21a2510cb0e908ef406885248173e3fb76bf050d41231860b313de459318a15606989b5b6cb776c4" +
			"171e14c20730d55deebd56a78d500b0348576eb4f52a9f91390b5b103350675bd03d3f3636b60415" +
			"a3720690ee5c8c17c4cc1c6c41430c0b9d5eefd4c4feb169a81011540421f50b8b77be07315edc22" +
			"be0fd127ad38beb87083f75185a8440388b17e647bbc45f89290da60b977a20adb60c335c0f5c5bb" +
			"2f73e25fda227e79486dc0fbecb7376e9d860dc6866a00a9f2f92c1e6c61f5e006e2feb15de76083" +
			"b0210c20c6fb5d7b6261e89d842dac07a65aac776a23bc84756700e9db6f6fbdc315d93168029215" +
			"60f717f9ef26442b37e591f13058b9cb858b7105c5d95474c3b647004776f241711bf41e7a1c60c7" +
			"5e481e7e0c9a828db20bd695011a63ec7102475ffc0ee29b1f032882e780f13f14a32e0d6369b724" +
			"6c04e091c7a1b7f34948f63c0d7563239860dd18a011c4e7848e6ffe2c25bc4bf44cd0570ba11df0" +
			"e1c7a1bbef2880d0143561bd99605d18a076e267848f38e1596f25bd2b74282ec3063c07724dc27a" +
			"fb8e414f68849a18613d9960cd0c5037f1a3bb5720feec475ccd77b2104af8d0b97b848278807017" +
			"f141636417f4f61fe543c3335007d68b09d6c40099b55f8f8f2fa47e612655f7129468fd2114443a" +
			"d48744dd4d930706bdb167a1377e4c1a8fd503675a2c39b116ef604d0c70fde6ed776a71f5b8053f" +
			"f2e9fbc03a778d1c933b918423c9651a97ce8e90bb7974bebc7366ea826d3ba173f8cfeb1a12a6f6" +
			"efddfd12ac12ab9e09bcb178e74c5dc46f39c417474908f5cb286bc934a6699c246914aaf4e6884e" +
			"198c14cf80d6c5af0543cebe0fc0db54034eae65fd60551ae0c6e2dd57134cde84aa21883ffb1eb0" +
			"6ed6d1c1e19a992025d621c38e31474bd889980a4330f3052c731b1d75a15d496e17484db0ad7a4d" +
			"c058f4cabeb19d6fc38018980132a3ef52e59b34a5e4bf27a54dc14ce484af3714792687180eda7f" +
			"51c770b0d45dee1d1fd4281c7808c82cfe6a89cf5d3b29f92bb68a75895d19f1656539e182512fbf" +
			"27db5c3146056d16171707a2cd400c201677eab0f8e3f94b72cc975044466b10f7cf83f14ed8200c" +
			"939bd60f176d8d172e41d510b4e926ad3383e4293d04c88d9b315e848a112d7d02f1b51fe6c4667a" +
			"9831e3b3798472d2b8e1549707f3d32cd4f477c2d1188daa537b4ffe2924bb0f43d5e8f6f8fc40c9" +
			"9d45a53480f0f7c5362ea81a5c9d46f3469268b7a746b823edee904073a13be36fb4823e23f9112c" +
			"43df948fa1f9029ff802f1673fac6328809138be50762828c500bb475bafd6a1fa85f4ab719f1ade" +
			"fa5cd15687dbc4b1ac7c1ee7da6d8a9e2c901eb2f47a5699a437d7e909330db07991133fbaf11154" +
			"0d41ab95242ab50fa3ef10902eefc697a16a08dffa17ffe9b867e65cbb692a44aa61134657f994c3" +
			"97797f061603b969ed7addf2c2dac4e44f279778be783b74bef4575c1d543f53c8bd8223fdbc82be" +
			"1a6064475ce926458578fea736819d01c053e8888440367398891d4cd3a91f09a7f93023b80a8340" +
			"79398384d51e79ec2d437cbd7a2d20c005f742bf34850c307ffdf62bfc3e6ad9d5c3eecea527544a" +
			"d19f85037a4dd56f283e740ee1b46a12c8b33302f5d16bca88dab6bcfe612db600c7e4dcc2e26451" +
			"8242068822380335205afc840f01770cd55de2526340a501124609e0124e9da0c359a8a4d6e1221d" +
			"c4cc39730b0c70122d5fd8029fcf411d68c571210d7319404a7f0d869f00bbf529f8536d9698417e" +
			"e733e7dac96f73103904c2216030886342982341a7ad84b9489bd9c28750130ab5402e03d425fd02" +
			"ecee6f2c0942655d17d13e9376a42b3e8e7ba8691f4c63ea31756417483404e513a692d132dc3665" +
			"49efdda86b1828d402410610933eb5493f1ffb517514e96fcf555334747c774ffe09415cd7d1fc90" +
			"948dd60843d3824aeb30a0e615b0f9cb6a18bf27c904f520570b8435807854bb26884e4a3b5159e3" +
			"864040c251fbe9ce46009d9e2ee9daf9653d40094e54b8d604a8db41d582761313e341989543d366" +
			"bb2de9b14606c8d5021e0308bf1fea7c5c5b1a4b3631285154b83ca0edd6e9d5404c27671401d512" +
			"ae76cd881b68ab7e4b6e03134b19a90913a54550b7313b32326428f5502303704c5e9b5ff4b6ea7b" +
			"0c30b22dae4dfa25bacb96e19e3f53855ebc925a1d4b18a5a0080f2ce71ac94c5f7a6dca41626fe4" +
			"a563f532009f228e3c97de1f0258bd2f6bd04bbe5a85824d28ddb366760fac684208953e8f01ec8c" +
			"e634b74c276de08839654ad464042a448cbdea85d18bebd76f9faccbf8d358be037a654f809affae" +
			"58696bde897709064e1a376db0dc40386001f103f9dd32976f43cd18758d415b033078116a470e61" +
			"ac24e8a72f2a2b37ba8fc4e6850d5257e9fcd5206ec52fd36b8b019035e3614ecbb50bd0ba349db0" +
			"7ff9964b87057c17e04b6d38221823d3b13bb0610cc08de39374a9583380dcf0d18097315a1d9719" +
			"00ba93b5058e401d79b486091346ad7cd79340cb825367a650d7c35049b5fb88d458342e2942beb7" +
			"d24f215584d1fb5dd0de80660016e1cbd0046cdb250fbe898759a79be55a743c818c74563e24224e" +
			"ad7bcb450c94e50349ad68e55139d1a9839629ebdb56df3385147164bc01cd00c858331ee7e6ebe7" +
			"4428add93b661c6ff32324b6688ff6caa13c585a432573b50938e543786840fbe849b85386cc9b31" +
			"77dde0de80b6f52403c8c99f863ccf8f0fedcd4e6c7f1ab50a77d2a3cd242a8c1efd8b146e3e92d8" +
			"c9877654c678f6512547af4c3decc4753c3ee683b7a6bd78efde61712e196064246e86f40b3cb40f" +
			"c2a244af6938b10b727fe0e591570839e9dcba20a7ccbc7662386ce70434059dcf3b27c4b125fe25" +
			"0c2759c1e85725f0e1476dc9348ff9d8e7561cf8abc776a98195de4c52dda9c3607d015871e86f32" +
			"668ed690f7b60f1a03966a7ca90158c48e4253c01900a2ede6da1532353f4454afd9bd138635cebb" +
			"e5e68ded2a2e9fabecb83ce157d742fdef3a004d01b7a7be298ea91188d09c21801b81420b28780b" +
			"38ce586e2fc4f42118a2138f3a1f90bcd4c2b7af89f58fbedb87e0ab7e5de6ae27a059606df13f9a" +
			"4f57881af531067cec79f04536f302947a46f0265ea8bf4f45512febaaac9a9198c5588c9469dc44" +
			"d0c44eff33bdba088ec1a71d541585a66e1c6b43c3302a0c41ee11b49af7250eae2a31da4e889be8" +
			"8d16901d2d8b056d4956418621ece2e9ea9e750df68613bb4e7f62c8d2256808efb643ba7f8f7e09" +
			"9a86dee79de311444973d4bf8218061e7f3e13f64c52555cd6cb39c3b9076b57afca8beea60de71c" +
			"d47001a54c63e6d5e95cef6eced84fd165d88eb0eed5bf3c3cf6b574524880104f76377d864f4fff" +
			"a2932e838a13502b8cf431729adecb8b7ac4f1ca7718aa281e0efc313411dc006cf321801d862642" +
			"6801690bb87008a6c2bc6401ddefe5cb81c304007dd21715f50427fef666cc007a88d89e880b5473" +
			"bfc6f5f8d7f4d4b04458c7a707df0087c295b87e740dc4bb8b3c85106904e1f77d199a0a6ef4b623" +
			"be08d05c06105ae0a91360f9fcc4dad7169718d3b5c596fdb2851e32a8836db52b77cea870a4ea1c" +
			"dc2106f41b446979deeaa5323e45d5071a2cfd209bc88700c0667f8f6fec29a90994ffad97638174" +
			"bc72e7c015ce34045da3916806d4e531b36a674a27ca073571cdac805b9e69a31cbef63757fa159a" +
			"6b04521c7c41ba527acfbda3f6ddf57acfa6b33803759cb58c8c4eb8a5080cf15d37911e05d265df" +
			"dd004fbc004d87a07d659f8c5913841df09597883af5375db8be3d16d985ae918750f892116f8712" +
			"55fb4e9d287cfeaf9c148fe6c2306038184080131f9f7d09986602a3accd4c9fa5e803474b71fb84" +
			"b5c2fa1d551b485b44db2c466d3e868701040413a80e768d2e7b505627f6d1e20146aed12a4fa97c" +
			"20c6a72e970e25748cd9be7be8882f305c0c2020a5ec2f733a1ac302ef2a07198f908b3ce5e1c62b" +
			"6c1b3ec957600b376f230c23bacb00d7fe17706e06dc777edadb35511b86d95b6448faf48aae28f6" +
			"83499bcefdb303c752237548c67c17ecfacddb9787c213c8c3c2cf01aefe4ff6d005b32d7565d8d1" +
			"f464e386620afb02b522f1a2809c0b823ffd2d80bd4fc1b082dfc66c0b861dc2d7168b2df33f07e4" +
			"8c40659baa6a744fc8516909ba2064bc0ae35aca790241f8092ef513478756ea15f87d2fb590c12c" +
			"3f6bc330431860875e0036fe65a90df0d667e6312c41e0d04bff15b199dad8e1461bb1970cb18908" +
			"6fc0380324f82963e5c6bfc64330c2337f964aeffccf006ffe1ae0d6b5f4a14c6af431e2bea1bb4b" +
			"8824138416fbf804e1f73cb189089f22e1a2228680cabf585d09c69fe51ae1d9f45c68842f1652cd" +
			"208c47a11dee0b0d6108cf76ec4ed71e1ed90f6c2727fac3fb011ed9b7e9884ec11783665bc21080" +
			"cd0e21bdfcc726faef7dd924bab014124efb88219b852d3c90c02499893a716f06b6f040a2d78225" +
			"a9f1f864d022346c67f016361c4bfbf7ee1ecba682b78681071052f34b06404c3e802d3c50e0f31c" +
			"ff2f8ed993416ccb0e78c010219b9647f1af17f7a6610b0f1494f12f1960626c6cf681980fd84206" +
			"9c113417677a3f4082f82e6ce181009ffad743be794750924cc1161e0874babdb7d5b99ef914af0e" +
			"eba2fc36d0d67cc0e686f4ffd585d600e213e4b8350c6c7af085504bd35b7b02f930f0166c6173a3" +
			"0796907b8b5fc33e2d8c6299b77b1fe0ee427aaeaec532f0fd6c93887823b9b876209784c5f2affa" +
			"edd8238f6c275f1a6eedc88ec3bb3c8c80b3e37bf71ca161fe9630c4f35c4f9c81a64310f1ee7c4a" +
			"68fe833bf329c17bcbfeae5d7b0fa8b33f8c6c2015f9dd6dff7427b8b88eb76b4660638700768e0f" +
			"0d63442c9dfca1f034c0fce2e2318671f55f3eee0349eca56b8077b2e37dfbcddb7a5f9f86fde61f" +
			"ebab201e47d8259934683d3b68731023a91122ce08c03588648ad1839c29c6a169e8b2de11e5ff2b" +
			"04f73ff061e0223f4c428d90045fe484befecbf4bc2bdeb56f1ec1721fd4557461cc12f10cd9d66f" +
			"547b00cda6516fb7afdb0e70368892974b6856f07888892f6f482660fb9f690a434c73ebff841b18" +
			"6600f14ef938be08552253e938cf09fedb8fd26b19e1cb20907046b77ed37300b2d78fe6a7fa00f5" +
			"8650e6ef0c4ff330709e21f1eba56da2ef32d67b2d458287b876183d046ce2abf25835f2be289ebb" +
			"03aa2a2d804b572199e3045fe08417c61aa85dba4e6702f3366f9a304306379dfd2d60578d87ca82" +
			"d2e1a6dcc1d232615072cdc0f63dcd8f7f001b8d90f167da96838dd40282e838ff0997f48f35d155" +
			"bfa9a777ca0ed73a3d09a3f92ca2040c3cab4e372a50a7c73a6e3bf3f207d24970bb211a7b12a223" +
			"7f927a1d1b004ce0d4f8bedd6f85e20af740aeab16102a9d4b7932f721e0e2d5fc74a121bc0c569b" +
			"6fa3ca5c455e61404613cfc96162bd5024fdb2cea2cceba20538e193ab3f81e4ca4f525fbc946897" +
			"419178b9f20c39e108f93e22cba98715941f6a5b280e0af2a3d404d1937f0491181ed6a8158aa43f" +
			"54bb87556b0141f82bffc789ff53befa70dfd416ba7f6d4a63b86f2d2b8d8481ca07be2568950d61" +
			"69747923c43f7969836d74db85f965a1734ed3abb0873823706d101d786eb58c30c52dff978a12f4" +
			"6580b9c5c5762b5d242a8de4d73f96520f1d33dbe6ddaf93a79f1e2892dd7ee5609f3c411431434e" +
			"5d65ca2f739f5e5b3923c44f7d9d0f0dcfc12008f9fd2e4af5c7c28d5b67cbcc0ee2e215e87df43e" +
			"9fa4b995431cdbb237ee98df20f791edd4a832ae952fd8e147bcf31efdd65f1af5ea35d7b6f7c1ac" +
			"fac149efe671db588631005c8672cae25a20fec313c0c6fb7b0e09e2b9c71edd73b65fba520c2096" +
			"8a3b185de28d69071308752fa45e8cf3403a574d98904ea361ba839d7448096d3dd307f670a08233" +
			"d58f5618b3dae1961daac36ba7c79d19c33af584ca0ddd93d536753b88b965e7213ef03c444f7f3d" +
			"77581086dfe72c397e84aff0f62babb446cc3308f12697fa8fdf03bc770b0645bf215aa661ac6fa7" +
			"a4f42f970e078c0f692884e2f24a8c1e69ba9c3617ddb3ee33312c1c7d09d8aec00c239ff4d91f98" +
			"f4c92baf34aedfb8f52692cf8f0a89effde2bfad8695a92c98ae9f915016e8288841cac9a9b7ccbd" +
			"ada5fcb5207eea1b5c1b7cc354c117f3c61fdd73ba6cfe819a438782e4573f86deaf7e049e1c877a" +
			"3fd56d46cd99d666f12a8f2b5f60ca0453869e65b1f2917aac32e9ad06f203986b0ba42d85334559" +
			"80d50db9faccaec7bcb326902754bfdbcf69b4608098fffaf9fc792d1a08c22b883efaaf4bbd6b33" +
			"a379a6d3da50a458d7aac0abac7b906a4302502a2328a6880e1e5dc2af7eeb783fabdfc5c06f0913" +
			"1574ae5e7a2dbd42d00dce3894bec9d302e69ce724f4def44633e58d21182e4b1fd03987823a9cf0" +
			"42f302edba8b5f5219884bbc9bcda9c70f50ef374caecd9c1b94f802ab7a4ddcc1ef7cf7ad24c1f3" +
			"e60b1a5973b21734f9cba3b2a916bfa873fb25cbea67138ec6bbe5424ea7d2f2f5220ca4eda0cc85" +
			"a1bed7d5a33da744980749ddfa4b42d93573db8c8eaa25f7997a0deefd93b6a323106e5b65bdecdc" +
			"816fffcb9bb00aacc924f9cd7ffcf33b88c949535080f2e0facd21bf9c2edc32eb5a85b92b82feaa" +
			"9f5dbf9bce5d59cc4b9317e61fd35434bd7f37ae5543dba07aa7e89ec2edb4e2194e1df8f6770b67" +
			"fb8ab0a617452edf6b9d52cf15a26a2a921fa8c6a39144229534457a43a043c1d2f821d5ec68099a" +
			"9a880b9a96d9e744f30090d7cdba612a0fda6994ea05a48d32f7e83595681595c46775f4ee9b6a2f" +
			"d526a3517076f9de17a7600d5893061098fbf7d7db08d145cc79d3986b8cfb1b2ca0b87565d316d4" +
			"d92f4ddef92065f7ad93dacbeb602bf3fa66f9f4db8923df796316d6803533808064026417397fb6" +
			"d3102ad32ecc2e1c9502759efecd3152c34ae4294a57ae3e3bbd69814fd150b94575843881e60327" +
			"dc94c584e4335c33f1698d6b866602a109ac818ff8f079b52380b7c7ca124b12a681765eaa57c155" +
			"3be0b7c751b7e17a9d72f3e80239e5e8a606dae2d29a91c8507fe83430bbb24ec43745ae13041324" +
			"09bbc84fdb7d13870845e302c165e5bdb0ce32441c34dc65b0d2635ca0cd45c3035b5fe20bacebdb" +
			"c22778c3a2084f0079d49cd83f366444ce9d12e1f42dfda2fea145202983186381baf4296230dc0a" +
			"a2c61c18a38e1402e5c96fd31bd13702cd39ccac37f105d6fd75f182095656ee1de7a753ea034c0c" +
			"d1e95c7263c4b9a65fe0b0ac722b9e7c8ed52d87e4570c46db00c4a2075206dde69d9566dd93db46" +
			"e30960f69170bb3ce6b645dd73d60674ee5585b34c7bd07990ac2fa63a2bf7d69df8f63d6f00aefe" +
			"e0f5b351c4ce50a9d07e34b3dfec9d37cc8690ab9d0365d23c9097cf896381732f8db362c74c23bc" +
			"70ec731f45f793009e3ff4d76f945edc19141bca0002d7beff4fa7812567f8dd8c163522d4f97969" +
			"caa24ce7d36b80c1eb088272cc2ac1b5c81237aa5f3bf8b76fbc051b880d670081cb175e6f6f1b41" +
			"3257c01c5b0921b83247c352bd0fc115401d9d855bd4a516380b970f0e0350b154f5d232c0496c79" +
			"3a8ce4c96141e6ef84a2ede5923fbbd28113474eadbfcaf79a0215e2ea0ffef14d5ee1abbef21b44" +
			"5607415e3d21f95f4d1d79834501d305f31a6004e7bb2bcb678f9c7ab392977857ca0002dc2e98e4" +
			"eaed02afb95d5a55bae90655b16b55c92eefb8e16e72b4a71bfad68d32c96cc2d8a9437ff3c63454" +
			"88ca3f1a256eb0d35b3e8e093b67b95096c54f2d7913a67f8ca401b0bc052b5ff6a32b75a1f2bc3c" +
			"00105a91f4d6101804dbace68f2c0177ce2d4f85b1732bbc4faa26be40e51a8042da0671f2bd04e0" +
			"24d3cdb11787808403a87e37e2682f968457ec80e454f190d5c4bc32fc3a21501e2d2724e67e3c38" +
			"65495b61bad365a7aa18ebf3502b03285cfbfe3fbcc207bf33c8b02d031082bbb0dc711303c33a7d" +
			"cad7d8686ab7aead9ebd11d8e53c528e37da7b758067409a9dcf6ed16c1a7becdca153d54bbc8b46" +
			"3080c215ce0811b233bcb3da8533aa0eb14990978646780c80d017a12979379e9655d46ec690131e" +
			"39e1ff6d1a1a82463180c2d50b7f3f291f44616c320db155ac4f8c3c2bcd4d634a082967131b0e0f" +
			"95ef0e4e4170c243c308afd04806501036421c256723846f7255da9681a1d53a054d831009036148" +
			"cb08a885dcb2c02fc7ca23c396b875779e0f0253074ffd6b635fc6dd6806a0b872e1ef4ef2e69ee4" +
			"e3ea8b50e55bcc4af25286253e79cbd740d8db4d94f61086860128c410c1fbff15ce0c47f965ff2f" +
			"4149f8bec57a40f8ef3d8477232ee95de8ce543581b35e184a06a0b87ce1743b86f81842341931cc" +
			"1882af3b640b508c587efa79406209ea3005447b34b72d4d41dcd904d9073c74a6079d694ef05918" +
			"620c3d038470edc269ce10add124658676c4e030a7a2183646b97a1e65ca9e10202b887c42665606" +
			"21ce8a6d573d886ef1d0ecbc3733ecc40ee1f79afef9615374fdb80000000049454e44ae426082",
	},
	"occupant-away-large": {
		size:   "100x100",
		width:  100,
		height: 100,
		encoded: "" +
			"89504e470d0a1a0a0000000d4948445200000080000000800806000000c33e61cb00000009704859" +
			"7300000b1300000b1301009a9c18000000017352474200aece1ce90000000467414d410000b18f0b" +
			"fc610500001aff494441547801ed5d4b8c1cc779feaa6776974b8ae4521269eb05cd5acf488249da" +
			"4948cab045da422ef18346901710c0e2250e1c03a2821c9c13c9537c492c0181919b2420487c33ed" +
			"244060c7e1ca862dcab2c495ed245224795731694b22292d253e767766fa77557757f55f8f9e99dd" +
			"9d99ee21f7237bbbbadeddffb3aaab6b04ae425cf9f5b38db128da25a2762342ed76089a02a10121" +
			"0f09a2f4ec4208cc83c482cc210fc843ccc768bf11b7c42cd5e285f11d1f9bc5550681114742ec1a" +
			"f6d744b4535eee27410d49ec290c02020b82209940ccb6633cd38ce3d9c99bf6cd638431720c4073" +
			"a7a65ad72deeaa23fa9c94ec8345d23c2c08c90cb21fb3ad263d3d76d3be198c184686019a679fdd" +
			"5f17e20b041c1c9884af154a4300c7db6df1adfa07f61cc708a0d20cb0fcf60f778d89fae7a45a3f" +
			"5c59a21741fa13f2e1ce2c36e95895cd442519209176882352daf7e32a806284568b8e55d144548a" +
			"01ae36c27b905a218ee9587dc7bea75011548201ae7ac2bba8102394ca00248770a88b27af19c2fb" +
			"38bed4a2c7caf4114a61003594c375cb8f12e828d6a1869247511f7f426cdbbd802163e80ca0d47d" +
			"4d882751f2f8bd729066a1dda443c3761487c60099d44b3b2f8774eb288424c8e362fbdec730240c" +
			"850194ada73171625dea7b84d4064b4d3a300cdf20c28041e79efb8224fea975e2af00f2594dd4a3" +
			"53ed374f0e5c5b0e5403d0d9e7beb6aef2d706e5208aed7b8e6140180803287b4f9b9794a37710eb" +
			"e8078e8bfac4a1418c12face0089bdaf47df94a15da800a8b508ba781674e92c62755c7c1b50718b" +
			"ef59f9c4862d10135b211f34a2a9db20366d4fce95c180fc82be3240559cbd84e80ba7d13af3424a" +
			"f8e6a2b95139e9e4dcb4c862f5a548568c24ca776c0262ebada8dd70276a1f7c00a563004cd03706" +
			"a802f115e1dba75f44fbcc8b493889cb68abe92a0277ecc6eb6b5e566cd88a68eb6da837f625e1d2" +
			"d06726e80b03944d7c45ecd6e917109f3e8538213c315117998c53120a9e258589dc78406b061d8f" +
			"ec6aacf1a0d408f797c7087d6482353340d9c46f9f7b15cdfffd0f23f11edc3ba4823c04c71a6411" +
			"3c8d1791fe427dfa41d4cb320d7d6282353140e6ed9732c64fa47eee4768fef22799a0bb94a200e1" +
			"f28b44e2851faf392057ffc28acff3a795d76ffd68c208a2be01c3879815f5f1036b191dac8901e2" +
			"7327bf59c6508f162f60e9c56f24e78ef9b2b370fc3c031e9f852d9e617100828ea40a47d2144c7c" +
			"e44fca3209c7a3ed7b3f8f5562d5338174feb92365117ff1857f49ce4a8a937f941e49ba65bd331a" +
			"c65aaad3547d4e88abcb3206d175da4c93d7919eb3b03ce22b0b3d31e4807090ce9efc1a56895569" +
			"003a7ff2518af138860c4efc5ed08be0f7134a036cf8e89f96a209a4a97a44dcb8e769ac102b6680" +
			"cce93b35ec459a86f85794b9cb48a8edb316e7ec3a49b5c67f2c3d14d6d07169057e27dcb1a4671b" +
			"a45f31395512138885a556bc7ba54ee18a4d40e6f10f97f8d2e15b7ce19f13554b19d1d2136584ca" +
			"2891eaf79cf83a8f49d76161cc421acdd53b85896fcae7ed660685f543240caafa5a382a1918686a" +
			"42d286de3db522daac8801d4cb9d323cfee6eb3f045dbe00610c3792b04538cd1859989f89d148db" +
			"ed54c8e354a0214c9dbcac06b178ce4fc26a27cba8fecbbeb6649f870e459bd6d2919514e9d90424" +
			"2b7920a57fc868ffea6758fcf9bff9da5babea02182d2efc384bfb0b3d550436d913f013dcf6dc51" +
			"6120efc4ce3f407dc7dd1836da2d3ad0ebcaa29e34801aef27cbb8860ca54e975fff3e52c986457c" +
			"91cdd1682d6c1f946b71164f9625c8cd46aa09c82fcf0f04ae4d47c9494baf977ffeef259802a036" +
			"269eecd514f46602b62c3f5a86ea6f49e98faf5c600f9552db9d9d751896ed264344b8369a6c7b9d" +
			"87e1d401bb5ecbcee766c46acfc993c4b4aea0f5c6f3183a24ade2e5c59ed661743501e9eb5d3187" +
			"214349ffe5ef7f3d77ca917bf742ac69fe2adc1ec898023bbef343e2e9a1bc6a8670f2a12f953253" +
			"b8d4a2e96ea382ee1a604cac7a92612d587eed07b9a42964debd198111050f9e378f23cb610c9663" +
			"0e223f0be2fa9ee97f271f027d5547dcbc82e6fc8f510626eaddcd76470668bdfdec2354d2aa9ef6" +
			"f9374cd8262cac219c70ce7a96cff2d78c5d277403e976d87552671c838f24d2b7874e1bac7d1ed9" +
			"9c7fbe145f40627ff3d7cfeeef94a123034491388212d03cfd5232e6cf9d2bc76e238d339eba2b85" +
			"44e0c332cfaef33aad239497c2e5b357c896bf51d0263517d17ee70d94815abd330d0b1940493fca" +
			"7ac5fbd62bec8abcb03dfe273f9b8eb008c1f3b0b97e621ac63874dde030058f07d7583a8ad09c2b" +
			"c70ca08b16286480b2a45fa125a5c5b5cf706c3a9c78807be7597cf64f4b28b172b9e34666224813" +
			"cb926ccd2004af3f60ed867c0ede7efbbd37cb32031db5409001d4a44f69d22f6d3f2d2f9a31bef6" +
			"fc99f0e6f46792c66db29ea435f304605ada10921116ae13e9e6d184d475515ea7c58c761fadf6a5" +
			"19882fbc899250a805820ca03ed54649509292c04823f26bcf2e93a58135c1cc946e9c4b23cbe51c" +
			"c8b903cc77c8f20a5e8ca97efe8a395f3840ac2e58da20d5026fa12c1469018f0192717f899f6bc7" +
			"cafb0fa87ea38e55263ef076992293e89c8802aeca06a79351ef40c81f88593fe0e671d34c9fecfc" +
			"fa28510328ec5f3efd436fa9beaf01c6ca937e05356e76876b7c2c9e2ccf8cfd219d756d09bc9dd7" +
			"0c21c996527738a9eb084d0209abacc3104e7ff8d968b792501b8bbc21bdaf014adeac21be9c2e6f" +
			"2326f9c4ae29405c6dfffdc99d74fcced374397dd62b08426501a72eb21d4ebeee809c7e02012668" +
			"96e3046a88287ad48db318a075ee470751f2471df1a5055b92f41f47a5e6929a13c7ce973982225b" +
			"e2cd884e2c5d4ff2c052eb19b1636632ac3438e602569fc3664196bb3cf4fd1f1cd094eb0c5a0c50" +
			"539b2f960e8710312160606d8976cb5a75c026ae491736d14cba08c4919397bc7edae1f0752f3391" +
			"8346bd26bec0af2d06a02a7ccce9d21a2e1111d008f6c48e4d1fcaa5d52a17b3785fd57b7579ed90" +
			"57b75707027d2d1924c441feaad8304032f647153663649329c8bed2d13634cea6561c074ecb2d2f" +
			"07e62c5a84029744b2de347286b37c025327cc5746bcbff6992b0bb2fe521538409a81d6e2a2190d" +
			"180650dbb0a202508b2ab5c6354bc0a01f2a1922e5636c1882192660d2a6d7fa68f0491c9e974cbd" +
			"6e1936af909d050bf3f2c2d25a64f55985a3c96a6c761ad584d1f4860164072bf139b7fa3c1b4c92" +
			"c97ad280e75c190a3082722d60a97e3f9c4f0f3baa3d6f00f93c44ae1160a97ad6161803721f4631" +
			"e8c6123f2a6510118caf973040b25f1faac100d1d69bd200f94770accf19c230092c9ee908423863" +
			"51bb28e88bcd3376f66c3421ea93a804e4488fde7df176154c18a03d568dcd1c146a5b3f080a3a65" +
			"5a153349746c7bae05c8925ab89e3adc78e1c779ce9cad0d845b1728dc6fc0ac60aadf783baa8276" +
			"73e9803ad7d51f1147fb7b5f1f3c5828065030f65c08e6e009eba30d3ec6d7644c2ef51fe108a421" +
			"9cad34ccc7df591b42384a45d8124fac7fe653727266a8599b3aaea6b55b0520fb9d087dc20091c0" +
			"ce5eb4e530509bba29f103f4ac59fee0f9979ac249832dc93c8a430884c6e244bc1cf9e5c8af3063" +
			"158731ecf6f3a2e96e23f5edd3a80a24cd1f4aceea0f55c4fe2b88b10d091358d0aa9f4730b56f62" +
			"3d07d14e474c763ddcd933e625504ee775cd819b89f5495867aa14f11524b336d4395a7efbc78af8" +
			"95fa3186893b1f6476388d23cf6e8379e4c8cc00bb66b6d92a9316b41928c85c7e7b00e0fa02769e" +
			"3c6f6cf2a5c5c66ebe0fd5024d2947500effdb53a88a039041498b5a469d6cf62467ec94ad178617" +
			"8cf2cd3778603e80c9c3b4719e66ab70387524d01f9eb070de261c5f23bf12d6ccb2ae3d4e4a459b" +
			"b661fcf6dda81cda8bbba3a822dbb97128333071d7832057d2b974eb78a6c6cdd81ff98b1c627979" +
			"394536c1df02422b83bc1cb1b6720622c688faccf3326d90b9975553ff1a712b6a48fa470d541013" +
			"777f0c91fa98c25006d633b767f12898cf9a0402ac301f469a78727c81c236285332c28a137cd8c1" +
			"f26db8ff93a8242234a24888db5141245a4032412e4d86aa28b2cbf6d9e2162f9d6b04d707b0a682" +
			"dd3ab9c6711c430af46df2fe4f21dab80d55841c016c8d9433808a4231806284fcb9daca17e44fd4" +
			"687f80b804b3743339935564d43fd300d6db3d5e96af032414305ede9ed83885f1c6475055c8d16f" +
			"23a28a8d003814f137eef9c3d45e13d8f7f8f98c1b5fc2458e1472a6c9b29879249e5700c115457a" +
			"08e728889c494c19bfaccab35149ffa66a4a7f02c500d27badf4eff18ddf725fa209dc57b21aee2b" +
			"5f1b9c48e4ab7e9d8b6b92bc186330d7a9b4b589555f169cb8e763189ffe28aa8e8846601fffc9fb" +
			"1f464d4952a6766db780139e2ce78b0a1d3bea98965645f9acb369879b145e8e85e51f25f5930f3c" +
			"8cca43d27ee03f18d10f88f10dd8fcc93f970f562b2b8b0358d89ed215de94b1965cbdd6a0408a2d" +
			"09272f2db84c8d117f8becab325fa38091600085e4c17eea8ba94d35d20de720ef9a28b45084af35" +
			"8065d7dd7ac9399bf29e26927d944e9fe9e38860641840c165829c10149064db56eb891cff7d81ed" +
			"f459ce20883111a3b4c3609448be24fec37f3152c457182906504898e0e12f263e81e59d03418f3c" +
			"77e860089e98078709fc3cb034bf71195c27525ed7923e8d1ef115447cf624610441cb5770f9a7df" +
			"c595977f50bc17306ccf4014a43913f9290aeae4f5a8f0e4bd1fc7c69dbf373236df85a07327e746" +
			"61245084a55ffc04975ffa2eda97de81bb875088e8497c96600d2729bcf7905b872e5b1b9fc4a607" +
			"ff18e3b7de8f9185c07c1d238e890ffd36ea3bee908cf0bc6484ef24717c29169f2ce2029d9880c0" +
			"0211f7da2b27257df2be4f48c9ff44323a1965c867b020e8ecc9137495fc78737cf15d6916be83e6" +
			"9bafa17df19d34d2da3f38cbc85f01f37d7f8dda67f1d9652489bde12a213cc34c3d267a6310dbae" +
			"9581e8ba6db84eaa6585a5d79ec7f2e9ff4e982196fe8225d766dac0b1fd2698c60ba9e6ebd7df82" +
			"0dd2ce8f7ff08ee4faaa421c5f90264094fdc5e2403071e7ef248742f3cdd7d17ee70c9a6ffd4232" +
			"c3e5443b286d916a00a4122e9927ca085edb76737256c75524ed1e4844d20710f1fc088e06578431" +
			"29bdea502a7c1d0c31e623f94a701eebb82621cdff6c546b8a59ace39a44bd1d2f24de9f9c0c9206" +
			"b1daaf85d7d16f888568fb9e6ddaf8cf631dd71828d1fce987218467b08e6b0a92e62fa97394fea1" +
			"753fe01a4314c533c939b96a6306ebb8a6b09839fff99aca117f29b48ede21893e2bb6ef4d3e5532" +
			"3340718c6f611dd706048cc9cf1940d071ace39a40ab494feb70be49547d5171c555f95e601d1c62" +
			"81ffa49c6100b1edc0827c17be6e06ae720847d35b6f816281a7b08eab1cb125e4de4280519f166e" +
			"bf7f3e592fd83c772609ebeb7849bd067e37c9935c2f5e36ab44d29543406dcb0d88c636406cd898" +
			"bc1aae5d773dc4c4468cdd70ab8c9bc4987a3d2caf471624dffeedd83bcda3ea7e1e7a42a0dc2de3" +
			"7b01498236cf9f41ebfc6949ecd368c92379cf2fe37baf243b658b42daef9d9353229d114906a8df" +
			"704bc220e3b7dc8dfa8db78e0c6388c89feff13480da32a62ee253a8181481977ff5aa24fa2fe5f9" +
			"3549acf37606bde62bb0c517e9af84ccba30c1ca6075e06565586989dae6eb3176f3dd98b8f9ae84" +
			"31aa86d00f4906d7824933700225af13d4045f9c7b299170a5b6c9a86b4268159bb5c4cf5ad6d799" +
			"d2695e7be9a8bfa2386f572f242ade5947484d312935c5ad9898de5915869889b6ef3de046066fa1" +
			"8c5f0a4f54bab4db8b73b3b8f2ca734c95a7a40891d01142939ba7b9677f657f9ac27f36365c2eab" +
			"57582bc99cbef87dd5e1dae61b302e1961e3bd7b13d3316c14fda278210f0f4b0b2c9f7915975ffe" +
			"1196e67f261db34b263edd04d259b0c924da3c7046a55c3bb0b3c336022c8e2f0c15b03f262dfa58" +
			"c4ed0bb1feba9c2142ed293f6213261a1fc68669797c68085b34059c3fe45d0c63905a40113d91f4" +
			"974faecc69eb19be021f2c56df5ea219a446d8fcbbbf9f84078198e8507dc7bea742691d7bdd4f2d" +
			"a054fc1569cf15d197cffc5f16a90d75f6002dc34dccd6e652aa95acf103f2efbbdc164d9dd62760" +
			"2eb1c888705eced5ed26903995e62b22de6faf80dd86538fe57764e9e3b7dc83c97bf662e36fed43" +
			"dfd041fa756f0ad10f2da0087ff1a5ffc265792869cf55b3f3c9153a77c6ff44cbfe04ccfd962354" +
			"8ef8e840085b8b67a303c1f9907d3954d4b790e3d9e95e42fe85759681fad61bb069e7a7a479d8b9" +
			"66add049fa811ef4d66ab58026fc2545f8ccb65bf630d815f2ec789e2a3261b33ffbf2d301eed491" +
			"57a7562814ec935b8f9b4714ec37acd36c056297d1ed23e097b87d55a86fbd31d508f73db85a4638" +
			"2e3dffcf77cad09501921f92ac8b39ac00ef3ff7af29e1b97d774551389ebd3786673d0cc5157618" +
			"61d10ae5e9d044619dac90dd7f3b6da5f0fac0faa888bf79cf67566c1a42e3fe50bb5dd13efbecd1" +
			"5e6607974ebf8285ff7c3a9951f39b08287d6fd2067e1e1d679e5027cac2291ba05ad7fca1f82c64" +
			"d4bdedeaa7134d28e85760c810e048bf75bf0e3555bdf5e37f840d77741f39504cc76a1fd877b45b" +
			"be9e1880de3d3145cdc953327723982e25fd3d25f5b3dfcbfb9bd5eef875d9c8cb71ce908fc8dca1" +
			"191fe9c1ab871786e79379e5e0e4e9406f5e3677d83833e43e437a6ddc3bcb1488ae3ce877d8f58d" +
			"dd7e2b93b065cfa72543dc8820a4e3272e4dec16d3bbbbbedeef595915398489d47fe7a9f4a50b1b" +
			"4f13eb71eeace5d4b4275e9c891836d5269c6bee515bb619c2af87fde52dea7c619d13d0049ec349" +
			"8e09b1fbc1db174e7b6e1ff236c3cfc47da6ba9efa96eb71fda7ff1263db6f838b36e4a4cff67d33" +
			"e8013d334052f1b9938f0b82f9f9d18ba7be870bcf7ca373038ca30b7ca760fe5523931cb71ec12a" +
			"a78eed87f3f4d22f57d8ddf84e0e64a70af9f4b75b7ccbdecf62f3decf986b99fe446dc7dec3e811" +
			"2b62006e0ade3ff96dbcf7ecb7cd904eb76e49ae8e33adf992658fbbec8e91a7eb4d41186da0eb0d" +
			"eacd62a258ed17a4e5664074ec6b61bd057d42e17dc1a7b0b54f41a06d19b565df6724137c3651fd" +
			"9dc6fc21ac880192f6e4a8e0dd67fee9d4a59f3e33555ca543985eea4541679c3af87c7b17f2fafd" +
			"e9338afaecb8243d97eb0905cf74d3871f5a987ce8cf7677f3fa5dacf8bb70211bb838fbfdc7ac48" +
			"ed3829a9a11866972ef5a3cc4050edf1adddf85e7e2a8a67d775e411c2698fbc7aedebd8a33f6f17" +
			"56bb2c9ef2fa9368b2ef15599cd507e2f702a70ebe73999ddfaad7bd87d0f308f0f3fb2fcd1c5b29" +
			"f11556cd886f7ce581c785a047d34a3a4df0f80d12b853e3df4fc87126af3c8b337b0105fac10bc2" +
			"efabed1ada79fcbc76df7bb95704ca841c7cb78d5e60ea213a76db57ffe7285681553380c2ffffcd" +
			"03df944ffe6058a9b127df89a208c7f3d93a6b1f1f1328f00b8cf809f4c45dbcaec2a7eff815ba6f" +
			"461db3f2bc8877d3a1bea200ba7eb75fb68191cc7ffcb6bffd79c7d9be4e58d3d620ed2bf543f2fe" +
			"d38f0c8c9eb4d5979f46e9af7759998cbe34617b1b575dc6d503bc1cf230c1aecfd495c7e5aa5b58" +
			"f590db575fe7b3bef969a67dd7ec51a03ef2efdbca43fc79e5f16c57d4f9d6958b87b006ac490328" +
			"cc7de5de4684e884509f95314e0d8dc97d99f5e7ec5d1abbe5dc31354fb7c3141c5707f56e20bf9d" +
			"067f42a7084e3e7e3b6e7bbe0112054e23796649e69b6f0b3a30fdd597e7b106ac99011412262071" +
			"4256d6088dfac821aa088ce04283072f1f720d1f1a99b9793921b2d129b30ef62b654364f0c9971c" +
			"54407cde2fce815efb82ed5918980f48ba61da0ccf17e8052efd22be6eb72f4898204e660a1bba62" +
			"f716722285f40183a628bae72d124c51f49081ae751528890ef5d87dece67a7457261df5db7c1cf5" +
			"87f8ba2f7d43ca043881d057c6ded49cab1e80e24519a28b0852f83a388113d0cf05e5f2655ec266" +
			"caa2f6f4b52696ab9a3a4114e4b7faa5888fbe113fadb2cf504c20da48cc81ba2e925f4bc83b2058" +
			"be8b0249eb4f1f5ab74d308bf608eea58da2ba0aeb5c21ec452ff12cd5a2cff793f80a7d670085b9" +
			"c38d293136f1a4740c0f02c277f6585e5bd909e60cda29f60b130a3a57bc4492c6cc8008381be4d4" +
			"67fd36a880995bb0dbe3690125ad0956908e8ef71bce2703c7a9b97468faf1f9be7fbc3b1006d098" +
			"fbeb7b8f46a02321dba79db9907134ab7909850ea329e66a4b143422182188e5d5f919952c7ad83c" +
			"d1b9ff60f9c8b976eaf6fc219712591e39027c62faef5ee9f9e5ce4a3150065098fbab7b0ecb19c3" +
			"23087e6fc865c49569c7568b00a72054a3b0e4bbc04544481eed767b6b2f5c6f802b0aeb2a7219b1" +
			"20a7b11f9bfefb579fc20031700650983b2cfd82884ec839cb8691f0dcb1093e5bcf043bfea1083d" +
			"47f875e56a99b002b73e48a76c74d85b1d015eb0e61a3af3d43cc5cb07a4ca9fc780311406d0987b" +
			"ec2ef9fe4024ef0ff28791d9f86c4c6e139ed9df4c25727f20bdf26fc15ea2e5c6e96bc7e65b2976" +
			"fb6e3d76bb4553381e0b83fb33f69a64ebe3912740cda383b0f7210c950114e60edfb95f52f24935" +
			"4af004b88ba0bae8a698ed11548a0e86a663f96e7942acd4a9fe80c2989742201dbdd76630440c7d" +
			"9bf0e406a9b95bdeec313e474fe9297f88d63bd024d5ae88dcf771648729fb7d3f33ff0f4b7390b9" +
			"4ed3ad36757ef2fb22e0e80ba6def37ab383b56df591f2dc59fdc7483e9361135f61e81a80430e17" +
			"1b40fd6b3278308fedd5e1b2e1cefcf53216f7fd8c1e44bebf98015a878661eb8b502a0368cc1dbe" +
			"eb1139e03922bbd3703fd8b09c268dcc29d00e1e9f63071f5af172e4870d937067cd3aa78e87c54c" +
			"de3834abb0d3641239be8348366a385686c4bba8040368cc1dbee311793a229f712340ef1402ccc1" +
			"b3557ac89573e95f940f4efe5019720a777a78e4f06076392319a51284d7a8140368248e22916284" +
			"fd690cffac4a83bd1a35ea9f7f6dc4c987601a1b638093493ba4eee75cf92c5fde0b5ea7b51c9e41" +
			"88ea115ea3920ca0a17c048ac551f9e01f92ef4a1bc407e2fe73f6d53c80e03e0340f19d538f69dd" +
			"da571339c013ed567cfceeafcf577633ee4a3300c7dc97ef38d8467c3012e273e8b48b991149823d" +
			"dfcbb278be5e11d54306a3983b24b32d48463ddea2f6d377fdc3fc0c460023c3001caf7eb9a1be52" +
			"7a4406774a92ecca5576c09763be1b5ff0617deac599c1c9cfdf43d84e9d899f2712df8a111fafd7" +
			"313bac099c7e61241980439989764b3141b45f20de296f497d399968087b9b181174f481a09228ca" +
			"2bd53acdcbf33324305b6b6266fa1fcb1bc2f50323cf0021cc7da9b1ab15612a6a63176a68c8d9ae" +
			"dbe5ad4e49e24d499e50ccd1f00aa5e23e9f05a554cb43e08248cff3b59694ee11277608bf01d7d6" +
			"ed8c700b8e9d0000000049454e44ae426082",
	},
	"occupant-offline-large": {
		size:   "100x100",
		width:  100,
		height: 100,
		encoded: "" +
			"89504e470d0a1a0a0000000d4948445200000080000000800806000000c33e61cb00000009704859" +
			"7300000b1300000b1301009a9c18000000017352474200aece1ce90000000467414d410000b18f0b" +
			"fc610500001b69494441547801ed5d5b8f1cc775fe6a2ebc2ef7c2e55596c8a1284b94049ba485c8" +
			"8a6f5a2248e48704a27e8144207e30f2203ab1132786c1651cc37662c0d243222079a0f50b4c212f" +
			"019c98ebd80e6c2036d7066cd1b1482e752169ee92bb5c7249ee65ba52d5dd5575ea74f5cc2c7777" +
			"a667b91f393bddd575eb3ee77ce754754db7c02ac4952b776ba5eafca1929035a0b4579464bf046a" +
			"027a1f9052d442e58490632adf94da521ff51d893120bab4109546cb524cedd8d1338a5506812e87" +
			"1676b93a3f2484388852342494709510fbb10250176b4a0a8c2ac5188da4fc61345f1fddbd7b600c" +
			"5d8cae53808b1727fb7b7a2a8750c28ba2141dcdb3e6b641c851a114623e126feedebe65045d86ae" +
			"5180f1f15b43a2225f86c4d195b2f0a5423384eadfe9bac45b3bb7f59e4617a0d00a70eddaed43a2" +
			"2a5f14521e2faad0f3a02eec98528691f9b9fac922bb89422a80b67654e409750187b01a2030b2b0" +
			"204e16d145144a01569de019342b44114eeed8d6fb5d1404855080d52e788e2229424715e0ca95c9" +
			"5a6543f9d48322f8004e2fccd6bfd0c918a1230a100fe5fa2bafaa199961ac41cf400d57b0f0fac0" +
			"c0c014da8cb62b403c9c2bcb537a660e6bb0d06e61be5e3fb67bfbc008da8812da046df5e393b7be" +
			"83b23cb326fc2cf435a994cb67c6afab6bd446b48501b4afafae2faf09be45c46c305b3fd28ed860" +
			"c5196062f2f6cb4af867d784df3a623650d7eceaf59bc7b1c258510688295fcde2610df70f15206e" +
			"1fd872122b84155100edefb7f49575a077146b580e9cae88fab19518252cbb02c463fbf595ef2922" +
			"3b840260616101376fdfc3f4ed3bea7317b7d4677ea18e3bf766bd7c9b36acc7c60deb50ad94b1b5" +
			"bf07bd3d9b30a8be8b82958a0b9655018a12ec69a14f4cddc6c5f7ae617a46097c7e01c9a9caf8b8" +
			"10427926be2dd27d574f4529c3605f0f766defc7c3bb06d169ac84122c9b021441f85af017de1bc7" +
			"c5f7af292b5fc0d2e014466f6fda5055ccb0054fecdbad98623d3a85e556826551804e0b3f11fc35" +
			"25f8f158f0b1d894550b913d3d6dec3a59b2e32edd670119a8e7f1da6e3cb27bb0638ab09c4ab064" +
			"05e8b4f0af8e4f61f4edb10616efa83d617d999347864b331791e4d38cb00e8fef7b2856844e60b9" +
			"9460490a9046fb1d19e36bab3f77f10a2ebcfbfbf82c4227c2adb9f1315f098cb208d1f8123dfac8" +
			"4ee5161e8ae385f6438e5644746429a3832529c0c48de9ef7562a8775745f03ff9f96f55243f17ef" +
			"3beb26b0f294a915c3e5459ec2389f6f948ab286ab87688f4ad8b4713d3ef1b127e2914407707afb" +
			"d6de97709fb8ef99c0eb93b74e7442f877acf0f5304ec69f4470ec63d3a860d3bc32f9369f289219" +
			"9a9736cdc17321525aadbb737716ff63fbd4761c5dcafd83fb6280eb93b75f8d64f41ada8c44f8e7" +
			"d4059f4b53f26c19ce824d367aa8815b30d55955204160364084e77e34037ce299ce308110a557b6" +
			"0df4bc894562d10a90067d67dbbd48d35afedd7b249506666edf44f92eadd9b64912440bf28345cf" +
			"159076f5be76079f7ce6402794606a61b67e78b141e1a25d401af1b755f83ac2ffc9ff9ec3cc9d7b" +
			"d6973b01a4346f7373ea0e6dfb91bdad33928132c894372ec735e3faa1ddc18f555f973e0fb168f4" +
			"6bd94c4e4e2e4a368b52007d73a71311ffb90b9731a32e6c222f698dd42983efe3254933aedafbc4" +
			"419cde8e7c85127e3e83a40c2dcf8eb18f568273e72fa3ddd0b259882a271653a66517102fdc2ccb" +
			"336833debd3c815ffcfa3cc2f49d3f7e6f9c9f97a39721ec2212ffefbb1c171384fbf1f1838f63f7" +
			"8e01b41b0b75353fd0e2caa29618408ff7f5322eb419da92de3eff7e6a5984be11a06ffa49f3135e" +
			"b0df86017cab76a525909930b2b384d4e5788c213d2631756bc5ed802b40b55c3ed5aa2b6849017a" +
			"fb2baf7682fa2f5d1e8f95c0c00a8b0ce14cbaa701b6803b262d774b420254a092eeda7dcfcd4897" +
			"d7d6439b238aa3ab9f9bafe3fca5dfa3ddd0b29a8b4a2dadc368ea0292dbbbe58b6833b4e0ffe347" +
			"6701e9a66369909ec6fb80c707b05b3a353f8f0f2b37c1277c29f5875d8ee7302432b38b954a099f" +
			"fdcc61759bb98276438d0af6351b15346580ea86725b17291a68ea0709eee2bf3c3033419c1784c9" +
			"44dc92d1b347f9fe87f80ae702a8f5c305969cea0ddf67fb96e49f572cf0cea5abe80494e19e6a96" +
			"a7a1025c9b987e459d434756f58c5f9f46c6cf130af66d9a2a0aa5661a05302981e731bb8199452f" +
			"0d9efba18c638eb97822497b67ec4a47620185a12be393438d32345480520927d0015cfa605c0dfb" +
			"eec18db7257101d62c2db2819db4fb80642ce18463cb10014baf4e9f255c79e796241ce3808489b1" +
			"3b48fb32a717a8dcb8854ea0522e379461ae02c4d6df81c04fe3836bd7ed36a756bb219825521220" +
			"df21a377c1a4c94a5c0ccd1f220cf88a00c9dab23e84f617f8dd58fbe705523464815c05e894f56b" +
			"68fa77164a68dc46fff019c00810be4377ae427aff28626661e1a175351ead53d703388af7eba613" +
			"51945926a7673ae5061ab2405001f4a44fa7ac7ffcc6cd640d9f91a5b5743f9fbdc0304158fa0d96" +
			"dfb13371e9a40c7c61794267796c7d2cb0a4759b3c5e5fd5479fd39452820e219705c20ca07faadd" +
			"214c4ddfb1dbceb73af89685c0719637500787f4e984b08e7f9ce6e38a21211943781564ceadddc8" +
			"63818c02e8713f3af873edf1eb373396c8add3dd9e95ec3888ff4df3426485c5ca4106148be4734a" +
			"2140dd92639dacc248c84c3b53d3b7d1410cbd7f6d32b3543fa300d575e58e59bfc69cf193cccfdb" +
			"3420686921eba4dbe63b52730779e5bc7419b2e4309bd08092bb039abd832e2046b55cca0ce9b32e" +
			"4074f6610df12d5fc0b36a1e5439da35d6965a7a14794118e837589c90b627c0d8840472000df1c0" +
			"dacec60a7458e8d8c3858a73f39d09020d4a42bc9a49a33b1313d3473b15fc196805608e1c0859a3" +
			"99964d24e35b2c15be59d51ba853a74799b22e8fb56c09af3c0f103d04992bc93f73b7234bc628fa" +
			"7930e83380c08b28089c1c64269d0e0743c137b5e090f25056e0edd9367899503e8f89fcb2b69fb4" +
			"4c5091db8b72a5fc32ddf714408aceff98d30573c8046de90e322b3728dd7af972dc07f969182f2b" +
			"89b5675c0ea57496e66d9376e87ee7c5afbaa4a6f6e9ad62ab00f1828f823c8cd14c9ed8fdf43be2" +
			"fe979763fb91e47104ad1f198ba4b536b4de20f5fbfd15364d342ed77ef4df5b801d0d58051025f9" +
			"320a804d9bd607d7eb24acc0d841fa41a2997bcf5c6673e105b24121ac8b0e0b59fab40e20a8505e" +
			"1ecfe2a5cdbb69e3061401e5921b0d5805904214e2e7dcd57205c1b1b9bdfa3e3b8053709a46e9d8" +
			"4b0b9671fb2e2814aead80ab31c7bcbcb43d007424a0f36edeb80e45801a0dd8582f568078f2a720" +
			"bfe71fe8dd1c24781ef419ab22861a0cc4684d66d1465e5eda229d69f08785f002bc4c5ef21134af" +
			"daa856dbbf282404d595dae4ddbb7bf576ac00d56ab910c2d7e8efeb7114ca02ae18cc02418f5bd7" +
			"0066b1d430795ee9bc34250342efb418d73aea3a3c8b97ae6c3c73a9feef18ec4351303f337f447f" +
			"c72a190939249aaf0e6b0b06fa36dbedd88a58e0470f0aba4c1c92feb02bfe760bb95cec9064601c" +
			"23258b39921242c20f45a5b3eca418551ed72668eda4ee81bee23c71449d5c6cf431038892388882" +
			"a0bfb7275e3f67dd2f7c415908728c07dad2dff608048c408c80886fa0338620f107770942645d88" +
			"e7a6c8b63ea71d83c579e2bdeafbf3fa3b0902250ae302d6293f99b000915e605c1dfab8e1a327e1" +
			"a46249c7f49455046104aa6ea60e91597c22ed61dfdd6435ceb5bdb340f49f40d4f4dfd2b5e40e51" +
			"a15ec6f0f8a30ffb960fd80bee89885c6b19dab71f3a33e8d24c82f49bb1f9ed368bece970930f01" +
			"6dad9113bec687766f43c1d0af03c18a10957e76a93b8e9ddbfab14e51a6be791281acd8a182206b" +
			"b84d0c6097804b115ac14d2c9ea408c1ab0ec0d4edf69276ecafd5728febf49e4d1bf0e89e5d281a" +
			"ea33f3874b284585a17f03ed069ed8ff303c3a869b5031699496d3948cd5da144926666c19e18dd3" +
			"590d60dcc1d25dcffc3e4a522a0926776c2be6db6e1684ac956487effee5e1805280f8c71486fa89" +
			"1c3c459046e0c8f0b04cf9de318473ebfe1c3f5cac277d1703ebdea5efe289f5bb385178ac63eaff" +
			"c8811a8a081500d6d4a490d88b0242b3c081c71e71b46d8469ad994b8ad92595685a873753e8b4c4" +
			"dbb6a04a040418c14c4c913a6dbf5cdf3eaa84af5d402151127d25755d0afb362ecd02eb2a556426" +
			"8488705c1026491a02c1a0b176e9d1369d76b6142e5d5eaa204e7f026d822a60b2ad1f16f1e89edd" +
			"282ad43c47ada4a2a0c22a8066813f7ce68017d051eb97c1905f7ac2a62ec127887431884924bff4" +
			"f5eaa6f523e75bfa6d191771f0c9478b6bfd884f59b900c842bf8f6fcf43dbf1e4fe47e08756c217" +
			"329c4f2704ed5ba4a4019af4da908cce656048900d3609e57bf52469071e7b18fbf7162ff2e7286c" +
			"1048f1d127f7294bdae85b1b90f1d316245f365e40c66261620562e9de389f2959a81d5a56f7555b" +
			"7fd1a165dfb657c62c05da15fcc9673e86cd944ea9cc73b6e9f2717acc05964479428c1f6002531f" +
			"abd2d6a3fba8fbbaae2077fe9aa12b144043fbd2179e4f94c05a26217419fac7ad17840dbca95d9e" +
			"3fb7c640f9244dbba5cd2ae87be1f9670aedf739ba46013434b5bea0acab2755020d6f8c1e2790ef" +
			"60f0c72a952c2f4b9392e7f167fccc71bd92e985a1ee12be4657298046cf66a204d2971c19e67b41" +
			"a1efeac92821ef9b3083801f633826718d6a56fa6c6cf91bd16d10e337a625ba10fa3ec1e86f2ee0" +
			"d7ff77092230ef6f60bcbdf5fa744869d3d23160e8c162f0f75df4906c3ffdf81e1c7a6a7fd7f87c" +
			"0e317163fa62378c04f2f0ced865a508e7716be69ef734202bf4e04da104fe937fb23f13077c05a2" +
			"29ebab557cead9a7d4307507ba15eabcc6ba536d091eab3d845ddb076245381b3f4f5023a568bdfe" +
			"3f92cef48d8f30a3039a575bb7593468c06f42aa7d7d97f2e9c7f7e229f5e956ab3750673e25c627" +
			"a7cf6095bcbcf9f6cc5d9c556ee1eab51b8a11eec669d6a673283cf35430921de498b6784df7ab41" +
			"f00423156521979abd14a15ba003c44fffc1d3f1f6ef2e7e80773f18c7d5f11b98350f9cd0d0411c" +
			"79370ca576c922fcf54ad0fa3d41dae277edd8ba9a041f2382bca9cfa8ed6fac6e073ebcef43f147" +
			"4333c2f5c95b56193453e88f5102fdad9567ddbae4c55083e967eb40efaa133a85ba193456d18100" +
			"5639b4f5eacfd34fecc51a1c2225fb9290620c6b782021a368b4345fae8f620d0f24ea154cc5518f" +
			"9a0c9a44c15606af61c531b57d6bef403a15bce6061e40c4cc1f2b8094d10fb186070aea9ec62ff5" +
			"77facb20b116073c60284931127feb3ff5727d046b78a06082ff5801760f0c8c3d08f3016b3090a3" +
			"5ae67acbae0788a47c0b6b7820a0a6feadcb77cf088aa2d358c30381f985fa9b66dbdefdd08f0e5b" +
			"90f1bb81d6e6035637e2f1bfd9b10ca05f412ed7dcc0aa87baf7e531bdb72650b981ef620dab1b75" +
			"78469e5908d0edd3c2b766ee606e76011393d3b875fb0ea6f5fedc82ba0d3c87dbb792174febedd9" +
			"39f3e066f732e8decd9b505d5fc1866a35be35bca56723d6abef41755b38fededa1b2f0ce95648c8" +
			"b11d5bfbf6d1b4eccd6e295f5757e4040a8ed9b9794cdc9856f7f96fc6c2d6dbb795c067e7e75d26" +
			"bae487eeb36fb30a787a660698c9299b422b40ac084a211eda39886d5bfbba46314a2299fca1c89c" +
			"e2b5c9c9434296cfa260d002befcfb0925ec9bb87cf5466cdd7c0d9759df4157fdba2d61df3a6617" +
			"7ff265626c016966453172f2aaedc1813ef42ac6d04af1d0ce6d4a317a51342c88fa3e33fe3708ae" +
			"05536ee08cfa1a420761047ee1ddabb1956b1a978135ba099aade7061a8bd35f49ec8eb93ae88a63" +
			"bb84dcabc7b5ad736b17a29560df23bb8aa210232afa3fc213c30aa09f295f2e9f411b6128fde27b" +
			"57f0dbf3ef617636a1f23ceb044fe3b2005b16de6051a8cdc70bf2df0a00791493d50bd6d0962d9b" +
			"627638b07f0f3eb46b10ed46de1bc5735783b68b053eb87a1de7cebf8b3165e9f7e6b4d043d6e8c3" +
			"97b51363f2b3f1a09bcfe1075786d7eb597c837ec826fd0da56f50ec50dbb34bb1c3eeb63c3c2a14" +
			"fcd1fe05b1922ca0857ef1dd2b4af0cad2e7e65c57ac09c14f4b3783d2e4a6e7adeb270bfb454e1b" +
			"41074f1a94ac2e4b238c21f895a479685fbd3a1533f46c528cb00dcf1e7c22de5e09c808c7766ceb" +
			"fd6ee898685470395940537c2cf477de530a3081604f98a9d06b9fd18d1004530084a3015a11fbad" +
			"4863da21ccdfb02fd4af48c623348df5572bc2138f3d82271fdb83e54223eb375dcdc572b08016fc" +
			"2f7f73417dcec7dbfa84e37137a1ceb4a3e0dd0919bd85ad0731894be6c883f5b25ffd38fa77c181" +
			"7dcd9c10debb8af35c0578fd228f123227e0d549c6a4e8ddb219079f7a347ebed05259a191f5032d" +
			"18d5fdb24022f8f389e0554017624dd3013f5823e339492e714aa1e6499d196b27146be5005315ab" +
			"53d07a7c964e9eff1b689bd0917d5a28d8b9f01f225a6f919611ce05702fe6359632449f528403fb" +
			"15237c78cffd2ac26915f9bfd428435305b8323959ab2437895ac6cfce9e7316cf1aa356e35d2e2a" +
			"b560999c722d80bb7c5e6f88fd5b69a399d7c82b231b6c87daed55c27ff6f08145bb86d0b83fd49f" +
			"a618bf7e73b895d9c1f7af4ce03f7ff4f36492c6b6c0e911f9fb34bfcdc3bac92c39178c4532f5e4" +
			"e50fa5a7452d9bb0fe665829f73c25a5332f4fc66904ead08af0a9673f82fd7b9b3f7a2e92f2e4ce" +
			"c1bee166f95a52007dab785e96ce2adbab858e6b4bffd9d9b7f1cbf4d7b921adf6d205796823b2da" +
			"2f18cdd27cbc7ef0b2c85a90080470590a76d40bd6a6e913173a90cf1ea1b6c0eb319d637e919f0f" +
			"773b4f2926f8f8c79ecc750b3af09b11d1e17dea0e2f9aa02505d0c80b08b5d57fdf587dc88a9a59" +
			"7e088dcab4507eb12ea229589b893f372dad1068ac12385fcd067ffa47cf615be831f46ad2677b60" +
			"d22784459dc1c4f59baf49f2fad1d15fbf83fffee9afd29a7caba0daeb0b30f9c3298fb283c9c311" +
			"b2746e6df62d0e6904ef59b0ad28dcbe2d0ff80cc5d23855e706a660ec111a16d2729c5988025845" +
			"90e6ea257934137cfcf093e4d4e4eb3b06fb8ea3452c4a01a82bd094ffd35fbc6d4f2e4b81ee618e" +
			"bcc166815f9c8fbef2552caa9bac1fadb34186391af5afc5ba430a9be766ee17cfa54ad06ccc1fc2" +
			"a21e12a5570dd54574e4bf7e7c76eaa73f7f3b4eb34fe7249a9f3ca0290ad691277cfe744efd22e8" +
			"18961168dd5e02fc47c6a68196749ba0c71bec4bde0fdab6f44f42678b789f4d3de45b4abf8f9936" +
			"d040f8929c042b43fbae0df1074a265a36582416fd94303dacf8d5b90b5f30cfd5f34e4eb2277349" +
			"f2ec3d2b14922778c1dc719b06992b789acf90237d3698df16299352293d6e5d86d70f99e983f947" +
			"fb0cd20f3b9994f6855f0f04ae0dbd9676db9d45f67aa6d7c07cffeaed0b279b0df94228e33ef0a3" +
			"efbf35fae93f7e71409de8732d17ca383eb4c67ba1720ca2c9f02e1403d0224b0ae568ff38c7f336" +
			"1a9d0b29930858787518c5ca043f7a53e2e4d7ffe6d837711f58d2b9ffdd3f9efa9eead9d1a4a234" +
			"500afafdf4356ce63b330ccca6f3edb472af7e4128dad4ef2e20024193bb808dfa49f769ddb61e1e" +
			"9c5161a5c2e134cffbc6fb6fda095d0f7ebd689d7a91e73ffcf5b186b37d8db0a40745aabb9ac7cc" +
			"8f0c282d52bdf29eec0d4af9c4ffc37705a16d43bd14193a46968e69194ae7965f697d269de6677d" +
			"a77df369de77151ca174da7fdecf503b2483f91a53a3ef63580296a400c35f383655afe325c97e5e" +
			"eef93a181f4733a447586ce08ed1bae084657d25c92703f990adcf963310803fc1285d3afcba83df" +
			"acbd3cc8d0b94b738de0f59f9fabcbebf7315597b128ba77e4b5e1634b7ac6d3925c80c197bf71aa" +
			"26843ca32aabc96657049c6a1b0d8cf28f71ba0e974f6109c7a5bbf27ede6cbd7439580b6db59096" +
			"47e9b6bd800b617d1e9372f6c837fff6f363582296450134122588cea8cd9a4db417de6cb3891011" +
			"c80758bf976c23ff0eaba9138d2e564e592018acb984900285cbda3e36033d711a8866ce1ffefc99" +
			"24a7aa2c5fcab965117eda93e5835602353a264a402c8b044cfe757056e882367856e797f5add6bf" +
			"a79e0d925d301592a1cbc9a6fa6d25b45d1714babf99409307a699be23d85bff96807fdd5cfddad5" +
			"2e9ff04d0f96155ffec61b35a0ea94a0819586c4953d86266939c772ad9bc1b3be46f5f3b6021551" +
			"ddcc9c73b36b80867d53ca312ac4fc4bcb297c8d657f5cbceee0bdd9f261a97f8346acc8c06ecae4" +
			"4f12f8d00912d00c2c4892641b2c20945e10152709804fd4d07e48677269bb3293c7f481b69fb425" +
			"5dbfd37e58cb1520133ca64fd20bf4b29360fc5c618feb6b393b573eb2dcc24fbbba72f8f2d7ff6d" +
			"58da7504dcd243819e73054e20d9e361c640209dfa5a1ede872cb4519b8df234ee83cb49dc5d20d8" +
			"ccd61dd3ffebdffaca9fb77c7367b1b8af99c056f1e31ffcfbc8278ffcd94db5f99c92a97d9506f5" +
			"b534e03169492638eb24e93c28f47c3b15b429cfe54eb348646e56364d87dfaec7f62c2f68bfb80e" +
			"71d0f349dcfe5449cacf7feb2b9fbbaf19be56b1a20c60a0e30229cb67a414b5b8512a7020c703fa" +
			"57d4bfd3ca19249407b6661a5c36afbb51bf98941be4175e0009700dc83fefb8bf63626efec83787" +
			"979ff2336da18df8d2d7fef53551d2eb09b2949e0cfd1a14b6d79e492b6f1997972cb2699ee902cd" +
			"0351421b343b10c81fa004ef24026ecc304084d7e7ebd5e1a54ef0b48ab62a80c617bff6c650a954" +
			"3e053d4aa0e71ea0cf6671741e93506ae6433b89f07e08ae7c229d90d57237269892e55a3932e7a2" +
			"66f6c4b16f7ff573236823daae001ac7874ff5af2bcf1d5717e044aed97b5733e440f3e9180d875b" +
			"e160d0cdce35cad70879160f346302d5eec985fabad7da65f5141d510083e3c36fd4aad5f27710df" +
			"510c5063809da965fb2c9f94f7ad31bb78939a9e2706c10e82059ca40daf22c90341bf1ff63858c7" +
			"e3743152a9d78fb5c3d7e7a1a30a60f0977fffc62b65513a21b55b5814583087c6944e918a09cd2e" +
			"01cdd7780ebf1558951b519f93dffeeae747d0611442010cbea41401b122c85a92e2449a1926369c" +
			"1f00c2d1030d36c3415830904bad363ba540ebf02fa569c73051dace4851046f50280530d081a2ea" +
			"da09495e66150af83201589a3737f062817c300fc94c85982489b4bcf4f2cb401f59bb234513bc41" +
			"2115c040c70865816175059f47ec1e5a09fc96784a99509eb711621b7e3cde9e126a164fc8e8f43f" +
			"0dff45611fc65d6805a0f8abaffdcb51354c3aaa64f3a2bacef153cce89274c1a6e3bc255bcc7245" +
			"03eba6740f50b6a14bd45cbfbc6053e8177089d3a548bef9ede1e2597b085da300145f1c7e63a82e" +
			"f04a09e2a012ffa1d64a11eb6c68e58b415ce798b2f4b7546da717b061b41343b9a5a02b158042bb" +
			"09258843ca0a87943c0e42a86d889821422cd00a32f9dd984ed3fa5804f1438168344269e4b50e0e" +
			"e196035daf00211c1ffe67c50aa57ec8ba528c724da9c05e214afd918cb462e84f8d9749dc815e70" +
			"9158b5fa3ba6926e8a92543374fa51fa62b4db851dc2ff0385cb5fdf3d7b55df0000000049454e44" +
			"ae426082",
	},
	"occupant-chat-large": {
		size:   "100x100",
		width:  100,
		height: 100,
		encoded: "" +
			"89504e470d0a1a0a0000000d4948445200000080000000800806000000c33e61cb00000009704859" +
			"7300000b1300000b1301009a9c18000000017352474200aece1ce90000000467414d410000b18f0b" +
			"fc610500001af1494441547801ed5d5b901dc579fe7bced99b90d0ae4018882ebb981883012db121" +
			"c52d6885c1715c29a42aa72a4f0655f294729585ab529537496faee401a92a954ae505701e92ca8b" +
			"04a984025bec0a62632e8e168c31c402ad24900408692524ed7dfe74cf4c77fffd77cf39672fe7cc" +
			"1c693fe9ecccf47dfabff66566045c8678e1c8447f47251a1438d70fa2ba1122ec1588f21cfa9304" +
			"981d39048c018a7199601c01c60123793d7b348ec4288ab9f147d7ad1c85cb0c02da1c8ad89d15d8" +
			"0c50d92404caa32434402f340792396014311a45c0833373f1e877077ac6a08dd1760cb0ef08f6ae" +
			"ac4e0e4658794c44f1d65c696e19947680d118e3671f59df33026d86b661809f1d9fd81c89e871a9" +
			"cab742f3247cb1184721f6630ccf7d7b43d77e6803949a015efaf8c26007763c26d5ed0e282fd1c3" +
			"90fe048218999e897797d94c94920194b45740ec94a79be1f2c0c81ce0ee329a885231c065487817" +
			"4a2bc4b8fbe10d3dcf4049500a06b8ec09cf512246289401d410aeab2a9e862b85f00c72ae61fff4" +
			"2c3e59a48f500803a8a15c6f75fa47d2b9db05cb904410bb60b673efd0809a846a75dd2d46a2ee85" +
			"94fac2c7ef2583340b7388db5bed28b68c0112a9af4ced9493263b6019b940843d0f6fe87e125a84" +
			"96304062eb3bc4f0b2d43708a90da66670a815be41044dc6f0c7d38f4b47efd032f1e701d9575dd5" +
			"e8d081a3934dd7964dd500c3c7269f5a56f98b83721087d677ed8626a1290ca0ecfdd5d5a9a765e1" +
			"5b61198b861a2e46b35ddb9b314a58720648c7f6d13ed9ec4128012667113e3d37039f7e390ba7ce" +
			"cfc267f2373913c3f8c49c93ae774505567757a0bb43c0c66b3ae12babaac9b13468925fb0a40c50" +
			"16674f11fde8e9697863ec227c2a093e21092ed49d62f2df9c2750178836b3b05dd25d8d60c3351d" +
			"70cb57ba60d3ba1e281c4d608225638032105f11fe8d2317e5ef5222e51a09d1c991838787d2adee" +
			"a940bfd4080f7e6d25f4caf3c2b0c44cb0240c5034f115e15fffe802bc393691101e1d5177898f52" +
			"da850c3747f94f3a5a81f00c249deeae87fe7025dcb9bea73846584226583403144dfc0f4e4dc2f3" +
			"6f9f73243e04aee91b06351704ca67f813a90d36ad5b018560899860510ca0bcfdd51d53858cf195" +
			"d41ffce03cbcf1d1c5ec2e424a3e4fe95b4da0e1d11933993769c265fdf1c055f0d02dab40ce7540" +
			"eb2146c56ce7d06246078b9a085243bd2288af3cf87f39f8594a7c834ced2b314f449d5c9b787bee" +
			"1236257642749d5f64c4cfaed3ac68d364f994e9516de1a38ad600076345834560c10c307c7c6a67" +
			"11e3fcf14b73f0d35f9e8673f28819e1d01085483111e794a840880c86d0f45cc1b0458cbecd40ea" +
			"4b643f797e56b6e55f659b8a600245830372c20d168805e9ade1e393722917f6408ba13af8a7bff8" +
			"3c61024f67072c40e2dce9446428a0a5df38803c0d4516668bb7798155bf7a45157e70efb5897fd0" +
			"6a08113d31b4aef3599827e6cd00d9268e43d0e24d9a5af2c72fcdd64e28c078f5fa3ae4c485c21b" +
			"7514bd74a42c45fc1fdcb7b6002610e353b3f15df3750ae76d02128fbfc5c49f9c41497c25f933d6" +
			"fe3a1448c304e8a8d88d0a2051f159025da60dab91115c1fc0da96148a41555b559b5b0bec55b419" +
			"968ef97c72cd8b01d4e24e114edfc10fcec1f84526f9da10031a5e4020be006514fe4b9c40eb1b08" +
			"5a2610e36e4c03b27002ea7866f1aaadafc8114acb21691357a676ce274bc32620dbb8390c2dc6db" +
			"c72ec2fe43671c5badcfd3a3d6c0f61a1cdb2ed8c0101d3b2ea8810732430c213b9f67ff69b82dec" +
			"2fefb9166eb9a1f553c8d23d1e6a746751431a408df7936d5c2d86b2fb23ef9fcfb46c4a2c4afc04" +
			"8886204854b22592192b38e9a8a648553f55e9d6a470e631a68686676dd06ca0ab7e4e326eeb4d01" +
			"80a255a3a6a02106501b388b50fd4afa8dd38764b847cfb33873e4e768f3d26b614c4896dcd2ddb9" +
			"e6e63e8d432f0c587e55fcc4740caf7f589029881adb4c52970194d75fc4eedd54fad50417a32806" +
			"7ade481d95369e868621a13d36f0b365a0374c08e7d1e97ef5e19785680111899d8a76f5d2d56580" +
			"ceaa58f024c36230f2bb712b6940248e4ce0296fdff20365022aa1ae96b0928df5684df8c90b8094" +
			"c8b1a7358066910185690189ec998b9aa8c900078e4d3c210adad533767ad23a72868644fd131bcd" +
			"6dbb9d1524763ed31e3a8fe5234a79372d2d2f647e44e689e8747ab5519791b611e1b5c3e70bd102" +
			"129b95f35e2b414d06506a040ac0e8b10bc950ca742a7047cfb410b4b43be18e39b01a0081121c2d" +
			"430190b17d9636471b206122240ea85b677aaac7036aa552317411c81eb9cb452e0328e987829678" +
			"df3f71c99c63d0c4526923095d6136d26a88a3ad8309777537a23d77660ac991ac0f79b3898e3902" +
			"246606e157878b310350470be4324051d2af30f6b9929620e5fd891e87ea3c5d488c035cc2ce31e8" +
			"fe676601dd6be7e8956dcb3c353e5577cf42b3504b0b041920e19882a45f117f623a5b55f33c6e48" +
			"a77a1c498370bf332099a90b5dd37341ae433e852d9496052e73b2a48af8a7c6a7a120e46a812003" +
			"d4b31bcd849214e2e8031d90a736372584b5bd542281cc0db8ce1b9dadd3765cd7429d363076dd9f" +
			"704a0fae26a07e8a8e17b45cf253f75614f268ea31403676dc0c0561ecf49471caecba3b913dddc1" +
			"99fd47b03c420cbc49ef101ae8743ff3ff3de9d50c1567b9c9c8c1680493cc0192381a79f25c611a" +
			"4061f34b472e785bf53d06e8ec880a937e8544fd53a72c832001ce644ca0a79170853ee76ada24d4" +
			"3feddde9bd02bc0e52160db3e59023d0c6dbb8024d40824a54f186f41e0348c5b7190a845ef5c358" +
			"499e252c0698c2273ceb74b0126cd30370994dd43c729302358e503b8d696becc44d4e17b16dcc42" +
			"44d18f7898c3003f3f76b1f0f7ee8d5f9c06be61d3482e0208ae70d19fa4314444b2a993d970d7c9" +
			"8b990387ae9348a59a8479da84b5c959b092bfba9b599a0eece5cea0c30022aa3e0625801ee35367" +
			"0b008cebe73857249f9d2c0272064cbab35041b682e9fcc89e0920b53a769f72056d076b939949a4" +
			"f75430aa227a9c5ebb0c90be84b150784a36e8d0812b7144edfa05a26b9eb57319c7241e89cf800e" +
			"a338b51007d3695b50bb70362a0764b3b6d2a562c300996a28c5cb189ddd3cced66cd6b954253bd7" +
			"c84c835b1e22d70c4ee5c1b2a086baf7c2489ce065150eec9dad4e9ad180618088a986a2d0db534d" +
			"4f2851cd293f0f75689d4ece298fe7adabaeeb129368850cbd5775401910c5c2687ac30052fd97e2" +
			"71eeeece8849a825b4dec4619cc454ff328907205e1a608d5f5609d12e60e204d33c18d02eae5433" +
			"4d83e0699f22b68b87202a607cbd8401b2c99f5230c0f5abb367f28d5d054218aa18ac6d0700c74f" +
			"a09681fa0d227074ca74c2315797680fc1690b127e045b3792b27a3a9afe469ec620477abf38811b" +
			"d569d2a28e4a5c0ae22bdcd0dbe9489df59e5d6d0044ba743a00e63f009374e76809e9edf1e3a620" +
			"d7f4a05b06322712f5d2713a20dcb8b604ef18c830393b39a48e89c115283643c3fb839b8bebfbba" +
			"9c6be4224e2fec7600701d337e24322bc0b3ef5cd645200d508d908977e2537afa80d549cab981dd" +
			"5ba14091087da201e40cd12628096ee8ed86ee4455fa0ad8274a7af07917f3afa98fe0c47129a7e7" +
			"01e222342033369fbaa781eb0a7a943c0011c143eaa88d52694c8072021349d1069e9a03ba1b037d" +
			"67cc9dbda3a600c075e674908d739d365b773a9128c05d1606a0660620d0269b30b91eb8ae3cea3f" +
			"85e8577fa3973e9e56c42fd5c718eefd5a5f72a44e199059356e816d5a04be35ccf0112d07b4fa06" +
			"5fb8497a004d63f28c00f14b289f99bca09d483bd1a4ae6f5db712ca05ec558e6055e05c6f23caac" +
			"9550aab2ab43241b291191aec39a3428d81339a6e7551cb900706c760281a6b8743449d212384c20" +
			"42914423d0a50b536ddaf63e39febf6b6035940d135397ee8aa2b81ce37f0a6506eebb650ded4942" +
			"4b1be68ee7c135e74602b383930e5da6306683fed0a957008be770e2dc3695c9f65388a8d2af7c80" +
			"7e282114037477667b6dd02c031999777ede3091d871a076df3520e00c11f9b970cac3bc3ac8b91d" +
			"3dd8bdcceab8e58e6ba1a4900c1055364209916a816b8cad1684a698433beaf739f160277d741812" +
			"69b5ca01ad3e37c338bf6ccb3b24af62d258e74153e7963bd696660a9823aa88d591f46f4bfb35ae" +
			"fb6ee94b864f08ee922c954aba449cc650cd60adb4914bb4e760f291a9e034d08f0364750084cc0b" +
			"7d66a0774515fee8a6f2d97e0dd9c6c404949601ba3b2bf0fd7b6f74031d171ddc1366cb91a90232" +
			"79eb0d09b5d276868b4e1de00e1b988a71d619b2b02d775e575ae94f20940910e5fe1edfadeb57c1" +
			"fdda21d47d6e9c762444a7769941c7233937114054bb1f4e26f43dc64b867a18a84cfe576d2eb3f4" +
			"6b28fdda0f25c7963bd742df4ab54844366f383d4fedb5abb23137ad6b4ec2e100d691ccc278bcd3" +
			"9e344c0dfb94f4971e08fd25599eaa0d650afeeadbfd893a75770501ed77f31268ada9d5357d158c" +
			"73ccd25033909441cb05662288e407f90452e2fff523fd8913db0e688f564af4ad541d3b90dad48c" +
			"70cebc1f0278fb07113de7d0f103026969a9e61aed908e6a081b9f328872fa9236ae2cb1dd67681b" +
			"0650e04c9000d9d2711a985f0806ce035622bc0a09610d24fff45e2589ffe84d6d457c85b6620085" +
			"84091e1d483a9c4f005915ad9d43f41d406ec775589ad14e34b93adfe477660e336d91a87d49fcbe" +
			"3623be8278f9f824421b423d6471e0edcfe07fde3b0dec1102474aedc45cea14f03831cf65109a47" +
			"31da03b7ad8587377da56d6c3e8778f9e3c923ed3012c8c3af0f9f958cf0299cbd306ddff70fc26c" +
			"fc10010aebe95afa3458adb476ffa1f62504f4a8398afbd7c16d1bae86b68580b12ab439be79731f" +
			"dc74fd55f0bf92117e2e194141af0e3aaf8c65481f33d76b0d592062d07ba06528497fe0d6b570ff" +
			"6dd726a393b606c2b83201c370997cbc59698103a39fc247a72e24e709e85743341de9f2327d748c" +
			"be0458b8ebbb8ad84add5f1684b718a9428c47219aa7212c29d464d1f71f589f9cfffaf01978efd8" +
			"f9841994bfe04836125f816a0876ae087de39a9e84e8375dbff272227c0a8ccf55a5d21b1725db10" +
			"b214f8e6cd6b929f826282136726e0c8a98b093328ed60344406357c5376fd86352be4af3b21bcfa" +
			"5d764427408c121f600c2e7328e9553fa5c297e1602c428163b08c2b127184a351652e1a85655c91" +
			"a8cece8d27c65f8e04ce4289f7052ca31910e35bd677f5e9e9ab3158c615064c347fc20018c70761" +
			"195714e48af6dbea986a002196fd802b0c18cf8da863c200d11c8cc032ae285420b22660487d6a4c" +
			"2cfb0157104687b2cfcb99354c9c8b9f83655c1110c4e41b068823b11f9671456016e367f5b96180" +
			"eaeca4e28a057f857a19ed02314e3f2967186068a06f5cae0c2e9b81cb1c7295dbd1f4ce3ea6b908" +
			"9e81655cd6989b997584dc5b076ef769e1b35f4e256f1c3ff1c5a5e45c5f4f4ccd664bc0425ecfc2" +
			"e454f6526ad4ef1346e85bd525977fab725938829eae6ab2bf401d6fbc660574aba35c1e56d76d0b" +
			"39d2dbb2ae7b800679778331ee2df273318d4211f4c41713f277114e4a627f72fa52426015cebfee" +
			"ed6cfa8174cb98d93f982556c9cf9c571f74703fea60360f65c794217a92bd0337ddb81a6ebc7645" +
			"db30860031e287310c7f3c3d88181f82924149f48727cec34949e8c327cf27924dc943bf15ec6de6" +
			"cf82e9f78701f8b5fd049cbe76cb71af795ea525d6acea944c71357c55fed475d920667160887d5e" +
			"3eb815a80cfb0435c17f7be42c7c22cf27a5dacea3af23a65c64791cdf374ee29ca243e979fdc22f" +
			"431f95c9f803c904dfe8ef2b0b438c6c59df3dc403830c50c497c253957e4912fc0cbcf97f5f481b" +
			"3d9384dbfecfa3bc967b4e7920e1e8a40508dd38a3a6b123eef346748b38d710896921eda29cd3b7" +
			"aa5b32c22af8d62d6b13866835f2be289ebb19b0555a4049f95b1f7c0eef8e9d4d1cb3f93eac4137" +
			"f32ef4210fef6112709e25f1f3417863318d07c8ef5ca51d6e979a416987db07d640d31170fe6c54" +
			"0e9aa90514d1dffde80cbcf5fbd33031997ae3eefb75b2bf264c8760a0342b6dfc0d9fc2f9fe8ff0" +
			"ea48a1fd07004a3afda4b1ef236479cc6be7f3ed8aa0afa6270fa2d07a94dff055e94c3e72f73a79" +
			"de9c3789ca366c7f7843cf33a1b89a32b3945a40a97825e56fbdff59c200cd0077f26aa5d3d0e97d" +
			"03b2f87684da43c378bc320dca44dcfdf5257cb7400de94fa36b6029b48022fcabef9c84577e730a" +
			"261369afa377f3107ae8cf8cefc096ebe5630f7fd0a248b813469e23c440d9aeb3483dc8803daa67" +
			"5fb81291e16baeee8607efbc01be21cdc362b5422de9d7f752130bd50286f0ef9c320e5dd220f01d" +
			"69a78fdc07f6dc42f9933b2c5eab5c8f977899e61942f0dae5b62ac497d6d9cbad8797cbe61c00b8" +
			"9f407a84cc4b5c23194169846f498db010469065ec7f787df7b65a69ea32c0f091897eac8a23300f" +
			"bcf4e67149f89376b68d54960a949530d358241f6c2212e4a866960f01ea8ffa721efacc43d09a73" +
			"a9ad914634521e843b1e43ed973f45fc47ef5e3f6fd3101af77b69a0011c383ab1ab91d9c10f3f39" +
			"07fffef26139a336e954801957a79200ded3b8fe039c8e9275081872f2781c95b83ca7d0914a9637" +
			"54a6d33a522e77f48cf39764367fc09b7412f9e5f3b6eafc7d5777c1630f0c3434729075ed7e787d" +
			"cfae7ae91a6280e123677bb1a3e710e43c46aed4fd8b52ea5f7dfb0434024e9850a3105a07ae45f2" +
			"d23864c6067c8e3ae5a4d7b51d57af6df2e4ee5baf8347efd9906f16a4e32766baee1a1a107597f7" +
			"1bd68d790ea192fa7f3bf0fb646ad6d8d580cd4d1b8fbe039685039372eea4012dd7b43ee0130811" +
			"70d272ea0b0ee203ce25cbcffd07af1d1c75ebc96f635e9f2a4771fb9fdd2ad722aef2aacb9bf409" +
			"a171e32871e0f8a53d02ece7475f9112ffdcab1f05d3e6d9b95a687420c08f0d97c79cb060debc34" +
			"59850bb92f5ef67cca709d48db06dd24a509be237f24fd5ee9f8ed800631af7ba1a6e0c5378ec28b" +
			"af1ff3ed3373d22ca7934fa992f4a9bd4cbb24e40041c08973c6d8e8dbfc3ca78f773c86da64ea46" +
			"22fc22b7ad79e52621396da2edf6ea0d8c6c20d05ff455f9dfb96763ca0475c6fc21cc9b99d5a8e0" +
			"3f5e397ce8b5df9eea4d1bc83598eb2039d214b0fdf98ea05f5ea371bcfc7a6982f781302f3fa491" +
			"7aa8c6371a8c707d92db707eb88e34bf760c6dd2fb6ebf7efc2f1ebcf9ae7a5e3fc7bcdf6ca42a78" +
			"ed77279fd4d7f49ed579faa58c8ce8ea858a10b0c71488b91d979637df3864e972bc6caf0de0966d" +
			"caaac7066833d58a07da66f2b6c2ac6ef493fb25b1bea2497ff9ee27bbe74b7c8505bdda6af4278f" +
			"3e235bb237bb23dd3a70c5869c67e910596721ba1d8da4c375d9c8aec10f13a60c7db0e99cd7c5d2" +
			"7a495dce17c64d0713c5ee85832d0ff57db0f6f1a121bdefd05458e85e315466a09f20de3dfaf77f" +
			"ba07168005fb330a837ffbb37db2055b43b674d1a0636d1685004b561b3650beb1cf30bfb65009ad" +
			"e77b345217cd6be3c5fed17f78a4e66c5f2d2ceee57633d5edf2ef68c879715eb90afe6b59794a7d" +
			"ae4352c94692dbe6b112af4d0d9188ec9abff215581be9db454d9d59b820d7ba3e33fdeba860b75e" +
			"de06dd4e379f26bedf5e20f70bacbfe8a295bd5f1c83990bdb611158b4200dfedd0bfd30170dcbd3" +
			"7e00f04d21b9573eecf51ae30ccdb36ecf495b13751d29741c3e734eb2f953198230477efbb563ca" +
			"a72c6a36770169857a94af120f8dfee4bb63b0082c89261ddcf1423f56e4249110fd36942a316efb" +
			"44036114f59472adfc999d1622a75d61451b6c8317dc48f7f96d4a88a83e2f4318dd8907570379f5" +
			"25337d92f87b16477c52e2e2619820d304611a0b003a11c2e980e492f34e5e7a3a66237d695e12e9" +
			"f42f935f8f36540505d201bb1f9ac58917e14c21b593572ee4f01b4ae2cfe192105f17b964e04c60" +
			"6f204fd228fc34c6eee975f350dc226ea16eab1ca6acede886da4327ace8aee5902ee365997cd9bd" +
			"67614b4afcb4bd4b0cc5047104c3b2ddfd96e1030b1e08deac96b6cd411f4080719e30d06b8ec467" +
			"e5a77553bfc2974b60e55b670f88c6e50a266c363c9f81310000826face80e21a60c9d76e3683427" +
			"b62d25f1759d4b8ec11dfb7a31ea795a367aeb7cf271c7cb84836f4d52d49661bdec9c9e8b80d6cd" +
			"cf1fd6d274f9385446283e0f7c79bc463a88f68b7862fbe89e6d4bfef06e531840e3ce1fffd72e39" +
			"d2dc19265fc84e6631c25f636f2c3f137f70a53fd7e970f2e7c501d437fea174ae94eb38ba96914f" +
			"85c45bdcfbce53df6b787167be682a0328dcf9e3ffde216f523241f6bc6188863c0c803943e8fa01" +
			"b5e81474145999b5d2003055eeb7c7f50d5c1f92966954bfa85137b8e513bf765c0ac193bfd9f3bd" +
			"67a089683a0328247e81c061489c43ddbb2a865300bd7ee667405c296a5bc1e9e8f43aec4452572c" +
			"4ffc5cee0ad56773fa8eabf3bd0210a4569e0783b5cabf63114e49676fdb1834192d61008ddb77fc" +
			"e79e48a4fb093cd207a4d111704a63ea1f082fa529cb619b80c471a5a2abf1f889c653e79214c73b" +
			"126b8471a754b86dde1be1f4ae66d8fb105aca000a92093647103d0d6494601aa33b0579ae1cbbef" +
			"784f017def691a5b96750a799c60697274bf690273e4024ccacb0de97e35c48b21defeee9e3f1f81" +
			"16a2e51fba513718c1f45d31c6bbedaa56a66a91af18dab820d89a823df232c02b0b599cf0ca212a" +
			"1c799c004d44b3bc4b56ead0693b7ae5ba718969d9adfaa4d5c40728400350c8e162ff1c743e05a1" +
			"e1622edd5371a3f63501d5d174174ec849340e179b7009b5a19e0397ab80306c27d0297ea42a66b6" +
			"b7c2d6e7a15006d0b863c7f34f24c345946681384b213b4ae1bb0dbe8a86dc70ee44e6a5b5934320" +
			"fc074a6c3b38a7b8e72c66449eec2e42e2394ac1001a9a116427f77b91d4fb02a8d9dd00013608d8" +
			"69938e64e68e27cd1392f63c46751e74b58aa03484d728150368284711d4dc01e2661b9a4301e04f" +
			"ea02e4d98f7cc7cf4995a5cd88481ccdf0fec5bc76917a44f908af514a06d0f8baf4112a71b42b12" +
			"e2a1d43cd44140141b7d62b80990c338dc1bcfc6fbdffba76da57d1977a91980e28e1f3ebf358e70" +
			"ab24e8635204b3594532cce35bc731e0d83133921b961569672073ec87ce9f69a048c0788c95fd02" +
			"679e7df71fb78d401ba06d1880e2f61feedb8c51f4846cfc26d9ef834ce1068f00d651344e1d4340" +
			"79d754ee0a92e8637300cf4571bcff421546c75a3481b354684b06a05066a2631606e7a2687314e3" +
			"26794b83f2ae120de13c202a44903900420e233267d30c39d5fcfc184678b082303a330323efff73" +
			"7143b8a540db334008b7fdcdbec128825ea51db002fd512c364a59954c11f7a2628ed043aee90acc" +
			"58728a3026d38d49629f53e74aca676661b4dd891dc2ff031cdfd3d1a504b82d0000000049454e44" +
			"ae426082",
	},
	"message_error": {
		size:   "16x16",
		width:  16,
		height: 16,
		encoded: "" +
			"3c7376672077696474683d22313622206865696768743d223136222076696577426f783d22302030" +
			"203136203136222066696c6c3d226e6f6e652220786d6c6e733d22687474703a2f2f7777772e7733" +
			"2e6f72672f323030302f737667223e0a3c706174682066696c6c2d72756c653d226576656e6f6464" +
			"2220636c69702d72756c653d226576656e6f64642220643d224d313620384331362031302e313231" +
			"372031352e313537312031322e313536362031332e363536392031332e363536394331322e313536" +
			"362031352e313537312031302e31323137203136203820313643352e383738323720313620332e38" +
			"343334342031352e3135373120322e33343331352031332e3635363943302e383432383535203132" +
			"2e3135363620302031302e3132313720302038433020352e383738323720302e3834323835352033" +
			"2e383433343420322e333433313520322e333433313543332e383433343420302e38343238353520" +
			"352e38373832372030203820304331302e3132313720302031322e3135363620302e383432383535" +
			"2031332e3635363920322e33343331354331352e3135373120332e383433343420313620352e3837" +
			"383237203136203856385a4d3920313243392031322e3236353220382e38393436342031322e3531" +
			"393620382e37303731312031322e3730373143382e35313935372031322e3839343620382e323635" +
			"3232203133203820313343372e373334373820313320372e34383034332031322e3839343620372e" +
			"32393238392031322e3730373143372e31303533362031322e3531393620372031322e3236353220" +
			"3720313243372031312e3733343820372e31303533362031312e3438303420372e32393238392031" +
			"312e3239323943372e34383034332031312e3130353420372e373334373820313120382031314338" +
			"2e323635323220313120382e35313935372031312e3130353420382e37303731312031312e323932" +
			"3943382e38393436342031312e3438303420392031312e3733343820392031325631325a4d382033" +
			"43372e3733343738203320372e343830343320332e313035333620372e323932383920332e323932" +
			"383943372e313035333620332e3438303433203720332e3733343738203720345638433720382e32" +
			"3635323220372e313035333620382e353139353720372e323932383920382e373037313143372e34" +
			"3830343320382e383934363420372e373334373820392038203943382e3236353232203920382e35" +
			"3139353720382e383934363420382e373037313120382e373037313143382e383934363420382e35" +
			"31393537203920382e3236353232203920385634433920332e373334373820382e38393436342033" +
			"2e343830343320382e373037313120332e323932383943382e353139353720332e31303533362038" +
			"2e32363532322033203820335a222066696c6c3d2223464544434443222f3e0a3c2f7376673e0a",
	},
	"message_info": {
		size:   "16x16",
		width:  16,
		height: 16,
		encoded: "" +
			"3c7376672077696474683d22313622206865696768743d223136222076696577426f783d22302030" +
			"203136203136222066696c6c3d226e6f6e652220786d6c6e733d22687474703a2f2f7777772e7733" +
			"2e6f72672f323030302f737667223e0a3c706174682066696c6c2d72756c653d226576656e6f6464" +
			"2220636c69702d72756c653d226576656e6f64642220643d224d31342e3639343720332e32393237" +
			"394331342e3838323220332e34383033312031342e3938373520332e37333436322031342e393837" +
			"3520332e39393937394331342e3938373520342e32363439352031342e3838323220342e35313932" +
			"362031342e3639343720342e37303637394c362e36393437312031322e3730363843362e35303731" +
			"382031322e3839343320362e32353238382031322e3939393620352e39383737312031322e393939" +
			"3643352e37323235352031322e3939393620352e34363832342031322e3839343320352e32383037" +
			"312031322e373036384c312e323830373120382e373036373943312e303938353520382e35313831" +
			"3820302e39393737353920382e323635353820312e303030303420382e303033333943312e303032" +
			"333220372e373431313920312e313037343920372e343930333820312e323932383920372e333034" +
			"393743312e3437383320372e313139353620312e373239313120372e303134333920312e39393133" +
			"3120372e303132313143322e323533353120372e303039383320322e353036313120372e31313036" +
			"3320322e363934373120372e32393237394c352e39383737312031302e353835384c31332e323830" +
			"3720332e32393237394331332e3436383220332e31303533322031332e3732323520332031332e39" +
			"38373720334331342e3235323920332031342e3530373220332e31303533322031342e3639343720" +
			"332e32393237395a222066696c6c3d2223413545334243222f3e0a3c2f7376673e0a",
	},
	"message_other": {
		size:   "16x16",
		width:  16,
		height: 16,
		encoded: "" +
			"3c7376672077696474683d22313622206865696768743d223136222076696577426f783d22302030" +
			"203136203136222066696c6c3d226e6f6e652220786d6c6e733d22687474703a2f2f7777772e7733" +
			"2e6f72672f323030302f737667223e0a3c706174682066696c6c2d72756c653d226576656e6f6464" +
			"2220636c69702d72756c653d226576656e6f64642220643d224d313620384331362031302e313231" +
			"372031352e313537312031322e313536362031332e363536392031332e363536394331322e313536" +
			"362031352e313537312031302e31323137203136203820313643352e383738323720313620332e38" +
			"343334342031352e3135373120322e33343331352031332e3635363943302e383432383535203132" +
			"2e3135363620302031302e3132313720302038433020352e383738323720302e3834323835352033" +
			"2e383433343420322e333433313520322e333433313543332e383433343420302e38343238353520" +
			"352e38373832372030203820304331302e3132313720302031322e3135363620302e383432383535" +
			"2031332e3635363920322e33343331354331352e3135373120332e383433343420313620352e3837" +
			"38323720313620385a4d392034433920342e323635323220382e383934363420342e353139353720" +
			"382e373037313120342e373037313143382e353139353720342e383934363420382e323635323220" +
			"352038203543372e3733343738203520372e343830343320342e383934363420372e323932383920" +
			"342e373037313143372e313035333620342e3531393537203720342e323635323220372034433720" +
			"332e373334373820372e313035333620332e343830343320372e323932383920332e323932383943" +
			"372e343830343320332e313035333620372e373334373820332038203343382e3236353232203320" +
			"382e353139353720332e313035333620382e373037313120332e323932383943382e383934363420" +
			"332e3438303433203920332e3733343738203920345a4d37203743362e3733343738203720362e34" +
			"3830343320372e313035333620362e323932383920372e323932383943362e313035333620372e34" +
			"38303433203620372e373334373820362038433620382e323635323220362e313035333620382e35" +
			"3139353720362e323932383920382e373037313143362e343830343320382e383934363420362e37" +
			"3334373820392037203956313243372031322e3236353220372e31303533362031322e3531393620" +
			"372e32393238392031322e3730373143372e34383034332031322e3839343620372e373334373820" +
			"31332038203133483943392e323635323220313320392e35313935372031322e3839343620392e37" +
			"303731312031322e3730373143392e38393436342031322e353139362031302031322e3236353220" +
			"31302031324331302031312e3733343820392e38393436342031312e3438303420392e3730373131" +
			"2031312e3239323943392e35313935372031312e3130353420392e32363532322031312039203131" +
			"5638433920372e373334373820382e383934363420372e343830343320382e373037313120372e32" +
			"3932383943382e353139353720372e313035333620382e323635323220372038203748375a222066" +
			"696c6c3d2223443145384634222f3e0a3c2f7376673e0a",
	},
	"message_question": {
		size:   "16x16",
		width:  16,
		height: 16,
		encoded: "" +
			"3c7376672077696474683d22313622206865696768743d223136222076696577426f783d22302030" +
			"203136203136222066696c6c3d226e6f6e652220786d6c6e733d22687474703a2f2f7777772e7733" +
			"2e6f72672f323030302f737667223e0a3c706174682066696c6c2d72756c653d226576656e6f6464" +
			"2220636c69702d72756c653d226576656e6f64642220643d224d313620384331362031302e313231" +
			"372031352e313537312031322e313536362031332e363536392031332e363536394331322e313536" +
			"362031352e313537312031302e31323137203136203820313643352e383738323720313620332e38" +
			"343334342031352e3135373120322e33343331352031332e3635363943302e383432383535203132" +
			"2e3135363620302031302e3132313720302038433020352e383738323720302e3834323835352033" +
			"2e383433343420322e333433313520322e333433313543332e383433343420302e38343238353520" +
			"352e38373832372030203820304331302e3132313720302031322e3135363620302e383432383535" +
			"2031332e3635363920322e33343331354331352e3135373120332e383433343420313620352e3837" +
			"383237203136203856385a4d38203543372e3832343320342e393939383320372e36353136352035" +
			"2e303435393520372e343939343520352e313333373343372e333437323420352e32323135312037" +
			"2e323230383520352e333437383420372e31333320352e3543372e303639353720352e3631373838" +
			"20362e393833313120352e373231383220362e383738373620352e383035363643362e3737343431" +
			"20352e3838393520362e363534323920352e393531353420362e353235353220352e393838314336" +
			"2e333936373520362e303234363620362e323631393420362e303334393920362e31323931312036" +
			"2e303138343943352e393936323720362e303031393820352e383638303920352e39353839372035" +
			"2e373532313820352e383932303143352e363336323820352e383235303520352e35333439392035" +
			"2e3733353520352e343534333320352e363238363743352e333733363720352e353231383420352e" +
			"333135323920352e3339393920352e323832363320352e323730303843352e323439393720352e31" +
			"3430323720352e323433373120352e303035323220352e323634323120342e383732393443352e32" +
			"3834373220342e373430363520352e333331353720342e363133383420352e34303220342e354335" +
			"2e373332323220332e393238313120362e323431393120332e343831313620362e38353230332033" +
			"2e323238343643372e343632313420322e393735373620382e313338353920322e39333134342038" +
			"2e373736343720332e313032333643392e343134333420332e323733323820392e39373820332e36" +
			"343938392031302e333820342e313733384331302e37383220342e3639373720313120352e333339" +
			"363220313120364331312e3030303220362e36323036322031302e3830373920372e323236303320" +
			"31302e3434393820372e37333238354331302e3039313620382e323339363820392e353835303720" +
			"382e3632323939203920382e38335639433920392e323635323220382e383934363420392e353139" +
			"353720382e373037313120392e373037313143382e353139353720392e383934363420382e323635" +
			"3232203130203820313043372e373334373820313020372e343830343320392e383934363420372e" +
			"323932383920392e373037313143372e313035333620392e3531393537203720392e323635323220" +
			"3720395638433720372e373334373820372e313035333620372e343830343320372e323932383920" +
			"372e323932383943372e343830343320372e313035333620372e373334373820372038203743382e" +
			"3236353232203720382e353139353720362e383934363420382e373037313120362e373037313143" +
			"382e383934363420362e3531393537203920362e323635323220392036433920352e373334373820" +
			"382e383934363420352e343830343320382e373037313120352e323932383943382e353139353720" +
			"352e313035333620382e32363532322035203820355a4d3820313343382e32363532322031332038" +
			"2e35313935372031322e3839343620382e37303731312031322e3730373143382e38393436342031" +
			"322e3531393620392031322e32363532203920313243392031312e3733343820382e383934363420" +
			"31312e3438303420382e37303731312031312e3239323943382e35313935372031312e3130353420" +
			"382e3236353232203131203820313143372e373334373820313120372e34383034332031312e3130" +
			"353420372e32393238392031312e3239323943372e31303533362031312e3438303420372031312e" +
			"37333438203720313243372031322e3236353220372e31303533362031322e3531393620372e3239" +
			"3238392031322e3730373143372e34383034332031322e3839343620372e37333437382031332038" +
			"2031335631335a222066696c6c3d2223463944314236222f3e0a3c2f7376673e0a",
	},
	"message_warning": {
		size:   "16x16",
		width:  16,
		height: 16,
		encoded: "" +
			"3c7376672077696474683d22313622206865696768743d223136222076696577426f783d22302030" +
			"203136203136222066696c6c3d226e6f6e652220786d6c6e733d22687474703a2f2f7777772e7733" +
			"2e6f72672f323030302f737667223e0a3c706174682066696c6c2d72756c653d226576656e6f6464" +
			"2220636c69702d72756c653d226576656e6f64642220643d224d362e313631313120322e30323538" +
			"3643362e393638313920302e36353830343620392e303332383520302e36353830343620392e3833" +
			"38383820322e30323538364c31352e373235382031322e303032394331362e353137312031332e33" +
			"3434352031352e353031312031352031332e38383820313548322e313133303343302e3439383836" +
			"38203135202d302e3531373130372031332e3334343520302e3237343135312031322e303032394c" +
			"362e313631313120322e30323538365a4d392e3035352031312e3938333843392e3035352031322e" +
			"3235303520382e39343338352031322e3530363320382e3734362031322e3639343943382e353438" +
			"31352031322e3838333520382e323739382031322e3938393520372e39393939392031322e393839" +
			"3543372e37323031392031322e3938393520372e34353138342031322e3838333520372e32353339" +
			"392031322e3639343943372e30353631342031322e3530363320362e39343439382031322e323530" +
			"3520362e39343439382031312e3938333843362e39343439382031312e37313720372e3035363134" +
			"2031312e3436313220372e32353339392031312e3237323643372e34353138342031312e30383420" +
			"372e37323031392031302e39373820372e39393939392031302e39373843382e323739382031302e" +
			"39373820382e35343831352031312e30383420382e3734362031312e3237323643382e3934333835" +
			"2031312e3436313220392e3035352031312e37313720392e3035352031312e393833385631312e39" +
			"3833385a4d372e393939393920332e393337373943372e373230313920332e393337373920372e34" +
			"3531383420342e303433373520372e323533393920342e323332333643372e303536313420342e34" +
			"3230393820362e393434393820342e363736373920362e393434393820342e393433353356372e39" +
			"3630373843362e393434393820382e323237353220372e303536313420382e343833333320372e32" +
			"3533393920382e363731393543372e343531383420382e383630353620372e373230313920382e39" +
			"3636353220372e393939393920382e393636353243382e3237393820382e393636353220382e3534" +
			"38313520382e383630353620382e37343620382e363731393543382e393433383520382e34383333" +
			"3320392e30353520382e323237353220392e30353520372e393630373856342e393433353343392e" +
			"30353520342e363736373920382e393433383520342e343230393820382e37343620342e32333233" +
			"3643382e353438313520342e303433373520382e3237393820332e393337373920372e3939393939" +
			"20332e39333737395a222066696c6c3d2223464646354331222f3e0a3c2f7376673e0a",
	},
	"field_error": {
		size:   "16x16",
		width:  16,
		height: 16,
		encoded: "" +
			"3c7376672077696474683d22313622206865696768743d223136222076696577426f783d22302030" +
			"203136203136222066696c6c3d226e6f6e652220786d6c6e733d22687474703a2f2f7777772e7733" +
			"2e6f72672f323030302f737667223e0a3c706174682066696c6c2d72756c653d226576656e6f6464" +
			"2220636c69702d72756c653d226576656e6f64642220643d224d313620384331362031302e313231" +
			"372031352e313537312031322e313536362031332e363536392031332e363536394331322e313536" +
			"362031352e313537312031302e31323137203136203820313643352e383738323720313620332e38" +
			"343334342031352e3135373120322e33343331352031332e3635363943302e383432383535203132" +
			"2e3135363620302031302e3132313720302038433020352e383738323720302e3834323835352033" +
			"2e383433343420322e333433313520322e333433313543332e383433343420302e38343238353520" +
			"352e38373832372030203820304331302e3132313720302031322e3135363620302e383432383535" +
			"2031332e3635363920322e33343331354331352e3135373120332e383433343420313620352e3837" +
			"383237203136203856385a4d3920313243392031322e3236353220382e38393436342031322e3531" +
			"393620382e37303731312031322e3730373143382e35313935372031322e3839343620382e323635" +
			"3232203133203820313343372e373334373820313320372e34383034332031322e3839343620372e" +
			"32393238392031322e3730373143372e31303533362031322e3531393620372031322e3236353220" +
			"3720313243372031312e3733343820372e31303533362031312e3438303420372e32393238392031" +
			"312e3239323943372e34383034332031312e3130353420372e373334373820313120382031314338" +
			"2e323635323220313120382e35313935372031312e3130353420382e37303731312031312e323932" +
			"3943382e38393436342031312e3438303420392031312e3733343820392031325631325a4d382033" +
			"43372e3733343738203320372e343830343320332e313035333620372e323932383920332e323932" +
			"383943372e313035333620332e3438303433203720332e3733343738203720345638433720382e32" +
			"3635323220372e313035333620382e353139353720372e323932383920382e373037313143372e34" +
			"3830343320382e383934363420372e373334373820392038203943382e3236353232203920382e35" +
			"3139353720382e383934363420382e373037313120382e373037313143382e383934363420382e35" +
			"31393537203920382e3236353232203920385634433920332e373334373820382e38393436342033" +
			"2e343830343320382e373037313120332e323932383943382e353139353720332e31303533362038" +
			"2e32363532322033203820335a222066696c6c3d2223424331443144222f3e0a3c2f7376673e0a",
	},
	"warning_default": {
		size:   "64x64",
		width:  64,
		height: 64,
		encoded: "" +
			"3c7376672077696474683d22363622206865696768743d223636222076696577426f783d22302030" +
			"203636203636222066696c6c3d226e6f6e652220786d6c6e733d22687474703a2f2f7777772e7733" +
			"2e6f72672f323030302f737667223e0a3c7061746820643d224d35352e333730352033382e383137" +
			"384335352e393535352033362e393333332035362e323539332033342e393732382035362e323732" +
			"332033322e393939365631322e3633364c33322e3939393620332e39303836394c32332e38303639" +
			"20372e333431343222207374726f6b653d222344393737303622207374726f6b652d77696474683d" +
			"223222207374726f6b652d6c696e656361703d22726f756e6422207374726f6b652d6c696e656a6f" +
			"696e3d22726f756e64222f3e0a3c7061746820643d224d31312e383530392031312e383531314c39" +
			"2e37323732392031322e363336355633332e3030303243392e37323732392035302e343534372033" +
			"332036322e303931312033332036322e303931314333392e313538362035382e383431342034342e" +
			"363933372035342e353237372034392e333439312034392e33343933222066696c6c3d2223464546" +
			"334337222f3e0a3c7061746820643d224d31312e383530392031312e383531314c392e3732373239" +
			"2031322e363336355633332e3030303243392e37323732392035302e343534372033332036322e30" +
			"3931312033332036322e303931314333392e313538362035382e383431342034342e363933372035" +
			"342e353237372034392e333439312034392e3334393322207374726f6b653d222344393737303622" +
			"207374726f6b652d77696474683d223222207374726f6b652d6c696e656361703d22726f756e6422" +
			"207374726f6b652d6c696e656a6f696e3d22726f756e64222f3e0a3c7061746820643d224d312031" +
			"4c363520363522207374726f6b653d222344393737303622207374726f6b652d77696474683d2232" +
			"22207374726f6b652d6c696e656361703d22726f756e6422207374726f6b652d6c696e656a6f696e" +
			"3d22726f756e64222f3e0a3c2f7376673e0a",
	},
	"not_encrypted": {
		size:   "64x64",
		width:  64,
		height: 64,
		encoded: "" +
			"3c7376672077696474683d22363622206865696768743d223636222076696577426f783d22302030" +
			"203636203636222066696c6c3d226e6f6e652220786d6c6e733d22687474703a2f2f7777772e7733" +
			"2e6f72672f323030302f737667223e0a3c7061746820643d224d35352e333730352033382e383137" +
			"384335352e393535352033362e393333332035362e323539332033342e393732382035362e323732" +
			"332033322e393939365631322e3633364c33322e3939393620332e39303836394c32332e38303639" +
			"20372e333431343222207374726f6b653d222344393737303622207374726f6b652d77696474683d" +
			"223222207374726f6b652d6c696e656361703d22726f756e6422207374726f6b652d6c696e656a6f" +
			"696e3d22726f756e64222f3e0a3c7061746820643d224d31312e383530392031312e383531314c39" +
			"2e37323732392031322e363336355633332e3030303243392e37323732392035302e343534372033" +
			"332036322e303931312033332036322e303931314333392e313538362035382e383431342034342e" +
			"363933372035342e353237372034392e333439312034392e33343933222066696c6c3d2223464546" +
			"334337222f3e0a3c7061746820643d224d31312e383530392031312e383531314c392e3732373239" +
			"2031322e363336355633332e3030303243392e37323732392035302e343534372033332036322e30" +
			"3931312033332036322e303931314333392e313538362035382e383431342034342e363933372035" +
			"342e353237372034392e333439312034392e3334393322207374726f6b653d222344393737303622" +
			"207374726f6b652d77696474683d223222207374726f6b652d6c696e656361703d22726f756e6422" +
			"207374726f6b652d6c696e656a6f696e3d22726f756e64222f3e0a3c7061746820643d224d312031" +
			"4c363520363522207374726f6b653d222344393737303622207374726f6b652d77696474683d2232" +
			"22207374726f6b652d6c696e656361703d22726f756e6422207374726f6b652d6c696e656a6f696e" +
			"3d22726f756e64222f3e0a3c2f7376673e0a",
	},
	"partially_anonymous": {
		size:   "64x64",
		width:  64,
		height: 64,
		encoded: "" +
			"3c7376672077696474683d22363622206865696768743d223636222076696577426f783d22302030" +
			"203636203636222066696c6c3d226e6f6e652220786d6c6e733d22687474703a2f2f7777772e7733" +
			"2e6f72672f323030302f737667223e0a3c7061746820643d224d35302e32382035302e3237393943" +
			"34352e333037322035342e303730342033392e323531392035362e313730342033332035362e3237" +
			"32364331322e363336342035362e3237323620312033322e3939393920312033322e393939394334" +
			"2e36313835392032362e3235363320392e36333734382032302e333634352031352e37322031352e" +
			"373139394c35302e32382035302e323739395a4d32362e383930392031302e343235334332382e38" +
			"39333320392e39353635392033302e3934333520392e373232323920333320392e37323731324335" +
			"332e3336333620392e37323731322036352033322e393939392036352033322e393939394336332e" +
			"323334312033362e333033342036312e313238322033392e343133362035382e373136342034322e" +
			"323739394c32362e383930392031302e343235335a4d33392e313637332033392e31363731433338" +
			"2e333638332034302e303234362033372e343034382034302e373132332033362e33333433203431" +
			"2e313839334333352e323633372034312e363636332033342e313038312034312e39323238203332" +
			"2e393336332034312e393433354333312e373634342034312e393634312033302e36303035203431" +
			"2e373438362032392e353133382034312e333039364332382e343237312034302e38373037203237" +
			"2e343339392034302e323137342032362e363131322033392e333838374332352e37383235203338" +
			"2e353539392032352e313239312033372e353732382032342e363930322033362e34383631433234" +
			"2e323531332033352e333939342032342e303335372033342e323335342032342e30353634203333" +
			"2e303633364332342e303737312033312e383931382032342e333333362033302e37333631203234" +
			"2e383130362032392e363635364332352e323837352032382e353935312032352e39373533203237" +
			"2e363331362032362e383332372032362e38333236222066696c6c3d2223464546334337222f3e0a" +
			"3c7061746820643d224d33392e313637332033392e313637314333382e333638332034302e303234" +
			"362033372e343034382034302e373132332033362e333334332034312e313839334333352e323633" +
			"372034312e363636332033342e313038312034312e393232382033322e393336332034312e393433" +
			"354333312e373634342034312e393634312033302e363030352034312e373438362032392e353133" +
			"382034312e333039364332382e343237312034302e383730372032372e343339392034302e323137" +
			"342032362e363131322033392e333838374332352e373832352033382e353539392032352e313239" +
			"312033372e353732382032342e363930322033362e343836314332342e323531332033352e333939" +
			"342032342e303335372033342e323335342032342e303536342033332e303633364332342e303737" +
			"312033312e383931382032342e333333362033302e373336312032342e383130362032392e363635" +
			"364332352e323837352032382e353935312032352e393735332032372e363331362032362e383332" +
			"372032362e383332364d35302e32382035302e323739394334352e333037322035342e3037303420" +
			"33392e323531392035362e313730342033332035362e323732364331322e363336342035362e3237" +
			"323620312033322e3939393920312033322e3939393943342e36313835392032362e323536332039" +
			"2e36333734382032302e333634352031352e37322031352e373139394c35302e32382035302e3237" +
			"39395a4d32362e383930392031302e343235334332382e3839333320392e39353635392033302e39" +
			"34333520392e373232323920333320392e37323731324335332e3336333620392e37323731322036" +
			"352033322e393939392036352033322e393939394336332e323334312033362e333033342036312e" +
			"313238322033392e343133362035382e373136342034322e323739394c32362e383930392031302e" +
			"343235335a22207374726f6b653d222344393737303622207374726f6b652d77696474683d223222" +
			"207374726f6b652d6c696e656361703d22726f756e6422207374726f6b652d6c696e656a6f696e3d" +
			"22726f756e64222f3e0a3c7061746820643d224d3120314c363520363522207374726f6b653d2223" +
			"44393737303622207374726f6b652d77696474683d223222207374726f6b652d6c696e656361703d" +
			"22726f756e6422207374726f6b652d6c696e656a6f696e3d22726f756e64222f3e0a3c2f7376673e" +
			"0a",
	},
	"not_anonymous": {
		size:   "64x46",
		width:  64,
		height: 46,
		encoded: "" +
			"3c7376672077696474683d22363622206865696768743d223439222076696577426f783d22302030" +
			"203636203439222066696c6c3d226e6f6e652220786d6c6e733d22687474703a2f2f7777772e7733" +
			"2e6f72672f323030302f737667223e0a3c7061746820643d224d312032342e323732374331203234" +
			"2e323732372031322e36333634203120333320314335332e3336333620312036352032342e323732" +
			"372036352032342e323732374336352032342e323732372035332e333633362034372e3534353520" +
			"33332034372e353435354331322e363336342034372e3534353520312032342e3237323720312032" +
			"342e323732375a222066696c6c3d222346454633433722207374726f6b653d222344393737303622" +
			"207374726f6b652d77696474683d223222207374726f6b652d6c696e656361703d22726f756e6422" +
			"207374726f6b652d6c696e656a6f696e3d22726f756e64222f3e0a3c7061746820643d224d333320" +
			"33334333372e383139392033332034312e373237332032392e303932362034312e37323733203234" +
			"2e323732374334312e373237332031392e343532372033372e383139392031352e35343534203333" +
			"2031352e353435344332382e31382031352e353435342032342e323732372031392e343532372032" +
			"342e323732372032342e323732374332342e323732372032392e303932362032382e313820333320" +
			"33332033335a222066696c6c3d22776869746522207374726f6b653d222344393737303622207374" +
			"726f6b652d77696474683d223222207374726f6b652d6c696e656361703d22726f756e6422207374" +
			"726f6b652d6c696e656a6f696e3d22726f756e64222f3e0a3c2f7376673e0a",
	},
	"publicly_logged": {
		size:   "51x63",
		width:  51,
		height: 63,
		encoded: "" +
			"3c7376672077696474683d22353422206865696768743d223636222076696577426f783d22302030" +
			"203534203636222066696c6c3d226e6f6e652220786d6c6e733d22687474703a2f2f7777772e7733" +
			"2e6f72672f323030302f737667223e0a3c7061746820643d224d3333203148372e3443352e373032" +
			"3631203120342e303734373520312e363734323820322e383734353220322e383734353243312e36" +
			"3734323820342e3037343735203120352e3730323631203120372e345635382e3643312036302e32" +
			"39373420312e36373432382036312e3932353320322e38373435322036332e3132353543342e3037" +
			"3437352036342e3332353720352e373032363120363520372e342036354834352e384334372e3439" +
			"37342036352034392e313235332036342e333235372035302e333235352036332e31323535433531" +
			"2e353235372036312e393235332035322e322036302e323937342035322e322035382e365632302e" +
			"324c333320315a222066696c6c3d222346454633433722207374726f6b653d222344393737303622" +
			"207374726f6b652d77696474683d223222207374726f6b652d6c696e656361703d22726f756e6422" +
			"207374726f6b652d6c696e656a6f696e3d22726f756e64222f3e0a3c7061746820643d224d333320" +
			"315632302e324835322e3222207374726f6b653d222344393737303622207374726f6b652d776964" +
			"74683d223222207374726f6b652d6c696e656361703d22726f756e6422207374726f6b652d6c696e" +
			"656a6f696e3d22726f756e64222f3e0a3c7061746820643d224d33392e342033362e323030324831" +
			"332e3822207374726f6b653d222344393737303622207374726f6b652d77696474683d2232222073" +
			"74726f6b652d6c696e656361703d22726f756e6422207374726f6b652d6c696e656a6f696e3d2272" +
			"6f756e64222f3e0a3c7061746820643d224d33392e342034394831332e3822207374726f6b653d22" +
			"2344393737303622207374726f6b652d77696474683d223222207374726f6b652d6c696e65636170" +
			"3d22726f756e6422207374726f6b652d6c696e656a6f696e3d22726f756e64222f3e0a3c70617468" +
			"20643d224d32302e322032332e333939394831374831332e3822207374726f6b653d222344393737" +
			"303622207374726f6b652d77696474683d223222207374726f6b652d6c696e656361703d22726f75" +
			"6e6422207374726f6b652d6c696e656a6f696e3d22726f756e64222f3e0a3c2f7376673e0a",
	},
	"dialog_ok": {
		size:   "96x96",
		width:  64,
		height: 64,
		encoded: "" +
			"89504e470d0a1a0a0000000d4948445200000060000000600806000000e2987738000000047342495" +
			"4080808087c086488000000097048597300001d8700001d87018fe5f1650000001974455874536f66" +
			"7477617265007777772e696e6b73636170652e6f72679bee3c1a0000001e744558745469746c65005" +
			"37572752049636f6e205468656d652054656d706c6174656b870ca40000001174455874417574686f" +
			"720053616d20486577697474df8489460000005274455874436f70797269676874004343204174747" +
			"269627574696f6e2d5368617265416c696b6520687474703a2f2f6372656174697665636f6d6d6f6e" +
			"732e6f72672f6c6963656e7365732f62792d73612f342e302fc354620500000d9149444154789ced9" +
			"d7974d4d515c7bff7fd66c8a4c0cc04025a31641192a0b850844ab5b6c6000a9445246c094b690b52" +
			"7ba0cb111a828e1220d6e5f4b4d86aa556030d1001453888b204854a6be1146b51924012563506989" +
			"940b699f9ddfe91014948667e33f37e3309c9e71c4e9899fbbbf7cebbbf79effdde7d0ba18d129397" +
			"64f13420190aa7908a541027038803d0d5fb2fc6fb17002e01b8e0fd7b09c0290217ab248ae1a162a" +
			"50b4a2e2c2e7344e27bf88322edc0657ad96eebd6a0d4de03a8e910940ee6410084441365007601b4" +
			"8bddaedd4edbe9f31275074d44036059d937066e9141a02c26be07801226d31e061f20126bc8c5857" +
			"65b853d4c76af21fc01b041988df10f13d34c003f02600abb0f4da903b09589df70ba4ebc0b1bd470" +
			"1a0f5f006c30988d8953c0bc9880dbc2663700183802f04a67f289f5c880271c36f50f800d068b923" +
			"81bc48b00dca2bb3d391c07519ec355fe3a6c70eb6948d700c4e426dda7427d09c01d7adad191ffaa" +
			"429d5f9d7df21f7a19d0250066dbcd3d84c1f014038f436e4f26123081d7badd86df5cb41daf94ad5" +
			"c7a00acb9f11318b41a400fd9ba23cc7962ccb12fad785ba6527901b0ddd6c56ab8f41c03bf90aab7" +
			"6dc14cf883d3d5f509d88e34c85028a5a02ccbe213216803184342d3c4b25cd2d706e1df5079b263e" +
			"989f250bd09f9db5a7293ee06d4ed007a85aaab9d715e153ca63afbc481509484d4409a97278c043c" +
			"45e878850f003d848af72dcb124784a224e8009873e3a713632b40dd4271a07d43dd40bcd59c9b303" +
			"5580d418dbd9873e3a713281f802158c3d7110a0113a2d2aca5f57becff0bf4e280db00f3f284918d" +
			"773e8c815e7b9dd300a2318e25e53b03b928a000989f491a42c2b3a763573b3ea95105a707d2306b0" +
			"e806565df2478e85f00c506e75b87a1924043ed39e527b4086b6b845f196c8447fcbdb3f035d19bc1" +
			"85b0ddd6458bb0a60058bf3ef73c807b4272ab6331d4a2d4acd022e8b70af28eed6cd222db4913989" +
			"8c6db9796bfe34bc867a176b3ddd25b31783ec7f537b01626b84a75470da8b69554b526e1b30a1206" +
			"cfefd059f82140b1c250bfd2a7446b1f7893291ffa92e94413aa2af8bed6baa62dff026c30a85057a" +
			"1b3f06520844aafc0d6f2a8418b01b02889b301dca9ab5b1d8bdbadc6f8192d7d706d006c307813e8" +
			"9d48849916a3f0dab1b76b026036264e41fb99bdd09ee86f2e4d98d4fccda6016010b1da79f7eb846" +
			"02c85ad69993779615e113f0aa081e175ab6d72fb0db7a28b2277c097815bcdc6f89157bfd72400de" +
			"e9821d9e312923b173d626bc3cf64508923bab86546ad2185f691462f2922cacf25fd0c1c7f9e70d9" +
			"d8d55639e8551316240af64980c26ec2ddf2fcf00a15ff4fdd697eaf6daeb80ab7e01aa8727038896" +
			"67a97d41203c9db61879c39f6c72d72f183617f386ce9669cac40a4fbcfce28a2566354ba695f6449" +
			"4d205af3df2472c1836b7c5cf57a4e7606ceac3122dd295b2164063f543a061122db41b62bfd503db" +
			"b2d663c280d1adca08129871d764794689efed61eb6706bc016017ff007e13f42ccf81364282b52f7" +
			"6ccdc88217d06f9943b74f613ccdafc738996c9e036babe0f7803a0123fa0e122890e449ebbfbdc85" +
			"9db336a35f8f449f729f5516e3d1f5b370b1e1925c0758a401de00109026577bdb6674ca086c9d5e8" +
			"05e5d7bfa943b7ebe0213d665e142adfc154c84c69b9e62f2922caa5bbd80ebed166f857943676345" +
			"7a8edffefd19e71778287f124e39cee8e58a6a3446590d1e37a75007287c02e1a9b427b070d83cbfb" +
			"29597aa30be203384c2d7340158b8ea6b930508c9415ad18420811f26deaba709bf980c26e44ffc93" +
			"a6c23f57730163d74e43e9b9b2102c6abb9f59a114412a5243b0e497dc07b3f1f6b4b5c81bf194f4c" +
			"77a2dc4445bf1d6b47cfc28f521bfb2d5f517f1e8fa99385a551a06cf00c1942220d414bd0ccc199c" +
			"89f9df9d0300983764165e7f64154c86f0ad4a4db0f6c5fb333761589cff650bb5ae5a4c2e9c83ff7" +
			"cf169183c6b8481140195fae8a17cfc8051786ee4d34dde1b9bfa30b665ae43efaefacfef1a7cd39d" +
			"d8396b33faf74cf22bdbe07161c6a6f9f8e8e4c7bafb7535c474b3608259b6e26171435a1d49bcdcf" +
			"f4e89ed27dbec1546a78cc0b6cc757ebb9900e0610f7eba6501761edfab9b3fadc1c4dd05015227da" +
			"a6c4f643c1a4bfc064886a5526de1a87f7666ec4fd09df93691a406355973ff14f8836fa1f575459c" +
			"5dc2dbfc296cfdf95ee8746ba0b00dd656abcebc681b0465bfcca594d166c9cf23aa6ddf1a814bb82" +
			"0496a72f41de88a7a090ff650f0cc682edd9d878c4e7c4359de1ee8a29cdba0c1237c938527914f63" +
			"a3b86dff243bfb28a50303a6504acd156ec29db070e72bc294ae98257c6bd889983b42f547972f74a" +
			"bc7a303f287bf2204531a5599742f22e2587ce7e020f7b34573177f7b90ba9b1c9d851ba1b6e35b09" +
			"d0162a2ad7873cadf30a29f86e12c2fb97b5fc0ef0fbc1c901d9df028a634eb2fa14322e6a3931f23" +
			"ca10a5a90b0800a9bdfae30789f76247e92ed4b86a355d136f8dc3d6cc75b8f346ed69ec3f7ffc1a9" +
			"6ed7d5eb3bcbeb05d31a559e703b0eaa1fe838a7fa07b54370cbdf93b9ae4fb98bf8d71a90fa3a87c" +
			"1fced5f8de4f69f04d77e29de90588b368ef45af3eb4068bde7fdabf60d8a0af14539a650e40bdf53" +
			"25154b61f37996fd47c975a4d164c1a380e87ce7e82938ed32dca8c4a1e8e0d19ab613169ef41afff" +
			"f42d2cdc9e1d743ba313a714d303315920c4e969e5fd6345e8df3309037a691b7632194cc818380e5" +
			"fd79cc3e1664fa633074dc1cb635f40948f6e6e73b615bf879f6d59080f87752f26bf10d331c5f4a0" +
			"752474de4089c1d85eb21377dc3810fd7afa4e805c4690c043fd1fbcd2430280c5f72fc4f2f425018" +
			"d291595efc78c8d8fc11560e31e263e3210b898c3301aed52dd98b5f9e77873ca6bf87ebcf6f4f3bc" +
			"21b310fbad1e300803c60f181590cdfd27fe89a9853f45bd47cabe1ad221a098cccb133389794db88" +
			"c461ba3f1d6d47cdc1377b7ae760e9e398cf10599f253891261e2e9021e2a0ea7d15a572d3236fc18" +
			"9f7c19f0a272cd7c56598c491b6647b0f0b535f4041c1506551403e1dd29d0595f8d89ebf41977d73" +
			"38fab1d4d55ba6a34984ac579db312700fd6ec756a8aa398f09053350613f294de769e7598c2fc8c4" +
			"5717bf96a653470e572d2aae6e9c1704ec8984075f547f89316ba6e2b4f36cc8babeacfe0a63d64cd" +
			"533892e17a622c03b2d45785ff8b942173f4e3bcf62fcdf335179a9d5959c7e39577301e30bb2a4fe" +
			"9af48685fa4d00c8481f00fe362ad5afab7aec7c39261404576f3bebab31318c795c39b0dbe032ee0" +
			"3bc01b8b0b8ccc1e090b6de0a9523954703eeb9d4ba6a3179c39c6b9e96db3eb4dfdbf67e333b9a48" +
			"84ed59a0350e9e398c696ffe0c75ee7abfb20d1e17b2363d8603a7fe1d06cf24c3bcf6f27faf04402" +
			"8b40180b671601df9b0e2234c7bd3f7d3ab4b7563c6a6c7b0ebf80761f44c1a75e4a14d975f5c0980" +
			"f780836d1171a9197bcaf6e1276f2f683139e3610f1e7be7d7d851ba3b029e4980f1f6d5dbe53719d" +
			"562e237c2ef51cb6c3dba038f6f5b04f5aa114c06e357efe644388f1b1a0c3429e326a9c8fadd8e63" +
			"a67d96897ae60702e17f959fe37cadfd4aba71e9aeb690c70d1e023e73782a7e83bddff4e90dcd249" +
			"8739147c0da6bae8e10af1ecc47b72e5d214860d5bf5e8db43b21a11296353f20e2dace7d21144b49" +
			"fc5180f49b39d53129712457dcdafc60886b331b19f080c4b36173ab834084952d9dcad1626ac9d1b" +
			"ffc6f000eebee55c7e1bf7657458bd57acbb9bd0c7854a13e8eeb71655ef8511998dbda5128ad2657" +
			"bdc776bcae97571d88d5ce9c8a7fb6f6a1cfecb6471816016813079eb54fb84a15ae6c5f123e03703" +
			"1fbd8d7c49883ceaa28185840fcb83afbcc395f427ee784d615d98f46a559add4b9716b80f00bf69c" +
			"8a55fea4344db071f6eaf90418111dae6e677cec70775ba24550db0ca7b9875c004f07d02e92ad11a" +
			"69240195a0ff9d13cc5acf1c01a310ae08bc1fb76dd530d551da575e77420c0234c1c396507c16222" +
			"80b639d52cb23480c5238e274f1e0ae4a2801766d417d98f473d682923d004748015f61a519990e5c" +
			"cf1bd51774b04b532a67e8fe3d3a8346b29351e471bae3380db2a0d4cc8722ea9581fccc521ddc196" +
			"e589c3c1eae60e7ca44935583ce2585ab62b5805a11fe4f64cdfc110623b803691c409235f4155470" +
			"75ae73727e4cd1b1c4f9e3c44a0a1005a1def081e190fe03a3cc4330e0883181a6ae10392eaefba3d" +
			"7647fde45bf2a36aeaba7a9f982535ce32d448ed2730c02f387ac766d52dfcec820c85f28fb35d963" +
			"89649fdebf577e00f57a9acccae5e5a2675e688f41e4c5d91bdd834dcb29a98a2010c41fbefaa3281" +
			"d77a8471dcc59ce3d29354ba168ee599be83a1883f877ecc6dc438ac0a9e1fea89a9bed0ffee2c846" +
			"22d4e98c184df02e8afbb3d39941061a5bd7fc59a96f2b832095ff55008c55c929041e0ec36bc43fb" +
			"a74c58e1745514369f3ea217e1af9f19645e11ff10a93403847188fc7ed5b5606c61e00d674ec57ba" +
			"0f0269f22da40c6e425595497e7511065027c1f40613a1e97dd00ed27e235c265dc7879aa78246833" +
			"3d941b9ebba16b5d5dd761809a0e41e9601e04090f8a575106601740bbc8cd3baf9e201b49da4c009" +
			"a13fb6c4a77577d6d322b942254a43251320171dcb8c35737346e3072790cea22003b806a022e3170" +
			"8a806215384aaa5a628c8a2ea95a545c1da9efe28bff0315778735ec8187fb0000000049454e44ae4" +
			"26082",
	},
	"dialog_question": {
		size:   "84x84",
		width:  42,
		height: 42,
		encoded: "" +
			"89504e470d0a1a0a0000000d4948445200000060000000600806000000e2987738000000097048597" +
			"300000b1300000b1301009a9c18000000017352474200aece1ce90000000467414d410000b18f0bfc" +
			"610500000e2f494441547801ed9d0b7054d51980ff73efdd47b2c9269b0721981798c82b2411aa205" +
			"6880f7c8c8aa5886d671c541c759c716a3bb575e800a9b18ff131d55a99b6328a628522150a82d52a" +
			"b24b45de810086400284000981b04976c9beef3d3dff867480ece3ee66f7de0dd96fe6666f367777b" +
			"3ff7fce7ffef3ffff39172049922449922449a20a04121f12e0d17f3e65ca14ffe3debd7bf1815e75" +
			"f4432181494405f805cc84cb1f2a9d3bda9b3162060750420829a1842ba2408a994c0910aef08a575" +
			"16a633fbb09d09394b2472a1ea0a2a79ef388276e3df5c97eb3d92cc140e5a84ea22800ff0fde30fb" +
			"f96cf788f2f9c0f33398b06f034232201650da43a8f45f22f93670bddd66f7ca5f1d67cff62b44555" +
			"45300a594356ac2a5cd7921db612a7b8c6834b381e3bf0f4a20f9bee144ef879cc3bdc5bdf2f963a0" +
			"62cf504301fed6ae5bb0f40e9f463f1f08ff206be946500bc9f7117faeed77d3bb363731332582c28" +
			"a5052017d827fe2cf778a5ac322aa546b978bcfb38aef3cf9b267dd6f8f8282e6490905e06770ba47" +
			"5f29f519725f6766e601486444ef4ac171a1d6fdf7179bf1378833f15600bebf46787a590de534cfa" +
			"96a6a2284889edffbde79aa969d7aa1af47c4e773203ef85d49ed9c4563a5bceb57338f66120c4528" +
			"6de53b4eddeb59b718cd525c7a030ff1412b3cf9d75f48c6111f307fbd08862acc0da606e3a37ce57" +
			"da2b46fe32e88c3b8106b05b03913e8f8a797bd011afd42f6057430d421440fbc308bafba4723d56d" +
			"fa0662dc136266826a6a6ab8d776b4e7794aa6aea19c702b5c8b48be6de2f16d8fc097ef9d85188d0" +
			"bb1ea01dcf6cce9e37c8555eb997bf93db85661e694980aefd1144edab2e847b75b2d16cba04dd2a0" +
			"7b00b6fc3f1c10c78a79a59fb3ee3a74ed7d24f807e7e67b1756f0475e7ae9a541f584c1f6006e57f" +
			"af87c7154f97ad63aca60b8c00667c99039d3bc6fff7a3851df0b83189c39881e7c6daa77d44d1f53" +
			"c297c33083b0efcc97cefc989dea61100c46011ae189a5359417a6c370857d777ec15fde843e25446" +
			"5cea33141f8415ae1f1b75fa029e98b61b82368a69089773a68fdbf7740149e51340ae035773f3791" +
			"e696bc7b4df8f9318008da9b84ac311ba563db3b21c2f120521384ad3f551a33e5d3a114d7893b4c1" +
			"6e2e8f28fd8592a44688a225100292d2dd532bbbf64403a300913093f917bfc6d34c99a485e178909" +
			"e2ecd3e697d39ce215902420cc144d12b20a9829da751e649a2201e481dd2a45ca1ffb6b5099cc542" +
			"d1467a541668af68ae7ebcf58a1dbe1015561a6482aaa78253f3fff87ededed0e592f0179089a59cf" +
			"5449a5d37783c2a0c01faa28821937e44175d94828ce3604bd1615507fba0bd6d7b7c2fa03a7e0e48" +
			"58ba00ad6961f88ab6b36828cc09d1c05909c9c9cb4aed9b5cb4167980b0a8182ffe9ede3fd079e47" +
			"c3073b8e41eda67ae515e1f3ec10973d358b9d85fd60396380e09df270051d35f68fa010950559f0f" +
			"5cfee86872a8b40af893e5a52c5dee7f93bc6fbadb1a5a9031483e30bb8921b77d10633a635438e05" +
			"72be5d0ab9eb99d741d04e000540e16f66c21f999102b162e60d23955782a015e8be4d9f425f4a332" +
			"8e114c0265dcf96d3dc316f82029464a7c1b65fde17b5c909052a01c7889d2d9da008bc504025e72a" +
			"683fd603217a41b87980866617558342bc3bffd6b808bf9f25f7570ef09ee206f388b871773d5a525" +
			"212725e10ca0ded733d0d598f2851bbf2506521cc2ccb0b7b5d9fa763bdc29c541698fcf6be98f5a0" +
			"50f40fecb59fd58322a41aef6b696941ebe10a76495005545757f3dbc4a23249a3bf191460fe2da56" +
			"1afb11c3d0b73ffb605ba9d81cdea92fb2bd85115f23d663277163e03452028bb49d523e1a0d90e41" +
			"5cd2a026c86c36f3f4ba713340216696866efd2dcc95bcf3cdff04153e52bbe9807f0e10f273d858a" +
			"098196208150ffc04428427822ac06432e9a9c1742f284065615658dbffe48a6d2087b7b61c0e7b4d" +
			"a8c95caca13a03e64b82468d83298077bbdda92028637ec2b548b4fb725d48cbd1f0d729d90340a39" +
			"fca7ea24f1d70280d360610cf8ca72a80e3d2410170a68a33d660441ae3c1f70b37202b06caf0961f" +
			"8f81edff40ffd777f59f032a80b94e42abc1385aa9d2e996300a88948411fe25b8e28ae945ed3bea9" +
			"847344001014d10bb50005dfa904cb4a33b1b0e0cd8290aa729f6cb34d09f023c478c46a396e8d3c7" +
			"c110249c1b8aae6cb753d9b035cb1360ab404f68805109a8005114352456ebb31404275938290b054" +
			"64895866ab40510c4150da880dede5e41e285eb60088171240c358402c79a152a2880f0da7c884001" +
			"084f88321e502c40e1630435567389d84351cefdc715045300c762da89e54a04a15ff8e13c9fda8df" +
			"b950d475f0eaf61f170bfc7296f0c80f82ddc88297285bf627b330bc01d0095e1e43e496070258b8a" +
			"d09fb89123fc051f7e0b0900ca74400f08e49b129d4e477c90b8f40b3f9ccd4f20e10725504ba72c0" +
			"e2481cf7d0e1210343b6b9fa90e2b7cb4f909237c51c412f6808bc0032aa0ef629290bb8ca0ab2967" +
			"c04d009bff7f2815b13a2260e16e500550af5b25972134e1b26689267c3f5ed7d9949414f93d805d2" +
			"c119fbb0d120ccc1b846afd98aa4c38e103da126a733a9d38ac0ee80501bd1dffc55ee7194830c2c5" +
			"f16b372a94eb8d14970d177a07f46b8299200f75da4f43825192153a93a5da442b0cb4a7e30844a80" +
			"02f39be670f0c31948e72ca8574779e84be022d596300e2150f6d6eb9e43e25190c927851dcb1aa01" +
			"82f480602949bcb897d9ae7a30981266111e8692d508270f0aa70d07266cc8b24d1082a3b5136ce7e" +
			"b20c9a0a09dad5ba1af302ba2ba209a9999e91277aefe14920c0ae9441deeb2127431775005747777" +
			"bbb4175acf5047cf21481215d4693b0887cde88206f50e42d5867a3d1e4f0f676ddb0aa9190993a0c" +
			"718d0fca9d743494e1a64b07941fd29abbaab614271b6f973f613cb128396f385aa3c21191919993d" +
			"a9b937f30f2e5c0bbc900a2a132afe8f9330c58a6e65229a97cf319daddfd2d5d5859bca46648210d" +
			"ad3d3e384f6e65392fdfc76480042c5ff973c5029abba5a317a3abe64e6e730133e0ec051af0fc0ae" +
			"63256d873780ca3c36edfab051d070497945a9dbb09cfdc402a4902b64c229005d27bb64f9c0ec1f5" +
			"054049330e148988ab8eef62d62e3378d797979e8fd84dc3f424eea11bb502734ed5a0e496421ee5a" +
			"fb3e7be81c3f7ebc3bdcb5721480bdc0266dfbf06b6abfb0135462fd81d6b0d760d59beab0d6af69d" +
			"d87ae7bb7d96c0e9bd9959b7c77190c860e69e79a3f81e893b5023cd660d9b9a529b880b1823a9605" +
			"bed122ee5ef79e2008189675cab95e6ef909f57abd12584f7ba0b0620449cf566523d6adac85634e0" +
			"013339783156ff7bffd151c3967033591da9b56c2b7abd6f87cbe76f66b58f383445281cea7a5a565" +
			"bb5caeb1d2fcb756109da1045402f302fe55354c19fb59164cf16ae700509ffb9cb4ec69dc49a0911" +
			"d5690b9795324055894cd8cbd922401bd78ae852b9e7c37705c445bb3c40a5c2776a4c3e6177c87cd" +
			"056a4399599636bff373e86ac37c68c08518c188b400cbebff80a6dd75b4fdf02a48d2c719268be3b" +
			"bf14636287c6f242f8da60411bd221f3dfa6d0b14578e2206d3f0d9ae3200d2e9864fe8c6d796b2d3" +
			"16e88bfb4454ce138d02fc294b40451cb61c21136fbf8968f4b9300ca1bd5d87e99ac5b5ec14b3446" +
			"8f723de573ada225ca9b4b4d4e3703844a9ada1918efede54226833611841dd174f4a9b5e5f088e1e" +
			"5c178b55845125a4a3ae82b65aad1273b73c5aafc3e5eb6e3b418aaaa6135e506e01ae8a50affb3cb" +
			"1bcbf989e6e40bb8fe53b517b02832d43174d2693db77aed5e6eb3c7594144ca822826ec82d6d8a04" +
			"eab2b74ae67717d363bb719f502cddc10957d4659c8355006566c8278aa29b4dc17bb8f68683b4a8b" +
			"29c685372e01a8485621ac9176f2cd29c6bdec3be33b6fcb0c1b670c46221069d376f9eafa1a1c1a5" +
			"f5392ffaea36ed81fc1b528971c4905c65190ca9a3f90bee9f4b5e16ed5d0db1123e129395304cf87" +
			"ecf88fd63680b1d7074db119253c4312594a935598b1538c98296fdabe8c65797ea74ba2636ee9dad" +
			"a9a971582c9698dcc021d68be1fdfb4ab3239b1dc5505c35999bf5ec6f989b3a244d12da7b30bff71" +
			"a7ffae01e8d467392995b7435d1db8959e97ebc7623c0568f5b1be352d72232fbc505dc7513e6c010" +
			"015b3d6d6bfc824db03007826585687230d217d12c570ef15a8c27b171c1c34cd345bd5e7fd1f79de" +
			"53b7abea58e335d9709a91909bded31ed3ebb0fb62e7f95af5bbf81c5bd8ee5e4e49c612d1f67b871" +
			"59b5a5c88ddcd2d3d38d76bb1d33e64550583e819f36ef61c82999060904edb5364a0d96d5b0e75f7" +
			"8a7240c2777b0c9a6bdb9b939a626e76a94da10057b1a6e5a84fb08a022f2a170d2587eda237321a7" +
			"48b5da533435a4ab6dbf787cf766d8bb01058f191f9cd5a2b9c178fe90bf95e1155457570b870e1d4" +
			"ae9ececc4b0050eccb96ca02ee3c6dc3819464dba8d18b31509ec517be751da71bc8eee5df71558db" +
			"30d78982c748260a3e681d673c50eb7ec23848a3b794c65cbb4ce6bee6524ab368e1a4d1507c6325e" +
			"48f9d0cc6dc3212a36230bf2b8942ef6c6da47bd66e81ae76143866712eb0c39a979767c704ba9c1c" +
			"6eac51fb8eda988f4065a0a0b1a624e3b2230dc6cd2ce5b2478d24a682629a965d0cbc3615f4a959c" +
			"06b529972aed85a977a9ce82252703bacc465ef047650477787d4b4b3014e1dc49001b66e1c4c7123" +
			"559bd168ecb5d96c98dfee8becaa4442ddd21cfa6a5571ac4085a45c3af05c7fe91c1f5161976f7e8" +
			"1af95789e97584fc2168c87fbd2e1b874e0acd5c1e256aeaeae2e7cbeff0ea9c3f796e661e817aec0" +
			"dc400d1b33503968b250f802736d81e5a6f1eff83caeec170921227b0e85ea4f18419f90bd97cefb5" +
			"728c6edb6b4d192a80a0804b9ec80ab1e295c795ff8ab1f9324499224c940fe073e157356e34ab3af" +
			"0000000049454e44ae426082",
	},
	"room_config_basic_information": {
		size:   "16x16",
		width:  16,
		height: 16,
		encoded: "" +
			"89504e470d0a1a0a0000000d49484452000000860000008608060000001879f291000000097048597" +
			"300002e2300002e230178a53f760000087349444154789ced9d3d8cd44614805fa274145c052577d4" +
			"204807155b508e606b1a8e023a744b0755361212edd242c15e43bd2b4d09ca5241973b410d772534c" +
			"916d444eff28c7cfb66fc3b63cf8cdf2759916ce776177f7eef797e3cbffcf8f1030461935fd91e61" +
			"f0808821d8f8cdb23f4994525701608b7edba8e26f3ca20db4d62b76345192ac314880fcb60d0017d" +
			"889cd5803c0417ed35a1f74fd1b7d9384184aa9114500dc6eb013fc83b2ac685b68ad8f7af80e4e89" +
			"520ca514a683316d28c3597652bf1c02c03c6649a212432995c970971d0c1794644692fc1bcb970e5" +
			"e0c8a0ebb0030715827f4c19aa2c82c862812ac1824c484b6d052455bf601601ab220c18991b8109b" +
			"042b48506228a5a6031122cf9a6a90594835481062d0e3e63cf21aa22dc7785368ad17217c995ec5a" +
			"0b48151628f1d1c2e4b2cb6fb8e1ebd892151a29035c9d15bf4e8450caa25fe6007844df629bd741e" +
			"3d3a158352c7a2a766eb5839a4e8d1697f4c67ddeed4b1752452d4e60af6c128a576bbfcd04ec4a01" +
			"fb51ad863a84bf0dfed95526ad6d5077a4f2524c52b7640684a2775875731440a6f60dd31f22987b7" +
			"54a2949a8b14dec8ea8e2d5f1fe0450cca8531758dc78857399ca79258d2c7cd9b37e1f2e5cb70f1e" +
			"245d8d9d9f9b9fffbf7eff0e5cb1778fffe3d7cf8f001be7efdcafedfc0f092569c8a11831477eedc" +
			"81dbb76fc3993367d831136fdfbe85d7af5f872e8873399c89414ddc7fb103818091e1d1a347a7a24" +
			"355308abc7cf912debc7913eacf43f6b5d6ceda3a9c88418d57c1b653a014cf9e3dab1c256ccc66b3" +
			"d0e578aeb59eb0bd0d682d06153f07a17686b99222230239ee69ade76c6f4d5c3c952c42ee21c5f4e" +
			"14a0a6432999cc81630338ae0ad682506f59206dbf7818566939aa28c070f1e949cd12b98cee76d1f" +
			"631b8b41c566b05de71825f0e9c307972e5d3a79d40d982b3400aa318dc4201b5be7319f5cbf7edd6" +
			"90ad9c497740ed9a39bb7114d23c634f49157d7ae5d63fb62fafb8e689c526a8b4116063f46b38b02" +
			"31f0740274f3364a294d2246676302da70eedcb918be6617ec35794aa92586526a42858dd05154724" +
			"4ed9bb9b218b9a1fe021141075bc68dba85689d8831b41962a5601f4a44d4baa92b89a194da2631a2" +
			"e1d3a74fdebfeab76fdfd8be80a91535aa468ce8a2c5e7cf9fd93e97a01411a5928cca51a3548cdcf" +
			"b29a2c2774757e01d69362a478d2a1123cada022386af7482b5c572b964fb23a1d24d5e458ce8a245" +
			"c68b172fd83e17a01491159e79ee52cd5848a118f4ceab68271d63d4c061792ec1f1a0aeff660f94d" +
			"eec8562c41c2d32f022e2b84d17a0148f1f3f0ee057b5a6f4ba5a477051d1f90f3b10293886e2d6ad" +
			"5b8dbf7c2645c4296493df8b264a17458c31db1331586f3c7dfab451db03469d870f1fa6240594458" +
			"da2778927250682f3443e7efc7832a704b7a2d15d2801a6202c34236cafa8c2b8a8d1d2984a524b23" +
			"36ce9f3f7f2247be330c230a16adbe1bc802c19a4e6c11a3f1c89f98c048801b46928132a211fe0c5" +
			"b8d310831047bb920620c1beb087f2606d51732186720d8fa4e9818b4f88b301c8c62988a4fe38921" +
			"82837171fa615f3c79f2e4e4f137728c81c014314a3b5884a410310423174c734f4c62582b5521595" +
			"8d43089210c0f96254e89617b741192a7580c61b0948ac18a106110948ac18a1041c410860b1bd72b" +
			"620846440cc188a9af241a70f89d695211be62a968d89e504ed462e0f03bd370febe3bd7524052896" +
			"044c4108c881802d03aafa7103104308d14df14839d200c82a332317a5d4f5ce80d114330c2aefb29" +
			"316cd3d584e461d7dd547c1eb33d42ea94a612309d24a48dd69a5d7393182bb647489977a6df66128" +
			"3d923248df17a9bc49088312c8cd79b8941f98635910ac9c29e488c6210468b84e458db9a28448c61" +
			"63bdce3631166c8f9022d6eb6c1483ea8c437640488d7a6210d6302324c1a1d69af5915411238a45f" +
			"184c614ae9b6b1543d249f234138390a89126cba2340215c4584863579214460b289b57825629a550" +
			"8ebbec6000e0c422d3daa7a67d3eb07d0e4e840af895d3c75a6bebd34846a118c4345431f0c2f439b" +
			"1e8fefdfb6c1fd00a8ea689508150a93c281d254e45e83e3b20c4c8ba4a1aa9240651e98f09c1332b" +
			"2b3a6b89a1b55e49d4889e759da7cc3a138e645df7b8a91c2da08e18546b3c67078418c02711f76bb" +
			"be7984abb46945897b8b2514b0c0a45512dfe2f9cb472d61e46517b52b3d67a6e1b592c04c7bae98d" +
			"dc74b6fbaea49428989ae68c54a19118f461f2941236efb4d68d3b411bbf1f833e74c90e0821b02e5" +
			"a08af0a6d5fceb64bc3cfd90b44bb00d7480d7101fe26ab413b665ca7cdc2847141de3a28a5f035d3" +
			"7ff7fd2f21fce4cfba6d16265abf6a89e625dc6307843e58ba90025cbd838b1e61a555b45f0ecb16f" +
			"2af43eb54924729350f75ec46e260b1b9ddb6aec8e3faad7d131940dc3928c5c8a514e05a0cfa7223" +
			"91a33332298cf34fdbe0fc3d9f2247677893027cbd0056e4f08e5729c0e79b81450e6f7897027cbf3" +
			"23a27870c0b74c361175280ebc7d5229452d8b7b257708a50cca18fa70f1b9d8901ffcbb14b0352cf" +
			"b2834211fb5a6b678d5755e874f5016a2195baa33a584fdceb5a0ae863590aca8f2369422f056f9ea" +
			"b7433754ea7a964135a4b7ede57b77dc038e9216d43af0bd9d044a6ab123d7e82636977fa9602fa8e" +
			"1879685c0716a637d8c1f439a6f199c14c050d468c0ca5d4980419427ac9a60dd69a25d605c189914" +
			"18fb6d344050956888c60c5c8a002759a488a39a6dfb20855888ce0c5c8504a6dd3788f71845104bb" +
			"04e6546c47413462e4a13a24db426d455dd23bcc828f0e26a214230fa59a31359a5d612774c731bd3" +
			"4176558c528439ee8c5c8a394daa27691116ddb1ed3ce3b9a5373402224b500505262d8a036922d92" +
			"056a48934dde5ee5fe7b949a0426062186501f59db5d3022620846440c810300ff01533038247449f" +
			"d430000000049454e44ae426082",
	},
	"room_config_basic_information_dark": {
		size:   "16x16",
		width:  16,
		height: 16,
		encoded: "" +
			"89504e470d0a1a0a0000000d49484452000000860000008608060000001879f291000000097048597" +
			"300002e2300002e230178a53f760000074849444154789ced9de171e3361046d799fb6fa602fb2a88" +
			"ae02d315441d9cae827307913b902b885441e40a625710ab82b32a88598133f42d67140120011200b" +
			"1c0f766343743697ca2f8b80b800be0e2fdfd9d0038e717e508281e8218c0c427c3f15c591051c5e7" +
			"565b9ee32bbf5a9e9477332557311667af6b22ba523e358e86885e34afacc8a5f1599fbc6e9477c3d" +
			"37034695ffb93082316a962b4e960c9af56864be513f37220a2ad6449a489d1c9f05579275d5a4936" +
			"2cc99b942f2d418c363aac88e8ce633b610e1a8e221b09512465312a96e12ec15431951d11ad53162" +
			"445317216e29c6405494d8c7521429cd2707ad9a4d40649458c9af3afe436c4548e7c53ec53f83273" +
			"0f89577ca7fc5db814c4e7ff178b5129ef4666ce88812861a6e19ed86cd163ae88b14694e8e592a3c" +
			"776aee8113b62547c17cc316c2d9503478fa8cf6362468c0577cb20851bbff1339855ccff3496182b" +
			"3eb992baa13e697fb73fb9a11e8518a964c52705fcb0e36e6dd0318fd062408a301cb857174c8e90a" +
			"9640b2982d1b53b82f5584289b111f6685c2241e508914aa4a48faeeaeae5ac96b32d035c70dd8784" +
			"71962069c5b71812a438f2009b4de14ccd9f4dbd8bed5d0e9f62d43c9a99320f7ca15d7fc025b7995" +
			"2ee6eef7c8e75f8126321609ce21b5fdcb14838c707eeca4ec6871815e7e994f3f154293a4ab8013e" +
			"f0d12bd9272ec5832729886f80a572342d362cf024a68a917ac3ac6b68fae489f379aa5cfa782a3b2" +
			"59548686cfa4a21e7b45dda1fcad1b498d4de182b8684764513b896612b6010ef76ec7cdbb1a9642d" +
			"60f02774f55312b599038c4e2963c46853c877e5687a842e6c9130f3fd6a6c1b6b4c2a79e171fad41" +
			"91d461d9032bff38beb8de21a31ee8448118ba390efe95ce0e3224615a0eb271d29c5cc370e0bc57c" +
			"e02286b41962b3cfcd480ca79bda568c6b5f63f011993cfa3740e8bfef1ba7a8612b86c4f9a4a187a" +
			"e9d42732258470d9b5e49c565ff122bbc3f079c49fe2a74c294556fcd2662489e7d1eaab1bc123c8b" +
			"ceaa66c3266248bd333a7c8f6748781c30c460241d8a1852ea1efbf03dff7393c16f32183586c4883" +
			"a2d2e10571eaba9253c38b3619218ed0ff9bb7254265da9fdd82e66959114c4374bef6fd12746ea95" +
			"4aae7472b836486b6e53e4364fa6376af4353ef719458c738e7c7e5bc3c3a56b1622e76743473e4f2" +
			"d2631dad0f9af72345f9e4fceac0db1a5ccca373e75352d322f71546f0aa5aed9519bc430b5314a13" +
			"a3548ced48532a91528c03a673a1fb0bba8851418aa2d066079d18bdfd5b901d5a31748d4fed0713e" +
			"676c6af96fabc1a1bb481402786b16f9b28c5ec531608ad18ba54224d0c308d2bdd73249d185887b3" +
			"3c94a8a1130394879225cec5c0c056990c8a0120c607e762288d1050048362288d10003140b92835a" +
			"c1003688118408b6e485c1aa61a4ed37160410e62fca11cf909c498005209d00231801688018897be" +
			"fc1f100390ae52fc5c0ce503a0089499efe76204dd990f240bc4005a94eb8e54024877dd758d4f298" +
			"b9a027f0ca612d27d08648f72cd7562a01cbf2c9e7567ab1343b107648df67aebc440c4280bedf5d6" +
			"89f1aa1b2205d9a2f4484c6290c922901d0dc4003a8cd7d9248684fdbec0748cd7d9b4a20e65b0aa8" +
			"e76a518cf187f3c21fcaa1b0ea79e88417d610664c1c124c59018cefb680151f46e54dc974a48783a" +
			"412ae9c7984668206210a246b63cf649411662ec31d89525bd69842cc478ebebd200911c6daea94d3" +
			"170ea13772e0caf39ffef7be593e960d53cb011a37d76b2538e0289343669c4560cb2fd63207936b6" +
			"75bdb6623c216a88a771e965ba4c38c22461d958470b7214a36d6b3c284781048ea1f676ef58635c4" +
			"324cefbf2bb8af12670f3ffd2791c3316356652f3d654590c92a3197b238f9dedbe424a11c1da5405" +
			"3ec458315ed14b499ee7290f41a7ac8fb1e1fc05d2a3e9db08cf86a17a8c212aaed95016108d488ae" +
			"d9deb997f93dba9157853c5205e66fa1fe528988b7b1f69dec7524b6dc4f8a61c0573f0e8abede76b" +
			"0dae2d464567e730b491bf0b3e52c929ad205f95a320340db76bbcad88e47bd5be3b3617c4a3e19da" +
			"9bc2e93e55b8c37fe9290230e4ddfc6fd5308b1ce27e48843302928e002b090232c41a5a0c02b0343" +
			"8e30049782222c19ddc981b2403f1c62484101baab7db4cf56bef7bc0ffa3984e87d9888b9c8fc1d8" +
			"f90e271bd3b3b7ef4106de5e6d8bb0f6cd1ee70a2e19bc9db88a62d736c4bf1c2726008bd9f034789" +
			"59e6f4ccb55f49573b7a8b25aab5dcb314b3adb93af746364ffc03207afca4ad2df99c42755c0a3b1" +
			"c75d1e34bc145c6476e4bd4a9accc1cb3bb6acb92bbb6735640c5a29b36e8344b2c06298ad1b1e290" +
			"9aa320c90ad191b2181d350b72a3bc238f6eaae03ef5dda42488d171cd6d91a5c028b2e36ea798253" +
			"2258971caf2e475a9bc9b06ddd4c0e4a3830ea9629c52b324f5cc4b4f1e3922ecf95fd11b0fe620c6" +
			"29158f8bd4fc0a39bfe39947715f5884ac3600ca4d0c130b96a6e6f76da5e9c6559e4efe7d2d6117a" +
			"852c4008e606f77a00562002d1003a810d17fd32cc911fdd56d0b0000000049454e44ae426082",
	},
	"room_config_access": {
		size:   "16x16",
		width:  16,
		height: 16,
		encoded: "" +
			"89504e470d0a1a0a0000000d49484452000000860000008608060000001879f291000000097048597" +
			"300002e2300002e230178a53f760000079f49444154789ced9d3b4f1c491080eb4e97818423080f13" +
			"83e032888c05614bf00f5827a436399239098910720270420cd28420ad23c88ce51ce31047dec031a" +
			"7baabd1ade99e61a65fd3d5539fb4d269067c3bbb1fd5afeaeadf1e1f1f41109ef2bb7645e83d2062" +
			"0855881882913f4c17534329350b004b63af17156ff10700dc96afa228eeb59f101a916ce75329b50" +
			"900f85a05803fb51f68c667001802c09148d28ea4c4a0c8f00e00060030a5fd801b1f01e0b4288ad3" +
			"d8cfc59124c42021f600604bbbe99f6f285f5114e7b19f93139d8aa1947a4142bcd56e860723c8409" +
			"a18339d8d4aa80f71db9114c82b00f8aa94dad3ee08dd440ca514f6230eb51bdd21d1e309d1c5504a" +
			"9d46ea4bb4658423a0a228308af59ea84d49c252008d82864a299c27e93dd1c4485c8a12918308de9" +
			"4d0c803a5d8d06ea6cb676a567e307acf5e092a064981338f8bdacdf4e9b51cc19a12e65200bdef21" +
			"3d47ef082246065294f4560eef6250c7ed3603294af0398eb4ab99e3b58f41520c032c80a5c087a22" +
			"806193e97116f11237329902d1a72f7022f62f4408a92dec8e12c86520ac3eba71e4851b245cf9c35" +
			"4e62d00774a2ddc89f93dce5b016a3c75294642d879518b46cde67294a4e28af243b5a0f57992c86c" +
			"524cbe5fa561183b29d448a5fc97245b671c4a007ffa4dd104ab28a1c8dc4a0b5825b87fd1d7d01e5" +
			"58ca2145b0e94eb4bdd8524c4c4cc0caca0a2c2f2fc3e4e4e42ff7aeafafe1e6e6061e1e1eb4dfeb1" +
			"86c56ce9552ec97eb9f8d18b19b1014626363e3df17fe771d57575770767696a220ec73399a8831a4" +
			"54fbe0cccdcdc1cece0ebc7cf9b2f1ffeae7cf9fb0bfbf0f5fbe7cd1ee750c6b396a4725181263493" +
			"1333303070707ada4008a30f87b0b0b0bdabd8e59a4269825b562c47c308c14cf351d75eceeee3afd" +
			"7e2006b4fd921d9562d003458916ebebeb303f3faf5d6f034ab1bdbd1de3edb6618a6bd4a81483769" +
			"d47013b9a3e585b5b4b316a6c718c1a7562445903c0be45db7e451d38c44d107651c32806191e65de" +
			"c2a71440239b046117358c62c48a1610e08b4c540c88f999faa04a8cde6fd10b00abdc8d2a31a285b" +
			"defdfbf6bd75c487016b46491d3fe942a31a20c5391bbbb3bed5a4aff9e6756537e73e35489110dfc" +
			"22715adb17b8b896306c9a684d8c2e124e2e2e2eb46b36e0a25ac24d09b016a3a6b86a30500cd7a88" +
			"1bf8f2bad89c3be8f1115fc520f0fdd4a721d1f1fa71e2d58914c2d71ec1b1c1dd9ed1dc626e4f2f2" +
			"52bb2ed863cae0ea2c6711bf5cfcabc795d6e9e969edfe5330d260a41029fc634cd4514ae91723832" +
			"baeb8b8669a324721304a60df8459f3f1b1280a16435653c4002aabdc69e22f46017ce16ae9f83437" +
			"4a91f85c451d6c32c8abc4b84f25231c4548306dcf1636d9e3559dcfa17645f0019bcf55c488c788d" +
			"36624a31845518818fe61750c86510cc2cf3cb550928d187212903fbe713b38a7520c7a906fda0dc1" +
			"0676e5202bc520246ab833e2f8393e27c6113d9860cf1ec76d8ab562d003c9d150f660df826555e15" +
			"a31e03f398e6883aed01eb6bbdd9b2ebbf7a654b26716a9901d3b1a894133763bda0da109871ccb3e" +
			"1a97ddab908a7d4ebce1744a74db0cae77d2dfb08655c1589b3a9fb91c52d3157f71584c6b9df3494" +
			"3d855891cd6b0a8096a950c4c720c64f2cb0a160563adb3c4291cae8a1c56242f87f3d1573d3ac426" +
			"04f847359be294b9f3be92b1c821b4672ad5531abd6c382239de68378426247984a7b79d683479237" +
			"2d8919c1c5eb7288a1c4e2ca694fee77def2ac921eb2a76bc4ae594c66087fecbba8a139d1ffe1b6c" +
			"b73b3dd807ed86d084cecf770d5a0641e470628b8e1aeb84604dc938d2ac38d1c9727dacc229b25c6" +
			"f4f27cbf551c490155967a2cb11a52929915c0e675ec7da571cb50697440e67ce63adc8462fce2672" +
			"38116db9be93aa7d22871351e488dac730a194c20d4d6f0db7847a82e672745ee7b3280a1ccabe969" +
			"df5ad099acbd179c418878664be4f851ed1e6ec21956cdecb6c5414e47cd7a4c4282141f044209753" +
			"f43e53f981d3f10f2dd321b377399214a384bec44daadabff4cc392a1fa95c227ee9c3ba83f7e9dfb" +
			"d4da564a527bc16974d5a8c90649ac4ec6db93e9922f3b1c974fb83b7e5fade8a0122472dbd1603f2" +
			"ddfee09ccbd17b3120dfed0fef5d5664450c22d30c77ebe57a11630c91e37f448c2764bafd01e5687" +
			"584786fe7319e4329b54a29892eb3af2931a2d9d146455b440c4ba8d7ff9ed9db6e2c873425fda271" +
			"2e8788d13f4a3966eb9e5cc4e82753943f5a99cb2162d853fb17c780c5ba5311440c7bb88b816c54f" +
			"537440c7b2af33d98619cdf1031ec617322e23318239f8861cf6926cbf5c6744011c392b1bd31dcb3" +
			"db8d62541de12d34006710a9f3b64921f905e5a68e33cb31b754c470842247e5b08fe9d4b93425821" +
			"911233cc65e7fea8818e111310496180bb18818821111233c2ca7ce458cf0184375ea881881a1e462" +
			"769583448c38e0d4f9df9cd656241938329452671ac20e3aaa9e6c2c112953e291a1ba1d5a8794b62" +
			"b24833425e9608a22c131450b10319222a9195211433022620846440cc18888910eda482502956989" +
			"22463a54668105c438220111231d68d818b368cb88aa241b9199cfc4a099d181a1609ccfa4626c420" +
			"65573182062e4438399d355eac7dcd709512262083a00f00fb75adf42fb0867450000000049454e44" +
			"ae426082",
	},
	"room_config_access_dark": {
		size:   "16x16",
		width:  16,
		height: 16,
		encoded: "" +
			"89504e470d0a1a0a0000000d49484452000000860000008608060000001879f291000000097048597" +
			"300002e2300002e230178a53f760000069e49444154789ced9ded91db361086d719ff3f7570740556" +
			"2af0b982532a905c41920a72a9c0e70a2c5510b902cb1558aa205205912ab80c27cb092d101409e26" +
			"317789f991bcf8033f7413f5a828bc5e2d5cbcb0b0170cd4fc608281e8218c006c4009dbcee1a1448" +
			"4544f3d6d7ace757dc11d19ebf8ec6553008c993cf5a8015112d88e8deb83a8c13116d8968cda2808" +
			"14813a36219561364b07120a2679604dc408a18b5104f44b434aef8e7c43f0b82f420418cfa3fe937" +
			"22ba33ae84e5c091098f980e528af1c09f5adf8f8cb17c6231418b5462d49fd4cfc6683a103dae482" +
			"1863429dafcc26f31c5133bc1f524580ae2475bfd9a5c3c3123c63ad25bc7542e3cff29fab1122b62" +
			"689182f8ed68577ae48811313449d1e6c2721499560f193166fcc9d3280571e4d8de5897c9965011a" +
			"391e2ad71451f079e739c4b122344c4c8490ae2bf63575ae4f01d317293a2cda1a409a9cf88d14cd4" +
			"729482f8ef2a66e1cd9718738e14b117c262b32c450e1f629422454311724c15e3a130291a965cf49" +
			"32d53c4a817c3be162845c3af7c0fb2c4550cc92ba431f99cab1c2e62408a1fc9528eb1790c486127" +
			"ab5a8e316254bc145dea9ce216592dd78f7994ac21452f592dd70f8d1875b1ec4763343c97d6ceb28" +
			"6197f32a56658b3881c43c448f10819b2f7a3e25cc2a371253dea6b39863c4a9e224bb1e19bda2705" +
			"f14d5ff0a4ef625c4d8bfa5a8e5b11a3fe54fe6d8c8663e3f8ea27352dff85e555c7ad88f1648c84e" +
			"3db847cc05e682ee151eb64b42f62d461f01f63341c6f3c3c9325d6977ee3c9a82afa2246cc10b8f1" +
			"34518b19e186f22e37316286665f19c323575a4943a2b0bdd8c498b1e9b1d879fc393ebf972fde699" +
			"b6bd8c4881dfa7c56604bade656b5d0661303fb37fda3eab5d52686bac9520ba949a57b4d1f389b18" +
			"b16fae4f11254bade603671323f60295af305b09dfbea03e62c466e5294a497f2dac8c11a14811e3c" +
			"e431facb9820dd46ac4b0a5c43b0723f0de310f31e3f592d48dde86f04afeaf28af97f8d661bed1ec" +
			"97d520851aa489513f52fee2029c21738ea6522ad7fdb2c9b03d4ace026a1b2e1c41b61c119a8c66c" +
			"542ac22a7ed7da066a5d526c64ee14dd7801a316c8f1234420d83c405be4e20465cd4dc578811972c" +
			"22c6c918055338686af0661383d053db3baafa69d8de4a8853ccdf8d51e0c2855fb3b388187ba1f59" +
			"31a596beb13da2706e5de4e2812178df7f196186b4c4227f3ac710f6bdf1ca361c1eb17603ceae616" +
			"0d4316d1b69cca05e3396bed413e747575257047b906eeb5f6041d2ac611270d3aa3b261ecd8564b9" +
			"f8c513084a5b60d472ea70f683db148021fb4440f1731723e7a22062ae47029ed3b73b109b2a26ea8" +
			"68183be5201b448e69fc2cb9bc614a3170133990197543744fd0a955e267ce8c22c7311ed10d637d6" +
			"c1fd873e4801ce3112b87cfc3f24a3be9c82727be7f62d2e73e371ced95f7d548c9bdb4233c7def44" +
			"dbf37b3a188fa8f35d436c515c430e67c4c8116aef2ae47047c4f9ae213735d77fdcefc62818c2636" +
			"a39421dfadf068b6eeeb836dd9f4c8c36082bfe03c17892d572c4ea8f0139dc59a628928af12869b3" +
			"157a229106a22ed7c716032bb2d3882647ec564ba8e59846b45a8ed811a30191631ac16b395235676" +
			"b22c717e30a1842f015d9945dfb9a5a0e24c1c6137cb95e423bc7670e8dd8ed368ea07248e9f3d92c" +
			"d97f08542ab8e1aec3ef331330d8f9aea9269fb758f0ec7b4acee3c4af76ebabdde6394e7c0ffcc1f" +
			"256e823558c86e61cf7070e99f39e0ab1030bb0eb380fbeebfb428e1ea48b1112c8d183b45ee231c9" +
			"71fb83b75a8e92c5a04cb73f78a9e5285d0cca74fbc3e4e57a88f11f90e30a88f13f7b6d67a30e60e" +
			"97a4e1cc4f8915d8645cc7fb8acc8420c931c2bdc472fd7438c6ed6bc7eb3c968de314a8e92135c53" +
			"a927ab5f15fede834eaa44c4288fed90155988e18ed60ddc8396eb2146993472584f8e8618e572d77" +
			"75811c4289bb7b6a41ec40010c3337d85409ae89c67400c77b6396f9c8218d358e52ac76b63048c61" +
			"cff98005ff3bebc80fcc34960f420c3f6c7b5efda41f1dd63957c2a3243cbd19460174160e430cd00" +
			"9c4009d408cf074e609a40331c223a60df4182046783a67fdd28118e1b9592d9598cee3c521467876" +
			"c25b59428c84d4a9f33f351516a318383e95e54da54e847d3446c3d3591c8c94787c8e96f02d2a438" +
			"a47891c44bdd6420c39400cd0091e2540149d09388801b0ec2e1ce395312510430e294e32b2f67287" +
			"18723826e8cbf16c8c30c87ccaa3e214faf5a6e98a4f74f6c1858fd3b2462988910ff31bb9908756d" +
			"6f5e67c0662001322fa17c1929d058c2298880000000049454e44ae426082",
	},
	"room_config_permissions": {
		size:   "16x16",
		width:  16,
		height: 16,
		encoded: "" +
			"89504e470d0a1a0a0000000d49484452000000860000008608060000001879f291000000097048597" +
			"300002e2300002e230178a53f760000062b49444154789ced9d51521b391086b55b793737801be01b" +
			"c0be7715dc00e70421278873829813606ee054e97de1040b3780132c9c802d85f6d694d58e67a491a" +
			"625fd5f15952a8d6370f8d37f4f4bd3fdc7fbfbbb0160974fde4a0310d18931e6da1833e74ffb6c8c" +
			"595b6befa1900f9a8a182c88a531e6cabbf8c183bb0e8134240c2272d1c1fdc267de459fefd6daa5b" +
			"7da104d0883888e8c318fc69863efe27ebe5a6b577baf56ce9f8d7ccecb81a2702c59504dd24af2b9" +
			"f0560e336341ad0fbd9288dcebce3bc9acb3acfb927395568471e6adf463febb5771deb211a291fb7" +
			"edf88e8c589b24481546f254474ee2df667af3088c845a17f04517471d7fee6d716452b39c6a870a4" +
			"b81df09eb79102cd0e841146c8ddcac15c451345e4185c985a70683fe24aa5bbfddc586b9fbdbf90f" +
			"6679907e62cc7eeef5a6b1fbd2b0a512d0cbe5d5c0995ca335efb4144375cad7cf5de200d319670ce" +
			"82568f5a2b6151dc0ba2d8e58b7b5dc69a43ccf729a62ea239c770b781a7deaacc69691eae1d95c2e" +
			"0dbbba13e7ec1fe0f46406bc4b8f456fa515cbd402b5a8571e1adf4a3a85a81666aab63f4cd49c001" +
			"50e0022210061069f2cca7663a55de6ebef4ccdbf8d96ec9210c4510d18a0b76bbfcaaf412d132d73" +
			"63eac440944b4de238a2ed9b6f1210c0570243854faefb262cb4906843131bcc7733df0a798f16310" +
			"c98030a6e7b2e7230dbb8456877b01614c4f68b57696d24e208ce989f9e54218202f1006108130800" +
			"8840144200c200261001108038840184004c2002210061081308008840144200c2002610011080388" +
			"40184004c2002210061081308008840144200c200261001108038840184004c20022100610694118e" +
			"8fd194075c2109ac0c63cdf2989aa89969135468cff6799b14862bacfccb8d38d31e11d8b8ba4c61e" +
			"5cae79ecbf44f43452dfcf2b9e79f67a609a5155d4dc9c6dcc66b0b3c0e626c582bb92bc24ed9b352" +
			"610465ea464565a9b9c602be1046fc1bda0e61c6a5fb6cd4a79887ed6b15405704a44d7db09d09cd8" +
			"aab4a8a011de9c9daf7a7ca83bd7916ee8582a22aa7daef81bff192b8abf5235831d6c25dcbdf6b6e" +
			"78772bd2b9f85da42eba84f6607098323c5a1eeb5bbcc786619c45110bd85d19968188213c7a6e521" +
			"faa53124625c4786bf630cb42b8721c218a313ed458973ce5b648830c6aa24ae906fe8678a02d70c9" +
			"6a29fa92a9fa77cdb0b94326549fc0bef5a02850c11c683b712cf1ab7b03a19228c8db712cf2cd1fb" +
			"8248860863dda9f18fc9198f7e028ae82d0cde084b95307e23228cdf56c4d0e473c55beb2940bea18" +
			"841c2e0a891aa728992b92206dfaef2feff8d77611c5cc97ce844419080d03ac632a1a5fcf0564076" +
			"828491d8528002822b9f892d054c4c6c493ca5a580098912062ca55ea237d160297532d6ee2a2ca53" +
			"24611062ca53e463b8fc196f2d3bb008a64ec833a8b443bb02033a30a0396520fa31fedb3d66e6029" +
			"e593eacc272ca57092080396523ec94e89c352ca26f5e303b09442492a0c584ab9247fe008965226b" +
			"99e4483a5a421598fb32cc2604bc159ce9149d9fc2edbb3abd6da75a2c71c5b256904cefd50332c65" +
			"3c1e53be79566170e8c3e388e390b4876af63608dcfc1496124f3d11a3032c259e248d5fb74c220c5" +
			"84a346fd6da2a23062c258ea4d1c228983e004b092379b3994985014b09a66e6118584a083f874e73" +
			"0841cb201b584a7fb2f41051210c584a6f5e78b73a396a465fc1527a91ed3f8fb69968b094fdbcf04" +
			"664165409832d0527be64b21e5b503745913df4bb77a16d1e72e5165b548ed7b4d62e79d01ef8b0d6" +
			"ec5154eddc556bed02c9e82f16538c29d53e90d74d2778f256dbe126b7856c512d0caef09d376a2b7" +
			"7d6dac9cec9060de49d029e6a7c55c40f1bcf1d5be9641433db9dffa13e3750e7985c14a6b4a1ff5c" +
			"e039af38eff8aa4114a6242bd985679cc4ce82d5c20bdf7d243f80d397a2224617ae75cc2b484c5d2" +
			"bccb926519892234617223ae10da69292d387a96a147da842185b5820d75c29d46a312ec2adb54588" +
			"5daa1246171eddb9fd9a5a244f7cc066a33542ec52ad30baf0bcb5edd73c8350def824f77d4962e8d" +
			"284307661cb3961a11cb1588e02e7d7bb68f0ca227002784cfdcc470e9a14c6213ac2d9c76b0dbffc" +
			"df0161009162eb18202d1006f031c6fc0776ffcb3e9743f0150000000049454e44ae426082",
	},
	"room_config_permissions_dark": {
		size:   "16x16",
		width:  16,
		height: 16,
		encoded: "" +
			"89504e470d0a1a0a0000000d49484452000000860000008608060000001879f291000000097048597" +
			"300002e2300002e230178a53f76000005e849444154789ceddded71db381006e04de6fe9b1d581d98" +
			"a9c0eac0eac072054e07912b88af82301d381558ae207605b12a38a9026538b3b8a1095002497c2c8" +
			"0f799f1dc847272b1fd06bb0421e0d3f1782480becfda15281e211830a4a460ac88684b44c7cec79e" +
			"881a225a689f5db8127a8c8a889e88e85a7be5a30722da68570b957b302a1e25aeb457cc7e12d1daf" +
			"84a61722f255f4784a275cbbfa778b98f18ef4474a95d3d6d37b2e758f047dbafbc6aaf262ae711a3" +
			"9e100ae2df536b573faab81f6983f787889e89e8774ecd6ccec1586a57ec9dfac1d63c327c3304ef8" +
			"2cbd19fd41bd99c83516957ec0d8d183537b33623511b9c47ed6a2230c1354ec3a382adfb99235734" +
			"a9046329e01bbc1a7987a3247997233918cbce4ce5337f1cb9bec7f866afb42b766e42ff455d901a8" +
			"c8683609aad6cffd57ee7800cf5023e9c6a48cf49ae9c480c46c39dfd39573ca2cc69326180b460ac" +
			"2d43a15ca4dcf94b262d1853eefd6ff174d43d49c1983a5349331a4318202918737a058c188ee5128" +
			"c9077274590564a40887ff08310a5eafd0379e527b6c1e159890c6a96f7bfce2cef33fffa29c60419" +
			"8211dfe6c42c2ff194fa73e8c7f808465c6b7e3c6fe35bc8674408463c8b09b3b69b50b7e608463c5" +
			"f47aeed20fefc20937908463c531b4a0423735316fd50a8f91e04233d63cbcf240806182118608460" +
			"801182014608061821186084608011820146080618211860846080118201460806182118608460801" +
			"18201460806182118608460801182014608061821186084608011820146080618e57e5e894b456d34" +
			"8b6329ec4d7daf69927209c6756fdf88fe5e5663f50fcc4bf268893972da9ceda9b311c994bd27ba2" +
			"e794fac470e5c71c76ee6148c76a8ffa15d9deefac4be58d9c35d0918211861f41b61f13dcbd452a2" +
			"9a3bf5056e733b77d4b135f7404a76c1508d58ff4c11b525e18e0fa2798cb5a3ad50371c8c8643712" +
			"ffd2f3ce6a4e635ffc06dbafd1d7ffe567b65d866c49e97a5fbe4fbebb7ed3196dcf1dbde025ef26e" +
			"b638403f5136c1a87af5718c1f3855204d36c1b02d1f4370a05d826c823177c3d10b6eba2021e782b" +
			"174b4afe44daa271697ea5c305cf607dfd16fa4e35c305cf7060dfa8d349c0b86eb99cc2b1ca09b86" +
			"73c178d7aecc778b7352e5b319310edad5f91a9c952a9bcdedead4c9ad532e3cfdb9e0884d307cad5" +
			"e42bf21984d30da3ee341bbeac67d89eb295360fb10ad1d35deb4ab6e3ce116569e312bb87ccd5ca2" +
			"df1068cc7a0ce29ec0d7229343a8639d32e07d3dc6d860547c0b7ba9bd02218959a8a3ecb1f8a60c5" +
			"35689b7eb2bfed5ae4256c696120525252e71a5444149c9dc9c371ca1a4646c6a29515052e2105b4a" +
			"1494944cb978ef2a4a4a86e69612a5e2876d98b90c437c2951505232e3721b84f641d82fed2a24c95" +
			"529515052c248a69428282999f0b1a30e4a4a065c97120525c5afe44a89829292389f9bb3a1a4f8e1" +
			"6beded07be77ed5b7b7ac352c982ec6de63b182829890ab1cf274a8a5b6336bc9b2cd406b02829ee6" +
			"4514a947d891bb57b1264935d5ff31843b6256fdcee88f7390c8ab097384aca3c2fa1fe47a183f18e" +
			"92324b90c6932294120525659a2fb9f618ca82bf403c4bb17708b92b40acf34a5052c60bba896eac1" +
			"1434149b117ac8c9080138e709762e725f42141b18381926227f85eecb14b898292326c1763eb4b29" +
			"87e5ad50520645d99c5f4a30f6d82dd8e825d6fe64928ed76ccbc99d76b55c87986b59a49dbbdae07" +
			"db0ffdb78dacbdd8a94e6b3af311ce159929fb157be490d06151c8e37de2d39eab9b5928ff05e7bdc" +
			"aa5a2a11a120e1238632e620e0948909052572e8bf3af63ac8fb29227991140a4a2418c4cf099699d" +
			"eb13c480b0525524afa6a2e2da94fa14f39ff3e9854468c2e357adcf1373735071e256aa9a1a04447" +
			"8cbe357f481f410e3cbd1d75e2ca560ec1506a7ee0b4127607b3e3d2d748eb234ec929185d4b0ec89" +
			"2cf5e0b6dc7a343137a818d2bb906a3abe280d4fcdf85879d8cdf38005bfe105f2ace292118436a0e" +
			"4ddd597d7deee0be7d670478e55f8b6d20e728391870428ab7abe01b11fd051f1d2c8d6d6a0415000" +
			"0000049454e44ae426082",
	},
	"room_config_positions": {
		size:   "16x16",
		width:  16,
		height: 16,
		encoded: "" +
			"89504e470d0a1a0a0000000d49484452000000860000008608060000001879f291000000097048597" +
			"300002e2300002e230178a53f760000068249444154789ced9ddb6d233714869920ef76077107562a" +
			"58edb309581dd8a920eac0de0ee40ad6eec00bf03d7607eb0ee40e762a70c0c5513211297b4643f25" +
			"ce6ff80799931b01aeda743f2f0727e797b7b7300ecf36b7207cc1e0731c0212006c8023140168801" +
			"b2fc96bb6909effda9736e41aff42384f01d2a7c8c99e1aaf7fecc39b7240976d749f287fff1e29cd" +
			"b3ae7a2288f10e6ffa81683a2c1355de7c91f8ca38b8238e7ee43084faddf451a2ac5a0e870eb9cbb" +
			"4a1e962146934d08e1bef5bb494195181421361585d8e73546a3394610356278ef5731cc7fd06fa8c" +
			"53712e407c3bfcd82783118a2c42162f458cda5932a5a0c92e2a940c7b2247fb6ea7b78efe3bb7f4a" +
			"1ea47c0921dc2677272036c1e5bd5f089422f2d57b7f9ddc3586483128523c0a9462877939c489d16" +
			"b3e7e4f1ecac2b41c1223c6bde048b1cf869a3c738812c37bbf76ce5d260fe41287cef714e54c2146" +
			"8c5e36531b31baad157eee77911431b8925725b821b1cd20420ceffd72e0785d32a6e655a4440c8d4" +
			"dc83e9f487013b08b61245aec30337c9510312ce502aeac8c502488b14aeee8c684e8ac62d054bad6" +
			"91c8214c88ce1d31cc74d67a98e82fb14ebb7befbf2b4a7f8fe1f36ed5d788a9732eb253f6dc11c3a" +
			"214ce42246413c3eae413a13e0bca1931cc4d3cf5801813b02c867a38c5b0dc94a8079b9aeb80a604" +
			"64d9e66e6a82530c6c22160ca718b3d9d5a511cef331d487db77e847c3f58411d8666012f061c242a" +
			"1ecff039b182184adf73eb96f846def3d8f6e32bdf743a3eab6f4c66beecee77372c706eafb4fdc62" +
			"98ec805a3836815b8cc7e48e7ebe5978095631e897d5250f7463427609092e4bcbee3b88518e8d80c" +
			"f508a472ba7eeb08b1187ad864627c94a28ad48992bb1b0f7f38124378108312809f4903cd0436729" +
			"5a3861b3ab6bc523945b4bd1c24912833a6d1a37eb3c87102c75a07f226a3d4608210ef5ee920772e" +
			"90ceea4fb89b8853a2184b592514a946269f55058a9652956428f72ecb36e7018ecd029fbe2fd1bb1" +
			"07c00a3dfc7547b34360b910bbe69342f452d8a4546c3efe984355021587cc7bef638ee02679d0961" +
			"73a4bdcf2cab37fd1547d6049136e1c07c36637fe5a4663bd92355d2dced5786ed4c91487d60a47b5" +
			"0579a66ce66c4b6059a889b6a26bea89c2afb4962296bc9a453fe23d2c55513ced55515cd236c143f" +
			"d918ed69b6e6948fc0419f6886248bc2e2e2ece047fb6d3dc7d4b97b888d1ab55b2a03a64a296caf5" +
			"126fa7960be989128386a48f7b1d4a3159c603d9d83beaa89a9a3391547d20e609fece8c3262c118f" +
			"6696d3a1a6a9b49d1ff1565b17674147bc4e8351d1f9d6cc796791c9879ed28e761225dce7d9ce3ae" +
			"20de985cc4171a52560fdd47665bef68e9806ad8c4985860b7a36d07550421216e279ccff940d1436" +
			"dbf83450c2a32f73579309eae97949a94b6a626ed9aae1253fd2f9a17f23417a3a014fbbcee925531" +
			"79f5912854916841d7aad2ba0fb5723415a3a21487e8323beadfcb88d640a51ccdc460904212eae46" +
			"892c7a0d1c75ca570d44ca9da62505d8cde9074ee5c4948d40da56a537220853c77542c24ae1d3186" +
			"9e3a37275494fdae260625b0ae9207e044c3613155c4a026c4fc12fb099cd3fc8b586a450ccde5b85" +
			"b7123b9806f7131a80999bafe722e881da51415839a1073470254446c93523a62ac99360469662db1" +
			"ba73313168528a7b1ba1464e2446d9921163565bf80a73453f2c311411831236c8594c43d40fab54c" +
			"44087733aa2a2c66431682c6ea29eb900c4448d121143e3497b521113352689412f81be455944fcd0" +
			"a6460c0b473d4b43c4777ab418bd55d5a02c27b40c92952911638589b26ab01f2a3b450c3423f5b8e" +
			"4ee841e25067d68acccaa0b6bd4383662983c3f5b18acfd8c63c540a7b33ee79ccdc96831d08c3485" +
			"2d321f1331d08cb4836de9df3162885da768904bae453c10433e2cdff7283168dd05925a6d912f06a" +
			"2050b2ac43075329d125846801043011c1b93c68a81fc050fcd7f9083c590bc9d6e06c8156360353f" +
			"5087e6a9f13162a07fc147f3c5d68818200b2286125af7f1c4d65d05bc8c1143d4de4a50973162e07" +
			"8035ed094007e2006c8023140168801b2400c900562802c63c4e8923ba0254d6b9d8c1103a5257869" +
			"fafd8f11435429ed99f13ab518e058068b4135365e9207a005cd4f1618dbf9bc465fa339b1f04df36" +
			"83d4a0c0a6767547016d42546e7cf5cd5908e2e7d455be716d86b529ced90bab1b5612ffa0f648204" +
			"17c8023140168801b2400c900562802c1003a438e7fe019290903e07a073490000000049454e44ae4" +
			"26082",
	},
	"room_config_positions_dark": {
		size:   "16x16",
		width:  16,
		height: 16,
		encoded: "" +
			"89504e470d0a1a0a0000000d49484452000000860000008608060000001879f291000000097048597" +
			"300002e2300002e230178a53f760000062349444154789ced9de171db381046d799fcb75281950aac" +
			"ab204a05c70e2477e05410a582f82a885c41ac0a625670760772052755e01be696398500299200170" +
			"be07b339acc904944514fbbc082002e5e5f5f0980266f8c23207b086280362006b002318095b7b683" +
			"91b020a219112d5b2ef7b1f12718404cbd924a848245f8609cede69945792088d20bed625411e1968" +
			"8d64474659c1dc70b0b7247447be90f140b5ac598f117b732cef8e59e883610c444a3181b8e1297c6" +
			"99e9f8c2221ea43fac56348951b521b644746d9c91e185db304f81de5f155ac458f32f56324ab471c" +
			"3826a61ceaf731c7c4aad418c2a6d7c358e86e59e65d540955a3ff7b88eb2a3eb3e98d0758cad4003" +
			"730cf5356991439c9095cf5ba552d4ac94a514514289b156983e6cac58e0ec0821c6821b9ab1f0d56" +
			"7ee8e8510626c95f43e86f0c045b76c90166313b04ee1c2656451ce194931e691e7eb554e2945528c" +
			"4d8429a4c9c63892285262cc95774dfbf22197a82125464a5dbe2c8a5e5262a474335739f45024c42" +
			"812685b34298c23892121468a393979312406d1521463e8675a3adc87beff6eeed06bda37c7852486" +
			"dd539d03f9c780e71ffa0e9d87c218b29f3a95a4dcb55b184712626a31fa3c79142b297f3688e140d" +
			"25d564c511c0f5209c80f8801ac400c6005628c27e9698d538b91f2cd83180e408cffa82a9f17235f" +
			"5f8cffcd4ee9f01e4621726a31529e078a88e1c081270ba748d20bb048343e53bc81a571243124c47" +
			"8308ec44f8a9fe937a4c4381a47e306627822a51bb9cb6169262931529a8f91c58c342931f6bc1849" +
			"ec94b92c07293d132d7630136d02aaa8f197e0fbf96697d3e2b12166bbc758f03ae6b6808ab418874" +
			"867a5ad735b2436c4b07b158e3f1947f5729f43dda249a855fbeef89949ed33e0770a22dcbe6709de" +
			"eb8065e8753eb52ee748bc63c132d765a4433fc1b5565adfd8e52c052979b46f3de0611409aa2e759" +
			"1fb82f39a16995f72232fd49209479634bb86a60d4d0f033ff2ccb510a965c78d6148c1687b4abcae" +
			"737c147a18a6e4f72ab099cdef68dffa6ac915c73f8d336eecb8cb8cfdd15a8865b3bc19ffaa0b074" +
			"94a4e150f880ee789756ff705bfe62d1bbdec1b2f448681841463c95fa8d6ad1fea7647965b61856a" +
			"7c56a3ac3f88e89bd251cbaa01fc9d88fecee9198c53a423c68c737c73435ded5b4d3df3f565133d2" +
			"4c53857c07a0edc6d9c715a6b6bdcd6cf6464b1eb91e492d13f3aa420deaee229506aa9856c9382f8" +
			"dabfe5228644c41833825a72489fba3751377ec7ec159ff420db9462ccf88b75d9b8a6e44294ef52b" +
			"58fc259e8d437295389e1438a53ea8dfab70e0dc0057f915523f2ca383b8e234b965ca3740a317c4b" +
			"d1e4c85fc4e34911cb465df85af097d7d5be71bd9ee4e4f02dc6d452682539397cf64a729582381a6" +
			"d535a14d6a718db4ca5a8b9e61f461272f812e36e82a1f118b94e65d2b38f3646c1e30ae07f3ec52e" +
			"88ab1833ee15a4b6b5950f3ec63cdcef9a4abac63e7227eac6a88b18b7234ac9397115f3b8cad8543" +
			"2e73e3ba2c579a24c296323c61da4e84d9429658c184b744d077115e3da1a6352c9dee320544ebcef" +
			"18d751c7d088b18114a389ead9d1211103350b77a2891a4322c62da470269a6a68df888168e18f28a" +
			"246df888168e18f28da1a7d2206a2857fd4478d3e11630d29bca37e49cb3e1103750bff1cb55743cf" +
			"458c02524cc2a5f6a8714e8c1857f18d8542f37576a5922ad4fd631c053e79a775365b57c4506d742" +
			"2a88dc85d11e329f3a7be2578e60951ea68130369440e95e9a42d95208dc8a1f25e438cf0a8bcd76d" +
			"a9e4806aa7182a8b5db688b18014a25cf2e392aab089a1ee22330062002beaeeb9ad8d8141b3305c6" +
			"8ba9866c498418a60a82a7435c5505985cb048801ac3417ca0f8a2d958030a86a8036c5408f04fcc4" +
			"d65d056150b5a444b3bb8a527858d474599b11035284454de31fa944176a1affa762a047027e712a0" +
			"66a18e0174825c00ac400562006b002318095533192dddf0b0ce7548c2c772406769aa9a4b4fe2d20" +
			"c151d30ac24d31b2d8535429aa166eb33df3f988c5e3c551b78fabad575220a588a272735f9b1807b" +
			"ed01b22da1967812f4abec70b8d3d425b2a01c01a31008018c00ec400562006b0023180158801ac40" +
			"0c600562001322fa17d09561787e40eb180000000049454e44ae426082",
	},
	"room_config_others": {
		size:   "16x16",
		width:  16,
		height: 16,
		encoded: "" +
			"89504e470d0a1a0a0000000d49484452000000860000008608060000001879f291000000097048597" +
			"300002e2300002e230178a53f7600000bc149444154789ced9ded71e3b61686914cfecba9c0be15d8" +
			"a9609dff9c89b782d55610a5826b55106d052b57b0d20cfec7aa20520557eac0aa60ef2079b90b110" +
			"0858f031024f0ccec6422ea83265f0207e70b3f7cfdfa95552a5d7e545ea9140fabc2a898a8c2a868" +
			"f949f7e210344d73c3189b33c69e2c7efe8d31b6e19caf95231512b2303e218a57c6d8bd72b09f17c" +
			"ef9bcf71d152f72994ae61ea2107c689ac66684a938928b30426eee83f24a25985c8471a7bc62cf63" +
			"ea932d815c8471abbc521994c185d1344dc868c102479b8a0192e5aab4d4bcc13272afbcc94ca8f17" +
			"8db34cddc76e98a737d82a05e39e7afca9b2ae1cb55ac0ac44d99492fefc4c5e79cbf291ff8fe3971" +
			"639ec5ca4239e8c7529c07e7fc68fab41010636cd539d7ad1075dfb99648903070a13f2b07fee52c0" +
			"cc3eee801212d1863ef944fd0f00281bc767e77dd23c203ceb58a03780be38a2864fe608cedb17a98" +
			"2734340f18c98e1899aef949aa3824bc84e1208ab151c5019c5725131605c3a8f20a03b5689c84317" +
			"151b4142f0ee6228ca6691e0b1045cb3dec93627119314abb50bf951ca0731146896eeb6203743583" +
			"aba2c545182fca2bd3a7583bc34518cff06696c2b2cfbd3e759c1c5c5899fca51c981e5bce79d1996" +
			"14e3606e20f4be5c0b438c1755f34be2ef18d58ce2907a6c17bcef9a67461f8ae4a8a8f254c1de744" +
			"1db88a4de16b2ace88c8caa1f31bf8156285eb5bc43452fc88e193c115d328d3e65274899cd3213c9" +
			"e7725af4898a73016ca2be1888caf856d4a206c800d5649eb085ed93996e7c5e2ba5c15e978ff530e" +
			"84f18973ee2d364c6d6b6263f8c4392f3ac9d8d5f8a41e2d3e868882fd3b7abcc1e740e999bd458a4" +
			"1b1588f184dd33cc0189c2907fd081a2974344df34a68779c30bd1569886a8501113c4a2b811b6243" +
			"efc039278f5c625a39128a57e680ef2ea2cafe42180155e7aefc1aab9e235196d98e733ee9d2c8ae8" +
			"db149208a6dcc221f3ccd27e5002defa69ec4d315466ce7114b14ca5e29afd033e9249e6fc24895fc" +
			"9ac898ab658781c823468a2760a7bc1201c7dad98a86d4a97d29ddcc49443855a62c8c4a003519b8a" +
			"225753bc794967c9695648837cd25c7e18dc645e014548c416a61a40c4cc5f6c7388368f0c6c233fb" +
			"0e659277431558cb53498a13b82768ad74958c9d4fdd06337dcc22e7bef4f24d180987ad147f6c76c" +
			"2c003e19a373258e8bf6b7ca6a81b8991e8f30ddc80d8a987ccc389e67393ad43ff629a42f09384ae" +
			"30a2de3420721d62fe4e8accab97444ddd6ed122ca88f058374db347bdcfdf4dd31c61cb04a184dd1" +
			"3f4c86218991ea8f32a231444b549c92dafbe9dfe9aa61182fdaf72c08e1304bf918d518c106b83a1" +
			"fd07e7dc3b66a40843f307b5ea9b130fd1a46d8d222412d9741efce7da58242f53a602ecb050b0c99" +
			"1f16ec2ef9af32946923f9503fe908823822804bf980c72fcde463226cf6809b9e9bcef19a36f8cc4" +
			"215bae0a5c87ab306264481d7051b537c1e29c747d46433126035f11e10b04d336c44d91c66083f30" +
			"3e85abbfa1621d7e11e46d3ca25f42f561f2895fc62b84921680d3e29c3cdf47b1f703e9f331205c3" +
			"357632ca9d6b57239510c8b44fddbe6b9ce2b71fe1a788593bfb1fcd6fa74a7b8c857114d43186a2e" +
			"6138666d3534a8d367bfd4a67e131e0240cdfe86acae0ce6d62e34d197261748f5914ccb51ed75718" +
			"53aed2d2d9398a5846c6c1f56ff0e90cfc3481a7a78f0be31aab9021979b143cbb2e575d3b033f982" +
			"cf60921aadd65718c3eebcc2701dba533f04d047f41aefcde86eef1a47d1af31fe393eae0dab56fac" +
			"4b351fd6ad5f05ab9431b7b374768bbb08a3b4eaef99fc3723e610bbc22d160bd7ba2117619430857" +
			"4e95e4cead5c90e1bfd885ade1fc43fc6d8cfe2fff13a951067aee7ee92f3792ab09f78d7f0a43244" +
			"775829285159d834aff8b722ec1a24eca6bd6da5be8b3016880394c241e314a2f0df683dab268478b" +
			"01a5c11b8093ec359d73a288fa60d06870ebbe78a361a49e016176da8bda7a3486e79eda686aed1d5" +
			"5501cde6db0bd515c54d6092f1364414ecbb014c5d7aa9b53f9c3d9f38b9a98a432b0a1092707326c" +
			"ca78db13a5402a25eb112477188f7fd2242d97014a5c8443fa1e7b9b0eedf5bfea6764845b26d48be" +
			"2643aea6328ffb80ef217f30bbcb59ef4a34218ea669c493f5bb72f03b1f3b56f00217b94d38a6769" +
			"8896176a549b1bbbb924b7140fadb517aff82b013317572138521dae5412e89a0d8c25b97e87ac285" +
			"ee0dcf1b3eebc30b967fbd4f2562205d215f189a10c59ed06f73e69c93d7d1e2a1a4f42d5d34d70fa" +
			"e76c788f02b6ece168e99079b1c4e7c3674586cdb2ef68a827d776db7e7da3a97ba368518d1282f78" +
			"acdc15eaefbd285622296a86a34671d658123af7ae0dc6a2168b73a5ce3519e54e0d39f4c7987a5ba" +
			"42a0c4f422f5ceef912b1b2dda8ed968bfb308511835a18d4df17ab598c6985e5c3a19b8035b83060" +
			"1f7847117581a840a88531a328329621eefff1a231c09377d431e11ba01b4b66d5fc8ac1eb4aa8177" +
			"579ad383b8be66c583fbfc79066c30901a918ed1462d82c1fa8460d7c4f88d34df82bb4217f996007" +
			"570e606835a51e6ee1fcb2b2652256da9de0dff136b6e1b6de07e46658effa30fa768ec855f862100" +
			"54380e8d53621168eb2ad72209c5b9c87d76a422a910c49d8b1cef09f429f4f9be964e6322f63c7a4" +
			"658410f7bd8b485ba40a7b93f86db12e2318fd54e2b0ab51d01e237862178151d696330261abbea90" +
			"5027a260a98396d1e346a61c0b6b05dcd906c806708c485b0edec317b877f4fc4be8af8d5ee31c193" +
			"b9c2857983e1783137e23d738f80d7164fa96291c3da7fb38808871a8043d24d83309295307abad59" +
			"c20963d512fb01dbeef88a7b3db8c4e9bb4239de798735fadb61dcb46183da2180aa33870ae7f6772" +
			"9eae58754ccc625582e1d9a6c7764a6658414c6d8b2b6df26f975c96ab8b4ce7ec99c1f730f68df2a" +
			"e1aa1b90823e7ad2a2f6a58a57cd031635c22b7d48d6cec90478c29b482b89a9c9c8b30726fc6f28f" +
			"010a7b23a7368d3e2c6d5625b94457d7196f6e7790b2a7b3dc35c901eb6ab89ca6925c470dd99ed82" +
			"72a988ac1c1a58a2d2761f4aeab7300718d9c0ccf3332b096f8af49b4275d96561fb96470318295c9" +
			"160e32d921f588a72464297ce1e012d35ed3348c7037015f96dd209ce40f92eda053f426f331111bb" +
			"078dec0edb5822354bcad3c5713ef755def2c37be3b638a3cc23ea1088c193db2d2b93d2109f9d8dd" +
			"e3c4962c8411107bb00e0ac1ffb0f1b831c670fd958d64b43710e7b10e58dd58c53a42194c1818f61" +
			"ef014f984b1ad45d1f94d9f6d358c5d70a43697722b81ab5b6d78f66327491db021b930a4b07a4884" +
			"748b2c2b9fdf77c9e1903949368c521689d1438c2c47ddd4a3390f9f409c71f4a266086150b40b52b" +
			"68d703c07dbac2f132437c8a3623d99308658ae868ae240d08424d467f28e28ea6a9c6a0c245bd227" +
			"1506d12ecdce7db13550186f144fae8b40cf111ab018493d6264b19d0551dba360f7388ce76bd5743" +
			"b38afac7a8e50919383ab48c46a0709c6f243b31f6ab3ff962285a149bc19148c60598504924e2544" +
			"8e198aec290afb20c516de8331c4aa24b471fa3d81114b21ae4977021a42184f3d51405bbcad732c3" +
			"34397cccba16d80d8e4e0125f786ed5e9eb12f7a9016d37ffdf232835e96984651444f3f1866af753" +
			"3711208ae0f6056324a7f201d7e945b892bf884ec3d75619888fec3d43debd85c75325a77c8c9062e" +
			"136ef6123a5c6b753d53c2007224a57df3190931f23e4a99c41549455e8ac80ad448de494f399e393" +
			"59dc14d2924bedea5da6bb344ead6ed59a9c0a8e72aceefa8dba47e75818dcf80cc8a84a85306cefe" +
			"a72b5d26556e2949243cbe8cd08aabba6be4382426d83709d4f253ab872296a164fe447e5c0f0bc98" +
			"ca06a64e6ecdd94c7ba4ed2467d3234174b42d05b8ebc9167fc16e914592633bc727f8345a87d7061" +
			"b01cbeff1ae2aebeea96e10a3b1c0a81446db00d6a3dfa6710480d09e20c6deed1a4a61ec9d815dc2" +
			"f53f976844fa32763f866d02edae8ac28db10bc3b6f8a88ac291510b03cbdca572e092b34dc3d3ca2" +
			"553d9e1e8c190f9eddd38a47426218c0a3d358856d152855151618cfd1f86e4ffe7cc3ed010000000" +
			"0049454e44ae426082",
	},
	"room_config_others_dark": {
		size:   "16x16",
		width:  16,
		height: 16,
		encoded: "" +
			"89504e470d0a1a0a0000000d49484452000000860000008608060000001879f291000000097048597" +
			"300002e2300002e230178a53f7600000add49444154789ced5deb91db36108633f97f7405a754704a" +
			"054757704a05d65510b982c815585781a50aacab20bc0aa2ab205405112b5086334b0f850789c7025" +
			"c00fc6630f6403a92223f2ef68d0fd7eb95cd98c1e317616646f660333166a84089180bc6d89e3156" +
			"33c6ae23e304df2d84a3cc4001151d63010ffb4ef86418ef8cb1e5e0376658818ac4d85890a2c5036" +
			"36c2dccce70061562b8bcf5b3c4f0002ac4580833fa9889e1015488712fcccc98141488e1222dd82c" +
			"31fc008b1825636cc7183b82226962466e851933dc191ec3e55af3416bae3a8ef555447dbd5e9723c" +
			"76dffae12fed21ec7ebf55a4aced31f3bc9d14fd7ebb5907c37ebe183141d2ef079fffbed03d80271" +
			"7ca186f316dc7987483893831b2e0eaed67ff05d9815f10aceab5697f82c7cea0f0d2c17b5a69fe41" +
			"d96998bf04986b025467ba3bf09b3f1632607c08618ba922256644f0e666195a44e0a066ef62a776b" +
			"c54462ac18633f84d974917580ce4462ec8499b4917580ce841839baad5dbdb2d1c284188d30933eb" +
			"255404d88b11766d24693e16ffe0913626c4121cb059b5962e8e102ca580e4bca4bced282cd0e2e29" +
			"b2cf23659661f7f64d3a08b3e9c0350d2009d8e663a4ec15cc3e3f83592e25ad6dffaf308b8b37704" +
			"bd7301888f705c4311e3c9fbb146633c3af163f7725cce0a001efea4e610d54bdff2f40e4fb08e33f" +
			"c2f16be1938c6023316a0f5ed083a579d855af3d0a9fb8e105ae275b9812a315e7ff08b36e7846300" +
			"d5be9f197306b8f064837fb313481fd1661908201319e85597bdc795c32a380898eb142be595f909d" +
			"487b501ab1f48e1d5828274e09ce02b2a5a400022c7b8e1eec35fcd5d31bd93d485f91e03328c1c9b" +
			"bcb79622ce187db14189be0378f6f602b35fe16667191bc7794d731f6014871f02c96ab00c1bee493" +
			"787862f8741c750891091622009674124f9f18217e68033a806f1c039c236984264608523058aa72c" +
			"c384343e86af750c4087daee4109a18d95778c5029b20da0c7c149cf95b4d7d8f43132364389baad5" +
			"50f6fa72a81c870d7c67b2f4c2d0c408f5b00aa27530ba69917760d65753b9e2fb3a4688f5ff3e103" +
			"9a806c04cd206270de4f589114a8b0fe131a4488c8585149b6c39e463253e927078f8ce7508917ac8" +
			"2ce23d36319c3328a563f7aae8bd0c478c7bcb9bab21b296ee3c9f2784c2f61c68edbfd7e899be846" +
			"bf90ea3c690cab2b0fb021edcd252fce9e2770fcb1776a79f77cebd5e3bbc91eddf3d09b37ae8ca25" +
			"f7dc3d5b83922a0b7c1e5c082223860c0b10559837bd01f18a450eecb4c3b19c910527be5512c447e" +
			"2f21bfc5e1921fab0ef0e24ebd8363086baf4d9e0a2d1f6516794702c4c2c06cebb969c6f23e950b8" +
			"f7d89d5017a791df221d14b2c41b1079b61151ec44e016438938439d85ce3d9d601d20b745174d4f1" +
			"7d1838c2d2363e389d995460357feadf5d52f742b391f03e9862d9942612ff93dca612331dab7e13f" +
			"61160f9dc2375489b6f2a814abcc69dff9a4bed18c583737b0edf3b90fdccc3524be2a3c94a740196" +
			"ebe70367198d986dd534ea597a51e6e23270533f5efd81243a598a50099b88dbd5cf14d210595b021" +
			"c6c6c15113035afda64f8e929075610be39e1fa63a46889a0d0ae09d5b97c8c9f14198198189c4283" +
			"2cabe7ee2960f99de11138c977ed3cec0b18b54137ceb69f1dbc8db4b19c74c4c8891aa793a84fe0d" +
			"5d8312e70b0d1cdf47d9c35aa1542b31efed6e06cc25a50129f40974800274b8f6df8f8cb13f10a5d" +
			"49d4f73f52ccca40fde5f83955c7480656aadc808bf803eb78684200c49f564b21fbe093172ebc4ff" +
			"2a79cb30fc37cf702f7549568324f9227c628ecf10cea87a439e5aa00aa2280676d89d2a549be71d1" +
			"daf97df3c90cafd5f616c9697ebd657aec143ac866f2e99602a086906b641341b72341198bb2a5230" +
			"c7c0a12a626b83029617ec7b79e304b3b54af606cdd09e7b5af773a01d0cde40abff00ca9bce3955a" +
			"458c25bea62aeab7a97dae0e2c9e1761b7995ac63586bde50da5ee921eded023b31abd2d886cec7eb" +
			"1425823ed187ea9a6cc74238833b6e92a4302e5296ff5829943759461406769263cb86ec5a8f12526" +
			"0a2965c07c6c0ce24bb51405d766aeea3e879d72a856dae422b16ff547ca60341711a4197dddd6564" +
			"f1f11fec24245fbdc9ab81a2681bdc2428611535bbac7bae6baf6960af1eb956ecb2c028939a28b8c" +
			"427ef05e119516e739142ac847a4b255fc4c03eee8d644b416260174763130dbbab32035260e6a00a" +
			"ee7f2a12c3d6b7d178588a7c54e1cbe311d31fef1d6230c2f1a810c3d6551c4b922ef675baecdbd68" +
			"0f3ef23587352459c4a73b60aaadf379a56c105441f6f912cb9b5f762b134f8d0591ee1adc4488ddc" +
			"38163d69159263f931a6c6166e982c7e60dae8cc57a51d4675bfeb2600da3e9514ac92128a9a5537e" +
			"b0e027eba4ea656cabc08b3eee8b2a86cfd24183b43684bac1488a19b40649268b4e9a5d6bdc1c0c8" +
			"607b008961ea095d216d17a2bf9479f2e3871c27c1eb2f47851417c2c251a3ba7f05d78d8193e4f8c" +
			"a11bb8e61d25a092b2702bb9dd359d2cfb3d4ec98637a1efd654cc5980947c9bd255b49a4d6366c7f" +
			"82fe1efcf10a384f09632c4ceeab2f876fa8fa7e08839ac450658675cdc92eb0deba7afdceb0de1ee" +
			"1cd949980433b3caaae33060cfdae9fa0440c8a375b751343f512f5854f631e632a56c942e5819b18" +
			"df15d64c9411d31e463db1945ce25413857712a54d469698304a6c2ac4a0dc88856ff6be74cc38a38" +
			"0d1e4a1b976550ffd372cf656108d4e108e0a315ca28521d0296aa5c47a890d9b982446e5b9c5800b" +
			"0e09a51fbe28ac2c01949612aa5d6bfa37b28ab8eaffd5242f841231a8eeb0c85fd78ad09eae6748f" +
			"bff0499582ad2be1b5b523277e844c3a532ad86a2a37e506a014128d78a32997b7cead6d19781caf9" +
			"1df75ddde2af9b214c4c340a871bade3ff5f1a446179a81ec042e39835fc7d0924dd23104ad5a281b" +
			"fb672a044341a62d8488ba1da58d9282cc93114ae2e062492ea011692b7da043209863ea624c312de" +
			"26db7c03939d0afa0fc5861c7c7d2b3fb69c2418fb3eb324c7104951c71441b42568fa2e115297262" +
			"42e3b21bd8132ba95e46e16bd3d4174ca126d0271beea60054c410c8c625cd31d0c79b876a5314b7a" +
			"51c37453a060c498c25c7525c51b42a1b0eb4e8bf7480fc834633c58817468626004cb30bc9018c7c" +
			"020860941cf210bac42171c51c963a0e24c3b423290ac1d771722b80091f721af9b4a255aced807da" +
			"44d808a19712acae75148e41d5858f82d0c4c0a80bc558db85ea6e0b50efcbe18429ac12d7f0fa030" +
			"2395c53f39a9918f8d82090c325b1678560326f525f4aa62e1f28e026dbecb4fcc52287c3b630f8bd" +
			"b7d9ffd03eeec9804a5d896dd99f09396c4911ccdb48095412757603492643f8066ff0907bba80a5c" +
			"7b65a9c9c291902942ad15c1bc1be8242d879359730560e352b583191e840c9c1e5aacc3dc1b0d157" +
			"54c8525a3062399f59be995441a9128de22e8dd9299d1da81083aac87e4c605f772b50503e63e835e" +
			"19a18141d28488c185ccbd9e93f54cc55d314b790c0dccf2c1a50d131285577f1483e2e2203156274" +
			"bd2fa99143bb083835506bcea68a671c7a0fa844e8c0d379498b016f2bd63ea95182629fcf2597482" +
			"3dbb7ac0017baa9efe3007193be85d16d9fd9e938a6bdc79344ec0d604d94d6af23791c9d33ab2562" +
			"763a058fd889a11b786b12e8b41714b1f7e0d27db3934ec3f381d889a1ab0764e5b5c440ecc4a8a16" +
			"067c8cc7dcfd9bab0452a3b1c158af2479badafb2074b881833903137809d21c54c8c1952ccc49821" +
			"8231f63fe591d54478bba8e30000000049454e44ae426082",
	},
	"room_config_summary": {
		size:   "16x16",
		width:  16,
		height: 16,
		encoded: "" +
			"89504e470d0a1a0a0000000d49484452000000860000008608060000001879f291000000097048597" +
			"300002e2300002e230178a53f76000006a349444154789ceddddd71e33614866124937b2b15d8aec0" +
			"ea20ca3d66a20e56ae60dd419c0a625710bb037906f7b63ab02bb0544156153883e438d9350e41fc5" +
			"14346ef33b3174bae7e96fa04810078f8dddbdb9b013efa3ed882a3670806ba100ca808065404032a" +
			"820115c1808a60404530a0221850110ca808065404032a820115c1808a60404530a0221850fda06d2" +
			"c61ad3d33c69cc943b7ceb92d877cba8ad77c5a6b67c698a5fcf925f807ff7830c6acfd1fe7dc9760" +
			"2f46ab2818d6da6b63cc9531e624d8a9db1b63ae9d7337ea5e8c4e5630a4957832c65c043bd3bc186" +
			"316b41ee397dcf9b4d6ce7ddfa12214461efb2cfd118c58528bd1a0a5f8a869cb21ef6f25fd9d9f82" +
			"7f006fe3bf94c6989b941383d416e3ae61288c3cd75db0b580b576252dd9ef8422ca1f9bcfc698576" +
			"b6d6f5fafb7c5b0d62e8c318fc18e367e76ce3d953e9374827f0d762045b4d54e6931ae832ded5c95" +
			"3e93b5764928aaf856bbb3e588b618d2497c0d76b4759e3b18267d8a6dc6e932baa9ad765f8bb108b" +
			"6b457f21a4b42d1cc4a7ba2be60cc832ded959cba2e832d28f5497bdc188251d2621ce27d1d0d39c1" +
			"f8c65467574f832d686aaac1d8055bd0545f309e832ded053de2044ce9b7157cce630846c987bc0eb" +
			"6a0d4bd36c8d5178ce251c90c25af712753f9a8a74e4d448321034f0fc18e761e4a567a49c28b474d" +
			"f1af7b6d70cb24763e3b874d1b287e6ee79c4ffa6db003a95e625faee890f83b6bed3ab27caf944fa" +
			"b3aea9643e64cee1809cd72eb9ceb0c85c9385d5d49c25a89a63587736e2da3a797f2b347df43b791" +
			"16f6bc2f142667699face07a6af0cddcc9742fa79c23963cc0e59c7b966f664dcbe11f3b2714e377c" +
			"855e27e49d9906b3bd050ed75257deb2c37d231e4ba92896956645efa2033f9eb17f9e9c1b10703ff" +
			"2f5cd40c15c1808a60404530a0221850110ca8aa2beac8f8c542c630de576ffb310c3fa0f5c478c63" +
			"4d58c7caee4f2c5be15db3b299aa2ae14c238650743ae41b82b58c2ef03b2ea5a318471c9ea63482b" +
			"f158785d877fcca33c07462e673d86ff40ff087694b91ce2a745fa3b675ca916d84a25c5e4d63a756" +
			"9df103532d4abac4bc832801557a8f5dacb3adb9bbed9ee94c2293339cb687dd077b26827fa066306" +
			"2801752cf6b28aaef38c31a58f7135d037f1b4b2700aa128e717583dc94faf2a25184376166b9efb8" +
			"6505439895dd1170d86246ac8dfedd3586abb48a51fb5ae03b28fbffae58c06e340054a4a5e83abd0" +
			"da518f655f300e51a8b5e435381d6de7422bc83bd560742d3e46a3cf80d955a8fa82718825ff25afd" +
			"1f27249289fc1180aa794bc0653f9edecb481ae29174e411beab18c0643e63286bc7a7c5f325f228f" +
			"d9043b907dfcbb6a94448321d4073652f3dc4b4a1e545b75cd55a50663880fa033ad29e43fb4a0b46" +
			"391bd2c7d281b1237ff7d00eab069a5ceb4a6924ed35c0a82d07aa4d9c8acb6dab77897b350e7aee1" +
			"fc446fa99f5c32dbba6054b4d356166727d526c9bd595e8b70340f05dacb1af994626a9785cdf6fbe" +
			"f1aa19880d28a3a33b9746095505527793919c6a3ba3e8694539c2bb797f0630dcfb19e2fc68bc229" +
			"5031bb0a15c1808a60404530a0221850110ca808065455157564706b29835b1f2f4c7a9125786b06b" +
			"9a6a774487c29c3dca957a9f935135704643a72675767b246b0f46e47f71210e64c462e673d46abab" +
			"cb5fe4127cc23162397d8c5625072ee4b99a2ea8f9aabf135c5585bf6de5b827dd2224b5a28eef4f7" +
			"c0e76d469b260a7a258dcb14abaa9504a451dff0d7c0d76b4715e731bacc675c18e4df42e9629e318" +
			"d164552a7e6ef9e92014e53e596b3b5bec688b211dce3f831d6dfd58d211b5d66ef9f9a8e67f56ceb" +
			"4e33f86c2291f577ef5929f104251ef64cc85534ace4eb2c3844e45c138c40750f21a5c3bd2ce899c" +
			"d97d63aa936854eb1bd85483c1e58803a3700ad4e3d9178c43dc83bde43598a56de7a1e474f5101f4" +
			"0c96b108c76d45214d160c870f590956b362543e2f298df821d2839fe6a45a36830849aa8466a0aa7" +
			"5ccbfa0e9479890d60a6144e590fd46a6c6a5774c924102d47be87be3531a9a7ababc6a788fb585a7" +
			"348cb712e557528bbd46d2f81f037105ac64261325770cd65a1475fd983943718bd894a2d79afb3a1" +
			"9e7f829e73272a73d77ccee58ca07402cb7fa397dc8b75fc722bea7c5d0c2dd7ad140523141350734" +
			"3de3399995b465a909db43037352bb570784d0aa748483e4ed167ffae613ca8a80315d7ae424530a0" +
			"221850110ca808065404032a820115c1808a60404530a0221850110ca808065404032a820115c1808" +
			"a60404530a0221850110c848c317f018b3e6144ead8c1a30000000049454e44ae426082",
	},
	"room_config_summary_dark": {
		size:   "16x16",
		width:  16,
		height: 16,
		encoded: "" +
			"89504e470d0a1a0a0000000d49484452000000860000008608060000001879f291000000097048597" +
			"300002e2300002e230178a53f760000064349444154789cedddeb71db461486e1e34cfe4ba9404805" +
			"6607662a885c41a80aa20e2c75205710b9024b1584ac206405a13a202a508693c30946387bc3ee220" +
			"2f13e33f90346120d7edc5decf5c3ebebab006ffdd0bb82d913820117820113c1808960c044306022" +
			"1830110c9808064c040326820113c1808960c0443060221830110c9808064c040326820113c180896" +
			"0c0443060221830110c9808064c3f5a17132d44e4f2cd8facb9ddd3363418d722b212915f7baffce7" +
			"59449e44e4b1f70adebdd4b5ab4b117910918fbd57dc5e44e456438289486963dc89c89f89a138ba1" +
			"291ef941cd3125b951c3fd4df7a57d39c7e7e55f10e35fa1ffe751091ed907b11138cdb02a138a911" +
			"8e95b6797ced9db9db6955fea061090ab5318e4f1c7ff5aee6fb5ca0cdd16849f6a9f70a5c5afda20" +
			"7abf55030d6956efc4b6691bfd0f776d17b0531be6a409c7c8dcf45c56fe3556675f24828b2fcaed5" +
			"af932f18351b89127a631e77039e8cd0f7d0bbd2e1ab4ab6237c001f7a57c2f65ae2209fb3ade72b3" +
			"1c6f8562e7a57fc1684a22867a9ed0ac6dbb18f5a52ffce58ef6b2e9c0f00ae60a47e9371665cc160" +
			"7474e65cc118cb3ef1efa4fefff0737697fb82b1e95d29ab1d188c5def2a8672f680fa82613ec6143" +
			"4f4f77b9fbf116d33b4c4a81d0c675a031e751210866b73bac4f7daa75ec326b381bba24a19acd5fe" +
			"0b676921819e4fd17e837de17189561f874b3424ef34f98c9bc4d9e8fdf2864222a7f6951e7abf293" +
			"c9beb524b90a5a7036c51313cdd467aa33db3b51bee5d8da73778d799acf394524ac7cef93cdef83f" +
			"7a57d3950e052a49990c9c3307a2d570312178227c8dcfb7b65a6ca53648bf69a808c5840c3dfaeab" +
			"233d7d2aabf371a84277a2ba78933d16062ed2a4c040326820113c1808960c0443060221830e5eca8" +
			"d3743ab8bab38d0fda75be1ebad21affbf211d5c4b1dee8e59beb8d319570c9c4d4c4a302ef5031eb" +
			"2ddc046bbd0e91e9f88d860343aee91b33aadd5d286ea6502628271a91fa66b32488a5ae1580426ea" +
			"ccdd3a752a654c304aef91f1a21f64d4ce2e0129ed9db96bb5bd7717731f428fabb7156efa55ec9b0" +
			"b58e966718422ce716ac4172dad83256ba8c43818732d4af939a3315a6aaae15cedb4b47596dabe12" +
			"635579f6b5775d83474328b27dcc5957e2dc3ba1909c1d7590ef8baf4af1552535ab91939f7cc5998" +
			"3f30d239973d6beafc41863114fea3e1ccbde15e47096daae60b071ca3c38ab1257303073ae60d06d" +
			"3d0fcef69d2b18a23d94b5a5ae785f6b0f1eca702e02f305a3f63e5c43b73170fe6390a4f5dd4b5f3" +
			"09c3f5488f99814e19652a308ef4904be7e0ca9b80b6fab3d98ce371670ad87e360985de8c9d35762" +
			"4846b7758837ad119eb473869223dd734c7f50ccb0fb53e1436282694dd0681779a98376ce59d2d97" +
			"4b11375d685f616cfad427c961c7d65da6a9320a90b22766a5f8970ec74c4963e920988edf93c68f1" +
			"7fdf7b25ce37e67b4ecb90e503a77afd3a62a0ed591b9aec4d3e31b91ba75c778ef03e6dd178aacfd" +
			"695da1218013beac0c4e82a4c040326820113c1808960c0443060cad938a5ab3b5ab7a5ff62fa8606" +
			"63d1d932da9aaff1a21d5c8ff47a4e536a0757a31f76ca42e2e8c353f07ea4b4314e23a3a9abcb3fe" +
			"94138b526fda082b10fb2f9a6bf0bef5c4c304acfafbc2fbc30f9d4de59388ec898bb9d0e6c9e8e09" +
			"897a300805a3d1eaa3f4cdfea540a33467b3b8b98a3e692ad4c6b8abf40dcc3d54f734a38c50a4b9d" +
			"0d23f589dfb4a8c6369f177ef6a399f33d6ae6c0bcd419dabe011a7be12a3f653c4d046e88a5064bb" +
			"08b5f37c2546ed6f65eb5b86ef4169518e731f345f8951fbe65f0c585fd2108aa29cb5822b18636da" +
			"49afa7758335296f38be90a86f307300fae6030ae3173ae608c356c9efa7718ce2fcb6c788a271892" +
			"b1b149ac7640c9b41d69a79fb970ee51e20b46ed7914437fbff31f83241bdf67e0ebc7a0e7f3bc79c" +
			"7ab7c25c65e87c96bd8656ee5b41ca1aa3b6737be50482018a2dda63576ad7176ac443a68386a05f7" +
			"5cbd684911ac8e43c1d8571833b92fd47e39e8b8c9b15bf72b258853abbb0edc68f320eadefbda185" +
			"dcce09a99d8399f8f053643bb2714d3c12c719886ee8fc1ba9233576ae394ee4a34827006d8510726" +
			"1635c3443060221830110c9808064c040326820113c1808960c0443060221830110c980806fa44e41" +
			"fc1ac7b5c0a8e58770000000049454e44ae426082",
	},
}

func getMUCIcon(name string) Icon {
	ico, ok := mucIcon[name]
	if !ok {
		panic(fmt.Sprintf("getMUCIcon(): icon \"%s\" doesn't exists", name))
	}
	return ico
}

func getMUCIconPixbuf(name string) gdki.Pixbuf {
	ico := getMUCIcon(name)
	return ico.GetPixbuf()
}
