# How to contribute

Here's the brief:

* We welcome contributions of all kinds, including but not limited to features, bug fixes, quality assurance,
  documentation, security review, translations or asking questions
* If you do not know how to code yet you can help us by translating CoyIM through
  [Weblate](https://hosted.weblate.org/projects/coyim/main/)
* Pull requests are based off, integrated into & rebased against main
* Write automated tests, ideally using TDD. CI needs to be green in order to merge.
* Contact us for questions & suggestions:
  * IRC: #coyim @ irc.oftc.net ([join via webchat](https://webchat.oftc.net))
  * Email: [contact@coy.im](mailto:contact@coy.im)
  * Twitter: [@coyproject](https://twitter.com/coyproject)

This document outlines our way of working, gives hints and outlines the steps to make your contribution to CoyIM as
smooth as possible. You're not required to read this before getting started. We're explaining the way we work to make
sure you're having a good experience and can make best use of the time you're contributing to our project.


## Getting started

Coy is written in [Golang](https://golang.org/) and uses
[GTK+3](http://www.gtk.org/) as its UI toolkit.


### Requirements

- `git`
- `golang` with `cgo` support.
- `gtk`
- `make`
- `ruby`

Installing these requirements differs on each system.


### Instructions

1. Get the code, and navigate to the source directory.

   ```sh
   go get -d -u github.com/coyim/coyim
   cd $(go env GOPATH)/src/github.com/coyim/coyim
   ```

1. Download dependencies, and build the code and the gui.

   ```sh
   make deps
   make
   make build-gui
   ```

1. Start CoyIM.

   ```sh
   ./bin/coyim
   ```


## Contribution steps

This is the lifecycle of a contribution. We follow a simplified fork + pull request workflow:

* To start, fork this repository and create a branch that's based on the latest commit in the `main` branch
* Implement your change
* Run all checks locally. This is the default target:
  ```sh
  make
  ```
* Send a pull request against the main branch. Please make sure the automated tests are passing, as indicated by GitHub
  on the pull requests.
* Please keep your feature branch updated. Rebase your branch against upstream changes on the main branch, resolve any
  conflicts and make sure the tests are staying green.
* Your pull request will be reviewed and merged


### What to work on

Generally, all issues that have no user assigned are awaiting work and free to play. If you want to make sure, or you
think it will take more than a couple of days to complete your work, please reach out to us using the contact info
above.


### Guidelines

When implementing your change, please follow this advice:

* Your change should be described in an issue, or at least in the pull request description.
* For bugs, please describe in an issue or pull request:
  1. Steps to reproduce the behavior
  2. Expected behavior
  3. Actual behavior. Please also include as much meta-information as reasonable, e.g. time & date, software version,
     operating system etc.
* Pull requests need not be finished work only; you can also submit changes in consecutive Pull Requests as long as the
  CI stays green. Also, please send a PR with the intent to discuss & get feedback. Please mark those Pull Requests
  appropriately.
* We review your pull request. During this time, we ask you to keep it up to date by frequently rebasing against main.


### Review criteria

When reviewing your contribution, we apply the following criteria:

* Test must be green. This usually includes an automatic check of the style guide using e.g. gofmt. All tests should be
  executed locally before you push, as well as in the CI. If you struggle to reproduce a CI failure locally, please
  notify us on IRC so we can help you resolve the issue.
* We won't tolerate abusive, exploitative or harassing behavior in any context of our project and refuse collaboration
  with any individual who exhibit such behavior.


### Debugging CoyIM

* To see debug messages generated by the application, use the `-debug` flag when running it.
* To debug crashes, use the targets `build-debug` and `debug`. Consider using the environment variable
  `GOTRACEBACK=crash` to generate a core dump. Read [Debugging Go Code with GDB](https://golang.org/doc/gdb) for more
  information.
* To change and inspect the UI at runtime, use the [GtkInspector](https://wiki.gnome.org/Projects/GTK+/Inspector). Read
  [this blog post](https://blog.gtk.org/2017/04/05/the-gtk-inspector/) for a nice introduction.
* To enable debug features in the Glib and GTK+ runtimes, set the environment variables `G_DEBUG` and `GTK_DEBUG`,
  respectively. Read the documentation on how to run [Glib](https://developer.gnome.org/glib/stable/glib-running.html)
  and [GTK+](https://developer.gnome.org/gtk3/stable/gtk-running.html) applications for more information.

Not all options are enabled by default. For example, you may need to recompile your `gtk+` installation to enable
debugging and use the GTKInspector.
