/* mancmd.c - runs man and displays the output 
   Copyright (C) 1996-2000 Paul Sheer

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
   02111-1307, USA.
*/

#include <config.h>
#include "edit.h"
#include "mad.h"
extern Window main_window;

CWidget *CManpageDialog (Window in, int x, int y, int width, int height, const char *manpage);

int edit_man_page_cmd (WEdit * edit)
{
    int i;
    long start_mark, end_mark;
    char q[64];
    char *p, *man;
    CWidget *w;
    if (eval_marks (edit, &start_mark, &end_mark)) {
	w = CManpageDialog (0, 0, 0, 80, 25, 0);
	if (w) {
	    w->position |= WINDOW_UNMOVEABLE;
	    CFocus (CIdent ("mandisplayfile.text"));
	} else {
	    p = CInputDialog ("manpage", 0, 0, 0, 200, TEXTINPUT_LAST_INPUT, _(" Open Man Page "),
			      _(" No man page name is highlighted, \n" \
			      " or other man page open. " \
			      " Enter a man page : "));
	    if (p) {
		w = CManpageDialog (0, 0, 0, 80, 25, p);
		free (p);
		if (w) {
		    w->position |= WINDOW_UNMOVEABLE;
		    CFocus (CIdent ("mandisplayfile.text"));
		}
	    }
	}
    } else {
	man = q;
	for (i = 0; i < 63; i++)
	    man[i] = edit_get_byte (edit, start_mark + i);
	man[min (end_mark - start_mark, 63)] = 0;
	man += strspn (man, "\n\t()[];,\" ");
	p = man + strcspn (man, "\n\t()[];,\" ");
	*p = 0;
	w = CManpageDialog (0, 0, 0, 80, 25, man);
	if (w) {
	    w->position |= WINDOW_UNMOVEABLE;
	    CFocus (CIdent ("mandisplayfile.text"));
	}
    }
    return 1;
}


