#ifndef TACTICS_H
#define TACTICS_H

#define PAWN_SCORE          (100)
#define ROOK_SCORE          (510)
#define KNIGHT_SCORE        (310)
#define BISHOP_SCORE        (325)
#define QUEEN_SCORE         (965)

#define LONE_QUEEN_BONUS    (35)
#define LONE_ROOK_BONUS     (50)
#define LONE_BISHOP_BONUS   (40)

#define ATTACKED_PAWN       (5)  /* Penalty */
#define ATTACKED_PIECE      (5)  /* Penalty */
#define QUEEN_ATTACK        (4)
#define ROOK_ATTACK         (3)
#define QUEEN_ENDGAME_BON   (5)

#define ATTACK_7TH_RANK     (10)
#define KING_TRAPPED        (10) /* Penalty */
#define CONNECTED_ROOKS     (16)
#define TWO_BISHOPS         (18)
#define CENTRE_PAWN_UNMOVED (8)  /* Penalty */

#define QUEEN_TRAPPED       (10) /* Penalty */
#define ROOK_TRAPPED        (8)  /* Penalty */
#define ROOK_TRAPPED_SIDE   (3)  /* Penalty */
#define ROOK_BLOCKED_H      (6)  /* Penalty */
#define BISHOP_TRAPPED      (5)  /* Penalty */

#define ROOK_ENPR           (30) /* Penalty */ 
#define KNIGHT_ENPR         (20) /* Penalty */
#define BISHOP_ENPR         (20) /* Penalty */
#define QUEEN_ENPR          (50) /* Penalty */

#define PASSED_PAWN_1       (3)
#define PASSED_PAWN_2       (6)
#define PASSED_PAWN_3       (18)

#define BACKWARD_PAWN_1     (2)
#define BACKWARD_PAWN_2     (0)
#define BACKWARD_PAWN_3     (-5)
#define BACKWARD_PAWN_4     (-12)
#define BACKWARD_PAWN_5     (-32)

#define DOUBLED_PAWNS       (16) /* Penalty */
#define DOUBLED_PAWNS_LATE  (20) /* Penalty */
#define DOUBLED_PAWNS_ISO   (4)  /* Penalty */
#define PAWN_BLOCKADE       (8)  /* Penalty */
#define HOSTILE_BLOCKADE    (11) /* Penalty */
#define PIECE_BLOCKADE      (3)  /* Penalty */
#define CENTRE_PAWN_BONUS   (3)
#define NO_CENTRE_PAWNS     (6)  /* Penalty */

#define NO_PAWNS            (12) /* Penalty */
#define NO_PAWNS_KPR        (12) /* Penalty */
#define NO_PAWNS_KPB        (22) /* Penalty */
#define NO_PAWNS_KPN        (24) /* Penalty */

#define CONNECTED_PP        (160)
#define CONNECTED_PP_DEF    (200)
#define CPP_7TH_RANK        (80)
#define ROOK_DEF_PP         (12)

#define PP_ATTACKED         (18) /* Penalty */
#define KING_SAFETY         (6)
#define KING_SAFETY_PP      (8)
#define UNSTOPPABLE_PP      (400)
#define KING_TROPISM        (5)
#define KING_TROPISM_MILD   (3)
#define KING_BUFFER         (28)
#define UNDEF_BACK_PAWN     (8)  /* Penalty */
#define ROOK_THREAT         (10) /* Penalty */
#define KING_PROT           (6)
#define PP_DEF_BON          (8)

#define OPEN_FILE           (8)
#define HALF_OPEN_FILE      (6)
#define OPEN_FILE_Q         (6)
#define HALF_OPEN_FILE_Q    (3)
#define OPEN_FILE_K         (6)  /* Penalty */
#define HALF_OPEN_FILE_K    (4)  /* Penalty */

#define BLOCK_PAWNS         (4)  /* Penalty */

#define EARLY_QUEEN_1       (16) /* Penalty */
#define EARLY_QUEEN_2       (8)  /* Penalty */
#define EARLY_QUEEN_3       (3)  /* Penalty */

#define BACK_RANK_UNSAFE    (6)  /* Penalty */
#define SPOILT_CASTLE_1     (7)  /* Penalty */
#define SPOILT_CASTLE_2     (9)  /* Penalty */
#define REWARD_CASTLE       (12)

#define DRIVE_AWAY_SHORT    (7)  /* Penalty */
#define DRIVE_AWAY_LONG     (4)  /* Penalty */

#define DOUBLED_PAWNS_KPR   (28) /* Penalty */
#define OPEN_FILE_KPR       (10)
#define ATTACK_PAWN_KPR     (10)
#define DEFENDING_BLOCKED   (16) /* Penalty */
#define DEF_PAWN_KPR        (6)
#define DEF_PP_KPR          (30)
#define DANGEROUS_PP_KPR    (20)
#define TWO_ROOKS           (32)

#define DOUBLED_PAWNS_KPB   (30) /* Penalty */
#define TWO_BISHOPS_KPB     (32)
#define CONN_PP_KPB         (80)
#define CONN_PP_DEF_KPB     (100)
#define CPP_7TH_RANK_KPB    (40)
#define DANGEROUS_PP_KPB    (32)

#define DOUBLED_PAWNS_KPN   (20) /* Penalty */
#define DANGEROUS_PP_KPN    (36)


int tact_pawn(const board *,int,int,int,const compdat *,int,int);
int tact_pawn_kp(const board *,int,int,int,int);
int tact_pawn_kpr(const board *,int,int,int,const compdat *,int);
int tact_pawn_kpb(const board *,int,int,int,const compdat *,int);
int tact_pawn_kpn(const board *,int,int,int,const compdat *,int);
int tact_rook(const board *,int,int,int);
int tact_rook_kpr(const board *,int,int,int);
int tact_knight(const board *,int,int,int,const compdat *);
int tact_knight_kpn(const board *,int,int,int,const compdat *);
int tact_bishop(const board *,int,int,int,const compdat *);
int tact_bishop_kpb(int,int,const compdat *);
int tact_queen(const board *,int,int,int,const compdat *);
int tact_king(const board *,int,int,int,const compdat *);
int tact_king_kp(const board *,int,int,int);
int tact_overall(const board *,int,const compdat *);
void tact_general(move *,const board *);
int backward_pawn(const board *,int,int,int);
int passed_pawn(const board *,int,int,int);
int drive_away(const board *,int,int,int);
int passed_pawn_kp(const board *,int,int,int);
int king_defence(const board *,int,int,int);
#endif /*  TACTICS_H */
