#include <stdlib.h>
#include <stdio.h>

#include "chess.h"
#include "moves.h"
#include "checks.h"

#define REVCHK   (0)   /* Use revealed checks in qui-search? */

extern tosquare temptsq[30];

/*  Move list functions. */
/*  Note - testing to see if move leaves side in check is done elsewhere. */
/*         Generally in the functions mvs() and mvs2() of mprocs.c */
/*  Oh, and yes, there _IS_ a large number of them, but it's faster to write */
/*         lots of specific functions like this, rather than a few generic ones. */

/*  First group (mppw - mpqb) gives board with 1's where piece can move */
/*    (and 2 where piece can defend friendly piece). */
/*    One function for each of white & black.  Hehe - function apartheid :) */

/*  Second group (mpk-mpr) adds the value 1 onto each square the piece */
/*    can move to legally. */

/*  Third group (mpql - mpnl) creates a list of all the piece's moves, */
/*    and returns the total number of moves.  mpbl has an extra int */
/*    argument for an offset so that it can be used from mpql to give */
/*    a list of queen moves by concatenating the bishop's moves onto the */
/*    end of a rook's moves. */

/*  Fourth group simply returns the number of places to which the piece can */
/*    move. (mpqc-mpnc) */

/*  Fifth group does the same as the third group, returning a list of possible */
/*    moves, but only returning the capture moves.  This is used for gencapt(). */
/*    (mpql_capt - mpnl_capt) */

/*  Sixth group returns all non-quiescent moves, i.e. captures, checks and */
/*    pawn pushes past 5th rank. (mpql_qui - mpnl_qui) */

void mppw(int px,int py,int sq[8][8],board *mp) {
  if (py==6 && sq[5][px]==0 && sq[4][px]==0) mp->sq[4][px]=1;
  if (py>0 && sq[py-1][px]==0) mp->sq[py-1][px]=1;
  if (px>0 && py>0) {
	if (sq[py-1][px-1]<0) mp->sq[py-1][px-1]=1;
	else mp->sq[py-1][px-1]=2;
  }
  if (px<7 && py>0) {
	if (sq[py-1][px+1]<0) mp->sq[py-1][px+1]=1;
	else mp->sq[py-1][px+1]=2;
  }
}

void mprw(int px,int py,int sq[8][8],board *mp) {
  int a;

  a=px;
  if (a<7) {
	do {
	  a++;
	  if (sq[py][a]<1) mp->sq[py][a]=1;
	  else mp->sq[py][a]=2;
	} while (a<7 && sq[py][a]==0);
  }
  a=px;
  if (a>0) {
	do {
	  a--;
	  if (sq[py][a]<1) mp->sq[py][a]=1;
	  else mp->sq[py][a]=2;
	} while (a>0 && sq[py][a]==0);
  }
  a=py;
  if (a<7) {
	do {
	  a++;
	  if (sq[a][px]<1) mp->sq[a][px]=1;
	  else mp->sq[a][px]=2;
	} while (a<7 && sq[a][px]==0);
  }
  a=py;
  if (a>0) {
	do {
	  a--;
	  if (sq[a][px]<1) mp->sq[a][px]=1;
	  else mp->sq[a][px]=2;
	} while (a>0 && sq[a][px]==0);
  }
}

void mpnw(int px,int py,int sq[8][8],board *mp) {
  if (px<7) {
	if (py>1) {
	  if (sq[py-2][px+1]<1) mp->sq[py-2][px+1]=1;
	  else mp->sq[py-2][px+1]=2;
	}
	if (py<6) {
	  if (sq[py+2][px+1]<1) mp->sq[py+2][px+1]=1;
	  else mp->sq[py+2][px+1]=2;
	}
  }
  if (px<6) {
	if (py>0) {
	  if (sq[py-1][px+2]<1) mp->sq[py-1][px+2]=1;
	  else mp->sq[py-1][px+2]=2;
	}
	if (py<7) {
	  if (sq[py+1][px+2]<1) mp->sq[py+1][px+2]=1;
	  else mp->sq[py+1][px+2]=2;
	}
  }
  if (px>0) {
	if (py>1) {
	  if (sq[py-2][px-1]<1) mp->sq[py-2][px-1]=1;
	  else mp->sq[py-2][px-1]=2;
	}
	if (py<6) {
	  if (sq[py+2][px-1]<1) mp->sq[py+2][px-1]=1;
	  else mp->sq[py+2][px-1]=2;
	}
  }
  if (px>1) {
	if (py>0) {
	  if (sq[py-1][px-2]<1) mp->sq[py-1][px-2]=1;
	  else mp->sq[py-1][px-2]=2;
	}
	if (py<7) {
	  if (sq[py+1][px-2]<1) mp->sq[py+1][px-2]=1;
	  else mp->sq[py+1][px-2]=2;
	}
  }
}

void mpbw(int px,int py,int sq[8][8],board *mp) {
  int a,b;

  a=px;
  b=py;
  if (a<7 && b<7) {
	do {
	  a++;
	  b++;
	  if (sq[b][a]<1) mp->sq[b][a]=1;
	  else mp->sq[b][a]=2;
	} while (a<7 && b<7 && sq[b][a]==0);
  }
  a=px;
  b=py;
  if (a<7 && b>0) {
	do {
	  a++;
	  b--;
	  if (sq[b][a]<1) mp->sq[b][a]=1;
	  else mp->sq[b][a]=2;
	} while (a<7 && b>0 && sq[b][a]==0);
  }
  a=px;
  b=py;
  if (a>0 && b<7) {
	do {
	  a--;
	  b++;
	  if (sq[b][a]<1) mp->sq[b][a]=1;
	  else mp->sq[b][a]=2;
	} while (a>0 && b<7 && sq[b][a]==0);
  }
  a=px;
  b=py;
  if (a>0 && b>0) {
	do {
	  a--;
	  b--;
	  if (sq[b][a]<1) mp->sq[b][a]=1;
	  else mp->sq[b][a]=2;
	} while (a>0 && b>0 && sq[b][a]==0);
  }
}

void mpkw(int px,int py,int sq[8][8],board *mp) {
  if (px>0) {
	if (sq[py][px-1]<1) mp->sq[py][px-1]=1;
	else mp->sq[py][px-1]=2;
	if (py>0) {
          if (sq[py-1][px-1]<1) mp->sq[py-1][px-1]=1;
          else mp->sq[py-1][px-1]=2;
	}
	if (py<7) {
          if (sq[py+1][px-1]<1) mp->sq[py+1][px-1]=1;
          else mp->sq[py+1][px-1]=2;
	}
  }
  if (px<7) {
        if (sq[py][px+1]<1) mp->sq[py][px+1]=1;
        else mp->sq[py][px+1]=2;
	if (py>0) {
          if (sq[py-1][px+1]<1) mp->sq[py-1][px+1]=1;
          else mp->sq[py-1][px+1]=2;
	}
	if (py<7) {
          if (sq[py+1][px+1]<1) mp->sq[py+1][px+1]=1;
          else mp->sq[py+1][px+1]=2;
	}
  }
  if (py>0) {
        if (sq[py-1][px]<1) mp->sq[py-1][px]=1;
        else mp->sq[py-1][px]=2;
  }
  if (py<7) {
        if (sq[py+1][px]<1) mp->sq[py+1][px]=1;
        else mp->sq[py+1][px]=2;
  }
}

void mpqw(int px,int py,int sq[8][8],board *mp) {
  mprw(px,py,sq,mp);
  mpbw(px,py,sq,mp);
}

void mppb(int px,int py,int sq[8][8],board *mp) {
  if (py==1 && sq[2][px]==0 && sq[3][px]==0) mp->sq[3][px]=1;
  if (py<7 && sq[py+1][px]==0) mp->sq[py+1][px]=1;
  if (px>0 && py<7) {
	if (sq[py+1][px-1]>0) mp->sq[py+1][px-1]=1;
	else mp->sq[py+1][px-1]=2;
  }
  if (px<7 && py<7) {
	if (sq[py+1][px+1]>0) mp->sq[py+1][px+1]=1;
	else mp->sq[py+1][px+1]=2;
  }
}

void mprb(int px,int py,int sq[8][8],board *mp) {
  int a;
  a=px;
  if (a<7) {
	do {
	  a++;
          if (sq[py][a]>-1) mp->sq[py][a]=1;
		  else mp->sq[py][a]=2;
	} while (a<7 && sq[py][a]==0);
  }
  a=px;
  if (a>0) {
	do {
	  a--;
          if (sq[py][a]>-1) mp->sq[py][a]=1;
          else mp->sq[py][a]=2;
	} while (a>0 && sq[py][a]==0);
  }
  a=py;
  if (a<7) {
	do {
	  a++;
          if (sq[a][px]>-1) mp->sq[a][px]=1;
          else mp->sq[a][px]=2;
	} while (a<7 && sq[a][px]==0);
  }
  a=py;
  if (a>0) {
	do {
	  a--;
          if (sq[a][px]>-1) mp->sq[a][px]=1;
          else mp->sq[a][px]=2;
	} while (a>0 && sq[a][px]==0);
  }
}

void mpnb(int px,int py,int sq[8][8],board *mp) {
  if (px<7) {
	if (py>1) {
          if (sq[py-2][px+1]>-1) mp->sq[py-2][px+1]=1;
          else mp->sq[py-2][px+1]=2;
	}
	if (py<6) {
          if (sq[py+2][px+1]>-1) mp->sq[py+2][px+1]=1;
          else mp->sq[py+2][px+1]=2;
	}
  }
  if (px<6) {
	if (py>0) {
          if (sq[py-1][px+2]>-1) mp->sq[py-1][px+2]=1;
          else mp->sq[py-1][px+2]=2;
	}
	if (py<7) {
          if (sq[py+1][px+2]>-1) mp->sq[py+1][px+2]=1;
          else mp->sq[py+1][px+2]=2;
	}
  }
  if (px>0) {
	if (py>1) {
          if (sq[py-2][px-1]>-1) mp->sq[py-2][px-1]=1;
          else mp->sq[py-2][px-1]=2;
	}
	if (py<6) {
          if (sq[py+2][px-1]>-1) mp->sq[py+2][px-1]=1;
          else mp->sq[py+2][px-1]=2;
	}
  }
  if (px>1) {
	if (py>0) {
          if (sq[py-1][px-2]>-1) mp->sq[py-1][px-2]=1;
          else mp->sq[py-1][px-2]=2;
	}
	if (py<7) {
          if (sq[py+1][px-2]>-1) mp->sq[py+1][px-2]=1;
          else mp->sq[py+1][px-2]=2;
	}
  }
}

void mpbb(int px,int py,int sq[8][8],board *mp) {
  int a,b;

  a=px;
  b=py;
  if (a<7 && b<7) {
	do {
	  a++;
	  b++;
          if (sq[b][a]>-1) mp->sq[b][a]=1;
          else mp->sq[b][a]=2;
	} while (a<7 && b<7 && sq[b][a]==0);
  }
  a=px;
  b=py;
  if (a<7 && b>0) {
	do {
	  a++;
	  b--;
          if (sq[b][a]>-1) mp->sq[b][a]=1;
          else mp->sq[b][a]=2;
	} while (a<7 && b>0 && sq[b][a]==0);
  }
  a=px;
  b=py;
  if (a>0 && b<7) {
	do {
	  a--;
	  b++;
          if (sq[b][a]>-1) mp->sq[b][a]=1;
          else mp->sq[b][a]=2;
	} while (a>0 && b<7 && sq[b][a]==0);
  }
  a=px;
  b=py;
  if (a>0 && b>0) {
	do {
	  a--;
	  b--;
          if (sq[b][a]>-1) mp->sq[b][a]=1;
          else mp->sq[b][a]=2;
	} while (a>0 && b>0 && sq[b][a]==0);
  }
}

void mpkb(int px,int py,int sq[8][8],board *mp) {
  if (px>0) {
        if (sq[py][px-1]>-1) mp->sq[py][px-1]=1;
        else mp->sq[py][px-1]=2;
	if (py>0) {
          if (sq[py-1][px-1]>-1) mp->sq[py-1][px-1]=1;
          else mp->sq[py-1][px-1]=2;
	}
	if (py<7) {
          if (sq[py+1][px-1]>-1) mp->sq[py+1][px-1]=1;
          else mp->sq[py+1][px-1]=2;
	}
  }
  if (px<7) {
        if (sq[py][px+1]>-1) mp->sq[py][px+1]=1;
        else mp->sq[py][px+1]=2;
	if (py>0) {
          if (sq[py-1][px+1]>-1) mp->sq[py-1][px+1]=1;
          else mp->sq[py-1][px+1]=2;
	}
	if (py<7) {
          if (sq[py+1][px+1]>-1) mp->sq[py+1][px+1]=1;
          else mp->sq[py+1][px+1]=2;
	}
  }
  if (py>0) {
        if (sq[py-1][px]>-1) mp->sq[py-1][px]=1;
        else mp->sq[py-1][px]=2;
  }
  if (py<7) {
        if (sq[py+1][px]>-1) mp->sq[py+1][px]=1;
        else mp->sq[py+1][px]=2;
  }
}

void mpqb(int px,int py,int sq[8][8],board *mp) {
  mprb(px,py,sq,mp);
  mpbb(px,py,sq,mp);
}

/*  This set adds 1 to the squares in the given board where the */
/*     specified piece can move. */

void mpk(int px,int py,board *mp) {
  int a,b;
  for (a=py-1;a<py+2;a++) {
    if (a<0 || a>7) continue;
    for (b=px-1;b<px+2;b++) {
      if (b<0 || b>7 || (a==py && b==px)) continue;
      (mp->sq[a][b])++;
    }
  }
}

void mpn(int px,int py,board *mp) {
  if (px<7) {
    if (py>1) mp->sq[py-2][px+1]++;
    if (py<6) mp->sq[py+2][px+1]++;
    if (px<6) {
      if (py>0) mp->sq[py-1][px+2]++;
      if (py<7) mp->sq[py+1][px+2]++;
    }
  }
  if (px>0) {
    if (py>1) mp->sq[py-2][px-1]++;
    if (py<6) mp->sq[py+2][px-1]++;
    if (px>1) {
      if (py>0) mp->sq[py-1][px-2]++;
      if (py<7) mp->sq[py+1][px-2]++;
    }
  }
}

void mpq(int px,int py,const board *sq,board *mp) {
  mpr(px,py,sq,mp);
  mpb(px,py,sq,mp);
}

void mpb(int px,int py,const board *sq,board *mp) {
  int a,b;

  if (px<7 && py<7) {
    a=px;b=py;
    do {
      a++;
      b++;
      mp->sq[b][a]++;
    } while (a<7 && b<7 && sq->sq[b][a]==0);
  }
  if (px<7 && py>0) {
    a=px;b=py;
    do {
      a++;
      b--;
      mp->sq[b][a]++;
    } while (a<7 && b>0 && sq->sq[b][a]==0);
  }
  if (px>0 && py<7) {
    a=px;b=py;
    do {
      a--;
      b++;
      mp->sq[b][a]++;
    } while (a>0 && b<7 && sq->sq[b][a]==0);
  }
  if (px>0 && py>0) {
    a=px;b=py;
    do {
      a--;
      b--;
      mp->sq[b][a]++;
    } while (a>0 && b>0 && sq->sq[b][a]==0);
  }
}

void mpr(int px,int py,const board *sq,board *mp) {
  int a;

  if (px<7) {
    a=px;
    do {
      a++;
      mp->sq[py][a]++;
    } while (a<7 && sq->sq[py][a]==0);
  }
  if (px>0) {
    a=px;
    do {
      a--;
      mp->sq[py][a]++;
    } while (a>0 && sq->sq[py][a]==0);
  }
  if (py<7) {
    a=py;
    do {
      a++;
      mp->sq[a][px]++;
    } while (a<7 && sq->sq[a][px]==0);
  }
  if (py>0) {
    a=py;
    do {
      a--;
      mp->sq[a][px]++;
    } while (a>0 && sq->sq[a][px]==0);
  }
}

/*  These functions produce a list of possible moves for the */
/*     specified piece. */

int mpql(int px,int py,const board *sq,int side) {
  int a=0;
  a=mprl(px,py,sq,side);
  return mpbl(px,py,sq,side,a);
}

int mppl(int px,int py,const board *sq,int side) {
  int a=0;
  if (side==WHITE) {
    if (py==6 && sq->sq[5][px]==0 && sq->sq[4][px]==0) {temptsq[a].tx=px;temptsq[a].ty=4;a++;}
    if (py>0) {
      if (sq->sq[py-1][px]==0) {temptsq[a].ty=py-1;temptsq[a].tx=px;a++;}
      if (px>0 && sq->sq[py-1][px-1]<0) {temptsq[a].ty=py-1;temptsq[a].tx=px-1;a++;}
      if (px<7 && sq->sq[py-1][px+1]<0) {temptsq[a].ty=py-1;temptsq[a].tx=px+1;a++;}
    }
  }
  else {
    if (py==1 && sq->sq[2][px]==0 && sq->sq[3][px]==0) {temptsq[a].tx=px;temptsq[a].ty=3;a++;}
    if (py<7) {
      if (sq->sq[py+1][px]==0) {temptsq[a].ty=py+1;temptsq[a].tx=px;a++;}
      if (px>0 && sq->sq[py+1][px-1]>0) {temptsq[a].ty=py+1;temptsq[a].tx=px-1;a++;}
      if (px<7 && sq->sq[py+1][px+1]>0) {temptsq[a].ty=py+1;temptsq[a].tx=px+1;a++;}
    }
  }
  return a;
}

int mprl(int px,int py,const board *sq,int side) {
  int a,n=0;

  if (px<7) {
    a=px;
    do {
      a++;
      if ((side==WHITE && sq->sq[py][a]<1) || (side==BLACK && sq->sq[py][a]>-1)) {temptsq[n].tx=a;temptsq[n].ty=py;n++;}
    } while (a<7 && sq->sq[py][a]==0);
  }
  if (px>0) {
    a=px;
    do {
      a--;
      if ((side==WHITE && sq->sq[py][a]<1) || (side==BLACK && sq->sq[py][a]>-1)) {temptsq[n].tx=a;temptsq[n].ty=py;n++;}
    } while (a>0 && sq->sq[py][a]==0);
  }
  if (py<7) {
    a=py;
    do {
      a++;
      if ((side==WHITE && sq->sq[a][px]<1) || (side==BLACK && sq->sq[a][px]>-1)) {temptsq[n].tx=px;temptsq[n].ty=a;n++;}
    } while (a<7 && sq->sq[a][px]==0);
  }
  if (py>0) {
    a=py;
    do {
      a--;
      if ((side==WHITE && sq->sq[a][px]<1) || (side==BLACK && sq->sq[a][px]>-1)) {temptsq[n].tx=px;temptsq[n].ty=a;n++;}
    } while (a>0 && sq->sq[a][px]==0);
  }
  return n;
}

int mpbl(int px,int py,const board *sq,int side,int first) {
  int a,b,n=first;

  if (px<7 && py<7) {
    a=px;b=py;
    do {
      a++;
      b++;
      if ((side==WHITE && sq->sq[b][a]<1) || (side==BLACK && sq->sq[b][a]>-1)) {temptsq[n].tx=a;temptsq[n].ty=b;n++;}
    } while (a<7 && b<7 && sq->sq[b][a]==0);
  }
  if (px<7 && py>0) {
    a=px;b=py;
    do {
      a++;
      b--;
      if ((side==WHITE && sq->sq[b][a]<1) || (side==BLACK && sq->sq[b][a]>-1)) {temptsq[n].tx=a;temptsq[n].ty=b;n++;}
    } while (a<7 && b>0 && sq->sq[b][a]==0);
  }
  if (px>0 && py<7) {
    a=px;b=py;
    do {
      a--;
      b++;
      if ((side==WHITE && sq->sq[b][a]<1) || (side==BLACK && sq->sq[b][a]>-1)) {temptsq[n].tx=a;temptsq[n].ty=b;n++;}
    } while (a>0 && b<7 && sq->sq[b][a]==0);
  }
  if (px>0 && py>0) {
    a=px;b=py;
    do {
      a--;
      b--;
      if ((side==WHITE && sq->sq[b][a]<1) || (side==BLACK && sq->sq[b][a]>-1)) {temptsq[n].tx=a;temptsq[n].ty=b;n++;}
    } while (a>0 && b>0 && sq->sq[b][a]==0);
  }
  return n;
}

int mpnl(int px,int py,const board *sq,int side) {
  int n=0;
  if (px<7) {
    if (py>1) if ((side==WHITE && sq->sq[py-2][px+1]<1) || (side==BLACK && sq->sq[py-2][px+1]>-1)) {temptsq[n].tx=px+1;temptsq[n].ty=py-2;n++;}
    if (py<6) if ((side==WHITE && sq->sq[py+2][px+1]<1) || (side==BLACK && sq->sq[py+2][px+1]>-1)) {temptsq[n].tx=px+1;temptsq[n].ty=py+2;n++;}
    if (px<6) {
      if (py>0) if ((side==WHITE && sq->sq[py-1][px+2]<1) || (side==BLACK && sq->sq[py-1][px+2]>-1)) {temptsq[n].tx=px+2;temptsq[n].ty=py-1;n++;}
      if (py<7) if ((side==WHITE && sq->sq[py+1][px+2]<1) || (side==BLACK && sq->sq[py+1][px+2]>-1)) {temptsq[n].tx=px+2;temptsq[n].ty=py+1;n++;}
    }
  }
  if (px>0) {
    if (py>1) if ((side==WHITE && sq->sq[py-2][px-1]<1) || (side==BLACK && sq->sq[py-2][px-1]>-1)) {temptsq[n].tx=px-1;temptsq[n].ty=py-2;n++;}
    if (py<6) if ((side==WHITE && sq->sq[py+2][px-1]<1) || (side==BLACK && sq->sq[py+2][px-1]>-1)) {temptsq[n].tx=px-1;temptsq[n].ty=py+2;n++;}
    if (px>1) {
      if (py>0) if ((side==WHITE && sq->sq[py-1][px-2]<1) || (side==BLACK && sq->sq[py-1][px-2]>-1)) {temptsq[n].tx=px-2;temptsq[n].ty=py-1;n++;}
      if (py<7) if ((side==WHITE && sq->sq[py+1][px-2]<1) || (side==BLACK && sq->sq[py+1][px-2]>-1)) {temptsq[n].tx=px-2;temptsq[n].ty=py+1;n++;}
    }
  }
  return n;
}

/*  returns the number of possible moves for the specified piece */

int mpqc(int px,int py,const board *sq,int side) {
  return mprc(px,py,sq,side)+mpbc(px,py,sq,side);
}

int mppc(int px,int py,const board *sq,int side) {
  int a=0;

  if (side==WHITE) {
    if (py==6 && sq->sq[5][px]==0 && sq->sq[4][px]==0) a++;
    if (py>0) {
      if (sq->sq[py-1][px]==0) a++;
      if (px>0 && sq->sq[py-1][px-1]<0) a++;
      if (px<7 && sq->sq[py-1][px+1]<0) a++;
    }
  }
  else {
    if (py==1 && sq->sq[2][px]==0 && sq->sq[3][px]==0) a++;
    if (py<7) {
      if (sq->sq[py+1][px]==0) a++;
      if (px>0 && sq->sq[py+1][px-1]>0) a++;
      if (px<7 && sq->sq[py+1][px+1]>0) a++;
    }
  }
  return a;
}

int mprc(int px,int py,const board *sq,int side) {
  int a,n=0;

  if (px<7) {
    a=px;
    do {
      a++;
      if ((side==WHITE && sq->sq[py][a]<1) || (side==BLACK && sq->sq[py][a]>-1)) n++;
    } while (a<7 && sq->sq[py][a]==0);
  }
  if (px>0) {
    a=px;
    do {
      a--;
      if ((side==WHITE && sq->sq[py][a]<1) || (side==BLACK && sq->sq[py][a]>-1)) n++;
    } while (a>0 && sq->sq[py][a]==0);
  }
  if (py<7) {
    a=py;
    do {
      a++;
      if ((side==WHITE && sq->sq[a][px]<1) || (side==BLACK && sq->sq[a][px]>-1)) n++;
    } while (a<7 && sq->sq[a][px]==0);
  }
  if (py>0) {
    a=py;
    do {
      a--;
      if ((side==WHITE && sq->sq[a][px]<1) || (side==BLACK && sq->sq[a][px]>-1)) n++;
    } while (a>0 && sq->sq[a][px]==0);
  }
  return n;
}

int mpbc(int px,int py,const board *sq,int side) {
  int a,b,n=0;

  if (px<7 && py<7) {
    a=px;b=py;
    do {
      a++;
      b++;
      if ((side==WHITE && sq->sq[b][a]<1) || (side==BLACK && sq->sq[b][a]>-1)) n++;
    } while (a<7 && b<7 && sq->sq[b][a]==0);
  }
  if (px<7 && py>0) {
    a=px;b=py;
    do {
      a++;
      b--;
      if ((side==WHITE && sq->sq[b][a]<1) || (side==BLACK && sq->sq[b][a]>-1)) n++;
    } while (a<7 && b>0 && sq->sq[b][a]==0);
  }
  if (px>0 && py<7) {
    a=px;b=py;
    do {
      a--;
      b++;
      if ((side==WHITE && sq->sq[b][a]<1) || (side==BLACK && sq->sq[b][a]>-1)) n++;
    } while (a>0 && b<7 && sq->sq[b][a]==0);
  }
  if (px>0 && py>0) {
    a=px;b=py;
    do {
      a--;
      b--;
      if ((side==WHITE && sq->sq[b][a]<1) || (side==BLACK && sq->sq[b][a]>-1)) n++;
    } while (a>0 && b>0 && sq->sq[b][a]==0);
  }
  return n;
}

int mpnc(int px,int py,const board *sq,int side) {
  int n=0;

  if (px<7) {
    if (py>1) if ((side==WHITE && sq->sq[py-2][px+1]<1) || (side==BLACK && sq->sq[py-2][px+1]>-1)) n++;
    if (py<6) if ((side==WHITE && sq->sq[py+2][px+1]<1) || (side==BLACK && sq->sq[py+2][px+1]>-1)) n++;
    if (px<6) {
      if (py>0) if ((side==WHITE && sq->sq[py-1][px+2]<1) || (side==BLACK && sq->sq[py-1][px+2]>-1)) n++;
      if (py<7) if ((side==WHITE && sq->sq[py+1][px+2]<1) || (side==BLACK && sq->sq[py+1][px+2]>-1)) n++;
    }
  }
  if (px>0) {
    if (py>1) if ((side==WHITE && sq->sq[py-2][px-1]<1) || (side==BLACK && sq->sq[py-2][px-1]>-1)) n++;
    if (py<6) if ((side==WHITE && sq->sq[py+2][px-1]<1) || (side==BLACK && sq->sq[py+2][px-1]>-1)) n++;
    if (px>1) {
      if (py>0) if ((side==WHITE && sq->sq[py-1][px-2]<1) || (side==BLACK && sq->sq[py-1][px-2]>-1)) n++;
      if (py<7) if ((side==WHITE && sq->sq[py+1][px-2]<1) || (side==BLACK && sq->sq[py+1][px-2]>-1)) n++;
    }
  }
  return n;
}

 /*  This set returns a list of all possible capture moves. */

int mpql_capt(int px,int py,const board *sq,int side) {
  int a=0;
  a=mprl_capt(px,py,sq,side);
  return mpbl_capt(px,py,sq,side,a);
}

int mppl_capt(int px,int py,const board *sq,int side) {
  int a=0;
  if (side==WHITE) {
    if (py>0) {
      if (px>0 && sq->sq[py-1][px-1]<0) {temptsq[a].ty=py-1;temptsq[a].tx=px-1;a++;}
      if (px<7 && sq->sq[py-1][px+1]<0) {temptsq[a].ty=py-1;temptsq[a].tx=px+1;a++;}
    }
  }
  else {
    if (py<7) {
      if (px>0 && sq->sq[py+1][px-1]>0) {temptsq[a].ty=py+1;temptsq[a].tx=px-1;a++;}
      if (px<7 && sq->sq[py+1][px+1]>0) {temptsq[a].ty=py+1;temptsq[a].tx=px+1;a++;}
    }
  }
  return a;
}

int mprl_capt(int px,int py,const board *sq,int side) {
  int a,n=0;

  if (px<7) {
    a=px;
    do {
      a++;
      if ((side==WHITE && sq->sq[py][a]<0) || (side==BLACK && sq->sq[py][a]>0)) {temptsq[n].tx=a;temptsq[n].ty=py;n++;}
    } while (a<7 && sq->sq[py][a]==0);
  }
  if (px>0) {
    a=px;
    do {
      a--;
      if ((side==WHITE && sq->sq[py][a]<0) || (side==BLACK && sq->sq[py][a]>0)) {temptsq[n].tx=a;temptsq[n].ty=py;n++;}
    } while (a>0 && sq->sq[py][a]==0);
  }
  if (py<7) {
    a=py;
    do {
      a++;
      if ((side==WHITE && sq->sq[a][px]<0) || (side==BLACK && sq->sq[a][px]>0)) {temptsq[n].tx=px;temptsq[n].ty=a;n++;}
    } while (a<7 && sq->sq[a][px]==0);
  }
  if (py>0) {
    a=py;
    do {
      a--;
      if ((side==WHITE && sq->sq[a][px]<0) || (side==BLACK && sq->sq[a][px]>0)) {temptsq[n].tx=px;temptsq[n].ty=a;n++;}
    } while (a>0 && sq->sq[a][px]==0);
  }
  return n;
}

int mpbl_capt(int px,int py,const board *sq,int side,int first) {
  int a,b,n=first;

  if (px<7 && py<7) {
    a=px;b=py;
    do {
      a++;
      b++;
      if ((side==WHITE && sq->sq[b][a]<0) || (side==BLACK && sq->sq[b][a]>0)) {temptsq[n].tx=a;temptsq[n].ty=b;n++;}
    } while (a<7 && b<7 && sq->sq[b][a]==0);
  }
  if (px<7 && py>0) {
    a=px;b=py;
    do {
      a++;
      b--;
      if ((side==WHITE && sq->sq[b][a]<0) || (side==BLACK && sq->sq[b][a]>0)) {temptsq[n].tx=a;temptsq[n].ty=b;n++;}
    } while (a<7 && b>0 && sq->sq[b][a]==0);
  }
  if (px>0 && py<7) {
    a=px;b=py;
    do {
      a--;
      b++;
      if ((side==WHITE && sq->sq[b][a]<0) || (side==BLACK && sq->sq[b][a]>0)) {temptsq[n].tx=a;temptsq[n].ty=b;n++;}
    } while (a>0 && b<7 && sq->sq[b][a]==0);
  }
  if (px>0 && py>0) {
    a=px;b=py;
    do {
      a--;
      b--;
      if ((side==WHITE && sq->sq[b][a]<0) || (side==BLACK && sq->sq[b][a]>0)) {temptsq[n].tx=a;temptsq[n].ty=b;n++;}
    } while (a>0 && b>0 && sq->sq[b][a]==0);
  }
  return n;
}

int mpnl_capt(int px,int py,const board *sq,int side) {
  int n=0;
  if (px<7) {
    if (py>1) if ((side==WHITE && sq->sq[py-2][px+1]<0) || (side==BLACK && sq->sq[py-2][px+1]>0)) {temptsq[n].tx=px+1;temptsq[n].ty=py-2;n++;}
    if (py<6) if ((side==WHITE && sq->sq[py+2][px+1]<0) || (side==BLACK && sq->sq[py+2][px+1]>0)) {temptsq[n].tx=px+1;temptsq[n].ty=py+2;n++;}
    if (px<6) {
      if (py>0) if ((side==WHITE && sq->sq[py-1][px+2]<0) || (side==BLACK && sq->sq[py-1][px+2]>0)) {temptsq[n].tx=px+2;temptsq[n].ty=py-1;n++;}
      if (py<7) if ((side==WHITE && sq->sq[py+1][px+2]<0) || (side==BLACK && sq->sq[py+1][px+2]>0)) {temptsq[n].tx=px+2;temptsq[n].ty=py+1;n++;}
    }
  }
  if (px>0) {
    if (py>1) if ((side==WHITE && sq->sq[py-2][px-1]<0) || (side==BLACK && sq->sq[py-2][px-1]>0)) {temptsq[n].tx=px-1;temptsq[n].ty=py-2;n++;}
    if (py<6) if ((side==WHITE && sq->sq[py+2][px-1]<0) || (side==BLACK && sq->sq[py+2][px-1]>0)) {temptsq[n].tx=px-1;temptsq[n].ty=py+2;n++;}
    if (px>1) {
      if (py>0) if ((side==WHITE && sq->sq[py-1][px-2]<0) || (side==BLACK && sq->sq[py-1][px-2]>0)) {temptsq[n].tx=px-2;temptsq[n].ty=py-1;n++;}
      if (py<7) if ((side==WHITE && sq->sq[py+1][px-2]<0) || (side==BLACK && sq->sq[py+1][px-2]>0)) {temptsq[n].tx=px-2;temptsq[n].ty=py+1;n++;}
    }
  }
  return n;
}

/*  This set gives all possible captures, checks and pawn pushes within 2 of promotion
 *  Note - does not generate revealed checks */

int mppl_qui(int px,int py,const board *sq,int side) {
  int a=0;

  if (side==WHITE) {
    if (py>0) {
      if (px>0 && sq->sq[py-1][px-1]<0) {temptsq[a].ty=py-1;temptsq[a].tx=px-1;a++;}
      if (px<7 && sq->sq[py-1][px+1]<0) {temptsq[a].ty=py-1;temptsq[a].tx=px+1;a++;}
      if (sq->sq[py-1][px]==0) {
	if (py<3) {temptsq[a].ty=py-1;temptsq[a].tx=px;a++;}
	else if (px>0 && py>1 && sq->sq[py-2][px-1]==-6)  {temptsq[a].ty=py-1;temptsq[a].tx=px;a++;}
	else if (px<7 && py>1 && sq->sq[py-2][px+1]==-6)  {temptsq[a].ty=py-1;temptsq[a].tx=px;a++;}
	if (py==6 && sq->sq[4][px]==0) {
	  if (px>0 && sq->sq[3][px-1]==-6)  {temptsq[a].ty=4;temptsq[a].tx=px;a++;}
	  if (px<7 && sq->sq[3][px+1]==-6)  {temptsq[a].ty=4;temptsq[a].tx=px;a++;}	  
	}
      }
    }
  }
  else {
    if (py<7) {
      if (px>0 && sq->sq[py+1][px-1]>0) {temptsq[a].ty=py+1;temptsq[a].tx=px-1;a++;}
      if (px<7 && sq->sq[py+1][px+1]>0) {temptsq[a].ty=py+1;temptsq[a].tx=px+1;a++;}
      if (sq->sq[py+1][px]==0) {
	if (py>4) {temptsq[a].ty=py+1;temptsq[a].tx=px;a++;}
	else if (px>0 && py<6 && sq->sq[py+2][px-1]==6)  {temptsq[a].ty=py+1;temptsq[a].tx=px;a++;}
	else if (px<7 && py<6 && sq->sq[py+2][px+1]==6)  {temptsq[a].ty=py+1;temptsq[a].tx=px;a++;}
	if (py==1 && sq->sq[3][px]==0) {
	  if (px>0 && sq->sq[4][px-1]==6)  {temptsq[a].ty=3;temptsq[a].tx=px;a++;}
	  if (px<7 && sq->sq[4][px+1]==6)  {temptsq[a].ty=3;temptsq[a].tx=px;a++;}	  
	}
      }
    }
  }
  return a;
}

 /* Generates all rook moves which capture a piece or give check, either
  * directly or by revealed check */
int mprl_qui(int px,int py,const board *sq,int side,int kx,int ky) {
  int a,n=0,rchk=0;

  if (px<7) {
    if (REVCHK && revchck(sq,3-side,px,py,px+1,py)) rchk=1;
    else rchk=0;
    a=px;
    do {
      a++;
      if ((side==WHITE && (sq->sq[py][a]-rchk)<0) || (side==BLACK && (sq->sq[py][a]+rchk)>0)) {temptsq[n].tx=a;temptsq[n].ty=py;n++;}
      else if (sq->sq[py][a]==0 && a==kx && check_spaces(sq,a,py,kx,ky,0)) {temptsq[n].tx=a;temptsq[n].ty=py;n++;}
    } while (a<7 && sq->sq[py][a]==0);
  }
  if (px>0) {
    if (REVCHK && revchck(sq,3-side,px,py,px-1,py)) rchk=1;
    else rchk=0;
    a=px;
    do {
      a--;
      if ((side==WHITE && (sq->sq[py][a]-rchk)<0) || (side==BLACK && (sq->sq[py][a]+rchk)>0)) {temptsq[n].tx=a;temptsq[n].ty=py;n++;}
      else if (sq->sq[py][a]==0 && a==kx && check_spaces(sq,a,py,kx,ky,0)) {temptsq[n].tx=a;temptsq[n].ty=py;n++;}
    } while (a>0 && sq->sq[py][a]==0);
  }
  if (py<7) {
    if (REVCHK && revchck(sq,3-side,px,py,px,py+1)) rchk=1;
    else rchk=0;
    a=py;
    do {
      a++;
      if ((side==WHITE && (sq->sq[a][px]-rchk)<0) || (side==BLACK && (sq->sq[a][px]+rchk)>0)) {temptsq[n].tx=px;temptsq[n].ty=a;n++;}
      else if (sq->sq[a][px]==0 && a==ky && check_spaces(sq,px,a,kx,ky,0)) {temptsq[n].tx=px;temptsq[n].ty=a;n++;}
    } while (a<7 && sq->sq[a][px]==0);
  }
  if (py>0) {
    if (REVCHK && revchck(sq,3-side,px,py,px,py-1)) rchk=1;
    else rchk=0;
    a=py;
    do {
      a--;
      if ((side==WHITE && (sq->sq[a][px]-rchk)<0) || (side==BLACK && (sq->sq[a][px]+rchk)>0)) {temptsq[n].tx=px;temptsq[n].ty=a;n++;}
      else if (sq->sq[a][px]==0 && a==ky && check_spaces(sq,px,a,kx,ky,0)) {temptsq[n].tx=px;temptsq[n].ty=a;n++;}
    } while (a>0 && sq->sq[a][px]==0);
  }
  return n;
}

 /* Generates all bishop moves which capture a piece or give direct check */
int mpbl_qui(int px,int py,const board *sq,int side,int kx,int ky,int first) {
  int a,b,n=first,rchk=0;

  if (px<7 && py<7) {
    if (REVCHK && revchck(sq,3-side,px,py,px+1,py+1)) rchk=1;
    else rchk=0;
    a=px;b=py;
    do {
      a++;
      b++;
      if ((side==WHITE && (sq->sq[b][a]-rchk)<0) || (side==BLACK && (sq->sq[b][a]+rchk)>0)) {temptsq[n].tx=a;temptsq[n].ty=b;n++;}
      else if (sq->sq[b][a]==0 && abs(kx-a)==abs(ky-b) && check_spaces(sq,a,b,kx,ky,1)) {temptsq[n].tx=a;temptsq[n].ty=b;n++;}
    } while (a<7 && b<7 && sq->sq[b][a]==0);
  }
  if (px<7 && py>0) {
    if (REVCHK && revchck(sq,3-side,px,py,px+1,py-1)) rchk=1;
    else rchk=0;
    a=px;b=py;
    do {
      a++;
      b--;
      if ((side==WHITE && (sq->sq[b][a]-rchk)<0) || (side==BLACK && (sq->sq[b][a]+rchk)>0)) {temptsq[n].tx=a;temptsq[n].ty=b;n++;}
      else if (sq->sq[b][a]==0 && abs(kx-a)==abs(ky-b) && check_spaces(sq,a,b,kx,ky,1)) {temptsq[n].tx=a;temptsq[n].ty=b;n++;}
    } while (a<7 && b>0 && sq->sq[b][a]==0);
  }
  if (px>0 && py<7) {
    if (REVCHK && revchck(sq,3-side,px,py,px-1,py+1)) rchk=1;
    else rchk=0;
    a=px;b=py;
    do {
      a--;
      b++;
      if ((side==WHITE && (sq->sq[b][a]-rchk)<0) || (side==BLACK && (sq->sq[b][a]+rchk)>0)) {temptsq[n].tx=a;temptsq[n].ty=b;n++;}
      else if (sq->sq[b][a]==0 && abs(kx-a)==abs(ky-b) && check_spaces(sq,a,b,kx,ky,1)) {temptsq[n].tx=a;temptsq[n].ty=b;n++;}
    } while (a>0 && b<7 && sq->sq[b][a]==0);
  }
  if (px>0 && py>0) {
    if (REVCHK && revchck(sq,3-side,px,py,px-1,py-1)) rchk=1;
    else rchk=0;
    a=px;b=py;
    do {
      a--;
      b--;
      if ((side==WHITE && (sq->sq[b][a]-rchk)<0) || (side==BLACK && (sq->sq[b][a]+rchk)>0)) {temptsq[n].tx=a;temptsq[n].ty=b;n++;}
      else if (sq->sq[b][a]==0 && abs(kx-a)==abs(ky-b) && check_spaces(sq,a,b,kx,ky,1)) {temptsq[n].tx=a;temptsq[n].ty=b;n++;}
    } while (a>0 && b>0 && sq->sq[b][a]==0);
  }
  return n;
}

 /* Generates all knight moves which capture a piece or give check either
  *  directly or by revealed check */
int mpnl_qui(int px,int py,const board *sq,int side,int kx,int ky) {
  int n=0;
  if (side==WHITE) {
    if (px<7) {
      if (py>1) if (sq->sq[py-2][px+1]<0 || (sq->sq[py-2][px+1]==0 && REVCHK && revchck(sq,3-side,px,py,px+1,py-2)) || (sq->sq[py-2][px+1]==0 && py-2!=ky && px+1!=kx && abs(py-2-ky)+abs(px+1-kx)==3)) {temptsq[n].tx=px+1;temptsq[n].ty=py-2;n++;}
      if (py<6) if (sq->sq[py+2][px+1]<0 || (sq->sq[py+2][px+1]==0 && REVCHK && revchck(sq,3-side,px,py,px+1,py+2)) || (sq->sq[py+2][px+1]==0 && py+2!=ky && px+1!=kx && abs(py+2-ky)+abs(px+1-kx)==3)) {temptsq[n].tx=px+1;temptsq[n].ty=py+2;n++;}
      if (px<6) {
        if (py>0) if (sq->sq[py-1][px+2]<0 || (sq->sq[py-1][px+2]==0 && REVCHK && revchck(sq,3-side,px,py,px+2,py-1)) || (sq->sq[py-1][px+2]==0 && py-1!=ky && px+2!=kx && abs(py-1-ky)+abs(px+2-kx)==3)) {temptsq[n].tx=px+2;temptsq[n].ty=py-1;n++;}
        if (py<7) if (sq->sq[py+1][px+2]<0 || (sq->sq[py+1][px+2]==0 && REVCHK && revchck(sq,3-side,px,py,px+2,py+1)) || (sq->sq[py+1][px+2]==0 && py+1!=ky && px+2!=kx && abs(py+1-ky)+abs(px+2-kx)==3)) {temptsq[n].tx=px+2;temptsq[n].ty=py+1;n++;}
      }
    }
    if (px>0) {
      if (py>1) if (sq->sq[py-2][px-1]<0 || (sq->sq[py-2][px-1]==0 && REVCHK && revchck(sq,3-side,px,py,px-1,py-2)) || (sq->sq[py-2][px-1]==0 && py-2!=ky && px-1!=kx && abs(py-2-ky)+abs(px-1-kx)==3)) {temptsq[n].tx=px-1;temptsq[n].ty=py-2;n++;}
      if (py<6) if (sq->sq[py+2][px-1]<0 || (sq->sq[py+2][px-1]==0 && REVCHK && revchck(sq,3-side,px,py,px-1,py+2)) || (sq->sq[py+2][px-1]==0 && py+2!=ky && px-1!=kx && abs(py+2-ky)+abs(px-1-kx)==3)) {temptsq[n].tx=px-1;temptsq[n].ty=py+2;n++;}
      if (px>1) {
        if (py>0) if (sq->sq[py-1][px-2]<0 || (sq->sq[py-1][px-2]==0 && REVCHK && revchck(sq,3-side,px,py,px-2,py-1)) || (sq->sq[py-1][px-2]==0 && py-1!=ky && px-2!=kx && abs(py-1-ky)+abs(px-2-kx)==3)) {temptsq[n].tx=px-2;temptsq[n].ty=py-1;n++;}
        if (py<7) if (sq->sq[py+1][px-2]<0 || (sq->sq[py+1][px-2]==0 && REVCHK && revchck(sq,3-side,px,py,px-2,py+1)) || (sq->sq[py+1][px-2]==0 && py+1!=ky && px-2!=kx && abs(py+1-ky)+abs(px-2-kx)==3)) {temptsq[n].tx=px-2;temptsq[n].ty=py+1;n++;}
      }
    }
  }
  else {
    if (px<7) {
      if (py>1) if (sq->sq[py-2][px+1]>0 || (sq->sq[py-2][px+1]==0 && REVCHK && revchck(sq,3-side,px,py,px+1,py-2)) || (sq->sq[py-2][px+1]==0 && py-2!=ky && px+1!=kx && abs(py-2-ky)+abs(px+1-kx)==3)) {temptsq[n].tx=px+1;temptsq[n].ty=py-2;n++;}
      if (py<6) if (sq->sq[py+2][px+1]>0 || (sq->sq[py+2][px+1]==0 && REVCHK && revchck(sq,3-side,px,py,px+1,py+2)) || (sq->sq[py+2][px+1]==0 && py+2!=ky && px+1!=kx && abs(py+2-ky)+abs(px+1-kx)==3)) {temptsq[n].tx=px+1;temptsq[n].ty=py+2;n++;}
      if (px<6) {
        if (py>0) if (sq->sq[py-1][px+2]>0 || (sq->sq[py-1][px+2]==0 && REVCHK && revchck(sq,3-side,px,py,px+2,py-1)) || (sq->sq[py-1][px+2]==0 && py-1!=ky && px+2!=kx && abs(py-1-ky)+abs(px+2-kx)==3)) {temptsq[n].tx=px+2;temptsq[n].ty=py-1;n++;}
        if (py<7) if (sq->sq[py+1][px+2]>0 || (sq->sq[py+1][px+2]==0 && REVCHK && revchck(sq,3-side,px,py,px+2,py+1)) || (sq->sq[py+1][px+2]==0 && py+1!=ky && px+2!=kx && abs(py+1-ky)+abs(px+2-kx)==3)) {temptsq[n].tx=px+2;temptsq[n].ty=py+1;n++;}
      }
    }
    if (px>0) {
      if (py>1) if (sq->sq[py-2][px-1]>0 || (sq->sq[py-2][px-1]==0 && REVCHK && revchck(sq,3-side,px,py,px-1,py-2)) || (sq->sq[py-2][px-1]==0 && py-2!=ky && px-1!=kx && abs(py-2-ky)+abs(px-1-kx)==3)) {temptsq[n].tx=px-1;temptsq[n].ty=py-2;n++;}
      if (py<6) if (sq->sq[py+2][px-1]>0 || (sq->sq[py+2][px-1]==0 && REVCHK && revchck(sq,3-side,px,py,px-1,py+2)) || (sq->sq[py+2][px-1]==0 && py+2!=ky && px-1!=kx && abs(py+2-ky)+abs(px-1-kx)==3)) {temptsq[n].tx=px-1;temptsq[n].ty=py+2;n++;}
      if (px>1) {
        if (py>0) if (sq->sq[py-1][px-2]>0 || (sq->sq[py-1][px-2]==0 && REVCHK && revchck(sq,3-side,px,py,px-2,py-1)) || (sq->sq[py-1][px-2]==0 && py-1!=ky && px-2!=kx && abs(py-1-ky)+abs(px-2-kx)==3)) {temptsq[n].tx=px-2;temptsq[n].ty=py-1;n++;}
        if (py<7) if (sq->sq[py+1][px-2]>0 || (sq->sq[py+1][px-2]==0 && REVCHK && revchck(sq,3-side,px,py,px-2,py+1)) || (sq->sq[py+1][px-2]==0 && py+1!=ky && px-2!=kx && abs(py+1-ky)+abs(px-2-kx)==3)) {temptsq[n].tx=px-2;temptsq[n].ty=py+1;n++;}
      }
    }
  }
  return n;
}

 /* Generates all queen moves which capture a piece or give check either directly,
  * or by revealed check */
int mpql_qui(int px,int py,const board *sq,int side,int kx,int ky) {
  int a,b,n=0,rchk=0;

   /*  Rook-like moves */
  if (px<7) {
    if (REVCHK && revchck(sq,3-side,px,py,px+1,py)) rchk=1;
    else rchk=0;
    a=px;
    do {
      a++;
      if ((side==WHITE && (sq->sq[py][a]-rchk)<0) || (side==BLACK && (sq->sq[py][a]+rchk)>0)) {temptsq[n].tx=a;temptsq[n].ty=py;n++;}
      else if (sq->sq[py][a]==0 && a==kx && check_spaces(sq,a,py,kx,ky,0)) {temptsq[n].tx=a;temptsq[n].ty=py;n++;}
      else if (sq->sq[py][a]==0 && abs(kx-a)==abs(ky-py) && check_spaces(sq,a,py,kx,ky,1)) {temptsq[n].tx=a;temptsq[n].ty=py;n++;}
    } while (a<7 && sq->sq[py][a]==0);
  }
  if (px>0) {
    if (REVCHK && revchck(sq,3-side,px,py,px-1,py)) rchk=1;
    else rchk=0;
    a=px;
    do {
      a--;
      if ((side==WHITE && (sq->sq[py][a]-rchk)<0) || (side==BLACK && (sq->sq[py][a]+rchk)>0)) {temptsq[n].tx=a;temptsq[n].ty=py;n++;}
      else if (sq->sq[py][a]==0 && a==kx && check_spaces(sq,a,py,kx,ky,0)) {temptsq[n].tx=a;temptsq[n].ty=py;n++;}
      else if (sq->sq[py][a]==0 && abs(kx-a)==abs(ky-py) && check_spaces(sq,a,py,kx,ky,1)) {temptsq[n].tx=a;temptsq[n].ty=py;n++;}
    } while (a>0 && sq->sq[py][a]==0);
  }
  if (py<7) {
    if (REVCHK && revchck(sq,3-side,px,py,px,py+1)) rchk=1;
    else rchk=0;
    a=py;
    do {
      a++;
      if ((side==WHITE && (sq->sq[a][px]-rchk)<0) || (side==BLACK && (sq->sq[a][px]+rchk)>0)) {temptsq[n].tx=px;temptsq[n].ty=a;n++;}
      else if (sq->sq[a][px]==0 && a==ky && check_spaces(sq,px,a,kx,ky,0)) {temptsq[n].tx=px;temptsq[n].ty=a;n++;}
      else if (sq->sq[a][px]==0 && abs(kx-px)==abs(ky-a) && check_spaces(sq,px,a,kx,ky,1)) {temptsq[n].tx=px;temptsq[n].ty=a;n++;}
    } while (a<7 && sq->sq[a][px]==0);
  }
  if (py>0) {
    if (REVCHK && revchck(sq,3-side,px,py,px,py-1)) rchk=1;
    else rchk=0;
    a=py;
    do {
      a--;
      if ((side==WHITE && (sq->sq[a][px]-rchk)<0) || (side==BLACK && (sq->sq[a][px]+rchk)>0)) {temptsq[n].tx=px;temptsq[n].ty=a;n++;}
      else if (sq->sq[a][px]==0 && a==ky && check_spaces(sq,px,a,kx,ky,0)) {temptsq[n].tx=px;temptsq[n].ty=a;n++;}
      else if (sq->sq[a][px]==0 && abs(kx-px)==abs(ky-a) && check_spaces(sq,px,a,kx,ky,1)) {temptsq[n].tx=px;temptsq[n].ty=a;n++;}
    } while (a>0 && sq->sq[a][px]==0);
  }

   /*  Bishop-like moves */
  if (px<7 && py<7) {
    if (REVCHK && revchck(sq,3-side,px,py,px+1,py+1)) rchk=1;
    else rchk=0;
    a=px;b=py;
    do {
      a++;
      b++;
      if ((side==WHITE && (sq->sq[b][a]-rchk)<0) || (side==BLACK && (sq->sq[b][a]+rchk)>0)) {temptsq[n].tx=a;temptsq[n].ty=b;n++;}
      else if (sq->sq[b][a]==0 && abs(kx-a)==abs(ky-b) && check_spaces(sq,a,b,kx,ky,1)) {temptsq[n].tx=a;temptsq[n].ty=b;n++;}
      else if (sq->sq[b][a]==0 && (a==kx || b==ky) && check_spaces(sq,a,b,kx,ky,0)) {temptsq[n].tx=a;temptsq[n].ty=b;n++;}
    } while (a<7 && b<7 && sq->sq[b][a]==0);
  }
  if (px<7 && py>0) {
    if (REVCHK && revchck(sq,3-side,px,py,px+1,py-1)) rchk=1;
    else rchk=0;
    a=px;b=py;
    do {
      a++;
      b--;
      if ((side==WHITE && (sq->sq[b][a]-rchk)<0) || (side==BLACK && (sq->sq[b][a]+rchk)>0)) {temptsq[n].tx=a;temptsq[n].ty=b;n++;}
      else if (sq->sq[b][a]==0 && abs(kx-a)==abs(ky-b) && check_spaces(sq,a,b,kx,ky,1)) {temptsq[n].tx=a;temptsq[n].ty=b;n++;}
      else if (sq->sq[b][a]==0 && (a==kx || b==ky) && check_spaces(sq,a,b,kx,ky,0)) {temptsq[n].tx=a;temptsq[n].ty=b;n++;}
    } while (a<7 && b>0 && sq->sq[b][a]==0);
  }
  if (px>0 && py<7) {
    if (REVCHK && revchck(sq,3-side,px,py,px-1,py+1)) rchk=1;
    else rchk=0;
    a=px;b=py;
    do {
      a--;
      b++;
      if ((side==WHITE && (sq->sq[b][a]-rchk)<0) || (side==BLACK && (sq->sq[b][a]+rchk)>0)) {temptsq[n].tx=a;temptsq[n].ty=b;n++;}
      else if (sq->sq[b][a]==0 && abs(kx-a)==abs(ky-b) && check_spaces(sq,a,b,kx,ky,1)) {temptsq[n].tx=a;temptsq[n].ty=b;n++;}
      else if (sq->sq[b][a]==0 && (a==kx || b==ky) && check_spaces(sq,a,b,kx,ky,0)) {temptsq[n].tx=a;temptsq[n].ty=b;n++;}
    } while (a>0 && b<7 && sq->sq[b][a]==0);
  }
  if (px>0 && py>0) {
    if (REVCHK && revchck(sq,3-side,px,py,px-1,py-1)) rchk=1;
    else rchk=0;
    a=px;b=py;
    do {
      a--;
      b--;
      if ((side==WHITE && (sq->sq[b][a]-rchk)<0) || (side==BLACK && (sq->sq[b][a]+rchk)>0)) {temptsq[n].tx=a;temptsq[n].ty=b;n++;}
      else if (sq->sq[b][a]==0 && abs(kx-a)==abs(ky-b) && check_spaces(sq,a,b,kx,ky,1)) {temptsq[n].tx=a;temptsq[n].ty=b;n++;}
      else if (sq->sq[b][a]==0 && (a==kx || b==ky) && check_spaces(sq,a,b,kx,ky,0)) {temptsq[n].tx=a;temptsq[n].ty=b;n++;}
    } while (a>0 && b>0 && sq->sq[b][a]==0);
  }
  return n;
}
