#include <stdlib.h>
#include <stdio.h>

#include "chess.h"
#include "checks.h"
#include "moves.h"
#include "misc.h"
#include "mprocs.h"

extern tosquare temptsq[30];

int chck(const board *sq,int side) {
  int a,b,x=0,y=0,p,np=3;

  /*  Tests to see if side given is in check.  If so then returns */
  /*  identifier of piece checking, else returns 0. */

   if (side==WHITE) {
    x=sq->kpos[0];y=sq->kpos[1]; /*  Setup king co-ords */
    np=-3; /*  Opponent Knight Value */
    if (y>0 && x<7 && sq->sq[y-1][x+1]==-1) return 1; /*  Check by pawn */
    if (y>0 && x>0 && sq->sq[y-1][x-1]==-1) return 1;
  }
  if (side==BLACK) {
    x=sq->kpos[2];y=sq->kpos[3];
    if (y<7 && x<7 && sq->sq[y+1][x+1]==1) return 1;
    if (y<7 && x>0 && sq->sq[y+1][x-1]==1) return 1;
  }
  /*  Check by opp. king */
  if (abs(sq->kpos[0]-sq->kpos[2])<2 && abs(sq->kpos[1]-sq->kpos[3])<2) return 6;
  /*  Check by knight */
   if (sq->npieces[2-side][1]>0) {
    if (x<6) {
      if (y>0 && sq->sq[y-1][x+2]==np) return 3;
      if (y<7 && sq->sq[y+1][x+2]==np) return 3;
    }
    if (x<7) {
      if (y>1 && sq->sq[y-2][x+1]==np) return 3;
      if (y<6 && sq->sq[y+2][x+1]==np) return 3;
    }
    if (x>0) {
      if (y>1 && sq->sq[y-2][x-1]==np) return 3;
      if (y<6 && sq->sq[y+2][x-1]==np) return 3;
    }
    if (x>1) {
      if (y>0 && sq->sq[y-1][x-2]==np) return 3;
      if (y<7 && sq->sq[y+1][x-2]==np) return 3;
    }  
  }
  /*  Rest of pieces */
  if (sq->npieces[2-side][3]>0 || sq->npieces[2-side][0]>0) {
    if (x>0) {
      a=x;
      do {a--;p=sq->sq[y][a];} while (a>0 && p==0);
      if (side==WHITE) p=-p;
      if (p==2 || p==5) return p;
    }
    if (x<7) {
      a=x;
      do {a++;p=sq->sq[y][a];} while (a<7 && p==0);
      if (side==WHITE) p=-p;
      if (p==2 || p==5) return p;
    }
    if (y>0) {
      a=y;
      do {a--;p=sq->sq[a][x];} while (a>0 && p==0);
      if (side==WHITE) p=-p;
      if (p==2 || p==5) return p;
    }
    if (y<7) {
      a=y;
      do {a++;p=sq->sq[a][x];} while (a<7 && p==0);
      if (side==WHITE) p=-p;
      if (p==2 || p==5) return p;
    }
  }
  if (sq->npieces[2-side][2]>0 || sq->npieces[2-side][3]>0) {
    if (x>0 && y>0) {
      a=x;b=y;
      do {a--;b--;p=sq->sq[b][a];} while (a>0 && b>0 && p==0);
      if (side==WHITE) p=-p;
      if (p==4 || p==5) return p;
    }
    if (x<7 && y>0) {
      a=x;b=y;
      do {a++;b--;p=sq->sq[b][a];} while (a<7 && b>0 && p==0);
      if (side==WHITE) p=-p;
      if (p==4 || p==5) return p;
    }
    if (x>0 && y<7) {
      a=x;b=y;
      do {a--;b++;p=sq->sq[b][a];} while (a>0 && b<7 && p==0);
      if (side==WHITE) p=-p;
      if (p==4 || p==5) return p;
    }
    if (x<7 && y<7) {
      a=x;b=y;
      do {a++;b++;p=sq->sq[b][a];} while (a<7 && b<7 && p==0);
      if (side==WHITE) p=-p;
      if (p==4 || p==5) return p;
    }
  }
  return 0;
}

/*  Tests to see if moving a piece from fx,fy causes revealed check to 'side'. */
/*  Returns identifier of checking piece, or zero. */

int revchck(const board *sq,int side,int fx,int fy,int tx,int ty) {
  int a,b,x=0,y=0,p,p1,p2;

  if (side==WHITE) {x=sq->kpos[0];y=sq->kpos[1];}
  if (side==BLACK) {x=sq->kpos[2];y=sq->kpos[3];}

  if ((fx==x && tx!=fx) || (fy==y && ty!=fy)) {
   /*  Horizontal or vertical i.e. rook or queen */
    if (sq->npieces[2-side][3]>0 || sq->npieces[2-side][0]>0) {
      if (side==WHITE) {p1=-2;p2=-5;}
      else {p1=2;p2=5;}
      if (fx<x && fx>0 && check_spaces(sq,fx,fy,x,y,0)) {
        a=fx;
        do {a--;p=sq->sq[y][a];} while (a>0 && p==0);
        if (p==p1 || p==p2) return abs(p);
	return 0;
      }
      if (fx>x && fx<7 && check_spaces(sq,fx,fy,x,y,0)) {
        a=fx;
        do {a++;p=sq->sq[y][a];} while (a<7 && p==0);
        if (p==p1 || p==p2) return abs(p);
	return 0;
      }
      if (fy<y && fy>0 && check_spaces(sq,fx,fy,x,y,0)) {
        a=fy;
        do {a--;p=sq->sq[a][x];} while (a>0 && p==0);
        if (p==p1 || p==p2) return abs(p);
	return 0;
      }
      if (fy>y && fy<7 && check_spaces(sq,fx,fy,x,y,0)) {
        a=fy;
        do {a++;p=sq->sq[a][x];} while (a<7 && p==0);
        if (p==p1 || p==p2) return abs(p);
	return 0;
      }
    }
    else return 0;
  }
   /* Diagonal i.e. bishop or queen */
  if (abs(x-fx)==abs(y-fy)) {
    if (sq->npieces[2-side][2]>0 || sq->npieces[2-side][3]>0) {
      if (side==WHITE) {p1=-4;p2=-5;}
      else {p1=4;p2=5;}
      if (fx<x && fy<y && fx>0 && fy>0 && (tx-fx!=ty-fy) && check_spaces(sq,fx,fy,x,y,1)) {
        a=fx;b=fy;
        do {a--;b--;p=sq->sq[b][a];} while (a>0 && b>0 && p==0);
        if (p==p1 || p==p2) return abs(p);
	return 0;
      }
      if (fx>x && fy<y && fx<7 && fy>0 && ((tx-fx)+(ty-fy)!=0) && check_spaces(sq,fx,fy,x,y,1)) {
        a=fx;b=fy;
        do {a++;b--;p=sq->sq[b][a];} while (a<7 && b>0 && p==0);
        if (p==p1 || p==p2) return abs(p);
	return 0;
      }
      if (fx<x && fy>y && fx>0 && fy<7 && ((tx-fx)+(ty-fy)!=0) && check_spaces(sq,fx,fy,x,y,1)) {
        a=fx;b=fy;
        do {a--;b++;p=sq->sq[b][a];} while (a>0 && b<7 && p==0);
        if (p==p1 || p==p2) return abs(p);
	return 0;
      }
      if (fx>x && fy>y&& fx<7 && fy<7 && (tx-fx!=ty-fy) && check_spaces(sq,fx,fy,x,y,1)) {
        a=fx;b=fy;
        do {a++;b++;p=sq->sq[b][a];} while (a<7 && b<7 && p==0);
        if (p==p1 || p==p2) return abs(p);
	return 0;
      }
    }
    else return 0;
  }
  return 0;
}

 /*  returns 1 if piece at fx,fy is attacking opponent's king. */
 /*  else zero. */
int give_direct_check(const board *sq,int fx,int fy) {
  int p=sq->sq[fy][fx],side,kx=0,ky=0;

  if (p==0) return 0;
  if (p>0) {side=1;kx=sq->kpos[2];ky=sq->kpos[3];}
  else {side=2;kx=sq->kpos[0];ky=sq->kpos[1];}

  switch(abs(p)) {
    case 1: if (side==WHITE && fy==ky+1 && abs(fx-kx)==1) return 1;
   	    if (side==BLACK && fy==ky-1 && abs(fx-kx)==1) return 1;break;
    case 2: if ((kx==fx || ky==fy) && check_spaces(sq,fx,fy,kx,ky,0)==1) return 1;break;
    case 3: if (fy!=ky && fx!=kx && abs(fy-ky)+abs(fx-kx)==3) return 1; break;
    case 4: if ((abs(kx-fx)==abs(ky-fy)) && check_spaces(sq,fx,fy,kx,ky,1)==1) return 1;break;
    case 5: if ((kx==fx || ky==fy) && check_spaces(sq,fx,fy,kx,ky,0)==1) return 1;
            if ((abs(kx-fx)==abs(ky-fy)) && check_spaces(sq,fx,fy,kx,ky,1)==1) return 1;break;
    case 6: if ((abs(kx-fx)<2 && abs(ky-fy)<2)) return 1; break;
    default: return 0;
  }
  return 0;
}

 /*  Tests to see if side given is in CM. */
 /*  Returns 1 if it is, 0 if it isn't :) */
 /*  pc holds piece known to be attacking king (used for early cutout) */
int chkmte(int side,board *sq,int pc,int epx,int epy) {
  int a,b,c,d,p,opt,flg=1,kx,ky,kkx,kky,n,king=6,oside=2-side;
  tosquare *tmv;
   
  if (side==WHITE) {kx=sq->kpos[0];ky=sq->kpos[1];king=6;}
  else {kx=sq->kpos[2];ky=sq->kpos[3];king=-6;}
  for (c=-1;c<2;c++) {   /*  Test king's move first to see if it can move away. */
    kkx=kx+c;
    if (kkx==-1 || kkx==8) continue;
    for (d=-1;d<2;d++) {
      kky=ky+d;
      if (kky==-1 || kky==8) continue;
      if (c==0 && d==0) continue;
      p=sq->sq[kky][kkx];
      if (side==BLACK) p=0-p;
      if (p<1) {
        opt=sq->sq[kky][kkx];
	sq->sq[kky][kkx]=king;
	sq->sq[ky][kx]=0;
	if (abs(opt)>1) (sq->npieces[oside][abs(opt)-2])--;
	if (side==WHITE) {sq->kpos[0]=kkx;sq->kpos[1]=kky;}
	else {sq->kpos[2]=kkx;sq->kpos[3]=kky;}
	flg=chck(sq,side);
        if (side==WHITE) {sq->kpos[0]=kx;sq->kpos[1]=ky;}
	else {sq->kpos[2]=kx;sq->kpos[3]=ky;}
        if (abs(opt)>1) (sq->npieces[oside][abs(opt)-2])++;
	sq->sq[ky][kx]=king;
	sq->sq[kky][kkx]=opt;
        if (flg==0) return 0;
      }
    }
  }
  /*  Now test the rest. */
  for (a=0;a<8;a++) {
    for (b=0;b<8;b++) {
      p=sq->sq[a][b];
      if ((side==WHITE && p<1) || (side==BLACK && p>-1)) continue;
      if (abs(p)==6) continue;
      n=0;
      if (side==WHITE) {
    	switch(p) {
  	  case 1: n=mppl(b,a,sq,1);break;
	  case 2: n=mprl(b,a,sq,1);break;
	  case 3: n=mpnl(b,a,sq,1);break;
	  case 4: n=mpbl(b,a,sq,1,0);break;
	  case 5: n=mpql(b,a,sq,1);break;
	  default: break;
	}
      }
      else {
  	switch (p) {
	  case -1: n=mppl(b,a,sq,2);break;
	  case -2: n=mprl(b,a,sq,2);break;
	  case -3: n=mpnl(b,a,sq,2);break;
	  case -4: n=mpbl(b,a,sq,2,0);break;
	  case -5: n=mpql(b,a,sq,2);break;
	  default : break;
	}
      }
      for (c=0;c<n;c++) {
        tmv=&temptsq[c];
        opt=sq->sq[tmv->ty][tmv->tx];
        if (abs(opt)!=pc && (pc==1 || pc==3)) continue; /*  Can't block checks from pawns or knights */
	if (abs(opt)>1) (sq->npieces[oside][abs(opt)-2])--;
        sq->sq[tmv->ty][tmv->tx]=p;
        sq->sq[a][b]=0;
        flg=chck(sq,side);
        sq->sq[a][b]=p;
        sq->sq[tmv->ty][tmv->tx]=opt;
        if (abs(opt)>1) (sq->npieces[oside][abs(opt)-2])++;
        if (flg==0) return 0;  /*  Possible escape */
      }
    }
  }
  /* Escape by EP capture */
  if (epx>-1 && epy>-1) {
    if (side==WHITE) {
      if (epx>0 && sq->sq[3][epx-1]==1) {
	sq->sq[3][epx-1]=0;sq->sq[2][epx]=1;sq->sq[3][epx]=0;
	flg=chck(sq,side);
	sq->sq[3][epx-1]=1;sq->sq[2][epx]=0;sq->sq[3][epx]=-1;
	if (flg==0) return 0;
      }
      if (epx<7 && sq->sq[3][epx+1]==1) {
	sq->sq[3][epx+1]=0;sq->sq[2][epx]=1;sq->sq[3][epx]=0;
	flg=chck(sq,side);
	sq->sq[3][epx+1]=1;sq->sq[2][epx]=0;sq->sq[3][epx]=-1;
	if (flg==0) return 0;
      }
    }
    else {
      if (epx>0 && sq->sq[4][epx-1]==-1) {
	sq->sq[4][epx-1]=0;sq->sq[5][epx]=-1;sq->sq[4][epx]=0;
	flg=chck(sq,side);
	sq->sq[4][epx-1]=-1;sq->sq[5][epx]=0;sq->sq[4][epx]=1;
	if (flg==0) return 0;
      }
      if (epx<7 && sq->sq[4][epx+1]==-1) {
	sq->sq[4][epx+1]=0;sq->sq[5][epx]=-1;sq->sq[4][epx]=0;
	flg=chck(sq,side);
	sq->sq[4][epx+1]=-1;sq->sq[5][epx]=0;sq->sq[4][epx]=1;
	if (flg==0) return 0;
      }
    }
  }
  return 1;
}

int castleok(int side,int type,board *sq,int cpk,int cpq) {
  /*  Returns 1 if side can castle in way specified. */
  /*  type 1 is King's side, 2is Queen's side. */
  /*  cpq and cpk are the current values of the check_possible flags. */
  if (type==1) {
    if (side==WHITE) {
      if (cpk==0) return 0;
      if (sq->sq[7][7]!=2 || sq->sq[7][4]!=6) return 0;
      if (chck(sq,1)!=0) return 0;
      if (!(sq->sq[7][5]==0 && sq->sq[7][6]==0)) return 0;
      sq->sq[7][4]=0;
      sq->sq[7][5]=6;
      sq->kpos[0]=5;
      if (chck(sq,1)!=0) {sq->sq[7][5]=0;sq->sq[7][4]=6;sq->kpos[0]=4;return 0;}
      sq->sq[7][5]=0;
      sq->sq[7][6]=6;
      sq->kpos[0]=6;
      if (chck(sq,1)!=0) {sq->sq[7][6]=0;sq->sq[7][4]=6;sq->kpos[0]=4;return 0;}
      sq->sq[7][6]=0;sq->sq[7][4]=6;sq->kpos[0]=4;return 1;
    }
    if (side==BLACK) {
      if (cpk==0) return 0;
      if (sq->sq[0][7]!=-2 || sq->sq[0][4]!=-6) return 0;
      if (chck(sq,2)!=0) return 0;
      if (!(sq->sq[0][5]==0 && sq->sq[0][6]==0)) return 0;
      sq->sq[0][4]=0;
      sq->sq[0][5]=-6;
      sq->kpos[2]=5;
      if (chck(sq,2)!=0) {sq->sq[0][5]=0;sq->sq[0][4]=-6;sq->kpos[2]=4;return 0;}
      sq->sq[0][5]=0;
      sq->sq[0][6]=-6;
      sq->kpos[2]=6;
      if (chck(sq,2)!=0) {sq->sq[0][6]=0;sq->sq[0][4]=-6;sq->kpos[2]=4;return 0;}
      sq->sq[0][6]=0;sq->sq[0][4]=-6;sq->kpos[2]=4;return 1;
    }
  }
  else {
    if (side==WHITE) {
      if (cpq==0) return 0;
      if (sq->sq[7][0]!=2 || sq->sq[7][4]!=6) return 0;
      if (chck(sq,1)!=0) return 0;
      if (!(sq->sq[7][1]==0 && sq->sq[7][2]==0 && sq->sq[7][3]==0)) return 0;
      sq->sq[7][4]=0;
      sq->sq[7][3]=6;
      sq->kpos[0]=3;
      if (chck(sq,1)!=0) {sq->sq[7][3]=0;sq->sq[7][4]=6;sq->kpos[0]=4;return 0;}
      sq->sq[7][3]=0;
      sq->sq[7][2]=6;
      sq->kpos[0]=2;
      if (chck(sq,1)!=0) {sq->sq[7][2]=0;sq->sq[7][4]=6;sq->kpos[0]=4;return 0;}
      sq->sq[7][2]=0;sq->sq[7][4]=6;sq->kpos[0]=4;return 1;
    }
    if (side==BLACK) {
      if (cpq==0) return 0;
      if (sq->sq[0][0]!=-2 || sq->sq[0][4]!=-6) return 0;
      if (chck(sq,2)!=0) return 0;
      if (!(sq->sq[0][1]==0 && sq->sq[0][2]==0 && sq->sq[0][3]==0)) return 0;
      sq->sq[0][4]=0;
      sq->sq[0][3]=-6;
      sq->kpos[2]=3;
      if (chck(sq,2)!=0) {sq->sq[0][3]=0;sq->sq[0][4]=-6;sq->kpos[2]=4;return 0;}
      sq->sq[0][3]=0;
      sq->sq[0][2]=-6;
      sq->kpos[2]=2;
      if (chck(sq,2)!=0) {sq->sq[0][2]=0;sq->sq[0][4]=-6;sq->kpos[2]=4;return 0;}
      sq->sq[0][2]=0;sq->sq[0][4]=-6;sq->kpos[2]=4;return 1;
    }
  }
  return -1;
}

int check_spaces(const board *sq,int fx,int fy,int tx,int ty,int sense) {
  int a;

  /*  Checks the spaces between fx,fy to tx,ty and returns a 1 if they */
  /*     are all empty, 0 otherwise. */
  /*  Sense holds the direction.  0 is horizontal/vertical. */
  /*    1 is diagonal. */
  /*  Not sure how fast this one is. */

  if (sense==0) {
    if (fx==tx) {
      if (ty>fy) {
   	for (a=fy+1;a<ty;a++) if (sq->sq[a][fx]!=0) return 0;
	return 1;
      }
      for (a=fy-1;a>ty;a--) if (sq->sq[a][fx]!=0) return 0;
      return 1;
    }
    if (tx>fx) {
      for (a=fx+1;a<tx;a++) if (sq->sq[fy][a]!=0) return 0;
      return 1;
    }
    for (a=fx-1;a>tx;a--) if (sq->sq[fy][a]!=0) return 0;
    return 1;
  }
  if (tx>fx) {
    if (ty>fy) {
      for (a=1;fx+a<tx;a++) if (sq->sq[fy+a][fx+a]!=0) return 0;
      return 1;
    }
    for (a=1;fx+a<tx;a++) if (sq->sq[fy-a][fx+a]!=0) return 0;
    return 1;
  }
  if (ty>fy) {
    for (a=1;fy+a<ty;a++) if (sq->sq[fy+a][fx-a]!=0) return 0;
    return 1;
  }
  for (a=1;fy-a>ty;a++) if (sq->sq[fy-a][fx-a]!=0) return 0;
  return 1;
}

int en_passant_possible(board *sq,move *mv,int side) {  /*  Can player take EP? */
  int poss=-1,pawn;
  move temp;

  if (!mv) return -1; /*  No last move given :( */
  if (mv->castle!=0 || mv->ep!=0) return -1; /*  Last move was a castle or EP */
  if (mv->ty<0 || mv->tx<0 || mv->fy<0 || mv->fx<0) return -1; /*  Last move illegal (should never happen) */
  if (abs(sq->sq[mv->ty][mv->tx])!=1) return -1; /*  Last piece moved not a pawn */
  if (abs(mv->ty-mv->fy)!=2) return -1; /*  .. or not moved two squares */
  temp.castle=temp.promote=0;
  temp.score=0;
  temp.tx=mv->tx;temp.fy=2+side;
  if (side==WHITE) {temp.ty=2;pawn=1;}
  else {temp.ty=5;pawn=-1;}
  if (mv->tx>0) {
    if (sq->sq[2+side][mv->tx-1]==pawn) {
      temp.fx=mv->tx-1;
      temp.ep=-1;
      do_move2(sq,&temp,side);
      if (chck(sq,side)==0) poss=0;  /*  Can EP castle from the left */
      undo_move(sq,&temp,side);
    }
  }
  if (mv->tx<7) {
    if (sq->sq[2+side][mv->tx+1]==pawn) {
      temp.fx=mv->tx+1;
      temp.ep=1;
      do_move2(sq,&temp,side);
      if (chck(sq,side)==0) poss+=2;  /*  Can EP castle from the left */
      undo_move(sq,&temp,side);
    }
  }
  return poss; /*  Returns -1 (no) 0 (from left) 1 (from right) or 2 (both) */
}
