use crate::{
    actions::GeneralArgs,
    render::json::JsonToStdout,
    types::{context::BergContext, output::OutputMode},
};

use clap::Parser;

/// Display short summary of the authenticated user account
#[derive(Parser, Debug)]
pub struct ApiVersionArgs {}

impl ApiVersionArgs {
    pub async fn run(self, general_args: GeneralArgs) -> anyhow::Result<()> {
        let ctx = BergContext::new(self, general_args).await?;
        let version = ctx.client.get_version().await?;

        match general_args.output_mode {
            OutputMode::Pretty => match version.version {
                Some(version) => println!("Version: {version}"),
                None => println!("No version detected"),
            },
            OutputMode::Json => version.print_json()?,
        }

        Ok(())
    }
}
