use crate::render::option::option_display;

pub mod create;
pub mod edit;
pub mod list;
pub mod view;

use clap::Subcommand;

use super::GeneralArgs;

/// Milestone subcommands
#[derive(Subcommand, Debug)]
pub enum MilestoneArgs {
    List(list::ListMilestonesArgs),
    View(view::ViewMilestonesArgs),
    Create(create::CreateMilestoneArgs),
    Edit(edit::EditMilestoneArgs),
}

impl MilestoneArgs {
    pub async fn run(self, general_args: GeneralArgs) -> anyhow::Result<()> {
        match self {
            MilestoneArgs::List(args) => args.run(general_args).await,
            MilestoneArgs::View(args) => args.run(general_args).await,
            MilestoneArgs::Create(args) => args.run(general_args).await,
            MilestoneArgs::Edit(args) => args.run(general_args).await,
        }
    }
}

fn display_milestone(milestone: &forgejo_api::structs::Milestone) -> String {
    option_display(&milestone.title)
}
