/*
  message-test.m - test program for message passing
 */

#include <stdio.h>
#include <stdlib.h>

#ifdef __APPLE__
#	include <Foundation/NSObject.h>
#	define	OBJECT	NSObject
#else
	/* note: "objc/Object.h" refers "strcmp" function. */
#	include <string.h>
#	include <objc/Object.h>
#	define	OBJECT	Object
#endif

@interface MessageTest : Object
{
}

- (void) message0p ;
- (void) message1p: (void *) p1 ;
- (void) message2p: (void *) p1 with: (void *) p2 ;

@end

@implementation MessageTest

- (void) message0p
{
	printf("message0p was called.\n") ;
}

- (void) message1p: (void *) p1 
{
	printf("message1p was called with %s.\n", (char *) p1) ;
}

- (void) message2p: (void *) p1 with: (void *) p2 
{
	printf("message2p was called with %s with %s.\n", (char *) p1,
	  (char *) p2) ;
}

@end

int main()
{
	id test = [[MessageTest alloc] init] ;

	[test perform: @selector(message0p) with: (void *) "m0p1" 
	  with: (void *) "m0p2"] ;
	[test perform: @selector(message1p:) with: (void *) "m1p1" 
	  with: (void *) "m1p2"] ;
	[test perform: @selector(message2p:with:) with: (void *) "m2p1" 
	  with: (void *) "m2p2"] ;

	exit(0) ;
}

