/*
  mem-test.m - test program for memory
 */

#include <stdio.h>
#include <stdlib.h>

#ifdef __APPLE__
#	include <Foundation/NSObject.h>
#	define	OBJECT	NSObject
#else
	/* note: "objc/Object.h" refers "strcmp" function. */
#	include <string.h>
#	include <objc/Object.h>
#	define	OBJECT	Object
#endif

struct rec {
	char	c1[1] ;
	char	c2[3] ;
	char	c3[5] ;
} ;

@interface CTest : Object
{
	char	message[128] ;
}

- init ;
- (void) print ;
@end

@implementation CTest

- init
{
	return [super init] ;
}

- (void) print
{
	struct rec	s ;
	char *		top ;
	char *		p1 ;
	char *		p2 ;
	char *		p3 ;
	ptrdiff_t	d1, d2, d3 ;

	top = (char *) &s ; 
	p1 = (char *) s.c1 ;
	p2 = (char *) s.c2 ;
	p3 = (char *) s.c3 ;
	d1 = p1 - top ;
	d2 = p2 - top ;
	d3 = p3 - top ;
	
	printf("d1: %u, d2 %u, d3 %u\n", d1, d2, d3) ;
}
@end

int main()
{
	id test = [[CTest alloc] init] ;
	printf("*** mem-test program\n") ;
	[test print] ;
	printf("bye.\n") ;
	exit(0) ;
}

