/*****
 NAME
 	macro-test.m - test some macros are defined or not.
 VERSION
	$Id$
 CHANGELOG
	$Log$
 */

#include <coconut/dbasic.h>
#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>

#ifdef __APPLE__
#	include <Foundation/NSObject.h>
#	define	OBJECT	NSObject
#else
	/* note: "objc/Object.h" refers "strcmp" function. */
#	include <string.h>
#	include <objc/Object.h>
/*
#	undef __OBJC__
#	include <objc/Protocol.h>
*/
#	define	OBJECT	Object
#endif

@interface CTest : Object
{
	char	message[128] ;
}

- init ;
- (void) print ;
- (void) macro_print ;
- (void) align_print ;

@end

@implementation CTest

- init
{
	strcpy(message, "Hello, World !!") ;
	return [super init] ;
}

- (void) print
{
	printf("%s\n", message) ;
}

- (void) macro_print
{
#if defined(__OBJC__)
	printf("__OBJC__ is defined.\n") ;
#else
	printf("__OBJC__ is NOT defined.\n") ;
#endif
}

- (void) align_print
{
	size_t	orgsize ;
	for(orgsize = 0 ; orgsize < 32 ; orgsize++){
		printf("align(%d) = %d\n", orgsize, ALIGNED_SIZE(orgsize)) ;
	}
}

@end

int main()
{
	id test = [[CTest alloc] init] ;
	[test print] ;
	[test macro_print] ;
	[test align_print] ;
	exit(0) ;
}

